'**************************************************************************
'*************************  Setup Detect API's  ***************************
'**************************************************************************
''Removed unused functions - FREM 03/04/92

''detect

DECLARE FUNCTION CbGetEnvVariableValue LIB "msdetstf.dll" (szEnvVar$, szBuf$, cbBuf%) AS INTEGER
DECLARE FUNCTION FGetValidDrivesList LIB "msdetstf.dll" (szSymbol$) AS INTEGER
DECLARE FUNCTION FIsRemoteDrive LIB "msdetstf.dll" (nDrive%) AS INTEGER
DECLARE FUNCTION LcbTotalDrive LIB "msdetstf.dll" (nDrive%) AS LONG
DECLARE FUNCTION LcbFreeDrive LIB "msdetstf.dll" (nDrive%) AS LONG
DECLARE FUNCTION FDirExists LIB "msdetstf.dll" (szDir$) AS INTEGER
DECLARE FUNCTION FDoesFileExist LIB "msdetstf.dll" (szFileName$, mode%) AS INTEGER
DECLARE FUNCTION FDoesIniSectionExist LIB "msdetstf.dll" (szFile$, szSect$) AS INTEGER
DECLARE FUNCTION FDoesIniKeyExist LIB "msdetstf.dll" (szFile$, szSect$, szKey$) AS INTEGER
DECLARE FUNCTION CbGetIniKeyString LIB "msdetstf.dll" (szFile$, szSect$, szKey$, szBuf$, cbBuf%) AS INTEGER
DECLARE FUNCTION WGetDOSMajorVersion LIB "msdetstf.dll" AS INTEGER
DECLARE FUNCTION WGetDOSMinorVersion LIB "msdetstf.dll" AS INTEGER
DECLARE FUNCTION WGetNumWinApps LIB "msdetstf.dll" AS INTEGER
DECLARE FUNCTION FHasMonochromeDisplay LIB "msdetstf.dll" AS INTEGER
DECLARE FUNCTION FHasMouseInstalled LIB "msdetstf.dll" AS INTEGER
DECLARE FUNCTION CbFindFileInTree LIB "msdetstf.dll" (szFile$, szDir$, szBuf$, cbBuf%) AS INTEGER
DECLARE FUNCTION GetTypeFaceNameFromTTF LIB "msdetstf.dll" (szFile$, szBuf$, cbBuf%) AS INTEGER
DECLARE FUNCTION GetExistingFOTFileForTTF LIB "msdetstf.dll" (szFile$, szBuf$, cbBuf%) AS INTEGER


'*************************************************************************
'****************  Detect Basic Wrapper Declarations  ********************
'*************************************************************************


'' detect

DECLARE FUNCTION GetFreeSpaceForDrive (szDrive$) AS LONG

DECLARE FUNCTION DoesFileExist (szFile$, mode%) AS INTEGER
DECLARE FUNCTION FindFileInTree (szFile$, szDir$) AS STRING

DECLARE FUNCTION DoesIniSectionExist (szFile$, szSect$) AS INTEGER
DECLARE FUNCTION DoesIniKeyExist (szFile$, szSect$, szKey$) AS INTEGER
DECLARE FUNCTION GetIniKeyString (szFile$, szSect$, szKey$) AS STRING

DECLARE FUNCTION GetEnvVariableValue (szEnvVar$) AS STRING

DECLARE FUNCTION IsDriveNetwork (szDrive$) AS INTEGER

DECLARE SUB GetValidDrivesList (szSymbol$)

DECLARE FUNCTION DoesDirExist (szDir$) AS INTEGER

'$IFDEF MOREAPI

DECLARE FUNCTION GetTotalSpaceForDrive (szDrive$) AS LONG
DECLARE FUNCTION HasMonochromeDisplay AS INTEGER
DECLARE FUNCTION HasMouseInstalled AS INTEGER

'$ENDIF ''MOREAPI

'*************************************************************************
FUNCTION IsDriveNetwork (szDrive$) STATIC  AS INTEGER
'$ifdef DEBUG
    if FValidDrive(szDrive$) = 0 then
        BadArgErr 1, "IsDriveNetwork", szDrive$
    end if
'$endif ''DEBUG
    IsDriveNetwork = FIsRemoteDrive(ASC(UCASE$(szDrive$)) - ASC("A") + 1)
END FUNCTION

'*************************************************************************
SUB GetValidDrivesList (szSymbol$) STATIC
'$ifdef DEBUG
    if szSymbol$ = "" then
        BadArgErr 1, "GetValidDrivesList", szSymbol$
    end if
'$endif ''DEBUG
    if FGetValidDrivesList(szSymbol$) = 0 then
'$ifdef DEBUG
        StfApiErr saeFail, "GetValidDrivesList", szSymbol$
'$endif ''DEBUG
        ERROR STFERR
    end if
END SUB


'*************************************************************************
FUNCTION GetEnvVariableValue (szEnvVar$) STATIC  AS STRING
'$ifdef DEBUG
    if szEnvVar$ = "" then
        BadArgErr 1, "GetEnvVariableValue", szEnvVar$
    end if
'$endif ''DEBUG
    cb% = 1024
    szBuf$ = STRING$(cb%, 32)
    cbRet% = CbGetEnvVariableValue(szEnvVar$, szBuf$, cb%)
    GetEnvVariableValue = szBuf$
'$ifdef DEBUG
    IF cbRet% >= cb% THEN
        StfApiErr saeOvfl, "GetEnvVariableValue", szEnvVar$
        ERROR STFERR
    END IF
'$endif ''DEBUG
    szBuf$ = ""
END FUNCTION


'*************************************************************************
FUNCTION GetFreeSpaceForDrive (szDrive$) STATIC  AS LONG
'$ifdef DEBUG
    if FValidDrive(szDrive$) = 0 then
        BadArgErr 1, "GetFreeSpaceForDrive", szDrive$
    end if
'$endif ''DEBUG
    GetFreeSpaceForDrive = LcbFreeDrive(ASC(UCASE$(szDrive$)) - ASC("A") + 1)
END FUNCTION


'*************************************************************************
FUNCTION DoesFileExist (szFileName$, mode%) STATIC  AS INTEGER
'$ifdef DEBUG
    if FValidFATPath(szFileName$) = 0 then
        BadArgErr 1, "DoesFileExist", szFileName$+", "+STR$(mode%)
    end if
'$endif ''DEBUG
    DoesFileExist = FDoesFileExist(szFileName$, mode%)
END FUNCTION

'*************************************************************************
FUNCTION FindFileInTree (szFile$, szDir$) STATIC  AS STRING
'$ifdef DEBUG
    if CchlValidFATSubPath(szFile$) = 0 then
        n% = 1
    elseif FValidFATDir(szDir$) = 0 then
        n% = 2
    else
        n% = 0
    end if
    if n% > 0 then
        BadArgErr n%, "FindFileInTree", szFile$+", "+szDir$
    end if
'$endif ''DEBUG

    cb% = 512
    szBuf$ = STRING$(cb%, 32)
    cbRet% = CbFindFileInTree(szFile$, szDir$, szBuf$, cb%)
    FindFileInTree = szBuf$
'$ifdef DEBUG
    IF cbRet% >= cb% THEN
        StfApiErr saeOvfl, "FindFileInTree", szFile$+", "+szDir$
        ERROR STFERR
    END IF
'$endif ''DEBUG
    szBuf$ = ""
END FUNCTION


'*************************************************************************
FUNCTION DoesIniSectionExist (szFile$, szSect$) STATIC  AS INTEGER
'$ifdef DEBUG
    if FValidIniFile(szFile$) = 0 then
        BadArgErr 1, "DoesIniSectionExist", szFile$+", "+szSect$
    end if
'$endif ''DEBUG
    DoesIniSectionExist = FDoesIniSectionExist(szFile$, szSect$)
END FUNCTION


'*************************************************************************
FUNCTION DoesIniKeyExist (szFile$, szSect$, szKey$) STATIC  AS INTEGER
'$ifdef DEBUG
    if FValidIniFile(szFile$) = 0 then
        n% = 1
    elseif szKey$ = "" then
        n% = 3
    else
        n% = 0
    end if
    if n% > 0 then
        BadArgErr n%, "DoesIniKeyExist", szFile$+", "+szSect$+", "+szKey$
    end if
'$endif ''DEBUG

    DoesIniKeyExist = FDoesIniKeyExist(szFile$, szSect$, szKey$)
END FUNCTION


'*************************************************************************
FUNCTION GetIniKeyString (szFile$, szSect$, szKey$) STATIC  AS STRING
'$ifdef DEBUG
    if FValidIniFile(szFile$) = 0 then
        n% = 1
    elseif szKey$ = "" then
        n% = 3
    else
        n% = 0
    end if
    if n% > 0 then
        BadArgErr n%, "GetIniKeyString", szFile$+", "+szSect$+", "+szKey$
    end if
'$endif ''DEBUG

    cb% = 512
    szBuf$ = STRING$(cb%, 32)
    cbRet% = CbGetIniKeyString(szFile$, szSect$, szKey$, szBuf$, cb%)
    GetIniKeyString = szBuf$
'$ifdef DEBUG
    IF cbRet% >= cb% THEN
        StfApiErr saeOvfl, "GetIniKeyString", szFile$+", "+szSect$+", "+szKey$
        ERROR STFERR
    END IF
'$endif ''DEBUG
    szBuf$ = ""
END FUNCTION

'*************************************************************************
FUNCTION DoesDirExist (szDir$) STATIC  AS INTEGER
'$ifdef DEBUG
    if FValidFATDir(szDir$) = 0 then
        BadArgErr 1, "DoesDirExist", szDir$
    end if
'$endif ''DEBUG
    DoesDirExist = FDirExists(szDir$)
END FUNCTION


'' This stuff was deleted temporary (Parser out of memry problem)
'$IFDEF MOREAPI

'*************************************************************************
FUNCTION GetTotalSpaceForDrive (szDrive$) STATIC  AS LONG
'$ifdef DEBUG
    if FValidDrive(szDrive$) = 0 then
        BadArgErr 1, "GetTotalSpaceForDrive", szDrive$
    end if
'$endif ''DEBUG
    GetTotalSpaceForDrive = LcbTotalDrive(ASC(UCASE$(szDrive$)) - ASC("A") + 1)
END FUNCTION



'*************************************************************************
FUNCTION HasMonochromeDisplay STATIC  AS INTEGER
    HasMonochromeDisplay = FHasMonochromeDisplay
END FUNCTION


'*************************************************************************
FUNCTION HasMouseInstalled STATIC  AS INTEGER
    HasMouseInstalled = FHasMouseInstalled
END FUNCTION


'$ENDIF ''MOREAPI
