*
*  checkout.asm      program to check out a modified PP144 ProClass modem
*

*************************************************************
*
*  equates.asm      68302 system equates
*

bar	equ	$00f2			base addr reg
scr	equ	$00f4			system control reg

base	equ	$700000			move base addr to here
cmr	equ	base+$802		channel mode reg
sapr	equ	base+$804		source addr ptr
dapr	equ	base+$808		destination addr ptr
bcr	equ	base+$80c		byte count reg
csr	equ	base+$80e		channel status reg
fcr	equ	base+$810		function code reg
gimr	equ	base+$812		global intrpt mode reg
ipr	equ	base+$814		intrpt pending reg
imr	equ	base+$816		intrpt mask reg
isr	equ	base+$818		in-service reg
pacnt	equ	base+$81e		port a cntrl reg
paddr	equ	base+$820		port a data dir reg
padat	equ	base+$822		port a data reg
pbcnt	equ	base+$824		port b cntrl reg
pbddr	equ	base+$826		port b data dir reg
pbdat	equ	base+$828		port b data reg
br0	equ	base+$830		base register 0
or0	equ	base+$832		option register 0
br1	equ	base+$834		base register 1
or1 	equ	base+$836		option register 1
br2	equ	base+$838		base register 2
or2	equ	base+$83a		option register 2
br3	equ	base+$83c		base register 3
or3	equ	base+$83e		option register 3
tmr1	equ	base+$840		timer 1 mode reg
trr1	equ	base+$842		timer 1 reference reg
tcr1	equ	base+$844		timer 1 capture reg
tcn1	equ	base+$846		timer 1 counter
ter1	equ	base+$849		timer 1 event reg (byte)
wrr	equ	base+$84a		watchdog timer ref reg
wcn	equ	base+$84c		wdt counter
tmr2	equ	base+$850		timer 2 mode reg
trr2	equ	base+$852		timer 2 reference reg
tcr2	equ	base+$854		timer 2 capture reg
tcn2	equ	base+$856		timer 2 counter
ter2	equ	base+$849		timer 2 event reg (byte)
cr	equ	base+$860		command register
simode	equ	base+$8b4
scon3	equ	base+$8a2
scm3	equ	base+$8a4
scce3	equ	base+$8a8
sccm3	equ	base+$8aa

*
*  end of equates.asm
*
************************************************************

stkbeg	equ	$1fff0

irombeg	equ	$0			start of ROM during init
irambeg	equ	$400000			start of RAM during init
rombeg	equ	$400000			start of ROM after init
rambeg	equ	$0			start of RAM after init


	org	$0			start at the beginning
	dc.l	stkbeg			point to stack
	dc.l	start			point to start


	org	$400			start of code
start
	move.w	#$2700,sr		shut off all interrupts
	move.w	#$0700,bar		put base addr reg at $700000
	move.w	#$3f80,or0		extend ROM addr
	move.b	#$81,cr			reset the CP
	move.w	#$0,$f8			???
	move.l	#$0003d090,d0		get a delay counter
loop
	subq.l	#1,d0			count this loop
	bne	loop			loop until done

*
*  Move a section of code from ROM into system RAM.
*

	move.l	#copy,a0		copy from here
	move.l	#base,a1		to here
	move.l	#copyend,d0		until reach this addr
loop1
	move.b	(a0)+,(a1)+		move a byte
	cmp.l	a0,d0			all done?
	bne	loop1			loop until done
*
*  Turn on the LED at PB0 so we know we got this far.
*
	move.w	#$0,pbcnt		pb0-pb7 are I/O pins
	move.w	#$01ff,pbddr		pb0-pb8 are outputs
	move.w	#$fffe,pbdat		turn on only pb0
	jmp	base			now execute code put in RAM

*
*  The following code is copied into system RAM and executed from there.
*  The JMP instruction at the end must allow for the fact that the ROM
*  will have moved from $0000 to $400000.  That's why you can't do a
*  simple JSR-RTS.
*

copy
	move.w	#$2801,br0		move ROM to new addr
	move.w	#$3e00,or0		assign length of ROM
	move.w	#$2001,br1		move RAM to new addr
	move.w	#$1e00,or1		assign length of RAM
	clr.l	$0001fff4		???
	jmp	rombeg+copyend		jump to ROM to continue

*
*  Control reaches this point after the ROM and RAM have been placed
*  in their final configuration:
*
*      RAM from $000000 to $01ffff  ???
*      ROM from $400000 to $43ffff
*      68302 base = $070000
*
*  Initialization is now complete.  Control is executing out of ROM
*  at address rombeg+copyend.
*

copyend
	nop
	move.w	$fa,d0			???
	ori.w	#$3000,d0		???
	move.w	d0,$fa			???
	move.w	#$2700,sr		mask all interrupts
	move.l	#stkbeg,a7		set stack pointer

*
*  The following code sets up the 68302 registers to a stable configuration.
*  The port pin configuration matches that of the PP144 modem, so the LEDs
*  work properly.
*

	move.w	#$0,imr
	move.w	#$ffff,ipr
	move.w	#$ffff,isr
	move.w	#$8740,gimr
	move.w	#$0,simode
	move.w	#$103,pacnt
	move.w	#$f2f2,paddr
	move.w	#$220,padat
	move.w	#$0,pbcnt
	move.w	#$3ff,pbddr
	move.w	#$1f7,pbdat
	move.w	#$2801,br0
	move.w	#$1e00,or0
	move.w	#$2001,br1
	move.w	#$1e00,or1
	move.w	#$3c01,br2
	move.w	#$3c00,or2

*
*  Clear out all RAM.
*

	movea.l	#$10000,a0		start at this addr
	move.l	#$1fff0,d0		loop until this addr
xloop1
	clr.w	(a0)+			fill a word
	cmp.l	a0,d0			count this loop
	bne	xloop1			loop until done

*
*  Write a default restart address to all vectors in the vector address
*  area.
*

	movea.l	#$10000,a0		start at this addr ???
	move.l	#$10200,d0		loop until this addr ???
xloop2
	move.l	#copyend+rombeg,(a0)+	write restart addr and bump
	cmp.l	a0,d0			count this loop
	bne	xloop2			loop until done

	move.w	pbdat,d2		get led pattern
	and.w	#$ffbf,d2		light 2nd LED (pb6)
	move.w	d2,pbdat		write to port

	move.l	#$1fff0,$10000		write stack addr to holding addr
	move.w	#$0,$f8			???
	move.b	#$81,cr			reset the CP
	bsr	waitcr			wait until CP finishes
	move.w	pbdat,d2		get led pattern
	and.w	#$ffbe,d2		light 1st and 2nd LED
	move.w	d2,pbdat		write to port

	bra	cont1			start the checkout code

*
*  This code waits until the CP shows it is finished with a command by
*  clearing the FLG bit in the CR.
*

waitcr
	btst.b	#0,cr
	bne	waitcr
	rts

*
*  The above code, from START to here, should be used to start any
*  68302 ROM software based on a PP144 ProClass modem.  It can serve
*  as a common startup file.
*
**************************************************************************



*************************************************************************
*
*  Main code for checkout
*
*  The checkout program sits in a loop, waiting for the user to send a
*  character through the PP144 RS-232 serial port.  The code uses SCC3 to
*  monitor the serial port.
*
*  When the code detects a character, it echoes that character back to the
*  serial port.
*
*  This code also blinks a "heartbeat" LED so you can see that the program
*  is alive.  It also toggles another LED on each received character.
*
*  The characters are detected and echoed using a polling loop, rather than
*  interrupts.
*
*  This code is heavily modified from sample code taken from the Motorola
*  FREEWARE Web site.
*
*  For more details on the original version of this program, consult
*  chapter D, section 4, (Configuring a UART on the MC68302) in Motorola's
*  "68302 Integrated Multiprotocol Processor User's Manual,"
*  available from Motorola or your local Motorola field office.
*

*
* Register initialization values before execution:
*
* D1 = SCCE3 holding register
* D3 = count of characters received
* D4 = count of characters transmitted
* D5 = count of BSY conditions occuring (no receive buffers available)
* D6 = 1 or greater, if character(s) waiting to be transmitted, 0 otherwise
* A0 = current Rx BD pointer
* A1 = current "next TX byte" to send pointer
* A2 = current Tx BD pointer
* A3 = temp

* SCC3 Tx Buffer Descriptors initialization:
* 00xxx640  5000 0000 0003 0000
* 00xxx648  7000 0000 0003 0001  (wrap bit set)

* SCC3 Rx Buffer Descriptors initialization:
* 00xxx600  d000 0000 0003 0002
* 00xxx608  f000 0000 0003 0003  (wrap bit set)



cont1
	 MOVE.W #$00A0,GIMR		; GIMR = 00a0
	 MOVE.W #$FFFF,IPR		; clear IPR

	 MOVE.W #$0300,PACNT		; PACNT = 0300
* Causes the SCC3 TXD3 and RXD3 pins to be enabled.  TCLK3 and RCLK3
* pins are left as parallel I/O pins.

	 MOVE.W #$0,SIMODE		; SIMODE = 0000 (its reset value)
* SCC3 is set up for NMSI (i.e. modem) operation.  No multiplexed
* modes are used on the other SCCs.

	 MOVE.W #$00d8,SCON3	      ; SCON3 = 00d8 for ~9600 baud at 16.67 MHz
* Baud Rate generator is used for transmit and receive. Rate is 9556bps.

	 MOVE.W #$131,SCM3		; SCM3 = 0131, 1 stop bit
* No parity.  Normal UART operation.  8-bit characters.  1 Stop bits.
* The CD* and CTS* lines not used to enable reception and transmission,
* but do cause a status change in the SCC3 Event register.

	 MOVE.L #$50000000,$700640	; Set up Tx BD 0 Status and Count
	 MOVE.L #base,$700644	 	; Set up Tx BD 0 Buffer Address
	 MOVE.L #$70000000,$700648	; Set up Tx BD 1 Status and Count
	 MOVE.L #base+1,$70064c 	; Set up Tx BD 1 Buffer Address
* Set up 2 Tx BDs

	 MOVE.L #$d0000000,$700600     ; Set up Rx BD 0 Status and Count
	 MOVE.L #base+2,$700604        ; Set up Rx BD 0 Buffer Address
	 MOVE.L #$f0000000,$700608     ; Set up Rx BD 1 Status and Count
	 MOVE.L #base+3,$70060c        ; Set up Rx BD 1 Buffer Address
* Set up 2 Rx BDs

	 MOVE.W #$0,$700680	      ; clear RFCR/TFCR (Function code setup)
* Must be initialized to a value other than 7, or won't work with chip selects

	 MOVE.W #$1,$700682	      ; MRBLR = 0001  (one-byte receive buffers)
* This combined with the "I" bit set in the Rx BD, gives interrupts on each
* character received.  

	 MOVE.W #$4,$70069c	      ; MAX_IDL don't care since MRBLR = 1.
* Normally set to a small value, it closes a receive buffer if a certain
* number of idles are received without a new character.  Note that 0 is the
* maximum value.  In this case the buffer will always be closed after 1
* character, so MAX_IDL is a don't care.

	 MOVE.W #$1,$7006A0	      ; BRKCR = 1.  Only one break char. sent if
* STOP TRANSMIT command executed.  The STOP TRANSMIT command is not used in
* this code.

	 MOVE.W #$0,$7006A2		; PAREC = 0000
	 MOVE.W #$0,$7006A4		; FRMEC = 0000
	 MOVE.W #$0,$7006A6		; NOSEC = 0000
	 MOVE.W #$0,$7006A8		; BRKEC = 0000
* Initialize counters to zero

	 MOVE.W #$0,$7006aa		; UADDR1 = 0000
	 MOVE.W #$0,$7006ac		; UADDR2 = 0000
*  UART Address characters not used in normal operation.

	 MOVE.W #$8000,$7006B0		; CHARACTER1 = 8000
* No control characters are initialized to cause special interrupts.
* The flow-control facility (XON-XOFF) is not used.

	 MOVE.B #$FF,SCCE3		; clear SCCE3
	 MOVE.B #$0,SCCM3		; SCCM3 = 0
* Interrupts in SCCM3 are not allowed.
* Note that buffers are 1 character in this application.

	 MOVE.W #$0000,IMR	       ; IMR = 0000.  No interrupts

	 MOVE.W #$13d,SCM3	       ; SCM3 = 013d
* Set ENR and ENT bits in SCM3.
*
*  NOTE:  Contents of Dx and Ax registers (except A7) are unknown at this
*  point.  Initialize them if necessary.
*

	 CLR.L D0		             ; clear all used data registers
	 CLR.L D1   
	 CLR.L D3
	 CLR.L D4

	 MOVEA.L #$700600,A0	       ; Load A0 as current Rx BD pointer
	 MOVEA.L #$700002,A1	       ; Load A1 as current "next Tx Byte" ptr
	 MOVEA.L #$700640,A2	       ; Load A2 as current Tx BD pointer


****************************************************************************
*
*  This is the main loop of the checkout program.  It maintains the heartbeat
*  LED, looks for incoming characters, and echoes any characters back to the
*  serial port.
*
*  Note that calls to the character I/O routines use BSRs, not JSRs.  The
*  assembler assumes this code is running at $0000, which is NOT the case
*  after the system initialization occurs.  Therefore, you must use relative
*  jumps (BSRs) to reach any routines in this ROM, not absolute jumps (JSRs).
*

	move.w	#$ffff,d2		set up led counter
OUTLOOP
	subq.w	#1,d2			count this loop
	cmp.w	#0,d2			reached 0?
	bne	outloop1		branch if not
	move.w	pbdat,d2		yes, get led pattern
	eor.w	#$1,d2			toggle pb0
	move.w	d2,pbdat		switch led
	move.w	#$ffff,d2		reload counter
outloop1
	bsr	chkrcv			test for a received char
	tst.b	d0			anything there?
	beq	outloop			branch if nothing
	bsr	getchar			get the character
	bsr	putchar			echo the character
	bra	outloop			wait for more


*
*  chkrcv      test for a received character
*
*  If character was received, returns D0 as non-zero, else returns D0
*  as 0.
*

chkrcv
	move.b	scce3,d0		put event reg in d0
	and.b	#$01,d0			leave only rx bit
	rts


*
*  putchar      send char in D0 to serial port
*
*  This routine locates the current transmit buffer descriptor (BD) and
*  uses it to set up transmission of the character passed in D0.  If
*  necessary, this code waits until the current BD is marked as free.
*

putchar
	btst	#$0f,(a2)		check ready bit of tx bd
	bne	putchar			loop until buffer is empty

	move.w	pbdat,d2		get current led pattern
	eor.w	#$0040,d2		toggle led1
	move.w	d2,pbdat		show new pattern
	ADDQ.W	#$1,D4			increment number of chars transmitted
	MOVEA.L A2,A3			A3 will be used to find Tx data buffer
	ADDQ.W	#$4,A3			inc A3 to point to Tx data pointer
	MOVEA.L (A3),A3			A3 now points to Tx Data buffer
	move.b	d0,(a3)			put char to send in tx buffer
	ADDQ.W	#2,A2			increment A2 to point to byte count
	MOVE.W	#$1,(A2)		set Tx BD Byte count to 1
	SUBQ.W	#2,A2			A2 now points to beginning of Tx BD
	BSET.B	#$07,(A2)		set Ready bit of Tx BD
* The Tx BD send data status is not checked since the only one is CTS* lost,
* which is not applicable, since CTS is ignored in this application.

* The following updates A2 to point to the next Tx BD
	btst	#$05,(A2)		test Wrap bit
	bne	REINIT2			if set, reinit A2 to 700640
	ADDA.W	#$08,A2			else inc A2 by 8 to next Tx BD
	bra	CONT			jump to Continue on
REINIT2
	MOVEA.L	#$700640,A2		reinitialize A2
cont
	rts				and done


*
*  getchar      get a character from the serial port
*
*  This routine always returns something.  If no character is available,
*  this routine returns a null; otherwise, it returns the received character.
*
*  The character is returned in D0 as a byte.
*
*  Code should always use CHKRCV to test for an available character before
*  calling this routine.  Calling GETCHAR even though no character is actually
*  waiting won't crash anything, but you won't be able to tell whether the
*  user sent a NULL to you.
*

getchar
	clr.l	d0			default char is a null
	CLR.L	D1			clear D1
	MOVE.B	SCCE3,D1		move SCCE3 status to D1
	move.b	#$15,scce3		clear BRK, BSY, and RX bits
	move.w	#$ffff,d2		reload LED counter
	btst	#$2,D1			is BSY set?
	bne	BUSY			jump to BUSY handler if set

* Test Break:
BRKTEST
	btst	#$4,D1			is BRK set?
	bne	BREAK			jump to BREAK handler if set

* Test Receive:
RECTEST
	btst	#$0,D1			is RX set?
	bne	RECEIVE			jump to RECEIVE handler if set
	bra	getcharx		nothing to do, jump to exit

* Busy handler:
BUSY
	BSET.B	#$F,(A0)		set Empty bit of current Rx BD
	bra	BRKTEST			jump to test for BREAK

* Break handler:
BREAK
	NOP				this code ignores received breaks
* The UART BRKEC will record the number of breaks received
	bra	RECTEST			jump to test for RECEIVE

* Receive handler:
RECEIVE
	move.l	4(a0),a4		a4 holds addr of rx buffer
	ADDQ.W	#1,A0			inc A0 to point to Rx BD byte status
	CMPI.B	#$0,(A0)		does status = 00?
	bne	BSTAT			jump to Bad Status if not 00
	move.b	(a4),d0			get char received
INCPTR
	SUBQ.W	#1,A0			dec A0 to point to beginning of Rx BD
	ANDI.W	#$FF00,(A0)		clear out Rx BD status
	BSET.B	#$07,(A0)		set Empty bit of Rx BD
	btst	#$05,(A0)		test Wrap bit
	bne	REINIT0			if set, reinit A0 to 700600
	ADDA.W	#$08,A0 		else inc A0 by 8 to next Rx BD
	bra	getcharx		jump to exit
REINIT0
	MOVEA.L	#$700600,A0		reinitialize A0
	bra	getcharx		jump to exit

* Bad Status:
BSTAT
	NOP				bad status handler would go here
* Note that the UART FRMEC, NOSEC, and PAREC counters record bad status.
	bra	INCPTR			jump back to Receive handler

getcharx
	rts

	END
