#  Project Name
PROJECT = blinky_spinloops

#  List of the objects files to be compiled/assembled
OBJECTS = $(PROJECT).o
LSCRIPT = ..\linker\LPC17xx.ld

#  List of directories to be included during compilation
INCDIRS = ../include

#  List of additional object modules to link in.
#  Use this variable to point to prebuilt object modules
#  that exist outside of a library (such as the startup
#  code).
ADDOBJS = ../object/startup_LPC17xx.o


OPTIMIZATION = 0
DEBUG = -g
ASLISTING = -alhs
#LIBDIRS = C:\CodeSourcery\SourceryG++Lite\lib\gcc\arm-none-eabi\4.5.2
#LIBDIRS += C:\CodeSourcery\SourceryG++Lite\arm-none-eabi\lib
LIBS = C:\CodeSourcery\SourceryG++Lite\lib\gcc\arm-none-eabi\4.5.2\libgcc.a
LIBS += C:\CodeSourcery\SourceryG++Lite\arm-none-eabi\lib\libc.a




#  Compiler Options
GCFLAGS = -Wall -fno-common -mcpu=cortex-m3 -mthumb -O$(OPTIMIZATION) $(DEBUG)
GCFLAGS += -I$(INCDIRS)
#GCFLAGS += -Wcast-align -Wcast-qual -Wimplicit -Wpointer-arith -Wswitch
#GCFLAGS += -Wredundant-decls -Wreturn-type -Wshadow -Wunused
LDFLAGS = -mcpu=cortex-m3 -mthumb -O$(OPTIMIZATION) -nostartfiles -Wl,-Map=$(PROJECT).map -T$(LSCRIPT)
LDFLAGS += $(LIBDIRS)
LDFLAGS += $(LIBS)


ASFLAGS = $(ASLISTING) -mcpu=cortex-m3

#  Compiler/Assembler/Linker Paths
GCC = arm-none-eabi-gcc
AS = arm-none-eabi-as
LD = arm-none-eabi-ld
OBJCOPY = arm-none-eabi-objcopy
REMOVE = rm -f
SIZE = arm-none-eabi-size

#########################################################################

all:: $(PROJECT).hex $(PROJECT).bin $(ADDOBJS) $(LSCRIPT)

$(PROJECT).bin: $(PROJECT).elf
	$(OBJCOPY) -O binary -j .text -j .data $(PROJECT).elf $(PROJECT).bin

$(PROJECT).hex: $(PROJECT).elf
	$(OBJCOPY) -R .stack -O ihex $(PROJECT).elf $(PROJECT).hex

$(PROJECT).elf: $(OBJECTS) $(ADDOBJS)
	$(GCC) $(OBJECTS)  $(ADDOBJS)  $(LDFLAGS)  -o $(PROJECT).elf

stats: $(PROJECT).elf
	$(SIZE) $(PROJECT).elf

clean:
	$(REMOVE) $(OBJECTS)
	$(REMOVE) $(PROJECT).hex
	$(REMOVE) $(PROJECT).elf
	$(REMOVE) $(PROJECT).map
	$(REMOVE) $(PROJECT).bin
	$(REMOVE) *.lst

#########################################################################
#  Default rules to compile .c and .cpp file to .o
#  and assemble .s files to .o

.c.o :
	$(GCC) $(GCFLAGS) -c $<

.cpp.o :
	$(GCC) $(GCFLAGS) -c $<

.s.o :
	$(AS) $(ASFLAGS) -o $@ $< > $(basename $@).lst

#########################################################################
