/*
 *  startup_stm32f4xx.c      C version of the STM32F4xx startup file
 */

#include  <stdio.h>
#include  <stdint.h>
#include "stm32f4xx_gpio.h"
#include "stm32f4xx_rcc.h"
#include "stm32f4xx_flash.h"



/*
 * Define pins used by the GPIO peripherals.
 * Actually, we only care about the RED LED.
 */
#define RED_LED_PIN_NUM						14
#define RED_LED_PIN_MASK                	(1<<RED_LED_PIN_NUM)
#define RED_LED_PORT						GPIOD
#define RED_LED_CLK							RCC_AHB1Periph_GPIOD

#define LEDS_GPIO_PORT  (GPIOD)


/*
 *  Define a C macro for assigning the weak attribute to a function declaration.
 */
#define		WEAK		__attribute__ ((weak))


/*
 *  The following section declares global labels that will be defined
 *  in the linker script.
 */

extern unsigned long 	_etext;
extern unsigned long	_srodata;
extern unsigned long	_erodata;
extern unsigned long 	_sidata;
extern unsigned long 	_sdata;
extern unsigned long 	_edata;
extern unsigned long 	_sbss;
extern unsigned long 	_ebss;
extern unsigned long 	_estack;


/*
 *  Forward declaration for main().
 *  (You might need to alter this, based on your project requirements.)
 */

int			main(void);


/*
 * inline initialization routines borrowed from:
 * https://electronics.stackexchange.com/questions/224618/minimal-code-required-to-startup-a-stm32f4
 */
 
static inline void __initialize_data (long unsigned int* from,
									  long unsigned int* region_begin,
									  long unsigned int* region_end)
{
    // Iterate and copy word by word.
    // It is assumed that the pointers are word aligned.
    long unsigned int		*p;
    
    p = region_begin;
    while (p < region_end)
        *p++ = *from++;
}


static inline void __initialize_bss (long unsigned int* region_begin,
									 long unsigned int* region_end)
{
    // Iterate and clear word by word.
    // It is assumed that the pointers are word aligned.
    long unsigned int 		*p;
    
    p = region_begin;
    while (p < region_end)
        *p++ = 0;
}



/*
 *  The Reset_Handler function is the first code executed following reset.  It
 *  prepares the memory sections used by the C compiler for use by later code.
 *
 *  After setting up the various memory areas, this code invokes the main() function.
 *
 *  Control should never return to this handler.  If control does return to this
 *  handler, an endless loop at the bottom of this function will lock in place.
 */
void  Reset_Handler(void)
{
/*
 *  Copy values from the .data section to the proper locations in SRAM.
 *  This initializes all non-zero variables declared in C code.
 */
	__initialize_data(&_sidata, &_sdata, &_edata);

/*
 *  Write 0 to all non-initialized variables declared in C code (in the linker's .bss section).
 */
	__initialize_bss(&_sbss, &_ebss);
	
/*
 *  Memory is all set up, invoke main().
 */
    main();

    while (1)  ;							// should never get here, but if...

}


#ifdef  BLINK_IN_DEFAULT_HANDLER
/*
 * SpinDelay is a dedicated delay function, used only by the Default_Handler function.
 * The argument dly controls the length of the delay, but the actual delay duration
 * is not guaranteed, as this code does not know what the system clock is.  The value
 * used here is roughly based on a 168 MHz system clock; slower clocks will increase
 * the delay duration.
 */
void  SpinDelay(uint32_t  dly)
{
    while (dly)
    {
        for (uint32_t  n = 1000000; n!=0; n--)  ;
        dly--;
    }
}
#endif


/*
 *  Define a default handler.  Use this default function in any vector
 *  function that you do not have explicit code for.  The default handler
 *  will simply lock in place if it is ever invoked.
 */
void  Default_Handler(void)
{
#ifdef  BLINK_IN_DEFAULT_HANDLER
    GPIO_InitTypeDef			GPIO_InitStructure = {};    // used to set up the LED GPIO lines


	RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_GPIOD, ENABLE);	// debug only for LEDs

    GPIO_InitStructure.GPIO_Pin = RED_LED_PIN_MASK;  		// select the pins to modify (this is a MASK!)
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_OUT;			// set the mode to output
    GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;		// set the I/O speed to 50 MHz
    GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;			// set the output type to push-pull
    GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;		// set the pull-up to none
    GPIO_Init(RED_LED_PORT, &GPIO_InitStructure);			// do the init

    while (1)
    {
        GPIO_SetBits(LEDS_GPIO_PORT, RED_LED_PIN_MASK);     // turn on RED LED
        SpinDelay(10);
        for (uint32_t  n=3; n!=0; n--)
        {  
            GPIO_ResetBits(LEDS_GPIO_PORT, RED_LED_PIN_MASK);     // turn off RED LED
            SpinDelay(3);
            GPIO_SetBits(LEDS_GPIO_PORT, RED_LED_PIN_MASK);     // turn on RED LED
            SpinDelay(3);
        }
    }
#endif

	while (1)  ;
}



/*
 *  Declare weak function handlers for the various vector addresses stored
 *  in flash.  Declaring them weak means they can be overwritten by other
 *  code, should you need to.
 *
 *  You can replace any of the handler functions below with your own code.
 *  You simply write the replacement handler function in one of your
 *  source files; the linker will automatically use your new function rather
 *  than the default handler.
 *
 *  Note that your function handler must have the exact same name as the
 *  corresponding handler function defined below.
 *
 *  For example, if you need to write your own handler for the EXTI0 IRQ,
 *  you would write a void function with the name EXTI0_IRQHandler in your
 *  source file.  At link time, the linker would use your function, rather
 *  than the Default_Handler function above.  So your code would look like:
 *
 *  void  EXTI0_IRQHandler(void)
 *  {
 *        // your code goes here
 *  };
 *
 *  Note that your new handler code goes in your own source file, NOT in
 *  this file!  Do not modify any of the handler function declarations or
 *  vector address assignments in this file!
 */

void  NMI_Handler(void)			    WEAK __attribute__ ((alias("Default_Handler")));
void  HardFault_Handler(void)	    WEAK __attribute__ ((alias("Default_Handler")));
void  MemManage_Handler(void)	    WEAK __attribute__ ((alias("Default_Handler")));
void  BusFault_Handler(void)	    WEAK __attribute__ ((alias("Default_Handler")));
void  UsageFault_Handler(void)	    WEAK __attribute__ ((alias("Default_Handler")));
void  SVC_Handler(void)	            WEAK __attribute__ ((alias("Default_Handler")));
void  DebugMon_Handler(void)	    WEAK __attribute__ ((alias("Default_Handler")));
void  PendSV_Handler(void)	        WEAK __attribute__ ((alias("Default_Handler")));
void  SysTick_Handler(void)	        WEAK __attribute__ ((alias("Default_Handler")));
void  WWDG_IRQHandler(void)	        WEAK __attribute__ ((alias("Default_Handler")));
void  PVD_IRQHandler(void)	        WEAK __attribute__ ((alias("Default_Handler")));
void  TAMP_STAMP_IRQHandler(void) 	WEAK __attribute__ ((alias("Default_Handler")));
void  RTC_WKUP_IRQHandler(void)   	WEAK __attribute__ ((alias("Default_Handler")));
void  FLASH_IRQHandler(void)  	    WEAK __attribute__ ((alias("Default_Handler")));
void  RCC_IRQHandler(void)    	    WEAK __attribute__ ((alias("Default_Handler")));
void  EXTI0_IRQHandler(void)  	    WEAK __attribute__ ((alias("Default_Handler")));
void  EXTI1_IRQHandler(void)  	    WEAK __attribute__ ((alias("Default_Handler")));
void  EXTI2_IRQHandler(void)        WEAK __attribute__ ((alias("Default_Handler")));
void  EXTI3_IRQHandler(void)        WEAK __attribute__ ((alias("Default_Handler")));
void  EXTI4_IRQHandler(void)      	WEAK __attribute__ ((alias("Default_Handler")));
void  DMA1_Stream0_IRQHandler(void) WEAK __attribute__ ((alias("Default_Handler")));
void  DMA1_Stream1_IRQHandler(void) WEAK __attribute__ ((alias("Default_Handler")));
void  DMA1_Stream2_IRQHandler(void) WEAK __attribute__ ((alias("Default_Handler")));
void  DMA1_Stream3_IRQHandler(void) WEAK __attribute__ ((alias("Default_Handler")));
void  DMA1_Stream4_IRQHandler(void) WEAK __attribute__ ((alias("Default_Handler")));
void  DMA1_Stream5_IRQHandler(void) WEAK __attribute__ ((alias("Default_Handler")));
void  DMA1_Stream6_IRQHandler(void) WEAK __attribute__ ((alias("Default_Handler")));
void  ADC_IRQHandler(void)  	    WEAK __attribute__ ((alias("Default_Handler")));
void  CAN1_TX_IRQHandler(void)  	WEAK __attribute__ ((alias("Default_Handler")));
void  CAN1_RX0_IRQHandler(void)  	WEAK __attribute__ ((alias("Default_Handler")));
void  CAN1_RX1_IRQHandler(void)     WEAK __attribute__ ((alias("Default_Handler")));
void  CAN1_SCE_IRQHandler(void)     WEAK __attribute__ ((alias("Default_Handler")));
void  EXTI9_5_IRQHandler(void)      WEAK __attribute__ ((alias("Default_Handler")));
void  TIM1_BRK_TIM9_IRQHandler(void)  	WEAK __attribute__ ((alias("Default_Handler")));
void  TIM1_UP_TIM10_IRQHandler(void)  	WEAK __attribute__ ((alias("Default_Handler")));
void  TIM1_TRG_COM_TIM11_IRQHandler(void)  	WEAK __attribute__ ((alias("Default_Handler")));
void  TIM1_CC_IRQHandler(void)      WEAK __attribute__ ((alias("Default_Handler")));
void  TIM2_IRQHandler(void)  	    WEAK __attribute__ ((alias("Default_Handler")));
void  TIM3_IRQHandler(void)  	    WEAK __attribute__ ((alias("Default_Handler")));
void  TIM4_IRQHandler(void)  	    WEAK __attribute__ ((alias("Default_Handler")));
void  I2C1_EV_IRQHandler(void)  	WEAK __attribute__ ((alias("Default_Handler")));
void  I2C1_ER_IRQHandler(void)  	WEAK __attribute__ ((alias("Default_Handler")));
void  I2C2_EV_IRQHandler(void)  	WEAK __attribute__ ((alias("Default_Handler")));
void  I2C2_ER_IRQHandler(void) 	    WEAK __attribute__ ((alias("Default_Handler")));
void  SPI1_IRQHandler(void)  	    WEAK __attribute__ ((alias("Default_Handler")));
void  SPI2_IRQHandler(void)  	    WEAK __attribute__ ((alias("Default_Handler")));
void  USART1_IRQHandler(void)  	    WEAK __attribute__ ((alias("Default_Handler")));
void  USART2_IRQHandler(void)  	    WEAK __attribute__ ((alias("Default_Handler")));
void  USART3_IRQHandler(void)  	    WEAK __attribute__ ((alias("Default_Handler")));
void  EXTI15_10_IRQHandler(void)  	WEAK __attribute__ ((alias("Default_Handler")));
void  RTC_Alarm_IRQHandler(void)  	WEAK __attribute__ ((alias("Default_Handler")));
void  OTG_FS_WKUP_IRQHandler(void)  	WEAK __attribute__ ((alias("Default_Handler")));
void  TIM8_BRK_TIM12_IRQHandler(void)  	WEAK __attribute__ ((alias("Default_Handler")));
void  TIM8_UP_TIM13_IRQHandler(void)  	WEAK __attribute__ ((alias("Default_Handler")));
void  TIM8_TRG_COM_TIM14_IRQHandler(void)  	WEAK __attribute__ ((alias("Default_Handler")));
void  TIM8_CC_IRQHandler(void)  	WEAK __attribute__ ((alias("Default_Handler")));
void  DMA1_Stream7_IRQHandler(void)  	WEAK __attribute__ ((alias("Default_Handler")));
void  FMC_IRQHandler(void)  	    WEAK __attribute__ ((alias("Default_Handler")));
void  SDIO_IRQHandler(void)  	    WEAK __attribute__ ((alias("Default_Handler")));
void  TIM5_IRQHandler(void)  	    WEAK __attribute__ ((alias("Default_Handler")));
void  SPI3_IRQHandler(void)  	    WEAK __attribute__ ((alias("Default_Handler")));
void  UART4_IRQHandler(void)  	    WEAK __attribute__ ((alias("Default_Handler")));
void  UART5_IRQHandler(void)  	    WEAK __attribute__ ((alias("Default_Handler")));
void  TIM6_DAC_IRQHandler(void)  	WEAK __attribute__ ((alias("Default_Handler")));
void  TIM7_IRQHandler(void)  	    WEAK __attribute__ ((alias("Default_Handler")));
void  DMA2_Stream0_IRQHandler(void) WEAK __attribute__ ((alias("Default_Handler")));
void  DMA2_Stream1_IRQHandler(void) WEAK __attribute__ ((alias("Default_Handler")));
void  DMA2_Stream2_IRQHandler(void) WEAK __attribute__ ((alias("Default_Handler")));
void  DMA2_Stream3_IRQHandler(void) WEAK __attribute__ ((alias("Default_Handler")));
void  DMA2_Stream4_IRQHandler(void) WEAK __attribute__ ((alias("Default_Handler")));
void  ETH_IRQHandler(void)  	    WEAK __attribute__ ((alias("Default_Handler")));
void  ETH_WKUP_IRQHandler(void)  	WEAK __attribute__ ((alias("Default_Handler")));
void  CAN2_TX_IRQHandler(void)  	WEAK __attribute__ ((alias("Default_Handler")));
void  CAN2_RX0_IRQHandler(void)  	WEAK __attribute__ ((alias("Default_Handler")));
void  CAN2_RX1_IRQHandler(void)  	WEAK __attribute__ ((alias("Default_Handler")));
void  CAN2_SCE_IRQHandler(void)  	WEAK __attribute__ ((alias("Default_Handler")));
void  OTG_FS_IRQHandler(void)  	    WEAK __attribute__ ((alias("Default_Handler")));
void  DMA2_Stream5_IRQHandler(void) WEAK __attribute__ ((alias("Default_Handler")));
void  DMA2_Stream6_IRQHandler(void) WEAK __attribute__ ((alias("Default_Handler")));
void  DMA2_Stream7_IRQHandler(void) WEAK __attribute__ ((alias("Default_Handler")));
void  USART6_IRQHandler(void)  	    WEAK __attribute__ ((alias("Default_Handler")));
void  I2C3_EV_IRQHandler(void)  	WEAK __attribute__ ((alias("Default_Handler")));
void  I2C3_ER_IRQHandler(void)  	WEAK __attribute__ ((alias("Default_Handler")));
void  OTG_HS_EP1_OUT_IRQHandler(void)  	WEAK __attribute__ ((alias("Default_Handler")));
void  OTG_HS_EP1_IN_IRQHandler(void)  	WEAK __attribute__ ((alias("Default_Handler")));
void  OTG_HS_WKUP_IRQHandler(void)  WEAK __attribute__ ((alias("Default_Handler")));
void  OTG_HS_IRQHandler(void)  	    WEAK __attribute__ ((alias("Default_Handler")));
void  DCMI_IRQHandler(void)  	    WEAK __attribute__ ((alias("Default_Handler")));
void  CRYP_IRQHandler(void)  	    WEAK __attribute__ ((alias("Default_Handler")));
void  HASH_RNG_IRQHandler(void)  	WEAK __attribute__ ((alias("Default_Handler")));
void  FPU_IRQHandler(void)  	    WEAK __attribute__ ((alias("Default_Handler")));




/*
 *  Declare the vector table.
 */
uint32_t vectors[] __attribute__((section(".isr_vector"))) =
{
    (uint32_t)&_estack,					// end of RAM, provided by the linker
    (uint32_t)Reset_Handler,
    (uint32_t)NMI_Handler,
    (uint32_t)HardFault_Handler,
    (uint32_t)MemManage_Handler,
    (uint32_t)BusFault_Handler,
    (uint32_t)UsageFault_Handler,
    0,                                          // reserved
    0,                                          // reserved
    0,                                          // reserved
    0,                                          // reserved
    (uint32_t)SVC_Handler,
    (uint32_t)DebugMon_Handler,
    0,                                          // reserved
    (uint32_t)PendSV_Handler,
    (uint32_t)SysTick_Handler,
//  External interrupts
    (uint32_t)WWDG_IRQHandler,
    (uint32_t)PVD_IRQHandler,
    (uint32_t)TAMP_STAMP_IRQHandler,         
    (uint32_t)RTC_WKUP_IRQHandler,                   
    (uint32_t)FLASH_IRQHandler,
    (uint32_t)RCC_IRQHandler,
    (uint32_t)EXTI0_IRQHandler,
    (uint32_t)EXTI1_IRQHandler,
    (uint32_t)EXTI2_IRQHandler,
    (uint32_t)EXTI3_IRQHandler,
    (uint32_t)EXTI4_IRQHandler,
    (uint32_t)DMA1_Stream0_IRQHandler,
    (uint32_t)DMA1_Stream1_IRQHandler,
    (uint32_t)DMA1_Stream2_IRQHandler,
    (uint32_t)DMA1_Stream3_IRQHandler,
    (uint32_t)DMA1_Stream4_IRQHandler,
    (uint32_t)DMA1_Stream5_IRQHandler,
    (uint32_t)DMA1_Stream6_IRQHandler,
    (uint32_t)ADC_IRQHandler,
    (uint32_t)CAN1_TX_IRQHandler,
    (uint32_t)CAN1_RX0_IRQHandler,
    (uint32_t)CAN1_RX1_IRQHandler,
    (uint32_t)CAN1_SCE_IRQHandler,
    (uint32_t)EXTI9_5_IRQHandler,
    (uint32_t)TIM1_BRK_TIM9_IRQHandler,
    (uint32_t)TIM1_UP_TIM10_IRQHandler,
    (uint32_t)TIM1_TRG_COM_TIM11_IRQHandler,
    (uint32_t)TIM1_CC_IRQHandler,
    (uint32_t)TIM2_IRQHandler,
    (uint32_t)TIM3_IRQHandler,
    (uint32_t)TIM4_IRQHandler,
    (uint32_t)I2C1_EV_IRQHandler,
    (uint32_t)I2C1_ER_IRQHandler,
    (uint32_t)I2C2_EV_IRQHandler,
    (uint32_t)I2C2_ER_IRQHandler,
    (uint32_t)SPI1_IRQHandler,
    (uint32_t)SPI2_IRQHandler,
    (uint32_t)USART1_IRQHandler,
    (uint32_t)USART2_IRQHandler,
    (uint32_t)USART3_IRQHandler,
    (uint32_t)EXTI15_10_IRQHandler,
    (uint32_t)RTC_Alarm_IRQHandler,
    (uint32_t)OTG_FS_WKUP_IRQHandler,
    (uint32_t)TIM8_BRK_TIM12_IRQHandler,
    (uint32_t)TIM8_UP_TIM13_IRQHandler,
    (uint32_t)TIM8_TRG_COM_TIM14_IRQHandler,
    (uint32_t)TIM8_CC_IRQHandler,
    (uint32_t)DMA1_Stream7_IRQHandler,
    (uint32_t)FMC_IRQHandler,
    (uint32_t)SDIO_IRQHandler,
    (uint32_t)TIM5_IRQHandler,
    (uint32_t)SPI3_IRQHandler,
    (uint32_t)UART4_IRQHandler,
    (uint32_t)UART5_IRQHandler,
    (uint32_t)TIM6_DAC_IRQHandler,
    (uint32_t)TIM7_IRQHandler,
    (uint32_t)DMA2_Stream0_IRQHandler,
    (uint32_t)DMA2_Stream1_IRQHandler,
    (uint32_t)DMA2_Stream2_IRQHandler,
    (uint32_t)DMA2_Stream3_IRQHandler,
    (uint32_t)DMA2_Stream4_IRQHandler,
    (uint32_t)ETH_IRQHandler,
    (uint32_t)ETH_WKUP_IRQHandler,
    (uint32_t)CAN2_TX_IRQHandler,
    (uint32_t)CAN2_RX0_IRQHandler,
    (uint32_t)CAN2_RX1_IRQHandler,
    (uint32_t)CAN2_SCE_IRQHandler,
    (uint32_t)OTG_FS_IRQHandler,
    (uint32_t)DMA2_Stream5_IRQHandler,
    (uint32_t)DMA2_Stream6_IRQHandler,
    (uint32_t)DMA2_Stream7_IRQHandler,
    (uint32_t)USART6_IRQHandler,
    (uint32_t)I2C3_EV_IRQHandler,
    (uint32_t)I2C3_ER_IRQHandler,
    (uint32_t)OTG_HS_EP1_OUT_IRQHandler,
    (uint32_t)OTG_HS_EP1_IN_IRQHandler,
    (uint32_t)OTG_HS_WKUP_IRQHandler,
    (uint32_t)OTG_HS_IRQHandler,
    (uint32_t)DCMI_IRQHandler,
    (uint32_t)CRYP_IRQHandler,
    (uint32_t)HASH_RNG_IRQHandler,
    (uint32_t)FPU_IRQHandler,
};



