#ifndef ROMDUMPER_H
#define ROMDUMPER_H

#include <QDialog>
#include <QProcess>

namespace Ui {
class ROMDumper;
}

class ROMDumper : public QDialog
{
    Q_OBJECT

public:
    explicit ROMDumper(QString port, QString pLUTPath, QWidget *parent = 0);
    ~ROMDumper();
    void repaintBuffer();
    QString port;
    QString pLUTPath;
    bool powerDisplayer();

public slots:
    void onFinished(int,QProcess::ExitStatus);

private slots:
    void on_cbType_currentIndexChanged(const QString &arg1);

    void on_btnLoad_clicked();

    void on_btnSave_clicked();

    void on_btnClear_clicked();

    void on_btnExit_clicked();

    void on_btnRead_clicked();

    void on_btnVerify_clicked();

private:
    Ui::ROMDumper *ui;
    QProcess *process;
    void controls(bool);

};

#endif // ROMDUMPER_H
