#include "UsbKeyboard.h"
//MCbx 2016
//GNU GPL

//extended keypad scancodes
#define KEYP_1      89
#define KEYP_2      90
#define KEYP_3      91
#define KEYP_4      92
#define KEYP_5      93
#define KEYP_6      94
#define KEYP_7      95
#define KEYP_8      96
#define KEYP_9      97
#define KEYP_0      98


//pins for keys. 5 keys used, one is spare.
#define KEY_1 7 
#define KEY_2 8 
#define KEY_3 9 
#define KEY_4 10
#define KEY_5 11

//keys scancodes for installing and releasing
#define CODE1_DOWN KEY_A
#define CODE1_UP KEY_B
#define CODE2_DOWN KEY_C
#define CODE2_UP KEY_D
#define CODE3_DOWN KEY_E
#define CODE3_UP KEY_F
#define CODE4_DOWN KEY_G
#define CODE4_UP KEY_H
#define CODE5_DOWN KEY_I
#define CODE5_UP KEY_J

//#define CODE1_DOWN KEY_F12
//#define CODE1_UP KEY_F11
//#define CODE2_DOWN KEY_F10
//#define CODE2_UP KEY_F10
//#define CODE3_DOWN KEY_F8
//#define CODE3_UP KEY_F7
//#define CODE4_DOWN KEY_F6
//#define CODE4_UP KEY_F5
//#define CODE5_DOWN KEY_F4
//#define CODE5_UP KEY_F3

//Modifier for opening sequence
#define MODIFIER MOD_ALT_LEFT+MOD_SHIFT_LEFT+MOD_GUI_LEFT
//#define MODIFIER 0

char lastState1 = HIGH;
char lastState2 = HIGH;
char lastState3 = HIGH;
char lastState4 = HIGH;
char lastState5 = HIGH;

void setup() {
  //diagnostic LED setup
  pinMode(13,OUTPUT);
  digitalWrite(13,HIGH);

  //button setup
  pinMode(KEY_1, INPUT_PULLUP);
  pinMode(KEY_2, INPUT_PULLUP);
  pinMode(KEY_3, INPUT_PULLUP);
  pinMode(KEY_4, INPUT_PULLUP);
  pinMode(KEY_5, INPUT_PULLUP);
  
  // USB setup -----------------
  // Disable timer0 since it can mess with the USB timing. Note that
  // this means some functions such as delay() will no longer work.
  TIMSK0 &= !(1<TOIE0); //atmega328
  // Clear interrupts while performing time-critical operations
  cli();

  // Force re-enumeration so the host will detect us
  usbDeviceDisconnect();
  delayMs(250);
  usbDeviceConnect();

  // Set interrupts again
  sei();
} 

void loop() 
{
  digitalWrite(13,LOW);
  // update USB device state
  UsbKeyboard.update();

  //Now the most important thing. We check for transitions. If we have Low-high, button is pressed
  //If we have high-low, button is released. This pushes two different codes for keys. Buttons
  //work only in single-code.

  //KEYS
  if( (digitalRead(KEY_1) == LOW) && (lastState1==HIGH) ) 
  {
    digitalWrite(13,HIGH);
    UsbKeyboard.sendKeyStroke(CODE1_DOWN, MODIFIER);    
    lastState1 = LOW;
    delay(100); 
  } 
  else 
  if( (digitalRead(KEY_1) == HIGH) && (lastState1==LOW) ) 
  {
    digitalWrite(13,HIGH);
    UsbKeyboard.sendKeyStroke(CODE1_UP, MODIFIER);
    lastState1 = HIGH;
    delay(100);
  }

  if( (digitalRead(KEY_2) == LOW) && (lastState2==HIGH) ) 
  {
    digitalWrite(13,HIGH);
    UsbKeyboard.sendKeyStroke(CODE2_DOWN, MODIFIER);
    lastState2 = LOW;
    delay(100); 
  } 
  else 
  if( (digitalRead(KEY_2) == HIGH) && (lastState2==LOW) ) 
  {
    digitalWrite(13,HIGH);
    UsbKeyboard.sendKeyStroke(CODE2_UP, MODIFIER);
    lastState2 = HIGH;
    delay(100);
  }

  if( (digitalRead(KEY_3) == LOW) && (lastState3==HIGH) ) 
  {
    digitalWrite(13,HIGH);
    UsbKeyboard.sendKeyStroke(CODE3_DOWN, MODIFIER);
    lastState3 = LOW;
    delay(100); 
  } 
  else 
  if( (digitalRead(KEY_3) == HIGH) && (lastState3==LOW) ) 
  {
    digitalWrite(13,HIGH);
    UsbKeyboard.sendKeyStroke(CODE3_UP, MODIFIER);
    lastState3 = HIGH;
    delay(100);
  }

  if( (digitalRead(KEY_4) == LOW) && (lastState4==HIGH) ) 
  {
    digitalWrite(13,HIGH);
    UsbKeyboard.sendKeyStroke(CODE4_DOWN, MODIFIER);
    lastState4 = LOW;
    delay(100); 
  } 
  else 
  if( (digitalRead(KEY_4) == HIGH) && (lastState4==LOW) ) 
  {
    digitalWrite(13,HIGH);
    UsbKeyboard.sendKeyStroke(CODE4_UP, MODIFIER);
    lastState4 = HIGH;
    delay(100);
  }

  if( (digitalRead(KEY_5) == LOW) && (lastState5==HIGH) ) 
  {
    digitalWrite(13,HIGH);
    UsbKeyboard.sendKeyStroke(CODE5_DOWN, MODIFIER);
    lastState5 = LOW;
    delay(100); 
  } 
  else 
  if( (digitalRead(KEY_5) == HIGH) && (lastState5==LOW) ) 
  {
    digitalWrite(13,HIGH);
    UsbKeyboard.sendKeyStroke(CODE5_UP, MODIFIER);
    lastState5 = HIGH;
    delay(100);
  }
  
}

// helper method for V-USB library, disabling timer fails 
// built-in ms delay method.
void delayMs(unsigned int ms) {
  for( int i=0; i<ms; i++ ) {
    delayMicroseconds(1000);
  }
}
