; This procedure gets the x and y coordinates of the map field and the
; positions of the interesting memory parts. It profits by that all civ.exe
; versions need most of these informations, when they calculate whether a
; field is know or not. This happens for example, when you right click on
; a field of the map, because the program has to test, whether you can get
; informations of the landscape (when it is known) or not. The program code
; has the following appearance (version 1, 2(?)):
;
; E9 54 00       a jmp call           ; these bytes are varying between the
;                                     ; different versions
; B8 32 00       mov ax, 0032         ; these bytes you have changed to
;                                     ;  CD F1 90  int F1, nop
; F7 6E E4       imul word ptr [bp-1C]; at this stack position lies the x position
; 8B F0          mov si, ax
; 8B 5E DA       mov bx, [bp-26]      ; y position
; 8A 80 F8 7F    mov al, [bx+si+7FF8] ; offset of known/unknown data address
;                                     ; (segment: ds register)
; 98             cbw
; BA 01 00       mov dx, 0001
; 8A 0E 10 E7    mov cl, [E710]       ; ds:[E710] contains at with bit is
;                                     ; stored, whether YOUR civilization
;                                     ; knows that place
; D3 E2          shl dx, cl
; 85 C2          test dx, ax
; ...
;
; version 3-5:
;
; ?? ?? ??       a jmp call           ; these bytes are varying between the
;                                     ; different versions
; B8 32 00       mov ax, 0032         ; these bytes you have changed to
;                                     ;  CD F1 90  int F1, nop
; F7 6E E4       imul word ptr [bp-1C]; at this stack position lies the x position
; 8B D8          mov bx, ax
; 03 5E DA       add bx, [bp-26]      ; y position
; 8E 06 E4 63    mov es, [63E4]       ; ds:[63E4] contains segment address of
;                                     ; known/unknown data (this address like
;                                     ; all segment addresses will be created
;                                     ; after starting civ.exe)
; 26 8A 87 40 07 mov al, es:[bx+0740] ; offset of known/unknown address
; 98             cbw
; BA 01 00       mov dx, 0001
; 8A 0E EE D7    mov cl, [D7EE]       ; ds:[D7EE] contains at with bit is
;                                     ; stored, whether YOUR civilization
;                                     ; knows that place
; D3 E2          shl dx, cl
; 85 C2          test dx, ax
; ...
;
; The procedure civext2 steps over this program code and gets the interesting
; informations. To find the main data area which e.g. contains the map itsself
; it searches near the probable position for 80 bytes, which only consist of
; 07 and 0F (at least 5 of each; the first map row only contains tundra (07)
; and arctic (0F)), and then for 80 bytes, which consists of 01, 07 or 0F.
; Because of this you are not allowed to change the first two map rows !

code       segment word public
           assume cs:code
           public civext21;

civext21    proc far
            push bp
            mov di, sp                 ; stack position to di
            push ds
            mov si, ss:[bp+14h]        ; get segment of int F1 call from
            mov es, si                 ;   stack -> es
            mov bx, ss:[bp+12h]        ; get offset of int F1 call -> bx
            inc bx                     ; jump over the nop; es:bx now points
                                       ;   to the imul ... command of civ.exe
                                       ;   (see above)
            mov si, ss:[bp+4h]
            mov ds, si                 ; get data segment of civ.exe before
                                       ;   the int f1 call from stack -> ds
            mov bp, ss:[bp]            ; bp before int f1 call -> bp
            mov ax, es:[bx]            ; get first bytes after the nop
            cmp ax, 6ef7h              ; test: are they F7 6E (imul ...)
            jne error
            inc bx                     ; bx two bytes further on
            inc bx
            mov ch, 0FFh
            mov cl, byte ptr es:[bx]   ; get position of x position on stack
                                       ;   (e.g. E4 means [bp+FFE4] = [bp-1C])
            mov si, cx
            mov ax, ss:[bp+si]         ; get x position
            mov si, ss:[di+0ah]        ; write to variable column
            mov ss:[si], ax
            add bx, 04h                ; bx = bx+4
            cmp byte ptr es:[bx], 5eh  ; there should be a 5E
            jne error
            inc bx
            mov ch, 0ffh               ; then follows the position of the
            mov cl, byte ptr es:[bx]   ; y position on stack
            mov si, cx
            mov ax, ss:[bp+si]         ; get y position
            mov si, ss:[di+0eh]        ; write to variable row
            mov ss:[si], ax
            inc bx
            mov al, byte ptr es:[bx]   ; the next byte is a 8A in version 1,2
            cmp al, 8eh                ; and a 8E in version 3-5
            je ver5
            cmp al, 8ah
            jne error
            mov ax, ds                 ; version 1,2: ds contains the segment
                                       ;   of the known/unknown data
            mov si, ss:[di+1eh]        ; write to variable segm_dark
            mov ss:[si], ax
            inc bx                     ; bx = bx+2
            inc bx
            mov ax, es:[bx]            ; get offset of known/unknown data
            jmp l1
error:      jmp error1                 ; a dummy; the first jne error cannot
                                       ;   reach the error procedure otherwise
ver5:       inc bx                     ; version 3-5:
            inc bx
            mov si, es:[bx]            ; get pointer to segment address of
                                       ; known/unknown data
            mov ax, ds:[si]            ; get segment address
            mov si, ss:[di+1eh]        ; write this to variable segm_dark
            mov ss:[si], ax
            add bx, 05h                ; bx = bx+5
            mov ax, es:[bx]            ; get offset address of these data
l1:         mov si, ss:[di+1ah]        ; write it to variable off_dark
            mov ss:[si], ax
            add bx, 07h                ; bx = bx+7
            cmp byte ptr es:[bx], 0eh  ; if all is ok., then is here a 0E
            jne error
            inc bx
            mov si, es:[bx]            ; get pointer on number of own civil.
            mov cl, ds:[si]            ; get number
            mov ax, 0001               ; calculate at which bit is stored
                                       ; whether YOUR civ. knows a map field
            shl ax,cl
            mov si, ss:[di+16h]        ; put this to variable dark_pos
            mov ss:[si], ax
            mov si, es                 ; estimate segment address where the
                                       ; start of the main data can be found
            add si, 4a00h
            mov es, si
            mov bx, 0h
            mov cx, 0h
            mov si, 0h
l3:         mov dx, 50h                ; searching for the first 50h bytes
            mov bx, 0h
            mov cx, 0h
l4:         inc si                     ; offset = offset+1
            jz error                   ; end of segment reached ?
            mov al, byte ptr es:[si]   ; get byte
            cmp al, 07h                ; is it a 07h (tundra)
            jne l6
            inc bx
            jmp l7
l6:         cmp al, 0fh                ; or a 0fh (arctic)
            jne l3
            inc cx
l7:         dec dx
            je l5                      ; the $50th byte found?
            jmp l4
l5:         cmp bl, 05h                ; has there been 5 tundra at least
            jl l3
            cmp cl, 10h                ; and at least 16 arctic ?
            jl l3
            mov dx, 50h                ; test the next 50h bytes as a
            mov bx, 0h                 ;   precaution
            mov cx, 0h
            add si, 0f0h
            jc error1 
l14:        inc si                     ; offset = offset+1
            jz error1                  ; end of segment reached ?
            mov al, byte ptr es:[si]   ; get byte
            cmp al, 07h                ; is it a 07h (tundra)
            jne l16
            inc bx
            jmp l17
l16:        cmp al, 0fh                ; or a 0fh (arctic)
            jne l18
            inc bx
            jmp l17
l18:        cmp al,01h                 ; or 01h (water)
            jne l3                     ; no, hasn't been the right block
            inc cx
l17:        dec dx
            je l15                      ; the $50th byte found?
            jmp l14
l15:        cmp bl, 05h                ; has there been 5 land at least
            jl l3
            cmp cl, 10h                ; and at least 16 water ?
            jl l3
            mov cl, 4                  ; calculate correct data segment
            shr si, cl                 ;  (offset of data start should be 0h)
            sub si, 18h
            mov ax, es
            add ax, si
            mov si, ss:[di+12h]        ; segment to variable segm_data
            mov ss:[si], ax
            mov ax,0                   ; no error!
            jmp l2
error1:     mov ax,1                   ; error!
l2:         mov si, ss:[di+06h]        ; write errorlevel to variable error
            mov ss:[si], ax
            pop ds
            mov sp, di
            pop bp
            ret                        ; that's all
civext21    endp

code        ends
            end
