
/* Copyright 1993 by Peter Sprenger   Pete@amber.dinoco.de
 *                   5014 Kerpen 3
 *                   Germany
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The author Peter Sprenger
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */


#ifndef __SBP__

#define __SBP__

#define DSP_RESET 6
#define DSP_READ 0xa
#define DSP_WRITE 0xc
#define DSP_WSTATUS 0xc
#define DSP_RSTATUS 0xe

#define FM_DETECT 1
#define DSP_DETECT 2

#define DSP_DMA_8BIT 0x14
#define DSP_DMA_ADC 0x24

#define DSP_MIDI_WRITE 0x38
#define DSP_MIDI_READI 0x31
#define DSP_MIDI_UART 0x35

#define DSP_DMA_4BIT_REF 0x75
#define DSP_DMA_4BIT 0x74

#define DSP_DMA_26BIT_REF 0x77
#define DSP_DMA_26BIT 0x76

#define DSP_DMA_2BIT_REF 0x17
#define DSP_DMA_2BIT 0x16

#define DSP_SAMPLE_RATE 0x40
#define DSP_BLOCK_SIZE 0x48

#define DSP_SILENCE 0x80

#define DSP_DMA_HIGHSPEED 0x91
#define DSP_DMA_ADC_HIGHSPEED 0x99

#define DSP_SPKR_ON 0xd1
#define DSP_SPKR_OFF 0xd3

#define DSP_HALT_DMA 0xd0
#define DSP_CONT_DMA 0xd4

#define DSP_GET_VERS 0xe1

#define DSP_INVOKE_INTR 0xf2

#define FM_BOTH_OFF  8
#define FM_LEFT_OFF  0
#define FM_RIGHT_OFF 2

#define MIX_ADR_OFF 4
#define MIX_DATA_OFF 5

#define MIX_VOICE_VOL 4      /* Mixer register addresses */
#define MIX_MICRO_VOL 0xa
#define MIX_INPUT 0xc
#define MIX_OUTPUT 0xe
#define MIX_MASTER_VOL 0x22
#define MIX_FM_VOL 0x26
#define MIX_CD_VOL 0x28
#define MIX_LINE_IN_VOL 0x2e

#define MIX_IN_MICRO 0       /* Input register settings */
#define MIX_IN_CD 2
#define MIX_IN_MICRO2 4
#define MIX_IN_LINE 6
#define MIX_LOW_FILT 0
#define MIX_HIGH_FILT 8
#define MIX_NO_FILT 0x20

#define MIX_BYPASS_OUT_FILT 0x20   /* Output register settings */
#define MIX_STEREO 2
#define MIX_MONO 0

#define FM_HIHAT     1
#define FM_TOPCYM    2
#define FM_TOMTOM    4
#define FM_SNARE     8
#define FM_BASS   0x10

typedef enum {bit8=0,bit4=1,bit26=2,bit2=3,high} playmode;
typedef enum {none,nodsp,adlib,sb20,sbpro} cardtype;
typedef enum {both,left,right} fm_chan;
typedef enum {midi,sample} vect;

void FM_Write(WORD data);
void FM_Reset();
BYTE FM_Status();
void FM_SetChan(fm_chan channel);
void FM_SetVoice(BYTE voice,BYTE *ins);
void FM_SetNote(BYTE voice,BYTE note);
void FM_KeyOn(BYTE voice);
void FM_KeyOff(BYTE voice);
void FM_SetVol(BYTE voice,BYTE vol);
void FM_RythmMode(BYTE bool);
void FM_RythmOn(BYTE inst);
void FM_RythmOff(BYTE inst);

void MIX_Reset();
void MIX_SetInput(BYTE opt);
void MIX_SetOutput(BYTE opt);
void MIX_SetVolume(BYTE reg,BYTE left,BYTE right);
void MIX_GetVolume(BYTE reg,BYTE *left,BYTE *right);

void MIDI_Write(BYTE data);
void MIDI_WriteBuf(BYTE *data,int length);
WORD  MIDI_ByteAvail();
BYTE MIDI_GetByte();
void MIDI_ReadBuf(WORD count,BYTE *buffer);
int MIDI_Init(BYTE mode,WORD buflen);
void MIDI_Remove();

int DSP_Reset();
BYTE DSP_Read();
void DSP_Write(BYTE output);
WORD DSP_Get_Version();

void SetRate(DWORD rate);
void SetHighRate(DWORD rate);
int Play(char *data,playmode mode,DWORD length);
int PlayXMS(DWORD data,playmode mode,DWORD length);
int Sample(char *data,playmode mode,DWORD length);

int VocPlay(char far *data);
void VocStop();

int SB_Setup();
void SB_SetVect(vect which);
void SB_RemoveVect();

int get_sb_env();
int CardCheck();
cardtype WhichCard();

#endif

