	page	60,132
;-----------------------------------------------------------------------------
;	Magic.Asm - Snd_File_Play() / Snd_File_Record() - Disk file
;		 play/record code for the PSSJ Digital Sound Toolkit
;	Copyright 1994, Frank Durda IV. 
;	Commercial use is restricted.  See intro(PSSJ) for more information.
;-----------------------------------------------------------------------------
	extrn	_snd_cue:FAR
	extrn	_snd_play:FAR
	extrn	_snd_wait:FAR
	extrn	_snd_flush:FAR
	extrn	snd_fragmove:NEAR	;<24>
	extrn	snd_xfer_buf:NEAR
	extrn	snd_append_buf:NEAR
	extrn	_st_decompress_start:FAR;<24>
	extrn	_st_decompress_supply_buffer:FAR	;<24>
	extrn	_st_decompress_get_data:FAR	;<24>
	extrn	_snd_cue:FAR
	extrn	_snd_record:FAR
	extrn	snd_cat_buf:NEAR
	extrn	snd_reset_clock:NEAR	;<30>
	extrn	_snd_stop:FAR		;<31>
	extrn	rec_depth:WORD, rec_limit:WORD	;<32>
	extrn	snd_cat_chain:NEAR	;<33>
	extrn	snd_dma_stop:NEAR	;<33>
	extrn	snd_file_buf_unload:NEAR;<34>

	include	external.inc

	include	sound.inc
	page
	include	magic.inc

DISK_SIZE	equ	4
STANDBY	equ	2			;<32>Number of STANDBY buffers
snddata	segment	public	'DATA'
	public	indos,filehdl
	public	disk_queue_free		;<34>
	public	disk_exp_queue		;<34>
	public	compress_hold		;<34>
	public	disk_pl_len
indos		dd	0		;Address of INDOS flag in MSDOS
filehdl		dw	0		;File FCB handle
fileoptions	dw	0		;File operation options
filerate	dw	0		;Our copy of speed
fileadjust	dd	0		;Our copy of xlation table
filesilence	dw	0		;silence_len
filethresh	dw	0		;threshold
disk_xfer_buf	dd	0		;Address of buffer currently
					;being used in read/write DOS op
disk_queue_free	dd	0		;Head of queue of buffers reserved
					;for disk I/O
disk_exp_queue	dd	0		;Pointer to buffers read but not
					;yet expanded.
disk_wr_queue	dd	0
	page
compress_hold	dd	0		;<24>Compression buffer pointer
sndoldpsp	dw	0		;Previous PSP
sndourpsp	dw	0		;Our PSP
sndolddta	dd	0		;Previous DTA
ccstat		db	0		;
sndold24	dd	0		;Previous Int 24 trap
$snd_err24	db	0		;Flag for trap 24 detection
disk_rate	db	0		;Rate field
disk_st_len	dd	0
disk_pl_len	dd	0
disk_addr	dd	0
disk_pos	dd	0
disk_bias	db	0
disk_comp_type	dw	0		;<33>
disk_wr_len	dd	0		;Amount of sound data written to disk
disk_rec_len	dd	0		;Amount of sound data recorded

ratetooff	dw	5500
		db	R5500
		dw	11000
		db	R11000
		dw	22000
		db	R22000
		dw	32500
		db	R32500
		dw	39800
		db	R39800
		dw	-1
		db	-1

bytespermil	dw	550
		dw	1100
		dw	2200
		dw	3250
		dw	3980
		dw	-1

recdepth	db	?

snddata	ends

@codesize	equ	1
sptr	struc
	dw	?
	dw	(@codesize+1) dup (?)
sndhdl	dw	?			;Sound File Handle number
sndopt	dw	?			;Sound options
sptr	ends
	page
sndseg	segment	public	'CODE'
	assume	cs:sndseg,ds:snddata
;------------------------------------------------------------------------------
;	This routine performs all the magic involved in reading/writing
;	disks at interrupt time.
;	Based on "Toms Stupid DOS Tricks" - circa Feb 1989

;	Most of the things that follow are completely undocumented
;	in DOS.  They will not work with versions before MS-DOS 3.3
;	and Microsoft might break something in the future.
;	This code was originally developed in Edit 23 & Edit 26.
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
;	When a system buffer is used for file-play or file-record, it
;	contains a disk buffer that was read or is to be written.
;	It also contains enough dummy fields to allow the existing play and
;	record functions to think they are dealing with plain-old memory.
;	So a SOUND and SNDHDR plus some other baggage appear at the
;	start of a buffer.
;	The order is as follows:
;	+0	Buffer chaining information (left intact) HEADER_SIZE
;	+8	SoundHdr SNDHDR_SIZE
;	+20	SoundStr SOUND_SIZE
;	+36	File Control Info (estimate) DISK_SIZE
;	+40	up to 2048 of disk data

;	Initially, I will use two buffers for 5.5, four for 11 and eight for
;	22 Khz.  If there are not enough free buffers , the record or play
;	calls will not start.  This means that at 5.5Khz, five buffers
;	is the absolute minimum you can get away with for playback.
;	One for DMA, two for queuing, two for disk I/O, or 11K.
;------------------------------------------------------------------------------
	page
;------------------------------------------------------------------------------
;	Snd_File_Play

;	This function accepts the file handle from somewhere, allocates some
;	buffers from the play chain, sucks in the header and gets us ready
;	to play.  The player also accepts a word of option flags.
;------------------------------------------------------------------------------
		public _snd_file_play
_snd_file_play	proc far

	push	bp
	mov	bp,sp
	push	si
	push	di
	push	ds
	cld				;<25>Moved to the top to make sure

	mov	ax,snddata
	mov	ds,ax
	assume	DS:snddata
	push	es

;	First, make sure we aren't doing anything.

	mov	ax,snd_mode
	test	ax,INPLAY OR INRECORD OR UNINITIALIZED OR DISKABORT OR DISKPLAY OR DISKRECORD;<34>
	jz	$ok

;	For now, simply abort.

$failx:	mov	ax,INVALID
	pop	es
	pop	ds
	pop	di
	pop	si
	pop	bp
	ret
	page
;	We are not doing anything, so set hardware into play mode

$ok:	call	snd_envinit		;<33>Reset environment
	mov	ax,[bp].sndhdl		;Get file handle
	mov	filehdl,ax		;Store it
	mov	ax,[bp].sndopt		;Get file handle
	mov	fileoptions,ax		;Save options we have received

;	Reinitialize things in case we are re-entering

;	and	snd_mode,NOT (DISKABORT);Reset any left-over signals
	xor	ax,ax
	mov	al,TOPLAY
	push	ax
	call	_snd_cue
	add	sp,2

;	Now attempt to get buffers

	mov	cx,10			;Enough for testing was 8
$buflp:	mov	si,offset queue_free
	mov	di,offset disk_queue_free
	push	cx
	call	snd_xfer_buf
	pop	cx
	jnz	$failx
	loop	$buflp			;Keep going
	page
;	Now process each buffer so that it has headers like ours.

	les	di,disk_queue_free	;Point at first buffer
$prlp:	mov	ax,es
	or	ax,di
	jz	$done

	mov	si,di			;Save original pointer
	add	di,HEADER_SIZE		;Point to start of soundhdr
	lea	ax,[di+SNDHDR_SIZE]
	mov	word ptr es:[di].sndstrptr,ax
	mov	word ptr es:[di+2].sndstrptr,es

	xor	bx,bx
	mov	word ptr es:[di].sndst,bx	;Play complete sound
	mov	word ptr es:[di+2].sndst,bx
	mov	word ptr es:[di].sndend,bx	;Play complete sound
	mov	word ptr es:[di+2].sndend,bx

	mov	di,ax			;Points to soundstr
	mov	ax,DRQLEN
	mov	word ptr es:[di].sndblen,ax	;Set sound buffer max size
	mov	word ptr es:[di+2].sndblen,bx	;0
	mov	word ptr es:[di+2].sndlen,bx	;Set MSB of play len to zero

	lea	ax,[di+SOUND_SIZE+DISK_SIZE]
	mov	word ptr es:[di].sndbuf,ax
	mov	word ptr es:[di+2].sndbuf,es

	les	di,es:[si]		;Move to next buffer
	jmp	short	$prlp

$fail:	jmp	$failx
	page
;	We have enough buffers to start.

$done:	call	snd_frc_read		;Read file header
	inc	ax			;Was the result -1 (error)
	jz	$fail			;Could not read header

	les	si,disk_xfer_buf	;Point at buffer it got put it
	add	si,HEADER_SIZE+SOUND_SIZE+SNDHDR_SIZE+DISK_SIZE

;	es:si now points at the start of the sound file.

	cmp	byte ptr es:[si+2ch],01ah
	jnz	$fail
	mov	al,es:[si+2dh]		;Get mode field
	test	al,80h			;Is one of ours?
	jz	$fail
	page
;	File has been indentified as one of ours
;	Now that the file has been validated, suck in the parms we
;	need.

	mov	ax,es:[si+5ch]		;Get bias
	mov	disk_bias,al

	mov	ax,es:[si+58h]		;Get sampling rate
	cmp	ax,5500
	mov	bl,R5500
	jz	$ratemat
	cmp	ax,11000
	mov	bl,R11000
	jz	$ratemat
	cmp	ax,22000
	mov	bl,R22000
	jnz	$fail
$ratemat:
	mov	disk_rate,bl		;Store sample rate

;	This bit of code loads the speed info into all of our disk blocks

	push	si			;Save this pointer
	push	es
	les	di,disk_queue_free	;Point at first buffer
	mov	bh,disk_bias
$prlp1:	mov	ax,es
	or	ax,di
	jz	$done1

	mov	byte ptr es:[di+HEADER_SIZE+SNDHDR_SIZE].sndrecrate,bl
	mov	byte ptr es:[di+HEADER_SIZE].sndplayrate,bl
	mov	byte ptr es:[di+HEADER_SIZE+SNDHDR_SIZE].sndbias,bh

	les	di,es:[di]		;Move to next buffer
	jmp	short	$prlp1

$done1:	les	di,disk_xfer_buf
	mov	byte ptr es:[di+HEADER_SIZE+SNDHDR_SIZE].sndrecrate,bl
	mov	byte ptr es:[di+HEADER_SIZE].sndplayrate,bl
	mov	byte ptr es:[di+HEADER_SIZE+SNDHDR_SIZE].sndbias,bh
	pop	es
	pop	si

	mov	ax,es:[si+80h]		;Get LSB of length
	mov	word ptr disk_st_len,ax
	mov	ax,es:[si+82h]		;Get MSB of length
	mov	word ptr disk_st_len+2,ax
	page
;<24>	Now, we determine if compression was used (ooooooo, yucky)
	mov	ax,es:[si+42h]		;<24>Get compression type field
	or	ax,ax			;<24>
	mov	word ptr disk_comp_type,ax;<24>Save type or zero
	jz	$nocomp			;<24>Not compressed
	mov	bx,ax			;<24>
	and	bx,007fh		;<24>Lose all but bits 6-0
	cmp	bx,3			;<24>
	jnc	$typok			;<24>Cannot decompress these types
	jmp	$failx			;<24>Letni is soooo wonderful
$typok:	or	word ptr snd_mode,COMPRESS	;<24>Signal compressed file
	call	far ptr _st_decompress_start	;<24>

;	Since we are doing decompression, we need a buffer to hold the
;	decompressed data in, so we will steal one of the disk blocks.

	push	es
	push	si
	mov	si,offset disk_queue_free	;<24>
	mov	di,offset compress_hold	;<24>Rate already set on this buffer
	call	snd_xfer_buf		;<24>
	pop	si
	pop	es

;	Now get sound length (size on disk)

$nocomp:mov	ax,es:[si+84h]		;<24>Get LSB of length
	mov	word ptr disk_pl_len,ax
	mov	ax,es:[si+86h]		;Get MSB of length
	mov	word ptr disk_pl_len+2,ax

	mov	ax,es:[si+7ch]		;Get LSB of sound address
	mov	word ptr disk_addr,ax
	mov	dx,es:[si+7eh]		;Get MSB of sound address
	mov	word ptr disk_addr+2,dx

;	Now we figure out if the start of the sound is in the buffer
;	we already have loaded.

$trynext:
	mov	ax,word ptr disk_addr	;Get offset
	mov	dx,word ptr disk_addr+2

	cmp	dx,word ptr disk_pos[2]	;See if we have read that far yet
	jc	$notyet			;Haven't read that far
	cmp	ax,word ptr disk_pos	;How about the LSB
	jc	$found
	page

;	Read ahead in the file until the block where the start of the
;	sound is located is found

$notyet:mov	si,offset disk_xfer_buf
	mov	di,offset disk_queue_free
	call	snd_xfer_buf

	mov	ax,word ptr disk_pos
	add	ax,DRQLEN		;BASIC position in file
	mov	word ptr disk_pos,ax
	jnc	$notca
	inc	word ptr disk_pos[2]

$notca:	call	snd_frc_read		;Read the next buffer
	inc	ax			;Was the result -1 (error)
	jnz	$trynext		;Look at next buf (sorta)
	jmp	$fail
	page
;	Here the first sample of the sound is in the buffer we are
;	currently looking at, so set the fields accordingly

$found:	les	si,disk_xfer_buf	;Get base address of current buffer
	add	si,HEADER_SIZE+SOUND_SIZE+SNDHDR_SIZE+DISK_SIZE
	mov	di,si			;Save a copy of 1st snd byte in buf
					;This must be refigured as it may
					;not be the buffer the control header
					;was in.
	and	ax,2047			;AX = offset in current buffer
	add	si,ax			;Combine with base for first sample

	mov	cx,offset DRQLEN
	sub	cx,ax	
	mov	word ptr es:[di-(DISK_SIZE+SOUND_SIZE)].sndlen,cx ;Set length
	xor	bx,bx
	mov	word ptr es:[di+2-(DISK_SIZE+SOUND_SIZE)].sndlen,bx	;Set MSB

;	Now, shift the sound down to the beginning of the buffer
;	Although snd_play can handle non-zero starts, decompress cant
;	es:si points at source
;	es:di points at destination

	push	ds			;<24>
	mov	ax,es			;<24>
	mov	ds,ax			;<24>
	call	snd_fragmove		;<24>
	pop	ds			;<24>

	xor	ax,ax			;And the clock is almost running...
	mov	word ptr snd_time_count,ax
	mov	word ptr snd_time_count[2],ax
	or	word ptr snd_mode,DISKPLAY ;Set mode

;	Okay, now we call expandplay which will either call snd_play
;	or decompress it and then call snd_play.  In any event, when
;	we come back, we don't fiddle with the buffer

	les	si,disk_xfer_buf
	mov	dx,es
	mov	di,offset disk_exp_queue
	mov	bx,ds
	mov	es,bx
	call	snd_append_buf
	call	playexpand
	page
;	Now, hook the system timer so we get more chances to run

	cli	;------------------------------------------------------------
	mov	al,CLOCKINT		;When Deskmate exits, 1ch or 8 Int 8
	mov	ah,35h			;vector is altered by DeskMate
	int	21h			;before it allows us to terminate.
	mov	word ptr cs:clkvec,bx
	mov	word ptr cs:clkvec+2,es

	mov	dx,cs
	push	ds
	mov	ds,dx
	lea	dx,SndClkIrq
	mov	ah,25h
	int	21h
	pop	ds

;	Now grab the "sitting in DOS not doing a lot(TM)" vector

	mov	al,28h			;Int 28h
	mov	ah,35h			;Get current vector
	int	21h
	mov	word ptr cs:idlevec,bx
	mov	word ptr cs:idlevec+2,es

	mov	dx,cs
	push	ds
	mov	ds,dx
	lea	dx,SndIdleIrq
	mov	ah,25h
	int	21h
	pop	ds
	page
;	Code to hook additional vectors would go here.....

	or	word ptr snd_mode,DOS_HOOKED;Set mode

;	Now we start reading blocks and expanding them until the player
;	starts.  Then we return.
;<35>	The following routines must be called with interrupts turned off - 
;<35>	they manipulate chains and background is now active.
$doitagain:
	call	disk_rd
	call	playexpand
	call	eofchk
	mov	ax,snd_mode
	test	ax,INPLAY OR DISKABORT	;Player has started
	jz	$doitagain
	sti	;<35>Now it is safe--------------------------------------------

	xor	ax,ax
	pop	es
	pop	ds
	pop	di
	pop	si
	pop	bp
	ret

_snd_file_play endp
	page
;------------------------------------------------------------------------------
;	PlayExpand - Handles expansion of data into the play queue

;	This function is called to convert one disk buffer into snd_play
;	requests.  It is responsible for making sure no deadlock can occur.
;	It can be run at interrupt time OR when getting things started.
;	It only converts one sector at a time to avoid being a hog.  Most
;	of the code runs with interrupts ENABLED so that other traffic
;	including our own interrupt can occur.
;------------------------------------------------------------------------------
;	See if an expansion can be performed
;	First, we look to see if we have any buffers left.  It not,
;	AND if the DISKABORT flag is true, then we need to flush.

	public	playexpand
playexpand	proc	near

	pushf	;-------------------------------------------------------------
	cli	;-------------------------------------------------------------

	les	di,disk_exp_queue	;First, make sure we can do this.
	mov	ax,es
	or	ax,di
	jnz	$bufsavail		;There are buffers available.
	jmp	short $norun

$norunf:and	word ptr snd_mode,NOT EXPBUSY
$norun:	popf	;------------------------------------------------------------
	ret				;Get outta here
	page
;	Now make sure we aren't currently running at a different level.

$bufsavail:
	mov	ax,word ptr snd_mode	;Get state of things
	test	ax,EXPBUSY		;Well?
	jnz	$norun			;We are here, get out NOW

;	Lock ourselves out and proceed

	or	ax,EXPBUSY
	mov	word ptr snd_mode,ax	;Set it
	test	ax,COMPRESS
	jz	$noc1			;No compression
	test	ax,HAVEBLK		;Do we have a block to work on?
	jnz	$haveblk		;Yes, 

;	Here we do not have a block to decompress, so fix that problem

$needmore:
	add	di,HEADER_SIZE+SNDHDR_SIZE
	mov	ax,word ptr es:[di].sndlen
	push	ax
	add	di,SOUND_SIZE+DISK_SIZE
	push	es
	push	di
	call	_st_decompress_supply_buffer
	add	sp,6

	or	word ptr snd_mode,HAVEBLK	;Signal a block is ready
	page
$haveblk:
$noc1:	sti	;-----------------------------------------------------------

;	Now we look into the players operation queue to see how many
;	free buffers it has.  If our buffer will not expand without
;	blocking, then we MUST NOT attempt an expansion or we will deadlock.
;	The exception to the rule is on start-up so that we will use
;	all the buffers we can.

	mov	al,byte ptr snd_mode
	test	al,INPLAY
	jz	$pretend		;Pretend there are enough
					;At one point there won't be and
					;we will block long enough for the
					;player to start.  OR if it underruns.
					;SHOULD NOT HAPPEN at ISR level
	mov	cl,disk_rate		;Get sampling rate

;	For 22,000 (3) we need one buffer
;	For 11,000 (2) we need two buffers
;	For  5,500 (1) we need four buffers
;	THIS CODE RELIES ON THE RELATIONSHIP BETWEEN EQUATE VALUE AND
;	SAMPLING EXPANSION!!!!!!
;	This test does not take into account the shortness of the
;	first and last buffer.

	mov	al,8
	shr	al,cl			;Shift to appropriate position
	mov	cl,al
	inc	cl
	xor	ch,ch
	page
;	al now contains number of buffers required

	les	di,queue_free		;Take a peek

$nextscan:
	mov	bx,es
	or	bx,di
	jz	$norunf			;Not enough - clear flag & exit
	les	di,es:[di].play_buf_next
	loop	$nextscan

;	If we reach here, there are enough play buffers to handle the
;	expansion of our buffer

$pretend:
	mov	ax,snd_mode
	test	ax,COMPRESS
	jz	$notcomp		;Not compressed

;	Handle compressed files

	mov	ax,DRQLEN		;2048
	push	ax
	les	di,compress_hold
	add	di,HEADER_SIZE+SNDHDR_SIZE+SOUND_SIZE+DISK_SIZE
	push	es
	push	di
	call	_st_decompress_get_data
	add	sp,6
	cli	;--------------------------------------------------------------
	cmp	ax,MOREDATA		;Have we emptied the input buffer?
	jc	$notmore		;<29>
	jz	$bufdone
	cmp	ax,EOF

;	Here we have an EOF
;	We also go through the moves of thinking about releasing the buffer
;	on a EOF - there is a code in the data stream to signal this,
;	but we would not get it if output was cut short by a disk error.

	mov	ax,snd_mode
	test	ax,HAVEBLK
	jz	$expout			;If a buf is present, free it
	page
;	We have emptied the input buffer, so release it and try for another
;	We get another loaded right away so that this clk will earn its time.

$bufdone:
	mov	si,offset disk_exp_queue
	mov	di,offset disk_queue_free
	call	snd_xfer_buf		;Put it on chain in any order
	and	word ptr snd_mode,NOT HAVEBLK	;Signal a block is ready

	les	di,disk_exp_queue
	mov	ax,es
	or	ax,di
	jz	$expout			;No buffers, either underun or
					;eof condition
	jmp	$needmore		;Line up another buffer


;	Here decompress handed us some quantity of bytes to play

$notmore:
	or	ax,ax			;How much was returned
	jz	$expout			;Should not happen
	sti	;--------------------------------------------------------------
	les	di,compress_hold
	add	di,HEADER_SIZE
	mov	word ptr es:[di+SNDHDR_SIZE].sndlen,ax	;Store returned length

	push	es
	push	di
	call	_snd_play		;Expand buffer
	add	sp,4
	jmp	short $expout
	page
;	Handle uncompressed files

$notcomp:
	les	di,disk_exp_queue	;Point at expansion chain
	add	di,HEADER_SIZE		;Point at sound stuff
	push	es
	push	di
	call	_snd_play		;Expand buffer
	add	sp,4

;	Now the buffer has been expanded.  Put the buffer back
;	on the free chain

	cli	;--------------------------------------------------------------
	mov	si,offset disk_exp_queue
	mov	di,offset disk_queue_free
	call	snd_xfer_buf		;Put it on chain in any order

;	Buffers have been freed, so exit the expander

$expout:and	word ptr snd_mode,NOT EXPBUSY	;Clear our flag
	popf	;--------------------------------------------------------------
	ret				;Get outta here

playexpand	endp
	page
;------------------------------------------------------------------------------
;	Here we figure out if we are done.
;	MUST BE CALLED WITH INTERRUPTS DISABLED
;------------------------------------------------------------------------------

	public	eofchk
eofchk	proc	near

	mov	ax,snd_mode
	test	ax,DISKABORT
	jz	$noteof1		;Not yet done

	les	di,disk_exp_queue
	mov	bx,es
	or	bx,di
	jnz	$noteof1

	test	ax,DISKPLAY		;Are we still active?
	jnz	$chkcomp
$noteof1:
	ret				;Don't do this stuff


;	Here there are no more data to read, and no more buffers to
;	expand, so shut down.

$chkcomp:
	test	ax,COMPRESS		;Are we decompressing
	jz	$notweird		;No

;	Tell decompression system that we have reached the end - in case
;	it did not figure it out on its own

	xor	ax,ax
	push	ax
	push	ax
	push	ax
	call	_st_decompress_supply_buffer
	add	sp,6
	page
;	Now, there is the possibility that the above call will shake
;	loose additional samples from the decompression system, so 
;	we must call and read however many it elects to spew out.

$rotorooter:
	mov	ax,DRQLEN
	push	ax
	les	di,compress_hold
	add	di,HEADER_SIZE+SNDHDR_SIZE+SOUND_SIZE+DISK_SIZE
	push	es
	push	di
	call	_st_decompress_get_data
	add	sp,6
	cmp	ax,MOREDATA		;Have we emptied the input buffer?
	jz	$notweird
	cmp	ax,EOF
	jz	$notweird

	or	ax,ax			;How much was returned
	jz	$rotorooter		;Should not happen
	les	di,compress_hold
	add	di,HEADER_SIZE
	mov	word ptr es:[di+SNDHDR_SIZE].sndlen,ax	;Store returned length

	push	es
	push	di
	call	_snd_play		;Expand buffer
	add	sp,4
	jmp	$rotorooter


;	Decompression is all handled
;	Even if no compression, there is no more data to read, so flush
;	player system.

$notweird:
	call	snd_file_buf_unload	;<34>Release file/comp buffers

	and	snd_mode,NOT DISKPLAY	;Turn off DISKPLAY flag
	call	far ptr _snd_flush	;Terminate current buffer

$noteof:ret				;Get out

eofchk	endp
	page
;------------------------------------------------------------------------------
;	This routine makes the read call and updates the control blocks
;	and such and tests for EOF.

;	Returns nothing
;	MUST BE CALLED WITH INTERRUPTS DISABLED
;------------------------------------------------------------------------------

	public	disk_rd
disk_rd	proc	near
	mov	ax,word ptr disk_queue_free+2	;Any buffers free?
	or	ax,ax
	jz	$bye1			;Segment 0 = no buffers

	mov	ax,snd_mode
	test	ax,DISKABORT		;Are we to stop?
	jz	$go1
$bye1:	or	al,1			;Force NZ
	ret				;Bail out now

;	Here a buffer is available, so call the disk reader.
;	It will turn interrupts on when it is safe to do so

$go1:	call	snd_file_magic		;Read another sector
	cmp	ax,-2
	jz	$bye1			;DOS is busy and DISK I/O can't
					;be performed - try later.

;	Here the I/O operation needs further examination.
;	There was disk access, either no error, error or EOF

	les	si,disk_xfer_buf
	cmp	ax,-1			;Did the read fail?
	jnz	$rdxok			;Read worked
	page
;	Here there was a critical error

	or	snd_mode,DISKABORT	;Signal end of things

	xor	bx,bx			;Set length to zero
	mov	word ptr es:[si+HEADER_SIZE+SNDHDR_SIZE].sndlen,bx	;0
	mov	word ptr es:[si+HEADER_SIZE+SNDHDR_SIZE+2].sndlen,bx	;0

	mov	di,offset disk_queue_free	;Free buffer
	mov	si,offset disk_xfer_buf	;<31>
	call	snd_xfer_buf
	xor	al,al			;RETURN CODE for clk
	ret		 		;See if we should finish up

;	Test the length to see if full buffer was read

$rdxok:	mov	ax,word ptr es:[si+HEADER_SIZE+SNDHDR_SIZE].sndlen;LSB only
	cmp	ax,DRQLEN		;Full block read?
	jz	$full1

	or	snd_mode,DISKABORT	;Signal EOF reached
$full1:	mov	bx,word ptr disk_st_len+2	;Get MSW
	or	bx,bx
	jnz	$nob			;More than 64K to go

;	Here there is less than 64K to go, so start being careful

	mov	bx,word ptr disk_st_len	;Get LSW of remainder to read
	cmp	bx,ax			;remain-read
	jz	$ext			;Exact match
	jnc	$nob			;Value greater than buffer
	page
;	Here more was read than allowed, change values

	mov	word ptr es:[si+HEADER_SIZE+SNDHDR_SIZE].sndlen,bx;LSW 
	mov	ax,bx			;Put value here
$ext:	or	snd_mode,DISKABORT	;Signal EOF (although fake) reached
	jmp	short $gx1		;Okay, move on

;	Here, subtract the values and keep going.

$nob:	sub	word ptr disk_st_len,ax	;Store LSW
	jnc	$gx1
	dec	word ptr disk_st_len+2	;Decrement LSW

;	Okay, put buffer on the queue.

$gx1:	mov	dx,es			;dx,si source buffer
	mov	di,offset disk_exp_queue;Point at expansion chain
	mov	ax,ds
	mov	es,ax
	call	snd_append_buf		;Add to expand chain
	xor	al,al			;RETURN CODE for clk
	ret				;Exit

disk_rd	endp
	page
;------------------------------------------------------------------------------
;	Snd_File_Magic	I cant think of a more accurate name
;	New in Edit 22 
;
;	Accepts:	
;		Nothing.  Only runs when it is safe.
;	Returns:
;		Hopefully.
;------------------------------------------------------------------------------

		public snd_file_magic
snd_file_magic	proc near

	pushf
	cli	;Turn off interrupts------------------------------------------
					;(they probably are off anyway)
	mov	ax,snd_mode		;Get control info
	mov	bx,DISKBUSY
	test	ax,bx			;Should we go inside?
	jnz	$bailout

	or	ax,bx			;set DISKBUSY
	mov	snd_mode,ax		;Set flag
	jmp	$doplay			;Playback


;	Here we are not doing anything - don't know if this can happen,
;	but don't want to have to debug it

$noaction:
	and	snd_mode,NOT DISKBUSY	;Clear flag
$bailout:
	popf				;Put flags back
	mov	ax,-2			;Return code
	ret				;Exit to fun way 

snd_frc_read:				;Special entry point
	pushf
	cli	;--------------------------------------------------------------
	jmp	short $rdcom

;	Here the system is in play mode

$doplay:les	di,disk_queue_free	;Are any buffers free?
	mov	ax,es
	or	ax,di
	jz	$noaction		;No buffers, get out
	page
$rdcom:	call	snd_add_hooks		;This saves most of the interrupted
					;environment since DOS is too dumb
					;to do it on its own.


;	Here we are not within DOS, so we might be able to do some
;	disk I/O.

	les	dx,disk_queue_free	;pick up pointer
	mov	word ptr disk_xfer_buf,dx
	mov	word ptr disk_xfer_buf[2],es
	push	es
	mov	di,dx
	les	di,es:[di].play_buf_next
	mov	word ptr disk_queue_free,di	;Unlink from free list
	mov	word ptr disk_queue_free[2],es	;like so
	pop	es

	add	dx,HEADER_SIZE+SOUND_SIZE+SNDHDR_SIZE+DISK_SIZE
	mov	bx,filehdl		;Handle of file
	push	ds			;Save dgroup
	push	bx			;Do this while we still have ds

	push	es			;Get buffer segment
	pop	ds			;Put it in ds

;	Address in DS:DX
;	Now set new DTA.  This may or may not be necessary and seems to be
;	yet-another one of those grey areas in the DOS universe.

	mov	ah,1ah			;Set DTA
	int	21h
	pop	bx			;Get file handle back
	page
	sti	;-------------------------------------------------------------

;	Now, we do the READ

	mov	cx,DRQLEN		;Always try for this amount
	mov	ah,3fh			;"Read from a file or device"
	int	21h
	pop	ds			;get dgroup back

;	Hopefully we have read some data now

	mov	bl,[$snd_err24]		;Test for critical error
	jc	$rderror		;Something went wrong
	or	bl,bl
	jz	$rdok			;No system error

;	Here the read failed, so we need to do things to let people know.

$rderror:
	mov	ax,-1			;Set that to -1

;	Here the read worked.  Now look at AX and determine
;	how much was read.

$rdok:	les	di,disk_xfer_buf	;Point at start of structure
	mov	word ptr es:[di+HEADER_SIZE+SNDHDR_SIZE].sndlen,ax

;	Now we are done processing, so back our way out.

$rdexit:cli	;--------------------------------------------------------------
					;Tom's tricks say I can skip this cli -
					;but it kills the buffer managers

	push	ax
	call	snd_pull_hooks		;Pull various hooks out
	pop	ax

	and	snd_mode,NOT DISKBUSY	;Clear flag
	popf				;Put flags back
	ret				;Exit to fun way 
snd_file_magic	endp
	page
;------------------------------------------------------------------------------
;	This function switches the DOS environment over so we can do I/O
;	in background without botching fg operations.  It must be undone
;	before we iret.
;------------------------------------------------------------------------------
	public	snd_add_hooks
snd_add_hooks proc near

;	Disable CONTROL-BREAK CONTROL-C operations.  They can only take
;	control away while we are in an INT call, and at ISR time is
;	the last place we want that, so lock-em out.

	mov	ax,3302h		;Disable CONTROL-C checking
	xor	dl,dl			;Disable code
	int	21h
	mov	[ccstat],dl		;CS context should not be needed

;	Get local PSP # and save it.  This has file control information
;	in at its destination.

	mov	ah,51h			;Get PSP
	int	21h
	mov	[sndoldpsp],bx

	mov	bx,[sndourpsp]		;Set our PSP - was determined
	mov	ah,50h			;when file-play/rec started in
	int	21h			;the foreground

	mov	ah,2fh			;Save the current DTA
	int	21h			;Geez DOS is stupid(TM)
	mov	word ptr [sndolddta],bx
	mov	word ptr [sndolddta+2],es

	mov	ax,3524h		;Trap int 24 errors
	int	21h			;Thanks Tom
	mov	word ptr [sndold24],bx	;Save old trap handle
	mov	word ptr [sndold24+2],es

	mov	dx,offset sndseg:sndhdl24	;Our service routine
	push	ds
	push	cs
	pop	ds			;Segment containing sucker
	mov	ax,2524h
	int	21h
	pop	ds
	ret
snd_add_hooks endp
	page
;------------------------------------------------------------------------------
;	This routine puts DOS back the way it was before we put
;	our hooks in.  It should be run just before we iret.
;------------------------------------------------------------------------------
	public	snd_pull_hooks
snd_pull_hooks proc near

;	Restore original PSP

	mov	bx,[sndoldpsp]
	mov	ah,50h			;Set PSP
	int	21h

;	Now we restore the original DTA

	push	ds
	mov	ah,1ah			;Read DTA
	lds	dx,[sndolddta]		;Put it back
	int	21h
	pop	ds

;	Now restore trap 24 handler - this assumes one can't happen while
;	we are removing it.

	push	ds
	lds	dx,[sndold24]		;Put back original trap24 handle
	mov	ax,2524h	
	int	21h
	pop	ds

;	And LAST (absolutely), we reset the CONTROL-C checking to the way
;	it was.

	mov	ax,3302h		;Put CONTROL-C checking back
	mov	dl,[ccstat]		;CS context should not be needed
	int	21h
	ret

snd_pull_hooks	endp
	page
;------------------------------------------------------------------------------
;	This routine effectively ignores any references to int 24
;	(critical or other bad errors) while we do disk I/O.  
;------------------------------------------------------------------------------

sndhdl24	proc	far
	push	ax
	push	ds
	mov	ax,snddata
	mov	ds,ax
	mov	byte ptr [$snd_err24],-1
	pop	ds
	pop	ax
	mov	al,3			;"Cause DOS to return FAIL from
	iret				;function call iret"

sndhdl24	endp

	public	delhook
delhook	proc	near
	pushf				;<22>
	cli				;<22>
	mov	ax,snd_mode		;<22>
	test	ax,DOS_HOOKED		;<22>
	jz	$plnorm			;<22>
	test	ax,DISKPLAY		;<22>
	jnz	$plnorm			;<22>Underrun, not EOF

	push	ds			;<22>
	push	dx			;<22>
	push	bx
	push	es

ifdef RESOURCE
;	First, make sure Deskmate hasn't screwed things upTM - RESOURCE ONLY

	mov	ax,3500h+CLOCKINT	;Find out what it is currently
	int	21h			;Set to.  IT SHOULD BE US
	lea	ax,SndClkIrq
	cmp	ax,bx			;If not, Deskmate has removed
	jnz	$botched		;us out of order
	mov	ax,cs			;by resetting the vectors to
	mov	bx,es			;the on-entry state for deskmate.
	cmp	bx,ax			;Stupid, huh?
	jnz	$botched		;Deskmate has screwed us up
					;so don't remove clock int
endif
	mov	ax,2500h+CLOCKINT	;<22>int 8 is botched with by Dmate
	lds	dx,cs:clkvec		;<22>so try its companion
	int	21h			;<22>
	page
$botched:
	mov	ax,2528h		;<22>Pull idle hook too (28h)
	lds	dx,cs:idlevec		;<22>
	int	21h			;<22>

	pop	es
	pop	bx
	pop	dx			;<22>
	pop	ds			;<22>

	mov	ax,fileoptions		;<29>
	test	ax,CLOSEFILE		;<29>Do they want this done?
	jnz	$noclose		;<29>Don't close it
	call	snd_add_hooks
	mov	bx,filehdl		;Close the file
	mov	ah,3eh
	int	21h
	call	snd_pull_hooks

$noclose:
	and	snd_mode,NOT DOS_HOOKED	;<22>
	call	snd_reset_clock		;<30>
$plnorm:popf				;<22>
	ret				;<22>
delhook	endp
	
;	RECORD STARTS HERE
sptr	struc
	dw	?
	dw	(@codesize+1) dup (?)
sndfilhdl	dw	?		;Sound File Handle number
sndfilspd	dw	?
sndfilopt	dw	?		;Sound options
sndfiladj	dd	?		;Adjust Table or NULL
sndfillen	dw	?		;Assume its there
sndfilsil	dw	?		;Amount of silence before VOX
sndfilthres	dw	?		;Definition of silence for VOX
sndfilcomp	dw	?		;OPTIONAL Compression parameters

sptr	ends
	page
;------------------------------------------------------------------------------
;	Snd_File_Record

;	This function accepts the file handle from somewhere, allocates some
;	buffers from the play chain, creates and writes a bogus header
;	and starts managing the recording. 

;------------------------------------------------------------------------------
		public _snd_file_record
_snd_file_record	proc far

	push	bp
	mov	bp,sp
	push	si
	push	di
	push	ds
	cld				;<25>Moved to the top to make sure

	mov	ax,snddata
	mov	ds,ax
	assume	DS:snddata
	push	es

;	First, make sure we aren't doing anything.

	mov	ax,snd_mode
	test	ax,INPLAY OR INRECORD OR UNINITIALIZED OR DISKABORT OR DISKPLAY OR DISKRECORD;<34>
	jz	$bok

;	For now, simply abort.

$bfailx:mov	ax,INVALID
	pop	es
	pop	ds
	pop	di
	pop	si
	pop	bp
	ret
	page
;	We are not doing anything, so set hardware into record mode

$bok:	call	snd_envinit		;<33>Reset environment
	mov	ax,[bp].sndfilhdl	;Get file handle
	mov	filehdl,ax		;Store it

	mov	ax,[bp].sndfilspd	;Get recording rate
	cmp	ax,MAXRATE+1
	jc	$rateok
	jmp	$bfailx			;Sampling rate is bogus

$rateok:mov	filerate,ax		;Save that
	les	di,[bp].sndfiladj	;Get the xlation table or NULL
	mov	word ptr fileadjust,di	;Just save it, no check needed
	mov	word ptr fileadjust[2],es

;	Speaking of options, check on length field

	mov	ax,[bp].sndfilopt	;<33>Get file options
	mov	fileoptions,ax		;<33>Save options we have received

	test	ax,RECORDLENGTH		;Did they specify a length?
	jz	$nolen
	mov	ax,[bp].sndfillen

;	The value input is in the format nnnn.n, or 100 msec increments.
;	Convert that number to total bytes needed.

	mov	bx,filerate
	mov	dx,[bx+bytespermil]
	mul	dx			;DXAX becomes total byte count.

;	Internally, keep this as number of buffers + last fraction.
;	This limits us to 65534 x 2048 = 134,213,632 samples, or 6100 seconds
;	(or 101 hours) at 22,000hz.

	mov	bx,ax
	and	bx,DRQLEN-1		;Mask off amount in last buffer
	mov	word ptr disk_pl_len,bx	;Fractional buffer (0 if none)

	mov	cx,11			;Divide by 2048
$shift:	shr	dx,1
	rcr	ax,1
	loop	$shift

	mov	word ptr disk_pl_len[2],ax	;Store count of buffers
					;does not count the fractional buf
	jmp	$lencom

$nolen:	xor	ax,ax			;0xffff means you never have to stop
	mov	word ptr disk_pl_len,ax	;Amount in last buffer (0 = full)
	dec	ax
	mov	word ptr disk_pl_len[2],ax	;-1 won't stop soon anyway
	page
;	Process VOX-related stuff

$lencom:mov	ax,[bp].sndfilthres	;Get threshold size
	mov	bx,fileoptions		;<34>
	test	bx,VOXSTARTOFF		;<34>
	jz	$normvx			;<34>Nothing fancy
	neg	ax			;<34>Take 2's
$normvx:mov	filethresh,ax
	mov	ax,[bp].sndfilsil	;Get silence length
	mov	filesilence,ax

	mov	ax,TORECORD		;<33>
	push	ax
	call	_snd_cue
	add	sp,2

;	Now attempt to get buffers

	mov	cx,num_buffers		;<33>Get ALL buffers that are available
	dec	cx			;Remember circular queue has one
					;NOTE - COMPRESS must use buffers
					; from the disk pool.
$bbuflp:mov	si,offset queue_free
	mov	dx,ds
	mov	di,offset disk_queue_free
	mov	es,dx
	push	cx
	call	snd_xfer_buf
	pop	cx
	jnz	$bfail			;Could not get as many as desired
	loop	$bbuflp			;Keep going
	page
;	Now process each buffer so that it has headers like ours.

	les	di,disk_queue_free	;Point at first buffer
$bprlp:	mov	ax,es
	or	ax,di
	jz	$bdone

	mov	si,di			;Save original pointer
	add	di,HEADER_SIZE		;Point to start of soundhdr
	lea	ax,[di+SNDHDR_SIZE]
	mov	word ptr es:[di].sndstrptr,ax
	mov	word ptr es:[di+2].sndstrptr,es

	xor	bx,bx
	mov	word ptr es:[di].sndst,bx	;Play complete sound
	mov	word ptr es:[di+2].sndst,bx
	mov	word ptr es:[di].sndend,bx	;Play complete sound
	mov	word ptr es:[di+2].sndend,bx

	mov	di,ax			;Points to soundstr
	mov	ax,DRQLEN
	mov	word ptr es:[di].sndblen,ax	;Set sound buffer max size
	mov	word ptr es:[di+2].sndblen,bx	;0
	mov	word ptr es:[di+2].sndlen,bx	;Set MSB of play len to zero

	lea	ax,[di+SOUND_SIZE+DISK_SIZE]
	mov	word ptr es:[di].sndbuf,ax
	mov	word ptr es:[di+2].sndbuf,es

	les	di,es:[si]		;Move to next buffer
	jmp	short	$bprlp

$bfail:	jmp	$bfailx
	page
;	We have enough buffers to start.  Now we build a file header
;	in a buffer and write it out to disk.  I am thinking that
;	we should round up to 2K on the header write so that all
;	subsequent I/O will be on cluster boundaries.

$bdone:	mov	dx,ds
	mov	es,dx
	mov	si,offset disk_queue_free
	mov	di,offset disk_xfer_buf
	call	snd_xfer_buf		;Get a buffer to play with

	les	di,disk_xfer_buf
	add	di,HEADER_SIZE+SOUND_SIZE+SNDHDR_SIZE+DISK_SIZE
	push	di
	mov	cx,1024			;Writing words, remember?
	xor	ax,ax
	rep	stosw			;Initialize buffer
	pop	di			;Get back base address (es is ok)

;	Now, fill in the fields we know about.  Some cannot be done
;	until we are completely finished.

	mov	al,-1			;<33>
	mov	es:[di+SIZE disk_header].hd_pitch,al	;<33>Sound wants 
	mov	es:[di+SIZE disk_header].hd_low,al	;<33>these at 0xff
	mov	es:[di+SIZE disk_header].hd_high,al	;<33>
	mov	ax,1
	mov	es:[di].hd_count,ax		;Sound Count = 1
	mov	word ptr es:[di+SIZE disk_header].hd_offset,800h;<31>2K into file
	mov	word ptr es:[di-(DISK_SIZE+SOUND_SIZE)].sndlen,800h	;<31>
					;<31>Set header length to write out

;	Compute the decimal version of the rate we were given,
;	which has already been checked for validity

	mov	si,offset ratetooff
	mov	ax,filerate
$nxt1:	cmp	al,[si+2]		;Does the rate code match?
	jz	$match
	add	si,3
	jmp	$nxt1

$match:	mov	ax,[si]
	mov	es:[di].hd_rate,ax	;Copy decimal count of sample rate
	page
;	If we are going to make a compressed file, that info goes here.

	mov	ax,[bp].sndfilcomp	;Get file options
	mov	disk_comp_type,ax	;<33>Save RAM copy of comp. options
	mov	es:[di].hd_compress,ax	;Copy it verbatim for now
					;Compression scheme not final
	or	ax,ax
	jz	$bncomp
	or	word ptr snd_mode,COMPRESS	;Ooooooh!
$bncomp:mov	al,machine		;Get machine ID
	xor	ah,ah
	mov	es:[di].hd_bias,ax	;Also known as the bias or skew

;	At this point, the header has been filled in as much as possible
;	so we will write it out.

	mov	si,offset disk_xfer_buf
	mov	di,offset disk_wr_queue
	call	snd_cat_buf		;Just stick it on write queue

;	Now get things going by calling the recorder-setup function.
;	We do this three times before starting up the background stuff

	cli	;--------------------------------------------------------------
	or	snd_mode,DISKRECORD	;Say we are here
	call	snd_rec_buf
	call	snd_rec_buf
	call	snd_rec_buf		;<33>Three are allowed now

;	Now, hook the system timer so we get more chances to run

	mov	al,CLOCKINT		;Int 8 is messed up by Dmate
	mov	ah,35h
	int	21h
	mov	word ptr cs:clkvec,bx
	mov	word ptr cs:clkvec+2,es

	mov	dx,cs
	push	ds
	mov	ds,dx
	lea	dx,SndClkIrq
	mov	ah,25h
	int	21h
	pop	ds
	page
;	Now grab "sitting in DOS not doing a lot(TM)" vector

	mov	al,28h			;Int 28h
	mov	ah,35h
	int	21h
	mov	word ptr cs:idlevec,bx
	mov	word ptr cs:idlevec+2,es

	mov	dx,cs
	push	ds
	mov	ds,dx
	lea	dx,SndIdleIrq
	mov	ah,25h
	int	21h
	pop	ds
	page
;	Code to hook additional vectors would go here.....

	or	word ptr snd_mode,DOS_HOOKED;Set mode
	sti	;-------------------------------------------------------------

	xor	ax,ax
	pop	es
	pop	ds
	pop	di
	pop	si
	pop	bp
	ret

_snd_file_record endp
	page
;------------------------------------------------------------------------------
;	Okay, now see about adding a buffer to the recorders list.
;	We program it to only hold STANDBY blocks (one active, two standby).
;	Since it only holds STANDBY, it is important that we not call it when
;	it already has three as it will block.  So we cheat and look at
;	the internal depth marker to determine if it is full.
;------------------------------------------------------------------------------

	public	snd_rec_buf
snd_rec_buf	proc near
	pushf
	cli	;--------------------------------------------------------------
	mov	ax,snd_mode
	test	ax,EXPBUSY
	jnz	$rec_buf_exit

	mov	ax,rec_depth		;<32>Get current number of buffers
					;<32>queued
	cmp	ax,rec_limit		;<32>How many do we allow?
	jc	$allowbuf		;<32>room if depth < limit

$rec_buf_exit:
	popf	
	ret


;	Step 1.  Figure out how much more needs to be recorded.
;	If there is a limit and we reach it, we simply stop calling
;	record and this by itself should end the recording process.

$allowbuf:
	or	snd_mode,EXPBUSY	;We're busy, man
	mov	ax,word ptr disk_pl_len[2]	;Count of full buffers
	or	ax,ax
	jnz	$moretodo		;At least one more buffer
	mov	ax,word ptr disk_pl_len	;Count of fractional buffers
	or	ax,ax
	jz	$nomore			;No more recording should be done.

;	Here there is only a fractional buffer left to do.

	push	ax			;Save amount to do for later.
	xor	ax,ax
	mov	word ptr disk_pl_len,ax	;Zero it out
	jmp	$com1
	page
;	Here at a full buffer is required

$moretodo:
	mov	bx,DRQLEN		;Amount to record in this buffer
	push	bx			;Save that for later
	inc	ax
	jz	$com1			;Don't bother to decrement MAX
	dec	ax			;Get back to where we were
	dec	ax			;Decrement count of this buffer
	mov	word ptr disk_pl_len[2],ax	;Decrement count

;	Now, get a buffer (can be the same one we just used and start
;	recording. 

$com1:	mov	si,offset disk_queue_free
	mov	di,offset disk_exp_queue
	call	snd_cat_buf		;Add in correct order a bit early
	pop	dx			;Get record length back
	push	filesilence		;silence_len
	push	filethresh		;threshold
	mov	ax,STANDBY		;<32>Store two standby buffers
	push	ax			;<32>Count to buffer inside record
	xor	ax,ax
	push	ax			;NO Block
	les	di,fileadjust		;Get translation table pointer or NULL
	push	es			;Pass pointer or NULL straight through
	push	di
	push	filerate		;Get sampling rate
	mov	es,cx			;es:si point at buffer we got
	mov	si,bx
	add	si,HEADER_SIZE+SNDHDR_SIZE
	mov	word ptr es:[si].sndblen,dx	;Set size
	push	ax			;Set time to zero - limit will be
					;controlled by buffer size we just
					;set
	push	es
	push	si			;Pass pointer to structure
	call	_snd_record
	add	sp,20			;<32>Balance stack
	inc	byte ptr recdepth	;ATOMIC+++++++++++++++++++++++++++++
					;NOTE: This is not a valid count of
					;buffers in the disk_exp_queue.  It
					;only keeps track of the number that
					;record "knows" about. 
	
$nomore:and	snd_mode,NOT EXPBUSY	;Turn off the busy flag
	jmp	$rec_buf_exit
snd_rec_buf	endp
	page
;------------------------------------------------------------------------------
;	This function determines if there is a buffer that is ready
;	for writing and if so, either hands it to compress or gets it on the
;	queue of buffers for writing.  (Almost nothing happens here if
;	the file isn't being compressed.)
;	Reminder:  the three buffer chains we deal with are:
;	disk_queue_free		Formatted buffers but not in use
;	disk_exp_queue		Buffers about to, are, or just recorded into 
;	disk_wr_queue		Buffers that are to be written out.
;------------------------------------------------------------------------------

	public	snd_rec_offl
snd_rec_offl	proc	near
	pushf
	cli	;--------------------------------------------------------------
	mov	al,recdepth		;Well?
	or	al,al			;<32>Is anything there
	jz	$notinrec		;<32>No buffers, don't do anything
	cmp	al,STANDBY+2		;<32>
	jnc	$enoughbuf		;>3 At least one buffer is finished

;	Here there are not enough buffers free to assume that record
;	isn't working on one of them.  But if the recorder is inactive,
;	then we must flush the remaining buffers anyway.  Hopefully 
;	record or stop filled in all the forms (blanks) correctly.
;	In DISKRECORD mode but not INRECORD mode.

	mov	ax,snd_mode
	test	ax,DISKRECORD
	jz	$notinrec
	test	ax,INRECORD
	jz	$enoughbuf		;Just pretend, ok?

;	No buffers, not enough, not in the right mode, etc.

$notinrec:
	popf	;--------------------------------------------------------------
	ret
	page
;	Here, the top buffer in the list can be processed
;	Code to handle compression goes here

$enoughbuf:
	dec	byte ptr recdepth	;ATOMIC+++++++++++++++++++++++++++++
					;NOTE: This is not a valid count of
					;buffers in the disk_exp_queue.  It
					;only keeps track of the number that
					;record "knows" about. 
	les	di,disk_exp_queue	;This is the buffer we will
					;compress or write
	mov	ax,word ptr es:[di+HEADER_SIZE+SNDHDR_SIZE].sndlen
					;Get amount of sound in it
	add	ax,word ptr disk_rec_len;Increment running total
	mov	word ptr disk_rec_len,ax;Store it
	jnc	$n641			;Did not carry
	inc	word ptr disk_rec_len[2];Bump MSW
$n641:	mov	ax,snd_mode		;Get mode
	test	ax,COMPRESS		;Are we compressing?
	jz	$nocomp1		;No, skip this

;	Okay, the buffer we just got needs to be handed to compress.
;	COMPRESSION CALL INTERFACE NOT YET FINALIZED - THIS IS A PROTOTYPE
;	THIS CODE IS NOT SUPPORTED.  YOU HAVE BEEN WARNED.

ifdef COMPIF
	les	di,disk_exp_queue	;This is the next buffer to use
	push	es
	push	di
	call	rtcompressin		;Compress this buffer
	add	sp,4
endif

;	Now remove that buffer from the record-full chain.
;	The location of that buffer is now held by the compress
;	utility.

	les	di,es:[di].play_buf_next
	mov	word ptr disk_exp_queue,di
	mov	word ptr disk_exp_queue[2],es
	jmp	$notinrec

;	No compression is to be done, so move the buffer onto the
;	write chain.

$nocomp1:
	mov	si,offset disk_exp_queue
	mov	di,offset disk_wr_queue
	call	snd_cat_buf
	jmp	$notinrec

snd_rec_offl	endp
	page
;------------------------------------------------------------------------------
;	This function checks the write queue for blocks to write.  If
;	there is something there, it writes one block.  That block
;	is then returned to the disk_queue_free chain.
;NOTE: Compression may need to be called here to give up buffers.
;------------------------------------------------------------------------------

	public	snd_disk_wr
snd_disk_wr	proc	near
	pushf
	cli	;Turn off interrupts------------------------------------------
	mov	ax,snd_mode		;Get control info
	test	ax,DISKBUSY		;<33>Should we go inside?
	jz	$goin			;<33>Not in there already

;<33>	Do not do any disk I/O, we are already in this routine

$notyet9:
	popf				;Put flags back
	mov	ax,-2			;Return code
	ret				;Exit to fun way 

$goin:	les	dx,disk_wr_queue	;Anything on write queue?
	mov	ax,es
	or	ax,dx
	jnz	$chkmod			;There are buffers to write

;	Here there are no buffers to write, but that might mean that
;	we are all done and need to cut a file header.

	les	di,disk_exp_queue	;Is there anything left in the
	mov	ax,es			;recorder queue?
	or	ax,di
	jnz	$notyet9		;Still things to do
	mov	ax,snd_mode
	test	ax,INRECORD		;Is recorder active?
	jnz	$notyet9		;Then we are not done

;	We need to write a header on the file to finish up

	or	snd_mode,DISKBUSY	;<33>Mark this module IN USE
	call	snd_add_hooks		;<33>This saves most of the
					;interrupted environment since
					;DOS is too dumb to do it on its own
	jmp	$isdone			;We are done - WRITE A HEADER

;	Here we have a buffer to write, so write it.

$chkmod:or	snd_mode,DISKBUSY	;<33>Mark this module IN USE
	call	snd_add_hooks		;<33>This saves most of the
					;interrupted environment since
					;DOS is too dumb to do it on its own
	page
;	Here we are not within DOS, so we might be able to do some
;	disk I/O.

	les	di,disk_wr_queue	;Get buffer to write
					;compress or write
	mov	cx,word ptr es:[di+HEADER_SIZE+SNDHDR_SIZE].sndlen
					;Get amount of sound in it
	or	cx,cx			;Is the buffer empty (happens on stop)
	jz	$nodata			;Don't write it
	mov	ax,cx
	add	ax,word ptr disk_wr_len	;Increment running total
	mov	word ptr disk_wr_len,ax	;Store it
	jnc	$n642			;Did not carry
	inc	word ptr disk_wr_len[2]	;Bump MSW
$n642:	mov	dx,di
	add	dx,HEADER_SIZE+SOUND_SIZE+SNDHDR_SIZE+DISK_SIZE

	mov	bx,filehdl		;Handle of file
	push	ds			;Save dgroup
	push	bx			;Do this while we still have ds

	push	es			;Get buffer segment
	pop	ds			;Put it in ds

;	Address in DS:DX
;	Now set new DTA.  This may or may not be necessary and seems to be
;	yet-another one of those grey areas in the DOS universe.

	mov	ah,1ah			;Set DTA
	int	21h
	pop	bx			;Get file handle back
	sti	;-------------------------------------------------------------

;	Now, we do the WRITE

	mov	ah,40h			;"Write to a file or device"
	int	21h
	pop	ds			;get dgroup back

;	Hopefully we have written some data now

	mov	bl,[$snd_err24]		;Test for critical error
	jc	$wrerror		;Something went wrong
	cmp	ax,DRQLEN		;<31>Did it all get written?
	jnz	$wrerror		;<31>No - must be out of space
	or	bl,bl			;<31>How about a critical error
	jz	$wrok			;No system error
	page
;	Here the write failed, so we need to bring things to a halt.

$wrerror:
	cli	;--------------------------------------------------------------
	call	snd_dma_stop		;<33>Abort DMA
	and	snd_mode, NOT INRECORD	;<33>Turn that flag off
	xor	ax,ax			;<33>
	mov	rec_depth,ax		;<33>
	jmp	short $isdone		;Abort

;	Here the write worked.  
;	Now we are done processing, so back our way out.

$nodata:				;No data was written but free the buf
$wrok:	mov	si,offset disk_wr_queue
	mov	di,offset disk_queue_free
	mov	dx,ds
	mov	es,dx
	call	snd_xfer_buf		;Buffer can now be reused.

	cli	;--------------------------------------------------------------
	push	ax
	call	snd_pull_hooks		;Pull various hooks out
	pop	ax
	and	snd_mode,NOT DISKBUSY	;Clear flag
	popf				;Put flags back
	ret				;Exit to fun way 

;	Here we handle the cleanup done at the end of a file record.

$isdone:mov	ax,snd_mode
	test	ax,COMPRESS
	jz	$nocom			;Don't have to check this

;	Code to test compress for emptiness goes here


;	At this point, all queues are empty, so all sound data has been
;	written.  So, go back and update the header on the file.
;	Interrupts are off

$nocom:	mov	bx,filehdl		;Get the handle
	xor	dx,dx			;Zero offset
	xor	cx,cx
	mov	ax,4200h		;Position to the start of the
	int	21h			;file  (Lseek)
	jc	$barf			;If this fails It's Bad
	page
;	We are now positioned to where we want to be

	mov	si,offset disk_queue_free
	mov	di,offset disk_xfer_buf
	mov	dx,ds
	mov	es,dx
	call	snd_xfer_buf		;Get a buffer to work with
	add	di,HEADER_SIZE+SOUND_SIZE+SNDHDR_SIZE+DISK_SIZE
	mov	cx,512			;One sector will do, was DRQLEN
	mov	bx,filehdl		;Get the handle
	mov	ah,3fh
	push	ds
	mov	dx,es
	mov	ds,dx
	mov	dx,di
	int	21h
	pop	ds
	jc	$barf1			;Hope it won't fail

;	At this point, the partially filled header is at es:di
;	Fill in the remaining information.

	mov	ax,word ptr disk_wr_len	;Get length of data on disk
	sub	ax,800h			;<32>Subtract size of file header
	mov	es:[di+84h],ax
	mov	ax,word ptr disk_wr_len[2]
	sbb	ax,0			;<32>Handle carry
	mov	es:[di+86h],ax
	mov	ax,word ptr disk_rec_len;Length of recorded sound
	mov	es:[di+80h],ax		;(Uncompressed length)
	mov	ax,word ptr disk_rec_len[2]
	mov	es:[di+82h],ax


;	Write the ID signature, now (a complete file)

	mov	word ptr es:[di].hd_kludge,801ah;1ah at 2c and 80h at 2d

;	Now, write it back.

	mov	bx,filehdl		;Get the handle
	xor	dx,dx			;Zero offset
	xor	cx,cx
	mov	ax,4200h		;Position to the start of the
	int	21h			;file  (Lseek)
	jc	$barf1			;If this fails It's real bad
	mov	cx,512			;One sector will do, was DRQLEN
	mov	bx,filehdl		;Get the handle
	mov	ah,40h			;Write it
	push	ds
	mov	dx,es
	mov	ds,dx
	mov	dx,di
	int	21h
	pop	ds
	page
;	Only a bit remains

$barf1:	mov	si,offset disk_xfer_buf
	mov	di,offset disk_queue_free
	call	snd_xfer_buf		;Free buffer
$barf:	mov	ax,fileoptions		;<33>
	test	ax,CLOSEFILE		;<33>Do they want this done?
	jnz	$noclose1		;<33>Don't close it
	mov	bx,filehdl		;<33>Close the file
	mov	ah,3eh			;<33>
	int	21h			;<33>


;	Now release all buffers back into queue_free

$noclose1:				;<33>
	mov	si,offset disk_queue_free
	mov	di,offset queue_free
	call	snd_cat_chain

	mov	si,offset disk_exp_queue
	mov	di,offset queue_free
	call	snd_cat_chain

	mov	si,offset disk_wr_queue
	mov	di,offset queue_free
	call	snd_cat_chain


;	Clean up DOS-related kludges

	call	snd_pull_hooks		;Remove hooks so delhook will work
	call	delhook			;Pull IRQ vectors and possibly
	and	snd_mode,NOT (DISKRECORD OR DISKBUSY)	;<33>Turn mode off
					;close the file.
	popf
	xor	ax,ax
	ret

snd_disk_wr	endp
	page
;------------------------------------------------------------------------------
;	This routine is called on a int 8 clock tick
;	Based on more of Tom's stupid DOS tricks...
;------------------------------------------------------------------------------

	public	clkvec
clkvec	dd	?
	public	idlevec
idlevec	dd	?


SndIdleIrq	proc	far
	pushf
	call	far ptr $saveit		;Make it look like a IRET
	jmp	cs:[idlevec]

$saveit:push	ds
	push	ax
	mov	ax,snddata
	mov	ds,ax			;Set up our environment

	push	bx
	push	cx
	push	dx
	push	es
	push	si
	push	di
	push	bp
	cld				;<25>Sorta important
	jmp	short $idleentry

SndIdleIrq	endp
	page
	
SndClkIrq	proc	far
	pushf				;Build a stack frame that looks
					;like what a IRET will want
	call	cs:[clkvec]		;Do normal clock things first
					;They will return via IRET, so
					;no stack balance needed
	cli	;-----------------------Tom suggests making sure old clock
					;routine doesn't do something dumb
	push	ds
	push	ax
	mov	ax,snddata
	mov	ds,ax			;Set up our environment

;	First, make sure we aren't inside some other interrupt routine,
;	(including one of these)

	mov	al,00001011b		;check in services register
	out	20h,al
	jmp	$x1
$x1:	in	al,20h			;Get the value from controller
	and	al,0feh			;Is someone else interrupting?
	jnz	$clkexit		;No, bail out now

;	Here it is okay for us to do some stuff - maybe

$clkrun:push	bx
	push	cx
	push	dx
	push	es
	push	si
	push	di
	push	bp
	cld				;<25>Sorta important

;	First, first, see if this is RECORD or PLAY mode

	mov	ax,snd_mode		;Get mode
	test	ax,DISKRECORD		;Are we recording?
	jnz	$prerec1		;Yes
					;Assume play in other case

;	check DOS busy flag (only for timer tick entry)

	les	di,indos
	cmp	word ptr es:[di],0
	jnz	$tryplayexp		;No Disk I/O for now
	jmp	$playcom
	page
;	DOS isn't doing anything, so perhaps we can do disk I/O
;	Idle entry looks like it is in DOS, but it really isn't.  Got that?

$idleentry:
	mov	ax,snd_mode		;See if we are doing anything
	test	ax,DISKRECORD
	jnz	$rechdl			;Let record code handle this one
$playcom:
	test	ax,DISKBUSY		;Disk I/O in progress
	jnz	$tryplayexp
	mov	bl,byte ptr circleirq	;See if we are interrupting me?
	or	bl,bl			;Try not to start disk I/O here.
	jnz	$tryplayexp		;Dont start disk I/O

;	See if we are completely done and if so, get outta here.

	test	ax,(DISKPLAY OR INPLAY OR BIAS OR STOPDMA)
	jnz	$playdoit		;Still working on the file at all
	call	delhook			;Try pulling vectors when not in DOS
	jmp	$playtryx		;Exit

;	Here, it is actually ok to do disk I/O

$playdoit:
	call	disk_rd

$tryplayexp:
	call	playexpand		;See if we can expand anything
	call	eofchk			;Handle end condition

$playtryx:
	pop	bp
	pop	di
	pop	si
	pop	es
	pop	dx
	pop	cx
	pop	bx

;	We will interrupt a ISR, so don't do anything.

$clkexit:
	pop	ax
	pop	ds
	iret				;All done, exit

;	Handle operations for record

$prerec1:
	les	di,indos
	cmp	word ptr es:[di],0
	jz	$rechdl			;Ok to do Disk I/O
	jmp	$reccom			;No disk I/O for now
	page
;	Once we reach here, all we have to do for disk I/O is make sure
;	we are not running already and there is something to write.

$rechdl:mov	ax,snd_mode
	test	ax,DISKBUSY		;Are we doing disk I/o elsewhere?
	jnz	$reccom			;Then try something else
	mov	bl,byte ptr circleirq	;Are we interrupting ourself?
	or	bl,bl			;<33>Try not to start disk I/O here.
	jnz	$reccom			;Then don't do disk I/O

	call	snd_disk_wr		;Try doing some writing
	
;	Try to perform non-disk related record operations

$reccom:call	snd_rec_offl		;<31>Try to remove buffers from recorder
					;and pass them on to compress or write.
	call	snd_rec_buf		;<31>Try to feed more buffers to recorder
	jmp	$playtryx		;Exit
SndClkIrq	endp

snd_envinit	proc	near
	xor	ax,ax			;<33>Zero everything
	mov	filehdl,ax
	mov	fileoptions,ax
	mov	filerate,ax
	mov	word ptr fileadjust,ax
	mov	word ptr fileadjust+2,ax
	mov	filesilence,ax
	mov	filethresh,ax
	mov	word ptr disk_xfer_buf,ax
	mov	word ptr disk_xfer_buf+2,ax
	mov	word ptr disk_queue_free,ax
	mov	word ptr disk_queue_free+2,ax
	mov	word ptr disk_exp_queue,ax
	mov	word ptr disk_exp_queue+2,ax
	mov	word ptr disk_wr_queue,ax
	mov	word ptr disk_wr_queue+2,ax
	mov	word ptr compress_hold,ax
	mov	word ptr compress_hold+2,ax
	mov	word ptr sndolddta,ax
	mov	word ptr sndolddta+2,ax
	mov	ccstat,al
	mov	$snd_err24,al
	mov	word ptr sndold24,ax
	mov	word ptr sndold24+2,ax
	mov	disk_rate,al
	page
	mov	word ptr disk_st_len,ax
	mov	word ptr disk_st_len+2,ax
	mov	word ptr disk_pl_len,ax
	mov	word ptr disk_pl_len+2,ax
	mov	word ptr disk_addr,ax
	mov	word ptr disk_addr+2,ax
	mov	word ptr disk_pos,DRQLEN;<37>Not really zero
	mov	word ptr disk_pos+2,ax
	mov	disk_bias,al
	mov	disk_comp_type,ax
	mov	word ptr disk_wr_len,ax
	mov	word ptr disk_wr_len+2,ax
	mov	word ptr disk_rec_len,ax
	mov	word ptr disk_rec_len+2,ax
	mov	recdepth,al		;Zero depth gauge
	mov	rec_depth,ax		;<33>

;	Get INDOS address and save that for ISR operations

	mov	ah,34h			;Get INDOS flag address
	int	21h
	dec	bx			;Adjust pointer in 3.3
	mov	word ptr indos,bx	;Save offset
	mov	word ptr indos+2,es	;Save segment

;	Get our PSP (whatever that is) and save it for ISR operations

	mov	ah,51h			;I guess I can do this now
	int	21h
	mov	sndourpsp,bx		;Save our PSP
	ret	
snd_envinit	endp
sndseg	ends
	end

