	page	60,132
;-----------------------------------------------------------------------------
;	Exit.Asm - Snd_Exit() Undoes all the things that the PSSJ Digital
;		Sound Toolkit has done to the system and puts the hardware
;		back into the joystick mode.  The buffers that were
;		allocated for various things are put back on
;		the free queue.
;	Snd_Exit is part of the PSSJ Digital Sound Toolkit
;	Copyright 1994, Frank Durda IV. 
;	Commercial use is restricted.  See intro(PSSJ) for more information.
;
;	Accepts
;		No input parameters
;	Returns
;		NOERROR, or a pointer, or NULL.
;	Trashes
;		AX, BX, CX, DX
;
;<30>	If snd_exit is called after things are already uninitialized, it
;<30>	resets all internal state with regard to the buffers and returns a
;<30>	pointer to the chain so they can be deallocated.
;-----------------------------------------------------------------------------
	extrn	delhook:NEAR
	extrn	snd_play_off:NEAR
	extrn	snd_dma_stop:NEAR
	extrn	_snd_stop:FAR		;<33>
	extrn	_snd_clock:word
	extrn	snd_residue:word	;<34>
	extrn	_snd_clock_t:word
	extrn	iirq:byte		;<32>

	include	external.inc

	include	sound.inc

snddata	segment public	'DATA'
snddata	ends
	page	
sndseg	segment	public	'CODE'
	assume	cs:sndseg
	public	_snd_exit
_snd_exit	proc far		;()
	push	bp
	mov	bp,sp
	push	si
	push	di

	push	ds
	mov	ax,snddata
	mov	ds,ax		;=============================================
	assume	DS:snddata

	mov	word ptr _snd_clock,0	;<30>reset clock
	mov	word ptr snd_residue,0	;<34>reset clock
	mov	word ptr _snd_clock_t,0	;<30>reset clock
	mov	al,byte ptr snd_mode	;<22>Only thing we rely on
	test	al,UNINITIALIZED	;Did we get that far?
	jz	$ok			;Okay

;<30>	Here snd_exit has been called when we are already uninitialized,
;<30>	so try to free up buffers.

	xor	bx,bx			;<30>Reset buffer count
	mov	num_buffers,bx		;<33>
	mov	dx,word ptr queue_free[2]	;<30>Get current pointer
	mov	ax,word ptr queue_free		;<30>Could be NULL already
	mov	word ptr queue_free,bx	;<30>Clear internal list
	mov	word ptr queue_free[2],bx	;<30>

	jmp	$exit_exit

$ok:	xor	ax,ax			;<33>
	push	ax			;<33>
	push	ax			;<33>
	call	_snd_stop		;<33>
	add	sp,4			;<33>

	page
;	Turn off sound hardware

	mov	al,byte ptr snd_mode	;<22>
	test	al,RAMPUP		;Are we still ramped up?
	jz	$down
	call	snd_play_off

;	Turn off interrupts, which causes an interrupt

$down:	mov	di,irq_vect_addr	;<32>Get offset or vector
	or	byte ptr snd_mode,SHUTDOWN	;<32>
	push	es			;<32>
	pushf				;<23>
	sti	;--------------------------------------------------------------
	mov	dx,DacBase
	xor	ax,ax			;Sound is OFF ENTIRELY
	out	dx,al			;This will cause an interrupt

;	Do some other stuff while waiting for the IRQ

	inc	dx			;<34>
	in	al,dx			;<34>Read and toss any 
					;<34>remaining record data
	and	word ptr snd_mode,NOT (DISKPLAY)	;<32>
	call	near ptr delhook	;<32>

	xor	bx,bx
	mov	es,bx			;Point at segment zero

;	Interrupt must have happened by now
;	Pull out interrupt hook

	cli	;--------------------------------------------------------------
	mov	cx,cs: word ptr irq_next_task	;Get chain entry
	mov	dx,cs: word ptr irq_next_task[2]
	mov	es:[di],cx
	mov	es:[di+2],dx		;Write it

	mov	ax,UNINITIALIZED	;<22>
	mov	word ptr snd_mode,ax	;<22>We are dead now

	popf	;--------------------------------------------------------------
	page
;	Give back memory we allocated
;	Memory may be in the following locations

;	merrygo_buf	one block for the DMA (always present)
;	ld_buf		one block (may be present)
;	queue_play	none or more blocks

	les	di,merrygo_buf
	sub	di,HEADER_SIZE
	call	freebuf
	les	di,ld_buf
	call	freebuf
	les	di,queue_play
	call	freebuf

;	Anything else  we do goes here

	xor	ax,ax
	xor	dx,dx			;<30>Now a pointer

	pop	es
$exit_exit:
	pop	ds
	pop	di
	pop	si
	pop	bp
	ret				;NEAR or FAR

_snd_exit	endp
	page
;------------------------------------------------------------------------------
;	This routine takes a buffer and puts it on the free-queue.
;	It also handles chains of buffers.
;	Accepts	
;		ES:DI	Address of buffer (or chain of buffers) to free
;	Returns
;		None
;	Trashes
;		AX, BX, DI, ES
;------------------------------------------------------------------------------

freebuf	proc	near
	mov	ax,es
	or	ax,di
	jnz	$release
	ret				;NEAR

$release:
	push	word ptr es:[di].play_buf_next		;Get next allocated
	push	word ptr es:[di].play_buf_next[2]	;buffer (if any)

	mov	ax,word ptr queue_free	;Get first buffer on free
	mov	bx,word ptr queue_free[2]

	mov	word ptr queue_free,di	;Add new buffer to free queue
	mov	word ptr queue_free[2],es	

	mov	word ptr es:[di].play_buf_next,ax	;Re-attach free
	mov	word ptr es:[di].play_buf_next[2],bx	;buffer on chain

	pop	es
	pop	di
	jmp	freebuf			;Handle next (if any)

freebuf	endp
sndseg		ends
		end

