.if t .po 1.0i
.if n .po 0.0i
.if n .nr LL 7.5i
.ds ]W February 23th, 1994\"
.TH SND_FLUSH PSSJ "" "PSSJ Digital Sound Toolkit"
.ig
SND_FLUSH troff documentation \- Version 1(6) 23\-Feb\-94
Copyright 1994 Frank Durda IV, All Rights Reserved.
This and other copyright notices may not be removed from this file.
..
.if t  .ta 0.5i 1.0i 1.5i 2.0i 2.5i 3.0i 3.5i 4.0i 4.5i 5.0i 5.5i 6.0i
.if n  .ta 0.6i 1.2i 1.8i 2.4i 3.0i 3.6i 4.2i 4.8i 5.4i 6.0i
.de IN
.if t  .in +0.5i
.if n  .in +0.6i
..
.de OU
.if t  .in -0.5i
.if n  .in -0.6i
..
.de TI
.if t  .ti -0.5i
.if n  .ti -0.6i
..
.de IZ
.if t  .in +1.0i
.if n  .in +1.2i
..
.de OZ
.if t  .in -1.0i
.if n  .in -1.2i
..
.de TZ
.if t  .ti -1.0i
.if n  .ti -1.2i
..
.SH Name
.br
snd_flush \- Queue any remaining sounds and force the player to start.

.SH Syntax
.br
.B short far snd_flush(\ );
.br

.SH Description
.br
\fISnd_flush\fR informs the player that there are no more sounds queued
to be played in this group, and it is to immediately start playing what
has been queued so far.  If the quantity of sound queued had already
reached the \fItrigger\fR threshold specified in the \fIsnd_init\fR(PSSJ),
the player may already be running.  Subsequent calls to
\fIsnd_play\fR(PSSJ) are perfectly valid, but the sound queued immediately
after the \fIsnd_flush\fR call will be preceded by a period of silence.
The \fIsnd_flush\fR call is used to force the player to start after
sounds have been queued, but before the quantity has reached the
\fItrigger\fR threshold.

If the player is already running, any remaining space in the last buffer 
(up to 100 milliseconds) is filled with silence, then it is scheduled
for playing.  Failing to call \fIsnd_flush\fR or \fIsnd_wait\fR(PSSJ)
with the \fIwait\fR option \fBTRUE\fR after the last sound has been passed
to \fIsnd_play\fR(PSSJ) will result in up to 100 milliseconds from the
end of the combined sound not being output.

.SH Return Values
.IZ
.TZ
NOERROR Call succeeded. 
.br
.TZ
INVALID Call not valid at this point (\fIsnd_play\fR(PSSJ) has
not been called).
.br
.OZ

.SH Notes
When \fIsnd_flush\fR is called, any additional sound that is supplied to 
a \fIsnd_play\fR(PSSJ) call will be separated from the earlier sounds by
a period of silence.  This is due to the fact that the sound driver
(internal to the toolkit) must have an exact amount of sound information
in a buffer before it can be queued for playing.  Calling \fIsnd_flush\fR
gives the sound toolkit permission to pad an incomplete buffer with
silence and schedule it for playing.  If the player runs out of sounds
to play before a subsequent call to \fIsnd_play\fR(PSSJ) can be processed,
the player will go idle.  The play queue will have to be filled to the
\fItrigger\fR threshold or a call to \fIsnd_flush\fR or
\fIsnd_wait\fR(PSSJ) will be required to start the player again.
.if n .bp
.if t .sp
.SH See Also
snd_play(PSSJ), snd_wait(PSSJ), snd_buf_wait(PSSJ),
snd_cue(PSSJ), snd_init(PSSJ)

.SH Credit
\fISnd_flush\fR(PSSJ) is part of the PSSJ Digital Sound Toolkit.
.br
Copyright 1994 Frank Durda IV, see \fIintro\fR(PSSJ) for
restrictions.
.br
\-\-\-\-\-\-
.br
402236

