.if t .po 1.0i
.if n .po 0.0i
.if n .nr LL 7.5i
.ds ]W February 18th, 1994\"
.TH SND_EXIT PSSJ "" "PSSJ Digital Sound Toolkit"
.ig
SND_EXIT troff documentation \- Version 1(7) 18\-Feb\-94
Copyright 1994 Frank Durda IV, All Rights Reserved.
This and other copyright notices may not be removed from this file.
..
.if t  .ta 0.5i 1.0i 1.5i 2.0i 2.5i 3.0i 3.5i 4.0i 4.5i 5.0i 5.5i 6.0i
.if n  .ta 0.6i 1.2i 1.8i 2.4i 3.0i 3.6i 4.2i 4.8i 5.4i 6.0i
.de IN
.if t  .in +0.5i
.if n  .in +0.6i
..
.de OU
.if t  .in -0.5i
.if n  .in -0.6i
..
.de TI
.if t  .ti -0.5i
.if n  .ti -0.6i
..
.de IZ
.if t  .in +1.0i
.if n  .in +1.2i
..
.de OZ
.if t  .in -1.0i
.if n  .in -1.2i
..
.de TZ
.if t  .ti -1.0i
.if n  .ti -1.2i
..
.SH Name
.br
snd_exit \- Terminates any active functions and disables the sound hardware.

.SH Syntax
.B short far snd_exit(\ );
.br

.SH Description
\fISnd_exit\fR disables the PSSJ sound chip and re-enables the joystick
and printer hardware.  If the player or recorder are currently running,
\fIsnd_stop\fR(PSSJ) is called automatically.  \fISnd_exit\fR also restores
the hardware interrupt vector to the address that was present before
\fIsnd_init\fR(PSSJ) was called.

Normally when \fIsnd_exit\fR is called, the toolkit does not forget about
the memory previously supplied to
\fIsnd_addbuf\fR(PSSJ).  If a subsequent call is made to
\fIsnd_init\fR(PSSJ), the sound toolkit will re-use any memory
that has been supplied to \fIsnd_addbuf(PSSJ)\fR up to that point.  This
allows the sound drivers to be reactivated quickly after utilizing the
joysticks or the printer port.

If \fIsnd_exit\fR is called and is then called a second time with no
intervening \fIsnd_init\fR(PSSJ) call,
the sound toolkit will not use any buffers previously supplied to
\fIsnd_addbuf\fR(PSSJ).  If the sound toolkit is to be used again, new
buffers must be provided before calling \fIsnd_init\fR(PSSJ).
.SH Return Values
.IZ
.TZ
NOERROR Call succeeded. 
.br
.TZ
INVALID Returned if \fIsnd_init\fR(PSSJ) has never been called or
if \fIsnd_exit\fR has been called more than once.  In both cases
the sound toolkit will not use any buffers previously supplied to
\fIsnd_addbuf\fR(PSSJ).
.br
.OZ

.SH See Also
snd_init(PSSJ), snd_play(PSSJ), snd_record(PSSJ),
snd_file_play(PSSJ), snd_file_record(PSSJ), snd_addbuf(PSSJ)

.SH Credit
\fISnd_exit\fR(PSSJ) is part of the PSSJ Digital Sound Toolkit.
.br
Copyright 1994 Frank Durda IV, see \fIintro\fR(PSSJ) for
restrictions.
.br
\-\-\-\-\-\-
.br
402157

