.if t .po 1.0i
.if n .po 0.0i
.if n .nr LL 7.5i
.ds ]W February 18th, 1994\"
.TH SND_ADDBUF PSSJ "" "PSSJ Digital Sound Toolkit"
.ig
SND_VOLUME troff documentation \- Version 1(8) 18\-Oct\-94
Copyright 1994 Frank Durda IV, All Rights Reserved.
This and other copyright notices may not be removed from this file.
..
.if t  .ta 0.5i 1.0i 1.5i 2.0i 2.5i 3.0i 3.5i 4.0i 4.5i 5.0i 5.5i 6.0i
.if n  .ta 0.6i 1.2i 1.8i 2.4i 3.0i 3.6i 4.2i 4.8i 5.4i 6.0i
.de IN
.if t  .in +0.5i
.if n  .in +0.6i
..
.de OU
.if t  .in -0.5i
.if n  .in -0.6i
..
.de TI
.if t  .ti -0.5i
.if n  .ti -0.6i
..
.de IZ
.if t  .in +1.0i
.if n  .in +1.2i
..
.de OZ
.if t  .in -1.0i
.if n  .in -1.2i
..
.de TZ
.if t  .ti -1.0i
.if n  .ti -1.2i
..
.SH Name
.br
snd_addbuf \- Provides buffers that are to be used by the sound toolkit functions.

.SH Syntax
.br
.B short far snd_addbuf(memory, count);
.br
.B saddr memory;
.br
.B unsigned short count;
.br

.SH Description
\fISnd_addbuf\fR assigns the memory pointed to by \fImemory\fR to the
driver's buffer pool.  These buffers are used when playing sounds
with the \fIsnd_play\fR(PSSJ) call.  The buffers are also used with
the \fIsnd_file_record\fR(PSSJ) and \fIsnd_file_play\fR(PSSJ) calls.

If called with \fImemory\fR equal to \fBNULL\fR, \fIsnd_addbuf\fR will return
the size (in bytes) of a buffer that the sound toolkit functions can use.
This call should be used to determine the size of memory that should be
allocated rather than relying on a constant.

When \fImemory\fR points to an allocated region of memory, \fIcount\fR
should be set to the number of buffers that will fit in that region.

Each call to \fIsnd_addbuf\fR can provide one
or more buffers to the sound toolkit.  You can make as many calls
as are necessary to assign the buffers.

\fISnd_addbuf\fR sets an upper limit of 128 buffers (280K) that can be
assigned to the sound toolkit, but the numbers of buffers needed for most
applications ranges from 15 to 50.

\fISnd_addbuf\fR must be called before \fIsnd_init\fR(PSSJ) is called.
Any calls to \fIsnd_addbuf\fR made after \fIsnd_init\fR(PSSJ) will return
\fBINVALID\fR.

To make use of the synchronizing capabilities of \fIsnd_buf_wait\fR(PSSJ),
the amount of buffer storage available must be greater than the size of
the largest sound that could be passed to \fIsnd_play\fR(PSSJ).  If the
sounds to be played were recorded at 11 KHz, the amount of buffer space
must be at least twice the size of the sound.  For 5.5 KHz, at least
four times the space is required.

.SH Return Values
.IZ
.TZ
NOERROR Call succeeded.
.br
.TZ
INVALID Call not valid at this point (\fIsnd_init\fR(PSSJ) has been called
or 128 buffers have already been assigned).
.br
.OZ
.if t .sp
.if n .bp
.SH Notes
The sound driver reserves three buffers for its internal use, and a 
minimum of two buffers are required for the playing of sounds.
Therefore, a minimum of five buffers should
be supplied to \fIsnd_addbuf\fR before calling \fIsnd_init\fR(PSSJ).  

The three internal buffers are required even if \fIsnd_play\fR(PSSJ) is
not used. 

When \fIsnd_file_play\fR(PSSJ) or \fIsnd_file_record\fR(PSSJ) are
used, the system requires a minimum of fifteen buffers to perform
file operations.  
.if t .bp
.if n .sp
At least one of the buffers supplied to \fIsnd_addbuf\fR must
be wholly contained in a physical 64K region (see the
\fIsnd_init\fR(PSSJ) description).  This buffer is used to hold data
that the DMA will read or write.  The other two reserved buffers are
used in certain functions for temporary storage.  A minimum of two
buffers (in addition to the three reserved buffers) are required to
sustain continuous output.

.SH See Also
snd_init(PSSJ), snd_exit(PSSJ), snd_buf_wait(PSSJ), snd_buf_stop(PSSJ),
snd_play(PSSJ),
.br
snd_file_play(PSSJ), snd_file_record(PSSJ)

.SH Credit
\fISnd_addbuf\fR(PSSJ) is part of the PSSJ Digital Sound Toolkit.
.br
Copyright 1994 Frank Durda IV, see \fIintro\fR(PSSJ) for
restrictions.
.br
\-\-\-\-\-\-
.br
402188

