/*----------------------------------------------------------------------------
	Demo4 -		Reads a file created by demo3 containing compressed
			sound data, decompresses the data and plays it.
			18-Oct-94

			This program expects a filename to be specified
			on the command line.  The syntax is:
				demo4 filename
			The file may be located on any type of disk.

			Demo3 is used to create the file demo4 reads.

			Note:	The file that this program reads is not
				compatible with the DeskMake Sound Editor.
				It is intended to be used with the file
				created by DEMO3.EXE.
			
				The system that runs DEMO4 must have at least
				as much memory available as the system that
				was used to create the sound file (DEMO3).

	DEMO4 is part of the PSSJ Digital Sound Toolkit.
	Copyright 1994 Frank Durda IV, all rights reserved.
	Commercial use is restricted.  See intro(PSSJ) for more information.
----------------------------------------------------------------------------*/

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include "sound.h"
#include "dsetup.h"
#include "dgetbuf.h"
#include "dplay.h"
#include "dload.h"

#ifdef __STDC__
int	main(int argc, char *argv[])
#else
int	main(argc, argv)
int	argc;
char	*argv[];
#endif
{
	char far *cp;			/*pointer to last allocated buffer */
	printf("Demonstration #4 - Read sound data from disk, decompress it,");
	printf(" and play it.\n");
	printf("Version  2(1)  18-Oct-94\n");
	printf("Copyright 1994 Frank Durda IV. All rights reserved.\n");

/*	Print the version number */

	printf("Sound Toolkit ");
	for (cp = snd_version()->version; *cp; putchar(*cp++));
	printf("\n");

	if (argc != 2)			/*Make sure a filename was specified*/
	{
		printf("Usage:  demo4 savefile\n");	/*Wrong number of*/
		exit(1);				/*parameters.*/
	}

/*	Allocate buffers that are used by the sound toolkit, then initialize
	the sound toolkit for operation.
*/

	set_up_sound((u_short) 5, (u_short) 0, (u_short) 0, (u_short) 0,
		(u_short) 0);


	set_up_buffers();		/*Allocate buffers to store sound in
					  that will be recorded by the sound
					  toolkit.*/

/*	Now the file is read, its contents decompressed and the sound
	data is placed in memory.
*/
	do_decompress_and_load(argv[1]);

	do_playback_sound();		/*Play the sound in memory.*/

	snd_exit();			/*Turn off the sound toolkit.  This
					  also disables the hardware.*/

	return(0);			/*Exit*/
}
