
/*----------------------------------------------------------------*/
/*                                                                */
/* DMGUF.H contains the structures and defines needed by          */
/*         applications that use the file I/O.                    */
/*                                                                */
/* Last update: 05/23/89                                          */ 
/*                                                                */
/*----------------------------------------------------------------*/

#ifndef DMGUF_INCLUDED
#define DMGUF_INCLUDED 1

#define WILD		1
#define NO_WILD		0
#define FILE_HEADER_LENGTH 22

#define OPEN_FOR_READ       0       /* file access modes */
#define OPEN_FOR_WRITE      1
#define OPEN_FOR_UPDATE     2

/*  file sharing modes ( OR with a file access mode from above ) */
#define EXCLUSIVE		0X90
#define DENY_WRITE		0XA0
#define DENY_READ		0XB0
#define DENY_NONE		0XC0  /* share  */

#define OPEN_FOR_UPDATE_SHARE 0xA2
#define OPEN_READ_DENY_NONE   0xC0

#define OPEN_NO_DIALOG      1       /* do not use a dialog box */
#define OPEN_WITH_DIALOG    0       /* use a dialog box on the open */

#define MERGE_NO_DIALOG     1       /* file menu merge */
#define MERGE_WITH_DIALOG   0       

#define LOAD_WITH_DIALOG    2

#define LOAD_NO_DIALOG      3

#define FIO_OPEN            1       /* used for dlgbox_Generic */
#define FIO_MERGE           2       /* used for dlgbox_Generic */
#define FIO_LOAD            3       /* used for dlgbox_Generic */

#define FIO_CHAR_XEXT     100       /* these are the same in dmcsr.h */
#define FIO_CHAR_YEXT     220       /* same as in dmcsr.h world coordinate */
#define FIO_SCREEN_WIDTH  (80 * FIO_CHAR_XEXT)
#define FIO_SCREEN_HEIGHT (25 * FIO_CHAR_YEXT)
#define FIO_PB_YEXT       (2 * FIO_CHAR_YEXT)

#define MAX_FILE_NAME_SIZE 65       /* maximum size that a filename can be */
#define MAX_FILES          50       /* used in the FillWithDir call */
#define MAX_BUFFER_SIZE_FOR_FILES 650    /* MAX_FILES * 13 */

#define op_col 26 * FIO_CHAR_XEXT + FIO_CHAR_XEXT/2   /* starting column for dlgbox_Generic */
#define op_row 7 * FIO_CHAR_YEXT    /* starting row for dlgbox_Generic */
#define op_width 27 * FIO_CHAR_XEXT /* width of the dlgbox_Generic */
#define op_height 12 * FIO_CHAR_YEXT/* height of dlgbox_Generic */

#define sa_col 24 * FIO_CHAR_XEXT   /* starting column for dlgbox_SaveAs */
#define sa_row 9 * FIO_CHAR_YEXT    /* starting row for dlgbox_SaveAs */
#define sa_width 32 * FIO_CHAR_XEXT /* width of dlgbox_SaveAs */
#define sa_height 7 * FIO_CHAR_YEXT /* height of dlgbox_SaveAs */

#define FIO_RUN_WIDTH      (36 * FIO_CHAR_XEXT)
#define FIO_RUN_HEIGHT     ((6 * FIO_CHAR_YEXT) + FIO_PB_YEXT)
#define FIO_RUN_XORG       ((FIO_SCREEN_WIDTH - FIO_RUN_WIDTH) >> 1)
#define FIO_RUN_YORG       ((FIO_SCREEN_HEIGHT - FIO_RUN_HEIGHT) >> 1)

#define FIO_PRINT_WIDTH      (35 * FIO_CHAR_XEXT)
#define FIO_PRINT_HEIGHT     ((11 * FIO_CHAR_YEXT / 2) + FIO_PB_YEXT)
#define FIO_PRINT_XORG       ((FIO_SCREEN_WIDTH - FIO_PRINT_WIDTH) >> 1)
#define FIO_PRINT_YORG       ((FIO_SCREEN_HEIGHT - FIO_PRINT_HEIGHT) >> 1)

#ifndef DM_ERROR
#define DM_ERROR                      -1
#endif 

#define DMERR_INVALID_START_POINT      1
#define DMERR_FILE_NOT_FOUND           2
#define DMERR_INVALID_FILENAME         3
#define DMERR_TOO_MANY_OPEN_FILES      4
#define DMERR_INVALID_PATHNAME         5
#define DMERR_INVALID_FILE_HANDLE      6
#define DMERR_INVALID_ACCESS_CODE     12
#define DMERR_OUT_OF_DISK_SPACE       28
#define DMERR_FILE_LOCKED             32
#define DMERR_READ_ONLY_FILE          65 

#define DMERR_NONDESTRUCTIVE_ABORT   101
#define DMERR_DESTRUCTIVE_ABORT      102
#define DMERR_INVALID_FILE_TYPE      103
#define DMERR_INVALID_LOCK_LENGTH    104
#define DMERR_NO_EEPROM     	     105
#define DMERR_INVALID_DRIVE          106
#define DMERR_INVALID_DIRECTORY      107
#define DMERR_BASE_TOO_LONG          108
#define DMERR_EXTENSION_TOO_LONG     109
#define DMERR_INVALID_FILENAME_CHAR  110
#define DMERR_NO_BASE                111
#define DMERR_EXPANDED_PATH_TOO_LONG 112

#define PERSONAL_TEXT_FILE             1
#define OLD_WORKSHEET_FILE             2
#define FILER_FILE                     3
#define PERSONAL_TEXT_ASCII_FILE      10
#define MAIL_FILE                     11
#define MUSIC_FILE                    12
#define OFFICE_TEXT_FILE              13
#define WORKSHEET_FILE                14
#define OFFICE_TEXT_ASCII_FILE        15
#define DRAW_FILE                     16
#define CALENDAR_FILE                 17
#define TELECOM_FILE                  18
#define PAINT_FILE                    19
#define DRAW88_FILE		              20

#define VENDOR_TAG                    50

/*global*/  int rename_file(char  *,char  *);
/*global*/  int delete_file(char  *);

/* this is the NEW datafile structure */
typedef struct datafile_defn
{
    unsigned char FileType;     /* what application owns the file */
    unsigned char Modified;     /* flag for save data prompt, TRUE/FALSE */
    int  FileHandle;            /* file handle, -1 if no open file (untitled)*/
    long FileSize;              /* number of bytes in file */
    char *pFilename;            /* ptr to filename string */
    char *pExtension;           /* ptr to application's filename extension */
    char *pStart;               /* ptr to beginning of data block to write */
    char *pEnd;                 /* ptr to end of data block to write */
    char *pTop;                 /* ptr to top of available memory */
    char *pTmpfil;              /* temporary filename pointer */
} DATAFILE;

typedef struct mergefile_defn
{
    unsigned char FileType;     /* what application owns the file */
    unsigned char Modified;     /* flag for save data prompt, TRUE/FALSE */
    int  FileHandle;            /* file handle, -1 if no open file (untitled)*/
    long FileSize;              /* number of bytes in file */
    char *pFilename;            /* ptr to filename string */
    char *pExtension;           /* ptr to application's filename extension */
    char *pStart;               /* ptr to beginning of data block to write */
    char *pEnd;                 /* ptr to end of data block to write */
    char *pTop;                 /* ptr to top of available memory */
    char *pTmpfil;              /* temporary filename pointer */
} MERGEFILE;

typedef struct env_defn 
{
	char 	*pEnvFileName;
	char	*pDosEnvString;
	char	bSwap;
	char	*pDmEnvString;
	char far *pDataInfo;
	int	DataLen;
} ENVDATA;

/* defines for bSwap flag */

#define ENV_SWAP_DISABLED	0
#define ENV_SWAP_ENABLED	1
#define ENV_SWAP_CREATE		2
#define ENV_NO_CREATE		3

#define	ENV_CANCEL		-2

/* International information
 * Information as it comes back from the DOS country information call
 */
typedef struct pdmintl_desc {
	unsigned Date_fmt;		/* Date format */
	char Currency_sym[5];		/* Currency symbol, null terminated */
	char Thousand_sep[2];		/* 1000's separator, null terminated */
	char Decimal_sep[2];		/* Decimal separator, null terminated */
	char Date_sep[2];		/* Date separator, null terminated */
	char Time_sep[2];		/* Time serarator, null terminated */
	char Currency_fmt;		/* Currency format flags */
	char Sig_decimals;		/* significant digits in currency */
	char Time_fmt;			/* Time format */
	char far *mono;			/* monocase routine entry point */
	char DList_sep[2];		/* Data list separator */
	unsigned int zeros[5];		/* Reserved.  Do not use. */
} PDMINTL;

#define	USA_DATEFMT	          0
#define	EUROPE_DATEFMT	      1
#define	TIMEFMT_12	          0
#define	TIMEFMT_24	          1
#define	CURFMT_0	          0		/* symbol precedes, no spaces */
#define	CURFMT_1	          1		/* symbol follows, no spaces */
#define	CURFMT_2	          2		/* symbol precedes, 1 spaces */
#define	CURFMT_3	          3		/* symbol follows, 1 spaces */
#define	CURFMT_4	          4	 	/* symbol replaces decimal separator */
#define DATE_SEPARATOR	      '-'


/* EEPROM call defines */
/* Language codes returned from get_lang_code() */

#define LC_ENGLISH	0
#define LC_FRENCH	1
#define LC_GERMAN	2
#define LC_SPANISH	3
#define LC_DUTCH	4

#define UK_CCODE   44

#define DEFAULT_CODE_PAGE 437




/* struct for passing the about command the applications version */
struct  appl_versionx 
{
	char *papp_title;	/* title of the application */
	char *papp_name;    /* executable file name of the application */
	char *pversion;      /* version number of the application */
	char *pcopyright_one;  /* free format information, preferable copyright */
	char *pcopyright_two;  /* free format information, preferable copyright */
};
typedef struct appl_versionx APPL_VERSION;

/*	new structure for help notification */
struct	notifyx
	{
	int (far *pre) ();
	int (far *post)();
	unsigned data_seg;
	char	*stack_ptr;
	unsigned psp;
	}

typedef struct notifyx NOTIFY;

#endif

/* end of DMGUF.H */
