;------------------------------------------------------------------------
;                                                                        
; DMDB.INC Database Include File 
;                                                                        
;------------------------------------------------------------------------

;defines for dbmgr main case statement

CREATE_FILE     equ 1
OPEN_FILE       equ 2
CLOSE_FILE      equ 3

CREATE_TABLE    equ 4
ALTER_TABLE     equ 5
OPEN_TABLE      equ 6

ADD_ROW         equ 7

DROP_TABLE      equ 8
CLOSE_TABLE     equ 9

COUNT_RECORDS   equ 10
FIRST_RECORD    equ 11
LAST_RECORD     equ 12
PREV_RECORD     equ 13
NEXT_RECORD     equ 14

SETUP_QUERY     equ 15
MORE_RECORDS    equ 16
FETCH_RECORD    equ 17

DELETE_ROW      equ 18
UPDATE_ROW      equ 19
GET_TABLE_NAMES equ 20

GET_COLUMN_NAMES equ  21

COPY_LAYOUTS    equ 22
PACK_TABLE      equ 23

DEFINE_INDEX    equ 24

GET_PAGE_SETUP  equ 25
SAVE_PAGE_SETUP equ 26

DROP_INDEX      equ 27

DELETE_MULTI_ROWS equ 28
GET_INDEX_INFO  equ 29

MERGE           equ 30

GET_MIN         equ 31
GET_MAX         equ 32

GET_COL_INFO    equ 33
GET_TBL_HIST    equ 34
INIT_TBL_HIST   equ 35
TEMP_SORT       equ 36
END_TEMP_SORT   equ 37
GET_RECORD_LOCATION equ 38
ADD_ROW_NO_FLUSH equ 39

;nothing should go between here

DB_PAUSE        equ 50
INIT_DB         equ 51
END_DB          equ 52

;defines for DB_PAUSE

PAUSE_STATUS    equ 0               ; Return the status
STOP_DB         equ 1               ; Stop the DBMGR
START_DB        equ 2               ; Start the DBMGR.

; defines for initialization binding and unbinding
BIND_READ_ONLY  equ 0               ; for 89 app support
BIND_ALL        equ 1               ; for server88 network app support
BIND_UPDATE     equ 2               ; bind update resource
BIND_BUILD      equ 3               ; bind build and update resources
READ_ONLY       equ 5               ; parameter to db_bind_read
READ_WRITE      equ 6               ; parameter to db_bind_read

MAX_REC_SIZE    equ 1020  ; PG_SIZE - TOKEN_OVERHEAD - RECORD_OVERHEAD
ER_TKN          equ 2     ; end of record token
KS_TKN          equ 4     ; separator for pSortOrder
LOWEST_VALID_CHAR equ 7   ; smallest character allowed for app data
MAX_HIST_SLOTS  equ 10    ; maximum partial update slots

;internal database limits
MTABS           equ 20      ; maximum number of tables in a database
MCOLS           equ 40      ; maximum columns allowed in a table
MQLINES         equ 12      ; maximum number of query lines
MSORT_FLDS      equ  5      ; maximum number of sort fields
MAX_COL_NAME    equ 20      ; maximum number of chars in column name
MAX_TAB_NAME    equ 20      ; maximum number of chars in table name
MAX_QLINE_LEN   equ 62      ; maximum number of chars in query line

;error messages from db_mgr

DB_OK                  equ  0
DB_NO_TBL_HIST         equ  -1
DB_ALREADY_OPEN        equ  -2
DB_DISK_WRITE          equ  -3
DB_NO_CREATE           equ  -4
DB_DUPL_TABLE          equ  -5
DB_TBL_NAME_ERR        equ  -6
DB_COL_NAME_ERR        equ  -7
DB_FIRST_RECORD        equ  -8
DB_LAST_RECORD         equ  -9
DB_QUERY_SYNTAX        equ  -10
DB_NO_ROWS_SELECTED    equ  -11
DB_DISK_READ           equ  -12
DB_NO_OPEN             equ  -13
DB_DUPL_COLUMN         equ  -14
DB_RECNUM_ERR          equ  -15
DB_OUT_OF_MEMORY       equ  -16
DB_MAX_NBR_FIELDS      equ  -17
DB_INVALID_FILE_TYPE   equ  -18
DB_MULTI_UNIQ          equ  -19
DB_UNIQ_NOT_SORT       equ  -20
DB_INVALID_CHAR        equ  -21
DB_NO_EOR              equ  -22
DB_UNIMPLEMENTED       equ  -23
DB_RECORD_NOT_CURRENT  equ  -24
DB_TOO_MANY_OPEN_FILES equ  -25
DB_INVALID_FILE_HANDLE equ  -26
DB_TABLE_LOCKED        equ  -27
DB_DUPL_KEY_FIELD      equ  -28
DB_TABLE_SHARED        equ  -29
DB_INVALID_TABLE_HANDLE equ  -30
DB_RECORD_DELETED      equ  -31
DB_NO_DBCOLUMNS        equ  -32
DB_NO_TEMP_SORT        equ  -33
DB_NO_PACK             equ  -34
DB_PAGE_NOT_FOUND      equ  -35
DB_NO_RECORDS          equ  -36
DB_DIR_FULL            equ  -37
DB_NO_INDEX            equ  -38
DB_ONLY_RECORD         equ  -39
DB_SAME_TABLE          equ  -40
DB_DIFFERENT_TABLES    equ  -41
DB_DISK_FULL           equ  -42
DB_STOPPED             equ  -43
DB_WRITE_PROTECTED     equ  -44
DB_TABLE_FULL          equ  -45
DB_TABLE_NEEDS_UPDATE  equ  -46
DB_MULTI_AGAIN         equ  -49
DB_BUSY                equ  -50
ifndef HL_ROM
DB_TIMOUT              equ  -51
DB_SERVER_BUSY         equ  -52
DB_NO_SERVER           equ  -53
DB_SERVER_DIED         equ  -54
DB_NETERR              equ  -55
endif

ifndef HL_ROM
;defines for client calls
CL_LOCAL        equ 0       ; not a client
CL_CLIENT       equ 1       ; client on non-server
CL_RESUME       equ 2       ; resume client on non-server
CL_REGISTER     equ 3       ; register client with server,
                            ; closes all files and tables
CL_SRVR         equ -1      ; client on server
CL_PAUSE        equ -2      ; pause client on non-server
endif

;strucures for database manager calls

db_columns struc              ; used internally as part of db_table
        col_name    DW  ?   ; pointer to column name
        col_newname DW  ?   ; used to change column name
        col_length  DW  ?   ; column length
        col_type    DB  ?   ; column type see types below
        col_pattr   DB  ?   ; column protection attribute
        col_unq_flg DB  ?   ; if non zero - column value must be unique
db_columns ends

; defines for col_type
CHAR87          equ        'C'     ; 1987 compatible - to_upper &0x5F
CHAR88          equ        'K'     ; for DOS 3.3 & greater uses
                                   ; collating sequence table for
                                   ; sorting & queries
NUMERIC_COL     equ        'N'
DATE_COL        equ        'D'     ; stored internally in julian format


;defines for setting unique_flag value
SET_UNIQUE_COL   equ       '1'
UNSET_UNIQUE_COL equ       '0'

db_table struc             ; used in CREATE_TABLE, ALTER_TABLE
    dbt_handle      DW  ?      ; handle of open file (create) or table (alter)
    dbt_tbl_name    DW  ?      ; pointer to table name
    dbt_n_columns   DW  ?      ; number of columns in table
    dbt_update_type DB  ?      ; update function number
    dbt_n_items     DW  ?      ; number of items in the db_column array
    dbt_cols        DW  ?      ; pointer to array of db_column strucures
db_table ends

;defines for ALTER_TABLE update_type

ADD_COLUMN      equ 1
DROP_COLUMN     equ 2
CHG_COLUMN      equ 3
COLUMN_INFO     equ 4


table_access struc     ; used in OPEN_TABLE, DROP_TABLE
    tbl_fh        DW ?   ; handle of open file
    tbl_name      DW ?   ; table name to open
    tbl_acc_level DW ?   ; DEFINITION or DATA_ACCESS
table_access ends

;defines for OPEN_TABLE access_level

DEFINITION      equ -2
DATA_ACCESS     equ 1


db_value struc              ; used internally in db_add strucure
    dbv_col_name  DW ?    ; pointer to column name
    dbv_col_value DW ?    ; pointer to column value
db_value ends


db_add struc            ; used in ADD_ROW, UPDATE_ROW single user calls
    table_handle DW ?   ; handle of open table
    n_columns    DW ?   ; number of columns to be added or updated
    val          DW ?   ; pointer to an array of db_value strucures
    prev_rec     DW ?   ; previous record, 0= this is first record
    next_rec     DW ?   ; next record, 0= this is last record
db_add ends


db_get struc
    dbg_th               DW ?     ; handle of open table
    dbg_buffer           DW ?     ; pointer to destination buffer
    dbg_num_columns      DW ?     ; number of columns being selected
    dbg_col_array        DW ?     ; array of column names (in ret order)
    dbg_num_query_lines  DW ?     ; number of constraints
    dbg_query_line_array DW ?     ; array of query constraints
    dbg_rec_num          DW ?     ; rec num used for priorafterfetch
    dbg_ih               DW ?     ; index_handle to support TEMP_SORT
db_get ends

db_delete struc
    dbd_th               DW ? ; handle of table to delete from
    dbd_rec_num          DW ? ; record number to delete
    dbd_num_query_lines  DW ? ; number of constraints
    dbd_query_line_array DW ? ; array of query constraints
db_delete ends


db_query struc
    dbq_th               DW ?   ; handle of open table
    dbq_buffer           DW ?   ; pointer to destination buffer
    dbq_num_cols         DW ?   ; number of columns being selected
    dbq_col_array        DW ?   ; array col names (in return order)
    dbq_num_query_lines  DW ?   ; number of constraints
    dbq_query_line_array DW ?   ; array of query constraints
    dbq_amt_memory       DW ?   ; amount of memory app has for recs
    dbq_rec_cnt          DW ?   ; number of records in buffer
    dbq_cur_rec_num      DW ?   ; next record number to be returned
    dbq_direction        DW ?   ; direction records are assembled in
    dbq_ih               DW ?   ; index to retrieve records from
    dbq_qid              DB ?   ; current query id
db_query ends


; directions for record searches for multi-user queries
DIRN_FIRST   equ FIRST_RECORD
DIRN_LAST    equ LAST_RECORD
DIRN_NEXT    equ NEXT_RECORD
DIRN_PRIOR   equ PREV_RECORD

DB_EQUAL     equ '='     ; all rows equal to the specified value
DB_GREATER   equ '>'     ; all rows greater or equal to  value
DB_LESS      equ '<'     ; all rows less or equal to value
DB_NOT_EQUAL equ '!'     ; all rows not equal to value
DB_SUBSTRING equ '|'     ; all rows with this substring in the field
REC_CONTAINS equ '^'     ; all rows with this substring in some field

db_update struc
    dbu_th              DW ?   ; handle of open table
    dbu_n_columns       DW ?   ; number of columns being selected
    dbu_col_names       DW ?   ; array col names (in return order)
    dbu_old_col_values  DW ?   ; old column values (in order)
    dbu_new_col_values  DW ?   ; new column values (in order)
    dbu_rec_num         DW ?   ; current record number
    dbu_verify_flag     DB ?   ; VERIFY or NO_VERIFY
    dbu_prev_rec        DW ?   ; previous record, 0= this is first record
    dbu_next_rec        DW ?   ; next record, 0= this is last record
db_update ends

;defines for verify_flag
VERIFY    equ 1
NO_VERIFY equ 0

handle_buf struc   ; general purpose struc for a handle and buffer
    hb_handle  DW ?    ; handle of open table or file
    hb_buffer  DW ?    ; pointer to buffer for returned information
handle_buf ends


db_index struc
    dbi_th         DW ?   ; open table handle
    dbi_index_name DW ?   ; pointer to index name
    dbi_SortOrder  DW ?   ; column names for sort order, separated by 0eh
db_index ends


db_end_temp struc
    dbe_th DW ?  ; table handle with TEMP_SORT defined
    dbe_ih DW ?  ; index handle of TEMP_SORT to drop
db_end_temp ends


db_merge struc
    dbm_to_th       DW ?  ; tbl handle merge to must be EXCLUSIVE USE
    dbm_from_th     DW ?  ; table handle merging from
    dbm_duplicates  DB ?  ; DUPLICATE - Allow duplicates
                          ; NO_DUPLICATE - Don't allow duplicate records
db_merge ends



DUPLICATE     equ 1
NO_DUPLICATE  equ 0

db_count struc
    dbc_th               DW ? ; handle of open table
    dbc_num_query_lines  DW ? ; number of constraints
    dbc_query_line_array DW ? ; array of query constraints
    dbc_num_match        DW ? ; number of matching records
    dbc_total_num        DW ? ; total number of records in table
db_count ends


db_copy_tbl struc
    cpy_tbl_name DW ? ; table name to copy
    cpy_data     DB ? ; COPY_DATA or NO_COPY_DATA flag
db_copy_tbl ends


COPY_DATA       equ 1
NO_COPY_DATA    equ 0



db_copy_lay struc
    lay_fh           DW ?     ; handle of file containing tables to copy
    lay_new_filename DW ?     ; name of destination file to create
    lay_num_tables   DW ?     ; number of tables in the array
    lay_table_array  DW ?     ; pointer to db_copy_tbl
db_copy_lay ends



; table history slot strucure
hist_slot struc
    his_rec_num         DW ?   ; record number of transaction
    his_trans_type      DB ?   ; A, D, U = Add, Delete, Update
hist_slot ends



; table history request strucure
UserHist struc
    uhis_th          DW ?     ; handle of table with history table
    uhis_time        DD ?     ; time of last update in seconds since 111980
    uhis_num_changes DB ?     ; number of items in following array.
    uhis_changes     DB MAX_HIST_SLOTS*SIZE hist_slot DUP(?)
UserHist ends

db_location struc
    dbl_th               DW ? ; handle of open table
    dbl_num_query_lines  DW ? ; number of constraints
    dbl_query_line_array DW ? ; array of query constraints
    dbl_rec_num          DW ? ; record to get location of
    dbl_prev_num         DW ? ; previous record to rec_num
    dbl_next_num         DW ? ; next record after rec_num
    dbl_ih               DW ? ; index handle from TEMP_SORT
db_location ends

;end of DMDB.INC
