;------------------------------------------------------------------------
;                                                                        
; CSRVID.INC Video Include File for DMCSR
;                                                                        
; Last update: 10-16-89                                                        
;                                                                        
;------------------------------------------------------------------------

; Tandy Characters 
TC_OPEN_BOX     equ 01h    ; box outline with a cleared interion 
TC_GRAYED_BOX   equ 02h    ; box outline with a grayed interior 
TC_CHECK1       equ 03h    ; left half of a check mark 
TC_CHECK2       equ 04h    ; right half of a check mark 
TC_LARROW1      equ 05h    ; left half of a left arrow 
TC_LARROW2      equ 06h    ; right half of a left arrow 
TC_RARROW1      equ 06h    ; left half of a right arrow 
TC_RARROW2      equ 07h    ; right half of a right arrow 
TC_UARROW1      equ 08h    ; left half of an up arrow 
TC_UARROW2      equ 09h    ; right half of an up arrow 
TC_DARROW1      equ 0Ah    ; left half of a down arrow 
TC_DARROW2      equ 0Bh    ; right half of a down arrow 
TC_ACCESSORY    equ 0Ch    ; menubar accessory symbol 
TC_KERNED_F1    equ 0Dh    ; kerned F1 character in a single character 
TC_KERNED_F     equ 0Eh    ; left half of kerned F1-F9 in two chars 
TC_KERNED_1     equ 0Fh    ; right half of two character kerned F1 
TC_KERNED_2     equ 10h    ; right half of two character kerned F2 
TC_KERNED_3     equ 11h    ; right half of two character kerned F3 
TC_KERNED_4     equ 12h    ; right half of two character kerned F4 
TC_KERNED_5     equ 13h    ; right half of two character kerned F5 
TC_KERNED_6     equ 14h    ; right half of two character kerned F6 
TC_KERNED_7     equ 15h    ; right half of two character kerned F7 
TC_KERNED_8     equ 16h    ; right half of two character kerned F8 
TC_KERNED_9     equ 17h    ; right half of two character kerned F9 
TC_DIAMOND      equ 18h    ; diamond character 
TC_CATEAR1      equ 19h    ; left half of cat-eared page character 
TC_CATEAR2      equ 1Ah    ; right half of cat-eared page character 
TC_KERNED_F101  equ 1Bh    ; left half of kerned F10 
TC_KERNED_F102  equ 1Ch    ; right half of kerned F10 
TC_BLANK        equ 1Fh    ; alternate space character 

; Cursor types 
VID_BLOCK_CURSOR    equ 0       ; block cursor 
VID_BAR_CURSOR      equ 1       ; insert cursor 
VID_LINE_CURSOR     equ 2       ; underline cursor 
VID_DEFINED_CURSOR  equ 3       ; definable cursor 
VID_NO_FLASH        equ 80h    ; mask for non-flashing cursor 

; Character attributes 
NORMAL      equ 00h        ; no special attributes 
BOLD        equ 01h        ; bold (by color or by enbolding) 
ITALIC      equ 02h        ; italic (skewed) 
UNDERLINE   equ 04h        ; underlined 
INVERSE     equ 08h        ; inverse (swap fore & background colors) 
GRAYED      equ 10h        ; grayed (cross hatch shading) 
TRANSPARENT equ 20h        ; transparent background 

; Character attribute switches 
BOLD_ON         equ 13h
BOLD_OFF        equ 12h
UNDERLINE_ON    equ 11h
UNDERLINE_OFF   equ 10h
ITALIC_ON       equ 17h
ITALIC_OFF      equ 16h

; Colors 
COLOR_XOR   equ CSR_ERROR
COLOR1      equ 0
COLOR2      equ 1
COLOR3      equ 2
COLOR4      equ 3
COLOR5      equ 4
COLOR6      equ 5
COLOR7      equ 6
COLOR8      equ 7
COLOR9      equ 8
COLOR10     equ 9
COLOR11     equ 10
COLOR12     equ 11
COLOR13     equ 12
COLOR14     equ 13
COLOR15     equ 14
COLOR16     equ 15

; Line types 
LINE_SOLID          equ 0   ; solid lines 
LINE_INVISIBLE      equ 1   ; invisible lines 
LINE_DOTTED         equ 2   ; dotted lines 
LINE_DASHED         equ 3   ; dashed lines 
LINE_DOT_DASHED     equ 4   ; dot-dashed lines 
LINE_DENSE_DOTTED   equ 5   ; densly dotted lines 
LINE_DENSE_DASHED   equ 6   ; densly dashed lines 

LINE_INVERTED    equ 80h   ; inverse (swap fore & background colors) 


; Line widths 
LINE_WIDTH1     equ 0
LINE_WIDTH2     equ 1
LINE_WIDTH3     equ 2
LINE_WIDTH4     equ 3
LINE_WIDTH5     equ 4

; Line brush 
LINE_BRUSH1     equ 5
LINE_BRUSH2     equ 6
LINE_BRUSH3     equ 7
LINE_BRUSH4     equ 8
LINE_BRUSH5     equ 9
LINE_BRUSH6     equ 10
LINE_BRUSH7     equ 11
LINE_BRUSH8     equ 12
LINE_BRUSH9     equ 13
LINE_BRUSH10    equ 14
LINE_BRUSH11    equ 15
LINE_BRUSH12    equ 16
LINE_BRUSH13    equ 17
LINE_BRUSH14    equ 18
LINE_BRUSH15    equ 19
LINE_BRUSH16    equ 20
LINE_BRUSH17    equ 21
LINE_BRUSH18    equ 22

; Fill flags 
VID_FILL        equ SELECTED
VID_NO_FILL     equ DESELECTED

; Rectangle beveledness 
VID_NO_BEVEL    equ 0
VID_BEVEL1      equ 1
VID_BEVEL2      equ 2
VID_BEVEL3      equ 3

; Fill pattern types 
PATTERN_DEFAULT equ CSR_ERROR
PATTERN_NULL    equ CSR_DEFAULT     ; transparent fill 
PATTERN1        equ 0               ; solid background 
PATTERN2        equ 1               ; solid foreground 
PATTERN3        equ 2               ; fine checker 
PATTERN4        equ 3               ; coarse checker 
PATTERN5        equ 4               ; 25% unalligned dots 
PATTERN6        equ 5               ; 25% alligned dots 
PATTERN7        equ 6               ; random dots 
PATTERN8        equ 7               ; vertical stripes 
PATTERN9        equ 8               ; horizontal stripes 
PATTERN10       equ 9               ; ascending slanted lines 
PATTERN11       equ 10              ; descending slanted lines 
PATTERN12       equ 11              ; diamonds 
PATTERN13       equ 12              ; squares 
PATTERN14       equ 13              ; cubes 
PATTERN15       equ 14              ; bricks 
PATTERN16       equ 15              ; shingles 
PATTERN17       equ 16              ; weave 
PATTERN18       equ 17              ; epcot 
PATTERN19       equ 18              ; curls 
PATTERN20       equ 19              ; scales 

; Video attributes 
VID_ATTRS struc
    VID_ATTRS_cursor_enable   db  DISABLED   ;##D DISABLED  cursor enable flag 
    VID_ATTRS_cursor_x        dw  0000H   ;##D 0000H cursor position 
    VID_ATTRS_cursor_y        dw  0000H   ;##D 0000H 
    VID_ATTRS_cursor_type     db  VID_BLOCK_CURSOR   ;##D VID_BLOCK_CURSOR block cursor type 
    VID_ATTRS_cursor_len      dw  ?   ;VID_LINE_CURSOR only 
    VID_ATTRS_cursor_color    db  ?   ;VID_LINE_CURSOR only 
    VID_ATTRS_cursor_defseg   dw  ?   ;segment address of defined cursor 
    VID_ATTRS_cursor_defptr   dw  ?   ;offset to defined cursor 
    VID_ATTRS_cursor_focal_x  db  ?   ;hot spot x of defined cursor 
    VID_ATTRS_cursor_focal_y  db  ?   ;hot spot y of defined cursor 
    VID_ATTRS_char_attr       db  NORMAL   ;##D NORMAL character attributes 
    VID_ATTRS_bg_color        db  COLOR1   ;##D COLOR1 background color 
    VID_ATTRS_fg_color        db  COLOR2   ;##D COLOR2 foreground color 
    VID_ATTRS_line_type       db  LINE_SOLID   ;##D LINE_SOLID line type 
    VID_ATTRS_line_width      db  LINE_WIDTH1   ;##D LINE_WIDTH1 line width 
    VID_ATTRS_line_fgnd_color db  COLOR4   ;##D COLOR4 line color 
    VID_ATTRS_pattern         db  PATTERN2   ;##D PATTERN2 fill pattern 
    VID_ATTRS_char_xext       dw  CHAR_XEXT   ;##D CHAR_XEXT character x extent 
    VID_ATTRS_char_yext       dw  CHAR_YEXT   ;##D CHAR_YEXT character y extent 
    VID_ATTRS_line_bgnd_color   dw  COLOR3            ;line pattern bg color
VID_ATTRS ends



; Video device 
VID_DEVICE struc
    VID_DEVICE_card           db  ?   ;video card id 
    VID_DEVICE_dc_xorg        dw  ?   ;device pixel x origin 
    VID_DEVICE_dc_yorg        dw  ?   ;device pixel y origin 
    VID_DEVICE_dc_xext        dw  ?   ;device pixel x extent 
    VID_DEVICE_dc_yext        dw  ?   ;device pixel y extent 
    VID_DEVICE_xaspect        db  ?   ;x aspect ratio  x:y  
    VID_DEVICE_yaspect        db  ?   ;y aspect ratio  x:y  
VID_DEVICE ends



; Video cards 
VID_1000    equ 0   ; Tandy 1000 640x200/4.......Better Again! 
VID_CGA     equ 1   ; Dual Display Adaptor/CGA 640x200/2 
VID_DDGA    equ 2   ; Dual Display Adaptor/special mode 640x200/16 
VID_EGA     equ 3   ; QuadEGA/EGA+ 640x350/16 
VID_HERC    equ 4   ; Dual Display Adaptor/Hercules 720x348/2 
VID_PLAN    equ 5   ; Dual Display Adaptor/Plantronics 640x200/16 
VID_TC16    equ 6   ; 1988 Tandy 1000TX custom mode 640x200/16 
VID_TC4     equ 7   ; 1988 Tandy 1000TX custom mode 640x400/4 
VID_VGA     equ 8   ; VGA Adaptor 640x450/16 
VID_MCGA    equ 9   ; MCGA Adaptor 
VID_EGAM    equ 10  ; Monochrome EGA 

; added on 02-01-89    
VID_LRES    equ 11  ; Low resolution (cga 40 column) 320x200/4 
VID_T256    equ 12  ; Tandy 256 colors (40 column) 320x200/254 
VID_TC40    equ 13  ; Tandy 40 column driver  320x200/16 

; added on 09-22-89    
VID_HERC40	equ 14     ; Hercules 40 column  360x348/3        
VID_EGA40C	equ 15     ; EGA 40 column color 640x350/16       
VID_EGA40M	equ 16     ; EGA 40 column monochrome  640x350/3  

; added on 10-9-89     
VID_EGA40C_LORES equ 17 ;EGA 40 column color low resolution 320x200/16

; Video colors 
VID_COLORS struc
    VID_COLORS_nColors        dw  ?   ;num of colors to choose from 
    VID_COLORS_nPalettes      db  ?   ;number of palettes 
    VID_COLORS_nGunIncs       db  ?   ;number of RGB gun increments 
    VID_COLORS_nIntensIncs    db  ?   ;number of intensity increments 
    VID_COLORS_first_palette  db  ?   ;first assignable palette of device 
VID_COLORS ends



VID_PALETTE struc
    VID_PALETTE_palette       db  ?   ;palette index 
    VID_PALETTE_red           db  ?   ;red color gun intensity 
    VID_PALETTE_green         db  ?   ;green color gun intensity 
    VID_PALETTE_blue          db  ?   ;blue color gun intensity 
VID_PALETTE ends



; Buttons 
BUTTON struc
    BUTTON_xorg               dw  ?   ;world coordinate x origin of button 
    BUTTON_yorg               dw  ?   ;world coordinate y origin of button 
    BUTTON_xext               dw  ?   ;world coordinate x extent of button 
    BUTTON_type               db  ?   ;button type 
    BUTTON_pattern            db  ?   ;pattern upon which button is being drawn 
    BUTTON_bgnd_color         db  ?   ;background color of the button image 
    BUTTON_fgnd_color         db  ?   ;foreground color of the button image 
    BUTTON_string_color       db  ?   ;color of the button label string 
    BUTTON_pString            dw  ?   ;pointer to the button label string 
BUTTON ends



; Button masks for type element of the BUTTON structure 
BTN_ROUNDED     equ 00h    ; rounded edges 
BTN_SQUARED     equ 01h    ; squared edges 
BTN_RAISED      equ 00h    ; raise position 
BTN_PRESSED     equ 02h    ; pressed position 
BTN_INVERTED    equ 04h    ; invert button (valid w/ BTN_PRESSED only) 
BTN_LEFT_EDGE   equ 08h    ; left unobstructed (for BTN_SQUARED only) 
BTN_RIGHT_EDGE  equ 10h    ; right unobstructed (for BTN_SQUARED only) 
BTN_GRAYED      equ 20h    ; button is grayed 

; video swaping structure     02-06-89 
VID_SWAP_INFO struc
    VID_SWAP_INFO_driver_name       db 'DMVS'
                                    db 0
                                    db 0
                                    db 0
                                    db 0
                                    db 0
    VID_SWAP_INFO_nColumns    dw  ?   ;number of columns the driver supports 
    VID_SWAP_INFO_nColors     dw  ?   ;number of colors supported 
    VID_SWAP_INFO_dc_xext     dw  ?   ;number of pixels on screen in x-extent 
    VID_SWAP_INFO_dc_yext     dw  ?   ;number of pixels on screen in y-extent 
    VID_SWAP_INFO_system_memory dw  ?   ;amount of system memory in paragraph used 
    VID_SWAP_INFO_card_id     db  ?   ;holds the card id, as in the VID_DEVICE struct
VID_SWAP_INFO ends




; Video Memory  09-26-89 
VID_MEMORY struc
    VID_MEMORY_card           db  ?   ;video card id 
    VID_MEMORY_start          dd  ?   ;offset of the first free video byte 
    VID_MEMORY_end            dd  ?   ;end offset of block video screen 
    VID_MEMORY_nKBytes        dd  ?   ;number of video memory Kbytes required 
VID_MEMORY ends

;end of CSRVID.INC
