/*------------------------------------------------------------------------*/
/*                                                                        */
/* CSRCMPS.H Components, Dialog Box, Information Box and Message Box      */
/* include File for DMCSR                                                 */
/*                                                                        */
/* Last update: 03/17/89                                                  */
/*                                                                        */
/*------------------------------------------------------------------------*/

#ifndef CSRCMPS_INCLUDED
#define CSRCMPS_INCLUDED 1

/* Titled frame */
struct frame_defn
{
    MAPRECT        maprect;    /* origin/extent of the frame */
    unsigned char  *pString;   /* pointer to title string for the frame */
};
typedef struct frame_defn FRAME;

/* Static string */
struct static_string_defn
{
    char           bEnabled;   /* grayed flag */
    int            xorg;       /* x origin of string */
    int            yorg;       /* y origin of string */
    char           attr;       /* string attribute */
    unsigned char  *pString;   /* pointer to string */
};
typedef struct static_string_defn STATIC_STRING;

/* Static box */
struct static_box_defn
{
    char    type;       /* type of box */
    MAPRECT maprect;    /* org/ext of box */
    char    color;      /* color of the box */
};
typedef struct static_box_defn STATIC_BOX;

/* Box types */
#define FLAT_BOX        0       /* single thin line box */
#define RAISED_BOX      1       /* 3-D raised block */
#define PYRAMID         2       /* 3-D pyramid */
#define DEST_FLAT_BOX   3       /* thin line box that erases a RAISED_BOX */
#define LISTBOX_BOX     4       /* item list border for listboxes */
#define GRAYED_BOX      0x80    /* flag to make boxes grayed */
#define ENLARGED_BOX    0x40    /* flag to pad frame interior with gap */

/* Static Icon */
struct static_icon_defn
{
    MAPRECT maprect;    /* icon org/ext */
    char    *pIcon;     /* pointer to icon definition */
};
typedef struct static_icon_defn STATIC_ICON;

/* Dialog box */
struct dialog_box_defn
{
    char            bStatRedraw;    /* redraw flag for static items */
    unsigned int    return_value;   /* return code */
    char            focus_index;    /* next focus id */
    char            help_level;     /* help level */
    FRAME           *pFrame;        /* pointer to FRAME structure */
    char            nStrings;       /* number of static strings */
    STATIC_STRING   *pStrings;      /* ptr to STATIC_STRING structs */
    char            nBoxes;         /* number of static boxes */
    STATIC_BOX      *pBoxes;        /* pointer to STATIC_BOX structs */
    char            nIcons;         /* number of static icons */
    STATIC_ICON     *pIcons;        /* pointer to STATIC_ICON structs */
    char            nCmps;          /* number of components */
    char            *pRFlags;       /* ptr to component redraw flags */
    char            **pCmps;        /* ptr to component pointer list */
};
typedef struct dialog_box_defn DIALOG_BOX;

/* Static item redraw flags */
#define DLG_REDRAW      SELECTED
#define DLG_NO_REDRAW   DESELECTED

/* No dialog box help */
#define DLG_NO_HELP     CSR_NULL

/* OK and Cancel button accelerators */
#define DLG_OK_KEY      RETURN_KEY
#define DLG_CANCEL_KEY  ESC_KEY

/* New component session , used in bEnables cmp_headers */
#define DLG_NEW_SESSION 0x80

/* Request for event_appl to be returned to application, or in help_level */
#define DLG_APPL_REQUEST (MENU_TAG+01) /* return code for appl events     */
#define DLG_RETURN_APPLS 0x80          /* all appl events to be returned  */


/* Information Box */
struct info_string_defn
{
    MAPRECT          maprect;         /* word wrap boundaries */
    char             color;           /* foreground color of string */
    unsigned char    *pString;        /* pointer to zero terminated string */
};
typedef struct info_string_defn INFO_STRING;

struct info_icon_defn
{
    STATIC_ICON icon;          /* icon definition structure */
    char        line_type;     /* line type for stroke list */
    char        line_width;    /* line width for stroke list */
    char        line_color;    /* line color for stroke list */
};
typedef struct info_icon_defn INFO_ICON;

struct info_box_defn
{
    STATIC_BOX  frame;       /* STATIC_BOX for INFO_BOX frame */
    char        bgnd_color;  /* background color of box */
    char        nStrings;    /* number of strings in INFO_BOX */
    INFO_STRING *pStrings;   /* pointer to INFO_STRING struc(s) */
    char        nBoxes;      /* number of static boxes in INFO_BOX */
    STATIC_BOX  *pBoxes;     /* pointer to STATIC_BOX struc(s) */
    char        nIcons;      /* number of icon images in INFO_BOX */
    INFO_ICON   *pIcons;     /* pointer to STATIC_ICON struc(s) */
    char        nImages;     /* number of generic bitmaps in INFO_BOX */
    IMAGE       *pImages;    /* pointer to IMAGE struc(s) */
};
typedef struct info_box_defn INFO_BOX;

/* Information Box String attribute defines */
/* Information Box String attribute defines */
#define INFO_NORMAL       0xC0      /* info_box NORMAL attribute */
#define INFO_BOLD         0xC1      /* info_box BOLD attribute */
#define INFO_ITALIC       0xC2      /* info_box ITALIC attribute */
#define INFO_UNDERLINE    0xC3      /* info_box UNDERLINE attribute */
#define INFO_INVERSE      0xC4      /* info_box INVERSE attribute */
#define INFO_GRAYED       0xC5      /* info_box GRAYED attribute */
#define INFO_TRANSPARENT  0xC6      /* info_box TRANSPARENT attribute */
#define INFO_RES1         0xC7      /* info_box RESERVED 1 attribute */
#define INFO_RES2         0xC8      /* info_box RESERVED 2 attribute */

#define INFO_NO_FRAME     CSR_ERROR /* no frame option for info boxes */

/* Component Manager */
struct cmp_routines_defn
{
    int     (far *pOpen)();  /* pointer to open routine for the component */
    int     (far *pDraw)();  /* pointer to draw routine for the component */
    int     (far *pRun)();   /* pointer to run routine for the component */
    int     (far *pClose)(); /* pointer to close routine for component */
    int     (far *pHelp)();  /* pointer to routine to return help string */
};
typedef struct cmp_routines_defn CMP_ROUTINES;

/* Null routine */
#define CMP_NO_ROUTINE   0

/* General */
struct cmp_header_defn
{
    unsigned int  type;           /* component type */
    char          bEnabled;       /* enable flag for component */
    MAPRECT       maprect;        /* origin/extent */
    unsigned int  accel;          /* key accelerator for component */
    unsigned int  return_code;    /* return code for component */
};
typedef struct cmp_header_defn CMP_HEADER;

/* No handle */
#define CMP_NULL_HANDLE     -1

/* Types */
#define CMP_PUSHBUTTON      CMP_TAG+0
#define CMP_RADIOBUTTONS    CMP_TAG+1
#define CMP_ICONBUTTON      CMP_TAG+2
#define CMP_LISTBOX         CMP_TAG+3
#define CMP_CHECKBOX        CMP_TAG+4
#define CMP_EDIT            CMP_TAG+5
#define CMP_MENUBAR         CMP_TAG+6
#define CMP_MESSAGE         CMP_TAG+7

#define CMP_QUEUE_HELP      CMP_TAG+251	/* 03-17-89 */
#define CMP_MESSAGE_BOX     CMP_TAG+252
#define CMP_DLG_BOX         CMP_TAG+253
#define CMP_MMBAR           CMP_TAG+254

/* Return codes */
#define CMP_NO_ACTION       0           /* no action taken within component */
#define CMP_ACTION          1           /* component status has changed */
#define CMP_SCROLLED        2           /* scroll occured */
#define CMP_TRUNCATED       3           /* edit string was truncated */
#define CMP_CANCEL          5           /* component was canceled */
#define CMP_DISABLED        6           /* component was grayed */
#define CMP_GO              7           /* user invoked select and go */
#define CMP_SELECT_CHANGE   8           /* user invoked selection change */
#define CMP_ACTION_IN_EVENT 9           /* cmp action is in the event queue */
#define CMP_APPL            10          /* cmp received an EVENT_APPL event */

/* Null states */
#define NO_ACCEL     -1     /* no accelerator */
#define NO_SELECTED  -1     /* no selected */

/* Keep component out of tab order */
#define CMP_NO_TAB          0x02

/* Pushbutton Component */
struct pushbutton_defn
{
    CMP_HEADER     header;
    char           type;       /* flat or raised */
    char           bState;     /* up/down flag */
    char           pattern;    /* pattern number of background */
    unsigned char  *pString;   /* pointer to button name string */
};
typedef struct pushbutton_defn PUSHBUTTON;

/* Header maprect */
#define PB_BASE_XEXT        2*CHAR_XEXT
#define PB_YEXT             345
#define PB_DEFAULT_ACCEL    CSR_DEFAULT

/* Types */
#define PB_FLAT         1   /* flat pushbutton */
#define PB_RAISED       0   /* raised pushbutton */
#define PB_INV_RAISED   2   /* invert raised pushbutton on press */

/* States */
#define PB_UP       DESELECTED
#define PB_DOWN     SELECTED

/* Radiobuttons Component */
struct radiobutton_defn
{
    char    bEnabled;   /* enable (grayed) flag */
    int     xorg;       /* x origin relative to group */
    int     yorg;       /* y origin relative to group */
};
typedef struct radiobutton_defn RADIOBUTTON;

struct rb_group_defn
{
    CMP_HEADER  header;
    char        nAcross;    /* number of buttons wide */
    char        nDown;      /* number of buttons tall */
    char        selected;   /* ordinal id of pushed button */
    char        pattern;    /* pattern number of background */
    char        nButtons;   /* number of buttons in group */
    RADIOBUTTON *pButtons;  /* pointer to RADIOBUTTON structures */
    char        cursor;     /* cursor button index */
};
typedef struct rb_group_defn RB_GROUP;

/* Radiobutton extents */
#define RB_XEXT     3*CHAR_XEXT
#define RB_YEXT     CHAR_YEXT

/* Iconbutton Component */
struct iconbutton_defn
{
    CMP_HEADER  header;
    char        type;     /* type of iconbutton */
    char        bState;   /* on/off flag */
    char        pattern;  /* pattern number of background */
    char        interior; /* interior pattern of button */
    char        *pUp;     /* icon "on" definition */
    char        *pDown;   /* icon "off" definition */
};
typedef struct iconbutton_defn ICONBUTTON;

/* types */
#define IB_FLAT         1   /* flat iconbutton */
#define IB_RAISED       0   /* raised iconbutton */
#define IB_INV_RAISED   2   /* invert raised icon button on press */
#define IB_NO_BORDER    3   /* no frame on this button, flat button */

/* Checkbox Component */
struct checkbox_defn
{
    CMP_HEADER  header;
    char        bState;  /* checked/unchecked flag */
};
typedef struct checkbox_defn CHECKBOX;

/* Header maprect */
#define CB_XEXT     2*CHAR_XEXT
#define CB_YEXT     1*CHAR_YEXT

/* State */
#define CB_CHECKED      SELECTED
#define CB_UNCHECKED    DESELECTED

/* Listbox Component */
struct listbox_defn
{
    CMP_HEADER      header;
    char            bTitle;        /* title selectable flag */
    char            bScroll;       /* scroll direction flag */
    char            bAlphabetize;  /* list alphabetization flag */
    char            bMulti;        /* multi select flag */
    char            border;        /* border type */
    char            bgnd_color;    /* background color */
    char            fgnd_color;    /* foreground color */
    unsigned char   top_string;    /* number of top item in window */
    unsigned char   selected;      /* list box selected item */
    unsigned char   *pString;      /* list box title */
    unsigned char   nItems;        /* number of strings */
    char            *pSelected;    /* pointer to selected list */
    unsigned char   **pItems;      /* pointer to string list */
};
typedef struct listbox_defn LISTBOX;

/* Header maprect */
#define LB_BASE_XEXT    2*CHAR_XEXT
#define LB_BASE_YEXT    2*CHAR_YEXT

/* Scroll types */
#define LB_VERT_SCROLL  0           /* single column vertical scrolling */
#define LB_HORZ_SCROLL  1           /* 2 coumn horizontal scrolling */

/* Additional border types */
#define LB_NO_FRAME     -1          /* no frame around listbox */
#define LB_NO_BORDER    -2          /* no border or frame around listbox */

/* Use current colors */
#define LB_NO_COLOR     CSR_DEFAULT

/* y extent from top of listbox to top of list */
#define LB_TITLE_YEXT   CHAR_YEXT*3/2

/* Listbox in multi-select mode mask */
#define LB_IN_MULTI     0x02

/* Editfield Component */
struct editfield_defn
{
    CMP_HEADER     header;
    char           type;           /* edit field type */
    char           bHighlight;     /* flag to highlight field on run */
    char           dec_places;     /* number of places to the right of . */
    MAPRECT        edit_maprect;   /* visible part */
    char           attr;           /* char attribute to use */
    int            cursor_offset;  /* cursor offset into string */
    int            end_offset;     /* offset to end of string */
    int            select_offset;  /* offset to select start */
    int            select_length;  /* length of selected area */
    char           terminator;     /* terminating character of string */
    unsigned char  *pBuffer;       /* pointer to edit string */
    unsigned char  *pFormat;       /* pointer to format string */
    char           scroll_type;    /* direction of scroll */
    int            scroll_length;  /* number of chars to scroll */
    int            scroll_height;  /* number of rows to scroll */
    char           bNoEdit;        /* editable field flag */
    char           border;         /* border type for editfield */
};
typedef struct editfield_defn EDITFIELD;

/* Editable field flags */
#define EF_EDITABLE         DESELECTED
#define EF_NO_EDIT          SELECTED

/* Types */
#define EF_STATIC           0x00 /* static */
#define EF_EXPAND           0x01 /* expand size of feild on insert */
#define EF_RIGHT_JUSTIFY    0x02 /* right justification of edit string */
#define EF_NUMBER           0x04 /* numeric input only */
#define EF_EXTNUM           0x06 /* extended numeric input only */
#define EF_WORD_WRAP        0x08 /* word wrap on multiline */
#define EF_NO_WORD_WRAP     0x10 /* no word wrap on multiline */

/* Highlight flag */
#define EF_HIGHLIGHT    ENABLED
#define EF_NO_HIGHLIGHT DISABLED

/* Scroll types */
#define EF_SCROLL_UP        0
#define EF_SCROLL_DOWN      1
#define EF_SCROLL_LEFT      2
#define EF_SCROLL_RIGHT     3
#define EF_NO_SCROLL        4
#define EF_SCROLL           5

/* Cursor offset options */
#define EF_SELECT_ALL       -1

/* Frameless editfield */
#define EF_NO_FRAME         CSR_ERROR

/* Editfield modified mask */
#define EF_MOD_MASK         0x40

/* Menubar Component */
struct menuitem_defn
{
    char          type;           /* item type */
    char          bEnabled;       /* enable (grayed) flag for item */
    char          bChecked;       /* check flag */
    unsigned int  accel;          /* accelerator for item */
    unsigned int  return_code;    /* return code for item */
    char          group;          /* group number of item */
    char          pattern;        /* pattern to use as the item */
    unsigned char *pString;       /* pointer to item name string */
};
typedef struct menuitem_defn MENUITEM;

struct menu_defn
{
    int           xext;       /* x extent of menu */
    unsigned char *pString;   /* pointer to button name string */
    char          nItems;     /* number of items in the menu */
    MENUITEM      *pItems;    /* pointer to MENUITEM structures */
};
typedef struct menu_defn MENU;

struct menubar_defn
{
    CMP_HEADER  header;
    char        bFlags;         /* arrow and top line flags */
    char        bRedraw;        /* visible redraw flag */
    char        nMenus;         /* number of menus on the menubar */
    MENU        *pMenus;        /* pointer to MENU structures */
    char        pattern;        /* background pattern of the menubar */
    char        bStatus;        /* process help only flag */
};
typedef struct menubar_defn MENUBAR;

/* Item check state */
#define MB_CHECKED     SELECTED
#define MB_UNCHECKED   DESELECTED

/* Groups */
#define MB_GROUP1   0
#define MB_GROUP2   1
#define MB_GROUP3   2
#define MB_GROUP4   3
#define MB_GROUP5   4
#define MB_GROUP6   5
#define MB_GROUP7   6
#define MB_GROUP8   7
#define MB_GROUP9   8

/* Item types */
#define MB_STRING   0   /* item is a string */
#define MB_PATTERN  1   /* item is a pattern */

/* Menu width */
#define MB_BASE_XEXT    6*CHAR_XEXT     /* base x extent of a menu */

/* Header maprect */
#define MB_XORG     0               /* default x origin of a menubar */
#define MB_YORG     290             /* default y origin of a menubar */
#define MB_XEXT     80*CHAR_XEXT    /* default x extent of a menubar */
#define MB_YEXT     345             /* y extent of menubars */

/* Accelerator */
#define MB_ACCEL    ALT_SPACE_KEY

/* Flag masks */
#define MB_PLAIN        0   /* no Tandy, help or arrow buttons */
#define MB_HELP_BUTTON  1   /* help button */
#define MB_RIGHT_ARROW  2   /* right arrow button */
#define MB_LEFT_ARROW   4   /* left arrow button */
#define MB_DOWN_ARROW   8   /* down arrow button */
#define MB_UP_ARROW     16  /* up arrow button */
#define MB_TANDY        32  /* Tandy icon button ...... Clearly Superior */
#define MB_ALARM        64  /* alarm button */
#define MB_VERT_ARROWS  MB_UP_ARROW+MB_DOWN_ARROW
#define MB_HORZ_ARROWS  MB_LEFT_ARROW+MB_RIGHT_ARROW
#define MB_ALL_ARROWS   MB_VERT_ARROWS+MB_HORZ_ARROWS

/* Redraw flags */
#define MB_REDRAW       SELECTED    /* redraw menubar */
#define MB_NO_REDRAW    DESELECTED  /* only redifine enabled/disabled items */

/* World coordinate of the last default main menubar pixel */
#define MB_BOTTOM_YORG  MB_YORG+MB_YEXT-1

/* Alarm menu access mask for bSatus element of the MENUBAR structure */
#define MB_ALARM_ACCESS 0x01

/* mb_add_alarm return codes */
#define MB_NOT_NOTIFIED     0x01    /* alarm added but User not notified */
#define MB_ALARM_EXISTS     0x02    /* alarm exists, not added again */

/* Message Box Manager */
struct msgbox_defn
{
    char            btn_combo;  /* button combination */
    unsigned char   *pString;   /* pointer to title string */
    unsigned char   *pMessage;  /* pointer to message */
};
typedef struct msgbox_defn MSGBOX;

/* Button combinations */
#define MSG_COMBO_OK            0   /* OK button only */
#define MSG_COMBO_OK_CAN        1   /* OK and CANCEL buttons */
#define MSG_COMBO_YES_NO_CAN    2   /* YES, NO and CANCEL buttons */
/* Combos 3-11 must remain undefined for 1987 compatibility */
#define MSG_COMBO_CANCEL        12  /* CANCEL button only */
#define MSG_COMBO_RETRY_CAN     13  /* RETRY and CANCEL buttons */
#define MSG_COMBO_YES_NO        14  /* YES and NO buttons */

/* Button return codes */
#define MSG_OK          MSG_TAG+1
#define MSG_CANCEL      MSG_TAG+2
#define MSG_YES         MSG_TAG+3
#define MSG_NO          MSG_TAG+4
/* Buttons 5-10 must remain undefined for 1987 compatibility */
#define MSG_RETRY       MSG_TAG+11
/* Buttons 12-16 must remain undefined for 1987 compatibility */

#define MSG_HS_XORG     36*CHAR_XEXT
#define MSG_HS_YORG     14*CHAR_YEXT
#define MSG_HS_XEXT     8*CHAR_XEXT

/* Message box save rectangle */
#define MSG_SAVE_XORG   19*CHAR_XEXT
#define MSG_SAVE_YORG   8*CHAR_YEXT
#define MSG_SAVE_XEXT   42*CHAR_XEXT
#define MSG_SAVE_YEXT   9*CHAR_YEXT

#endif

/* end of CSRCMPS.H */
