;
; tspeed, the TSR version of speed was written to allow switching of
; CPU speed 'on the fly'.  Not that I really have any need for this
; utility, I have seen it on other clones, and figured someone might
; find it useful.
;
;
;
;
	  jmp	 install	       ;avoid executing data
;
;
old9int   dw	 2 dup (?)	       ;store the original cs:ip for
speed	  db	 0		       ;what is current speed?
;
;  Here begins the new INT 9H (kbd).
;
main:
	  push	 ax		       ;save regs
	  push	 ds
	  push	 es
	  mov	 ax,cs		       ;set ds & es to point here
	  mov	 ds,ax
	  mov	 es,ax
	  sti			       ;enable higher priority interrupts
	  in	 al,60h 	       ;get scan code from keyboard
	  cmp	 al,55h 	       ;was <+>/<INSERT> key pressed?
	  jne	 exit		       ;if not, exit to orig 9h
	  mov	 ah,2		       ;else get state of shift keys
	  int	 16h		       ;kbd_io
	  and	 al,1100b	       ;is <CTRL>-<ALT> depressed?
	  cmp	 al,1100b
	  je	 roach1 	       ;if so, continue
;
;  This is where control is passed to the real INT 9H.
;
exit:
	  pop	 es		       ;restore regs
	  pop	 ds
	  pop	 ax
	  jmpf	 cs:old9int
;
;  Here, <CTRL>-<ALT>-<+> has been pressed.
;
roach1:   in	 al,61h 	       ;get current control port value
	  mov	 ah,al		       ;save it in ah
	  or	 al,80h 	       ;set bit 7
	  out	 61h,al 	       ;send reset value
	  mov	 al,ah		       ;get original value
	  out	 61h,al 	       ;send it out to enable keyboard
	  cli			       ;stop interrupts
	  mov	 al,20h 	       ;send eoi
	  out	 20h,al
	  sti			       ;allow interrupts
	  xor	 speed,1	       ;change speed from 1 to 0 or
				       ;0 to 1
	  cmp	 speed,1	       ;change to slow speed?
	  jne	 fst		       ;if not set for fast
	  call	 bigcurs	       ;set large cursor for slow
	  jmp	 start		       ;swap speed
fst:	  call	 smcurs 	       ;set small cursor for fast
;
;	  Switch CPU speed from 4.77 to 7.16 MHz (and vice-versa)
;
;  The port address was found in the Tandy 1000sx Tech Ref Manual
;
start:
	  in	 ax,62h 	       ;get current contents
	  xor	 ax,08h 	       ;flip speed bit (bit 3)
	  out	 62h,ax 	       ;send new value
;
;
;
	  pop	 es		       ;restore regs
	  pop	 ds
	  pop	 ax
	  iret			       ;interrupt return to caller
;
;  Set to small cursor
;
smcurs:
	  push	 ax		       ;save regs
	  push	 cx
	  mov	 ah,01h 	       ;set_cur_shap
	  mov	 ch,6		       ;default value
	  mov	 cl,7		       ;default value
	  int	 10h		       ;vid_io
	  pop	 cx		       ;restore regs
	  pop	 ax
	  ret			       ;return to caller
;
;  Set to large cursor
;
bigcurs:
	  push	 ax		       ;save regs
	  push	 cx
	  mov	 ah,01h 	       ;set_cur_shap
	  mov	 ch,0		       ;top row
	  mov	 cl,7		       ;bottom row
	  int	 10h		       ;vid_io
	  pop	 cx		       ;restore regs
	  pop	 ax
	  ret			       ;return to caller
;
;
install:
	  mov	 ah,35h 	       ;get interrupt vector
	  mov	 al,9h		       ;interrupt vector wanted
	  int	 21h		       ;DOS interrupt
	  mov	 old9int[2],es
	  mov	 old9int,bx
	  mov	 ah,25h 	       ;set_int_vector
	  mov	 al,9h		       ;set new interrupt 9h
	  mov	 dx,offset main        ;set offset
	  cli			       ;stop interrupts
	  int	 21h		       ;DOS interrupt
	  sti			       ;allow interrupts
	  mov	 dx,offset install     ;this code not needed after init
	  int	 27h		       ;Terminate-but-Stay-Resident
;
;**************PROGRAM ENDS****************
;
comend:
	  end			       ;end of source code
