; REFRESH2.ASM
;
; This program is a TSR utility to perform RAM refresh in software, for
; use with a Memory Plus card whose DMA	chip is fried.
;

CODE	SEGMENT PUBLIC	
	ASSUME	CS:CODE;DS:CODE;SS:CODE
	ORG	100H
MAIN	PROC	FAR
	JMP	STARTUP
	;
	; Needed data, access through CS.
	;
DEFAULT	DD	?
	;
	; Some constants.
	;
INSTCHA	EQU	0C987h
INSTCHB	EQU	00753h
INSTCHC	EQU	0FA15h
SUCCESS	EQU	01B04h
	;
	; Int 08h handler.
	;
TSRBEGIN:
	;
	; Disable interrupts.  They remain disabled until IRET, unless the
	; default handler is to be called.
	;
	CLI
	;
	; Installation check?
	;
	CMP	AX,INSTCHA
	JNE	SAVEREGS
	CMP	BX,INSTCHB
	JNE	SAVEREGS
	CMP	CX,INSTCHC
	JNE	SAVEREGS
	MOV	AX,SUCCESS
	IRET
	;
	; Save registers.
	;
SAVEREGS:
	PUSH	AX
	PUSH	CX
	PUSH	SI
	PUSH	DS
	;
	; Read the interrupt controller's in-service register to see if an
	; IRQ 0 has in fact occurred.  If not (electrical noise), just restore
	; registers and return.
	;
	MOV	AL,0Bh
	OUT	20h,AL
	JMP	$+2
	IN	AL,20h
	TEST	AL,1
	JNZ	REFRESH
	POP	DS
	POP	SI
	POP	CX
	POP	AX
	IRET
	;
	; Perform RAM refresh.  Read 256 bytes starting at 0000:0000, then
	; 256 bytes starting at 2000:0000.
	;
REFRESH:
	XOR	AX,AX
	MOV	DS,AX
	MOV	SI,AX
	MOV	CX,128
	CLD
	REP	LODSW
	MOV	AX,2000h
	MOV	DS,AX
	XOR	SI,SI
	MOV	CX,128
	REP	LODSW
	;
	; Call the default handler, which will issue EOI.
	;
	POP	DS
	POP	SI
	POP	CX
	POP	AX
	STI
	JMP	DWORD PTR CS:DEFAULT
;
; Installation code.
;
STARTUP:
	;
	; Check if already installed.
	;
	MOV	AX,INSTCHA
	MOV	BX,INSTCHB
	MOV	CX,INSTCHC
	INT	08h
	CMP	AX,SUCCESS
	JNE	INSTALL
	;
	; Already installed.
	;
	MOV	AH,9
	MOV	DX,OFFSET TMSG2
	INT	21h
	MOV	AX,4C00h
	INT	21H
	;
	; Get address of default Int 08h handler, store for TSR.
	;
INSTALL:
	MOV	AX,3508h
	INT	21h
	MOV	WORD PTR DEFAULT,BX
	MOV	WORD PTR DEFAULT+2,ES
	;
	; Set Int 08h vector to point to TSR.
	;
	MOV	AX,2508h
	MOV	DX,OFFSET TSRBEGIN
	INT	21H
	;
	; Inform user.
	;
	MOV	AH,9
	MOV	DX,OFFSET TMSG1
	INT	21H
	;
	; Terminate and stay resident.
	;
	MOV	DX,OFFSET STARTUP
	ADD	DX,15
	MOV	CL,4
	SHR	DX,CL
	MOV	AX,3100h
	INT	21h
MAIN	ENDP
	;
	; Data for transient part.
	;
TMSG1	DB	"RAM refresh code installed.",0Ah,0Dh,"$"
TMSG2	DB	"RAM refresh code already installed.",0Ah,0Dh,"$"
CODE	ENDS
	END	MAIN
