; MODSTUF.INC
;
; Assembler header file for Modstuf.asm.  This is the same stuff as in
; Modstuf.h, only this is for assembler.  Note that every identifer in a
; structure in assembly language must be unique; hence the long names.
;

; MACROS ************************************************************
;

PARTMIXSIZE     EQU     13364   ; size of the partial-mix buffer in bytes
MAXTICKS        EQU     48      ; maximum number of ticks per division


; TYPES *************************************************************
;

;
; Internal sample data structure.
;
SAMPREC         STRUC
SAMPSEG         DW      ?       ; segment address of sample data
SAMPLEN         DW      ?       ; length of sample in words
SAMPLSTART      DW      ?       ; start of sample loop in words
SAMPLLEN        DW      ?       ; length of sample loop in words
SAMPC4SPD       DW      ?       ; playback rate at C4 in Hertz
SAMPVOL         DB      ?       ; default volume for the sample, byte 0-64
SAMPEMSFLAG     DB      ?       ; 1 if sample loaded in EMS
SAMPEMSHANDLE   DW      ?       ; EMS handle if loaded in EMS
                ENDS
;
; Sample data structure in the mod file.  Note that word values here will
; need to have the bytes swapped (they are big-endian).
;
FILSAMREC       STRUC
FILSAMNAME      DB      22 DUP (?)  ; name of sample
FILSAMLEN       DW      ?           ; length of sample in words
FILSAMFINE      DB      ?           ; finetune of sample
FILSAMVOL       DB      ?           ; volume of sample
FILSAMRSTART    DW      ?           ; sample repeat start (word offset)
FILSAMRLEN      DW      ?           ; sample repeat length in words
                ENDS
;
; Channel data structure (76 bytes currently).
;
CHANREC         STRUC
CHANSAMPPTR     DW      ?       ; near pointer to sample structure for
                                ;   current sample
CHANLASTSAMP    DB      ?       ; last output sample on this channel, byte
                                ;   -128 to 127
CHANSAMPDONE    DB      ?       ; sample done flag, 1 if sample is not looped
                                ;   and has been played through; channel may
                                ;   not be ramped down yet
CHANSAMPFRAC    DW      ?       ; fractional part of current byte offset from
                                ;   the start of the current segment in the
                                ;   sample buffer
CHANSAMPOFFS    DW      ?       ; integer part of current byte offset from
                                ;   the start of the current segment in the
                                ;   sample buffer
CHANSAMPSEG     DW      ?       ; current segment in the sample buffer; equal
                                ;   to the segment address of the sample
                                ;   buffer, or 1000h more than the sample
                                ;   segment
CHANSTEPFRAC    DW      ?       ; fractional part of sample step in bytes
CHANSTEPINT     DW      ?       ; integer part of sample step in bytes
CHANPARTOFFS    DW      ?       ; offset of the starting address in the
                                ;   partial-mix buffer for the channel; for
                                ;   channels on the left, this is 0, for
                                ;   channels on the right, 2
CHANPARTSEG     DW      ?       ; segment address of the partial-mix buffer;
                                ;   this is a copy of a global variable put
                                ;   here so we can use the LES instruction
CHANC4SPD       DW      ?       ; playback rate of sample on channel at C4 (Hz)
CHANEFFPERIOD   DW      ?       ; effective period for the channel
CHANEFFTICKPROC DW      ?       ; near pointer to effect tick procedure for
                                ;   the channel
CHANEFFENDPROC  DW      ?       ; near pointer to effect end procedure for
                                ;   the channel
CHANASTEP0FRAC  DW      ?       ; fractional part of arpeggio sample step 0
                                ;   in bytes
CHANASTEP0INT   DW      ?       ; integer part of arpeggio sample step 0 in
                                ;   bytes
CHANASTEP1FRAC  DW      ?       ; fractional part of arpeggio sample step 1
                                ;   in bytes
CHANASTEP1INT   DW      ?       ; integer part of arpeggio sample step 1 in
                                ;   bytes
CHANASTEP2FRAC  DW      ?       ; fractional part of arpeggio sample step 2
                                ;   in bytes
CHANASTEP2INT   DW      ?       ; integer part of arpeggio sample step 2 in
                                ;   bytes
CHANARPCOUNT    DB      ?       ; arpeggio counter, byte 0-2
CHANGLISS       DB      ?       ; glissando flag, 1 if glissando slide enabled
CHANSLIDEINCR   DW      ?       ; signed slide increment (for period slide),
                                ;   -128 to 127, sign-extended to 16 bits
CHANPERIODGOAL  DW      ?       ; period goal for slide to note
CHANVIBWAVE     DW      ?       ; near pointer to vibrato waveform table
CHANTREMWAVE    DW      ?       ; near pointer to tremolo waveform table
CHANVIBDEPTH    DW      ?       ; vibrato depth, 1-15, extended to 16 bits
CHANTREMDEPTH   DW      ?       ; tremolo depth, 1-15, extended to 16 bits
CHANVIBINCR     DW      ?       ; vibrato increment, 1-15, extended to 16 bits
CHANTREMINCR    DW      ?       ; tremolo increment, 1-15, extended to 16 bits
CHANVIBPOS      DW      ?       ; current position in vibrato table, 0-63,
                                ;   extended to 16 bits
CHANTREMPOS     DW      ?       ; current position in tremolo table, 0-63,
                                ;   extended to 16 bits
CHANVIBNORETRG  DB      ?       ; vibrato retrigger flag, 1 if no retrigger
CHANTREMNORETRG DB      ?       ; tremolo retrigger flag, 1 if no retrigger
CHANMAINVOL     DB      ?       ; main volume for the channel, byte 0-64
CHANEFFVOL      DB      ?       ; effective volume for the channel, byte 0-64
CHANMIXVOL      DB      ?       ; mixing volume for the channel, byte 0-64
CHANVOLINCR     DB      ?       ; signed volume increment (for volume slide),
                                ;   -15 to 15, sign-extended to 8 bits
CHANRETRIGSPEED DB      ?       ; retrigger speed, byte 1-15
CHANRETRIGCOUNT DB      ?       ; retrigger count, byte 0-15
CHANCUTCOUNT    DB      ?       ; cut count, byte 0-15
CHANDELAYCOUNT  DB      ?       ; delay count, byte 0-15
CHANSAMPHALF    DB      ?       ; current 64k half of sample, if in EMS
CHANINFOBYTE    DB      ?       ; infobyte for current effect (.s3m)
CHANTREMOROFF   DB      ?       ; count where tremor turns channel off
CHANTREMOREND   DB      ?       ; count where tremor turns channel on again
CHANTREMORCOUNT DB      ?       ; current tremor count
                DB      ?       ; (pad to an even number of bytes)
                ENDS
;
; Internal note data structure.
;
NOTEREC         STRUC
NOTESAMPNUM     DB      ?       ; sample number for note
NOTEVOL         DB      ?       ; volume for note (for .s3m)
NOTEPERIOD      DW      ?       ; period for note (.s3m range)
NOTEEFFPARM     DB      ?       ; parameter for note effect
NOTEEFFNUM      DB      ?       ; major effect number for note
                ENDS
;
; NOTE:  There is no assembly structure for the note data in the mod file.
; It is packed in nibbles.  Deal with it by shifting and masking bits.
;
; 2k buffer segment data structure.  This data is kept on each buffer
; segment so that it can be displayed to the user when the segment is
; played.
;
BUFSEGREC       STRUC
BUFSEGENTRY     DW      ?       ; pattern table entry
BUFSEGPATNUM    DW      ?       ; pattern number
BUFSEGROW       DB      ?       ; row number in pattern
BUFSEGBPM       DB      ?       ; beats per minute
BUFSEGTICKSPER  DW      ?       ; ticks per division
BUFSEGGVOL      DB      ?       ; global volume
                DB      ?       ; (pad to an even number of bytes)
                ENDS


; GLOBAL VARIABLES **************************************************
;

EXTRN   _c4spds:WORD        ; playback rates at C4 for finetunes
EXTRN   _samplerecs:BYTE    ; array of sample data structures
EXTRN   _ninstruments:WORD  ; number of samples in the file
EXTRN   _channelrecs:BYTE   ; array of channel data structures
EXTRN   _patterntable:WORD  ; pattern table
EXTRN   _pattablesize:WORD  ; number of entries in the pattern table
EXTRN   _nfilepatterns:WORD ; number of patterns in the file
EXTRN   _patternsegs:WORD   ; table of segment addresses of pattern buffers
EXTRN   _patbufsize:WORD    ; size of a pattern buffer in paragraphs
EXTRN   _visiteds:BYTE      ; table of visited flags for pattern table entries
EXTRN   _currentpat:WORD    ; current entry in the pattern table
EXTRN   _nextpat:WORD       ; next entry in the pattern table (entry to play at
                            ;   after this division)
EXTRN   _songendjump:WORD   ; song end jump position
EXTRN   _loopdisable:BYTE   ; loop disable flag
EXTRN   _currentpatseg:WORD ; segment address of current pattern buffer
EXTRN   _partmixseg:WORD    ; segment address of the partial-mix buffer
EXTRN   _inpartmix:WORD     ; number of samples in the partial-mix buffer
EXTRN   _samplespertick:WORD ; number of output samples per tick
EXTRN   _setspeedparm:BYTE  ; set speed parameter
EXTRN   _beatspermin:BYTE   ; number of beats per minute
EXTRN   _bpmdefl:BYTE       ; default for number of beats per minute
EXTRN   _ticksperrow:WORD   ; number of ticks per division
EXTRN   _ticksdefl:WORD     ; default for number of ticks per division
EXTRN   _ticksleft:WORD     ; ticks remaining in this division, plus one
EXTRN   _patdelayparm:BYTE  ; pattern delay parameter
EXTRN   _currentrow:BYTE    ; current row in the pattern
EXTRN   _nextrow:BYTE       ; next row in the pattern (row to play at after
                            ; this division)
EXTRN   _patloopstart:BYTE  ; pattern loop start
EXTRN   _patloopcount:BYTE  ; pattern loop count
EXTRN   _nchannels:WORD     ; number of channels
EXTRN   _bytesperrow:BYTE   ; bytes per row in the pattern table
EXTRN   _bufsegrecs:BYTE    ; array of 2k buffer segment data records
EXTRN   _globalvol:BYTE     ; global volume, 0-64
EXTRN   _globalvoldefl:BYTE ; default for global volume
EXTRN   _savemem:BYTE       ; "save memory" flag
EXTRN   _optimize:BYTE      ; "optimize loading" flag


; EXTERNAL SUBROUTINES **********************************************
;

EXTRN   _initmodstuf:NEAR   ; initialization routine for the player module
EXTRN   BYTE2HEX:NEAR       ; routine to convert a byte to 2 hex digits
EXTRN   SAMPSTRING:NEAR     ; routine to convert sample number to ASCII
EXTRN   EFFSTRING:NEAR      ; routine to convert effect and parameter to ASCII
EXTRN   PERIODSTRING:NEAR   ; routine to convert period to ASCII note
EXTRN   VOLUMESTRING:NEAR   ; routine to convert volume to ASCII
EXTRN   FIL2MEMNOTES:NEAR   ; routine to convert notes to internal format
EXTRN   NOTE2PERIOD:NEAR    ; routine to convert .s3m note to period
EXTRN   SETBEATS:NEAR       ; routine to set the number of beats per minute
EXTRN   _dumpmod:NEAR       ; information dump routine
EXTRN   _dumpsample:NEAR    ; routine to dump a sample to a file
EXTRN   _unloadfile:NEAR    ; routine to unload the currently-loaded file
EXTRN   _getsamples:NEAR    ; routine to get 2k worth of samples
EXTRN   _loadfile:NEAR      ; main file loader routine