#include	<stdio.h>
#include	<string.h>
#include	<sys/time.h>

#ifdef		DOS
#include	<tcp.h>
#else
#include	<netinet/in.h>
#endif

#include	"smbhdr.h"
#include	"smbpd.h"
#include	"netio.h"
#include	"nameserv.h"
#include	"util.h"

extern unsigned long	my_ip_addr;

static unsigned char 	nsbuf[576];

/* swap n shorts */
static void htonss(unsigned short *s, int n)
{
	int		i;

	for (i = n; i > 0; --i, ++s)
		*s = htons(*s);
}

static void send_ns(unsigned long toaddr, struct dnsheader *dh,
	unsigned char *q, struct qdtail *qd, struct rrtail *rr,
	unsigned char *r, int rlen)
{
	int			len, qlen;
	unsigned short		nameptr;

	dh->flags |= (1 << 15);			/* mark as reply */
	htonss(&dh->id, 6);
	memcpy(nsbuf, dh, sizeof(*dh));
	len = sizeof(*dh);

	if (q == 0)
	{
		q = &nsbuf[sizeof(*dh)];
		qlen = nb_name_len(q);
	}
	else
	{
		qlen = nb_name_len(q);
		memcpy(&nsbuf[sizeof(*dh)], q, qlen);
	}
	len += qlen;

	if (qd != 0)
	{
		htonss(&qd->qdtype, 2);
		memcpy(&nsbuf[len], qd, sizeof(*qd));
		len += sizeof(*qd);

		nameptr = htons(0xC000 | sizeof(*dh));	/* -> query name */
		memcpy(&nsbuf[len], &nameptr, sizeof(nameptr));
		len += sizeof(nameptr);
	}
	else
	{
		htonss(&rr->rrtype, 2);
		rr->ttl = htonl(rr->ttl);
		rr->rdlength = htons(rr->rdlength);
		memcpy(&nsbuf[len], rr, RR_SIZE);
		len += RR_SIZE;
	}

	memcpy(&nsbuf[len], r, rlen);
	len += rlen;

	(void)write_ns(nsbuf, len, toaddr);
}

#if	0
static void register_name(void)
{
	struct dnsheader	dh;
	unsigned char		nbname[34];
	struct qdtail		qd;
	struct rrtail		rr;
	unsigned long		ip;

	dh.id = 0;
	dh.flags = (op_reg << 11) | (FLAG_B << 4);
	dh.qdcount = 1;
	dh.ancount = 0;
	dh.nscount = 0;
	dh.adcount = 1;
	(void)asctonb(my_host_name, nbname);
	qd.qdtype = QT_NB;
	qd.qdclass = QC_IN;
	rr.rrtype = RT_NB;
	rr.rrclass = RC_IN;
	rr.ttl = 3600;			/* one hour */
	rr.rdlength = 4;
	ip = my_ip_addr_n;
	printf("%s: Broadcasting registration %s = %s\n",
		ptime(), my_host_name, Inet_ntoa(my_ip_addr));
	send_ns(INADDR_BROADCAST, &dh, nbname, &qd, &rr,
		(unsigned char *)&ip, sizeof(ip));
}
#endif

void init_ns(void)
{
#if	0
	register_name();
#endif
}

static void do_query(unsigned long fromaddr)
{
	struct dnsheader	*dh;
	struct rrtail		rr;
	unsigned short		flags;
	unsigned char		*nbp;
	char			qname[17];
	int			qnamelen, mynamelen, qlen;
	char			*p;
	struct addr_entry	ae;

	dh = (struct dnsheader *)nsbuf;
	flags = (dh->flags >> 4) & 0x7F;
	if (!(flags & FLAG_B))		/* ignore non-broadcasts */
		return;
	nbp = &nsbuf[sizeof(struct dnsheader)];
	if ((qlen = nbtoasc(nbp, qname)) == 0)
		return;
	qname[16] = '\0';
	trim_space(qname);
	qnamelen = strlen(qname);
	if ((p = strchr(my_host_name, '.')) == 0)
		mynamelen = strlen(my_host_name);
	else
		mynamelen = p - my_host_name;
	if (strncasecmp(qname, my_host_name, mynamelen) != 0)
		return;
	/* it's for me, should check rest of query (qdtype, qdclass) here */
	printf("%s Query about %s from %s\n",
		ptime(), qname, Inet_ntoa(fromaddr));
	dh->flags = (op_query << 11) | (FLAG_AA << 4);
	dh->qdcount = 0;
	dh->ancount = 1;
	dh->nscount = 0;
	dh->adcount = 0;
	rr.rrtype = RT_NB;
	rr.rrclass = RC_IN;
	rr.ttl = 3600;			/* one hour */
	rr.rdlength = ADDR_ENTRY_LEN;
	ae.nb_flags = htons(NBF_BNODE);
	ae.nb_address = my_ip_addr_n;
	send_ns(fromaddr, dh, 0, 0, &rr,
		(unsigned char *)&ae.nb_flags, ADDR_ENTRY_LEN);
}

void ns_request(void)
{
	int			len;
	unsigned long		fromaddr;
	struct dnsheader	*dh;

	len = read_ns(nsbuf, sizeof(nsbuf), &fromaddr);
	if (len < sizeof(struct dnsheader))		/* truncated packet! */
		return;
	dh = (struct dnsheader *)nsbuf;
	htonss(&dh->id, 6);
	switch (dh->flags >> 11)
	{
	case op_query:
		do_query(fromaddr);
		break;
	case op_reg:
	case op_release:
	case op_wack:
	case op_refresh:
		break;
	}
}
