using System;
using System.Text;
using System.Web;

namespace ComputerBuff.Controls.XPanel
{
	/// <summary>
	///		Generates run-time script for the menu.
	/// </summary>
	public class Script
	{
		/// <summary>
		///		Returns the JavaScript for the control to use at runtime.
		/// </summary>
		/// <param name="id">XPanel control ID</param>
		/// <returns>string - JavaScript source</returns>
		public static string GetRuntimeScript(string id)
		{
			HttpBrowserCapabilities  bc = HttpContext.Current.Request.Browser;
			StringBuilder scriptText = new StringBuilder();

			scriptText.Append("\n<script language='JavaScript'>\n");
			scriptText.Append("\n<!--\n");
			scriptText.Append("\tvar arrowDown = new Image();\n");
			scriptText.Append("\tvar arrowUp = new Image();\n");
			scriptText.Append("\tvar divGroupName = \"\";\r\n");

			scriptText.Append("var openDisplay = \"inline\";\r\n");

			scriptText.Append("var closedDisplay = \"none\";\r\n");
			
			scriptText.Append("function expandit(itemId, hideImage, showImage, groupName)\r\n");
			scriptText.Append("{\r\n");
			scriptText.Append("window.setTimeout(\"toggleSection('\" + itemId + \"', '\" + groupName + \"')\", 10);\r\n");
			scriptText.Append("arrowDown.src = hideImage;\r\n");
			scriptText.Append("arrowUp.src = showImage;\r\n");
			scriptText.Append("}\r\n");

			scriptText.Append("function toggleSection(itemId, groupName) {\r\n");
			scriptText.Append("var arrowId = itemId.substring(0, itemId.indexOf(\";\")).replace(\"SectionPanel\", \"ArrowImage\");\r\n//itemId.replace(\"SectionPanel\", \"ArrowImage\");\r\n");
			scriptText.Append("var arrow, item;\r\n");
        	
			scriptText.Append("if (document.all) {\r\n");
			scriptText.Append("item = document.all[itemId];\r\n");
			scriptText.Append("arrow = document.all[arrowId];\r\n");
			scriptText.Append("}\r\n");
        	
			scriptText.Append("if (!document.all && document.getElementById) {\r\n");
			scriptText.Append("item = document.getElementById(itemId);\r\n");
			scriptText.Append("arrow = document.getElementById(arrowId);\r\n");
			scriptText.Append("}\r\n");
        		
			scriptText.Append("if (item.style.display == closedDisplay) {\r\n");
			scriptText.Append("if (groupName != '')\r\n");
			scriptText.Append("{\r\n");
			scriptText.Append("var divs = document.getElementsByTagName('table');\r\n");			
			scriptText.Append("for (var i=0; i < divs.length; i++ )\r\n");
			scriptText.Append("{\r\n");
			scriptText.Append("divGroupName = divs[i].id.substring(divs[i].id.indexOf(\";\") + 1, divs[i].id.lastIndexOf(\";\"));\r\n");
			scriptText.Append("if (divs[i].id.indexOf(\"SectionPanel\") > -1 && divGroupName == groupName)\r\n");
			scriptText.Append("{\r\n");
			scriptText.Append("divs[i].style.display = closedDisplay;\r\n");
			scriptText.Append("var arrowname = divs[i].id.substring(0, itemId.indexOf(\";\")).replace(\"SectionPanel\", \"ArrowImage\");\r\n");
			scriptText.Append("arrow1 = document.getElementById(arrowname);\r\n");
			scriptText.Append("arrow1.src = itemId.substring(itemId.lastIndexOf(\";\") + 1);\r\n");
			scriptText.Append("}\r\n");
			scriptText.Append("divGroupName = \"\";\r\n");
			scriptText.Append("}\r\n");
			scriptText.Append("}\r\n");
			scriptText.Append("arrow.src = arrowDown.src;\r\n");
			scriptText.Append("item.style.display = openDisplay;\r\n");
			scriptText.Append("}\r\n");
			scriptText.Append("else {\r\n");
			scriptText.Append("arrow.src = arrowUp.src;\r\n");
			scriptText.Append("item.style.display = closedDisplay;\r\n");
			scriptText.Append("}\r\n");
			scriptText.Append("}\r\n");
			scriptText.Append("\n-->");
			scriptText.Append("</script>");

			return scriptText.ToString();
		}
	}
}
