#!/usr/bin/perl

###############################################################################
#
# _AFVwMsgBatch.cgi - Get data for the forum
#
# AUTHOR:	Shawn Stepper, wiTHinc Inc.
# AUTHOR:	George Toye, wiTHinc Inc.
# DATE:		$Date: 2001/08/21 17:50:53 $ (last modified)
# COPYRIGHT:	1998, 1999, 2000, 2001 wiTHinc Inc. All Rights Reserved.
#
###############################################################################

$FileRevision = '$Id: _AFVwMsgBatch.cgi,v 1.25.2.2 2001/08/21 17:50:53 stepper Exp $';
$Version = '1.4.0';

if (@ARGV[0] eq "-v" || @ARGV[0] eq "--version") {
	print "File:		$0\n";
	print "Revision:	$FileRevision\n";
	print "Version:	$Version\n";
	exit();
}

require "F_Init.pl";

###############################################################################
#
# Process submitted data

$Class = $CGIQuery->param('fid');
$start = $CGIQuery->param('start');
$getnum = $CGIQuery->param('getnum');
$func = $CGIQuery->param('func');
$csection = $CGIQuery->param('section');

if ($Class eq "") {
	&showErrorHTML("$CorF not specified");
	exit();
}
	
&lookupClass;
	
&lookupUser($CGIEnvUser);

&loadColors($ColorQueryString);

&checkCookieGuest($CGIEnvUser, $C_authtype);

# Kick the user out if they have the wrong permissions
if (!&IS_ADMIN($U_Perms) && !&IS_FAC($U_Perms)) {
	&showErrorBackHTML("You do not have permission to access this resource.");
	exit();
}


if ($func eq "menu") {
	$BodyTag = &makeBodyTag("Threads");
} else {
	$BodyTag = &makeBodyTag("Content");
}

if ($csection ne "ALL") {
	($junk, $sectnum) = split(/\:/, $csection);
	$sectname = $C_Sects{$sectnum}{"name"};
} else {
	$sectname = "ALL";
}

# Get the ID of the next post.
$nf = $C_rootpath . "/Forum/.nextid";
open(n, $nf);
@n = <n>;
close(n);
$nextid = @n[0];

if ($func eq "gather") {
	
	################################
	# Print Message Content
	################################
	
	if ($start < 0) { $start = 0; }
	if ($start >= $nextid) { $start = $nextid; }
	
	$end = $start + $getnum - 1;
	if ($end > $nextid) { $end = $nextid; }

	if ($CGIQuery->param('mode') eq "all") {
		$start = 0;
		$end = $nextid;
	}
	
	# get a list of all subjects
	@subjects = &lookupSubjList;
	
	# Find all of the database files
	for ($m=$start; $m <= $end; $m++) {
		$dbf = "";
		$Subject = "";
		for ($n=0; $n < @subjects; $n++) {
			$tsubject = @subjects[$n];
			$tdbf = $C_rootpath . "/" . $DIR_CLASSFORUM . "/" . $tsubject . "/" . $m . ".db";
			if (-e $tdbf) {
				$dbf = $tdbf;
				push(@dbf, $dbf);
				push(@id, $m);
				push(@psub, $tsubject);
				# $Subject = $tsubject;
			}
		}
	}
	
	# Print out a header
	if ($CGIQuery->param('mode') eq "all") {
		$helplink = "file=ForumBatchMessagesCORP_Admin.html";
		$helplink .= "&anchor=BatchMessageOp2EdtFSummary";
		$helplink .= "&helptitle=Retrieving%20Messages%20by%20Date";
	
		&showHeaderBackHTML("All Messages for $sorg $sectname",
			"<br>", 0, 0, 0, $helplink);
	} else {
		$helplink = "file=ForumBatchMessagesCORP_Admin.html";
		$helplink .= "&anchor=BatchMessageOp1EdtFSummary";
		$helplink .= "&helptitle=Retrieving%20Message%20Threads";
	
		&showHeaderBackHTML("All threads for ID $start through ID $end for $sorg $sectname", "<br>", 0, 0, 0, $helplink);
	}
	
	if (@dbf == 0) {
		print "No messages found in the selected range.";
		exit();
	}

	if ($CGIQuery->param('mode') eq "all") {
		&printbydate;
		exit();
	}
	
	$printed = 0;
	for ($m = 0; $m < @dbf; $m++) {
		$dbf = @dbf[$m];
		$id = @id[$m];
	
		# Read from message db
		$dbfile = $dbf;

		$skipthread = 0;

		foreach (`$prtDB $dbfile -tbtree -a -q`) {
			($DB_Key, $ImgIndents, $title, $CGIEnvUser, $Perms, $posttime, $comment, $fullname, $U_Photo, $U_Email, $attachment, @junk) = split(/\t/, &UnEscape($_));
			
			$status = &dbErrorCheck($?, $DB_Key);
			if ($status) {
				&showErrorBackHTML("$status<p>Unable to read from $dbfile.");
				exit();
			}
			
			$MsgID = $DB_Key;
			
			if ($MsgID !~ /\./ && $csection ne "ALL") {
				&lookupUser($CGIEnvUser);
				if ($U_C_Sect =~ /\:/) {
					($junk, $U_sectnum) = split(/\:/, $U_C_Sect);
				} else {
					$U_sectnum = $U_C_Sect;
				}
				if ($U_sectnum ne $sectnum) {
					$skipthread = 1;
				}
			}
			
			if (! $skipthread) {
				if ($MsgID !~ /\./) {		
					&printthreadhead($title, $id, @psub[$m]);
				}
				
				$printed = 1;
			
				&procUserPhoto;
			
				$U_Photo = "<img src=" . $U_Photo . " border=0>";
			
				$itsnew = 0;

				$posttime = &formatDate($posttime);
			
				# Format comment for nice outputting
				$comment =~ s/\r/<br>\r/g;
			
				# Make multiple spaces look like multiple spaces in html
				$comment =~ s/  /\&nbsp\;\&nbsp\;/g;

				@comment = split(/\n/, $comment);
				
				# Put in breaks where they belong for quoted text.
				for ($i=0; $i < @comment; $i++) {
					if (@comment[$i] =~ /^>+/) {
					
						# Replace > with &gt;
						$numbrack = length($&);
						for ($k=0; $k < $numbrack; $k++) {
							@comment[$i] =~ s/>/\&gt\;/;
						}
					} 
				}

				print "<a name=" . $MsgID . ">\n";

				# Print out the table with the post in it.
				
				print "<table border=0 width=100% cellpadding=0>\n";
				print "<tr><td rowspan=2 valign=top>";
				print $FontFace, $FontSize;
			
				# A table for putting a border around the photo
				print "<table cellpadding=0 cellspacing=0 border=0 width=20>\n";
				print "<tr>\n";
			
				if (&IS_FAC($Perms)) {
					$U_Photoborder = "<td valign=middle align=center bgcolor=$Ffacultyhilight height=25 width=20>";
				} else {
					$U_Photoborder = "<td valign=middle align=center bgcolor=$Fstudenthilight height=25 width=20>";
				}
			
				if ($U_Photo eq "") {
					if ($CGIEnvUser eq "Anonymous") {
						$U_Photo = $anonphoto;
					} else {
						$U_Photo = $guestphoto;
					} 
				}
			
				print "$U_Photoborder", "$U_Photo";
				print "</td></tr></table>";
				print "</td>\n";
			
				print "<td rowspan=2 valign=top>";
				for ($k=0; $k < $ImgIndents; $k++) {
					print $ImgIndent, $ImgIndent;
				}
			
				# This makes the new icon display properly
				print $ImgIndent;
			
				if ($itsnew) {
					print "$IcoNew</td>";
				} else {
					print "<img src=images/cleardot.gif width=9 height=9></td>";
				}
				
				print "<td width=100\%";	

				print ">";
				print $FontFace, $FontSize2;
			
				print "<b>$title</b></font>";

				print $FontFace, $FontSize;
				if ($U_Email ne "") {
					$link = "http://" . $ENV{'SERVER_NAME'} . $C_rooturl . "/$DIR_CLASSFORUM/";
					$link .= "?fid=$Class%26tid=$Subject%26mid=$MsgID";
					print "<a href=\"mailto:$U_Email?tid=$title&body=$link\">";
				}
				print $ImgIndent;
				print "<i>$CGIEnvUser";
				if ($U_Email ne "") {
					print "</a>";
				}
			
				print $ImgIndent;

				print "<font color=$FCdate>";
			
				print "$posttime</b></i> ";
				
				print "</td></tr>\n";

				print "<tr>";
			
				print "<td width=100\%";	
			
				$comment = join("", @comment);
				print ">", $FontFace, $FontSize, "\n", $comment, "</td></tr>\n";
				print "</table>\n\n";

			}
		}
	}
	
	if (! $printed) {
		print "No messages found in the selected range.";
	}
	
	print "</body></html>\n";

##########################################################	
	
} elsif ($func eq "nothing" ) {

	&printEmptyTaskFrame("Choose the messages to retrieve in the frame above.");
	
} elsif ($func eq "menu") {
	$helplink = "file=ForumBatchMessagesCORP_Admin.html";
	$helplink .= "&anchor=BatchMessageTskFSummary";
	$helplink .= "&helptitle=Retrieving%20Messages%20in%20Batch%20Blocks";
	
	&showHeaderBackHTML("Get Multiple Threads for $CorF - $Class",
		"", 0, 1, 0, $helplink);

	# Print the form to choose the threads
	# Start Form
	print "<form action=$CGIEnvScript method=POST target=batchget>\n";
	print "<input type=hidden name=fid value=\"$Class\">\n\n";
	print "<input type=hidden name=func value=gather>\n\n";

	# Table start
	print "<table cellpadding=0 cellspacing=0 border=0>\n";
	print "<tr><td rowspan=15>$ImgClear88</td>\n";
	
	# Header
	print "<td colspan=5>", $FontFace, $FontSize2;
	print "<b>Retrieve Selected Message Threads by $SorG</b></td></tr>\n";
	
	# Divider
	print "<tr><td bgcolor=$FTheaderback colspan=5 height=1>";
	print "<img src=", $ImgSrcClearDot, " width=20 height=1>";
	print "</td></tr>\n";
	
	# Spacer
	print "<tr><td bgcolor=$FTheaderback width=1 height=4>";
	print "<img src=", $ImgSrcClearDot, " width=1 height=4></td>\n";
	print "<td colspan=3 height=4>";
	print "<img src=", $ImgSrcClearDot, " width=4 height=4>";
	print "</td>\n";
	print "<td bgcolor=$FTheaderback width=1 height=4>";
	print "<img src=", $ImgSrcClearDot, " width=1 height=4>";
	print "</td></tr>\n";

	# Print form
	print "<tr><td bgcolor=$FTheaderback width=1>";
	print "<img src=", $ImgSrcClearDot, " width=1 height=4></td>\n";
	print "<td valign=middle align=left colspan=3 nowrap>";
	print $FontFace, $FontSize, $ImgClear88;
	print "Get ";
	print "<select name=getnum>";
	print "<option value=1> 1\n";
	print "<option value=5> 5\n";
	print "<option value=10 selected> 10\n";
	print "<option value=25> 25\n";
	print "<option value=50> 50\n";
	print "<option value=100> 100\n";
	print "<option value=500> 500\n";
	print "<option value=1000> 1000\n";
	print "<option value=", $nextid, "> ALL\n";
	print "</select>";
	print " threads, starting at number: ";
	print "<input type=text name=start size=5 maxlength=8 value=0>\n";
	
	print ", started by users from $sorg: ";
	
	print "\n<select name=section>\n";
	print "<option value=\"ALL\"> All $SorGs\n";
	for ($i=1; $i <= $C_Sect_n; $i++) {
		print "<option value=$Class",":", $C_Sects{$i}{"num"};
		print "> ", $C_Sects{$i}{"name"}, "\n";
	}
	print "</select>\n";
	print "&nbsp;&nbsp;</td>\n";
	
	print "<td bgcolor=$FTheaderback width=1>";
	print "<img src=", $ImgSrcClearDot, " width=1 height=4>\n";
	print "</td></tr>\n";
	
	# Spacer
	print "<tr><td bgcolor=$FTheaderback width=1>";
	print "<img src=", $ImgSrcClearDot, " width=1 height=4></td>\n";
	print "<td colspan=3><img src=", $ImgSrcClearDot, " width=4 height=4>";
	print "</td>\n";
	print "<td bgcolor=$FTheaderback width=1>";
	print "<img src=", $ImgSrcClearDot, " width=1 height=4>";
	print "</td></tr>\n";
	
	# submit
	print "<tr><td bgcolor=$FTheaderback width=1>";
	print "<img src=", $ImgSrcClearDot, " width=1 height=4></td>\n";
	print "<td valign=middle align=right colspan=3>", $FontFace, $FontSize;
	$numthreads = $nextid + 1;
	print "There are $numthreads threads, starting at ID 0.";
	print "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\n";
	print "$BtnFormSubmit";
	print "&nbsp;&nbsp;</td>\n";
	print "<td bgcolor=$FTheaderback width=1>";
	print "<img src=", $ImgSrcClearDot, " width=1 height=4></td>\n";
	print "</td></tr>\n";
	
	print "</form>\n\n";
	
	# Spacer
	print "<tr><td bgcolor=$FTheaderback width=1>";
	print "<img src=", $ImgSrcClearDot, " width=1 height=4></td>\n";
	print "<td colspan=3><img src=", $ImgSrcClearDot, " width=4 height=4>";
	print "</td>\n";
	print "<td bgcolor=$FTheaderback width=1>";
	print "<img src=", $ImgSrcClearDot, " width=1 height=4>";
	print "</td></tr>\n";
	
	# Divider
	print "<tr><td bgcolor=$FTheaderback colspan=5 height=1>";
	print "<img src=", $ImgSrcClearDot, " width=20 height=1>";
	print "</td></tr>\n";
	
	# Spacer
	print "<tr><td colspan=5 height=10>";
	print "<img src=", $ImgSrcClearDot, " width=20 height=10>";
	print "</td></tr>\n";
	
	print "<form action=$CGIEnvScript method=POST target=batchget>\n";
	print "<input type=hidden name=fid value=\"$Class\">\n";
	print "<input type=hidden name=func value=gather>\n";
	print "<input type=hidden name=mode value=all>\n\n";
	
	# Header
	print "<tr><td colspan=3>", $FontFace, $FontSize2;
	print "<b>Retrieve All Messages by Date</b></td>\n";
	print "<td>";
	print "<img src=", $ImgSrcClearDot, " width=100 height=2>";
	print "<td width=1>";
	print "<img src=", $ImgSrcClearDot, " width=1 height=2>";
	print "</td></tr>\n";
	
	# Divider
	print "<tr><td bgcolor=$FTheaderback colspan=3 height=1>";
	print "<img src=", $ImgSrcClearDot, " width=20 height=1>";
	print "<td colspan=2 height=1>";
	print "<img src=", $ImgSrcClearDot, " width=2 height=1>";
	print "</td></tr>\n";
	
	# Spacer
	print "<tr><td bgcolor=$FTheaderback width=1>";
	print "<img src=", $ImgSrcClearDot, " width=1 height=4></td>\n";
	print "<td><img src=", $ImgSrcClearDot, " width=4 height=4>";
	print "</td>\n";
	print "<td bgcolor=$FTheaderback width=1>";
	print "<img src=", $ImgSrcClearDot, " width=1 height=4></td>\n";
	print "<td colspan=2><img src=", $ImgSrcClearDot, " width=4 height=4>";
	print "</td></tr>\n";
	
	print "<tr><td bgcolor=$FTheaderback width=1>";
	print "<img src=", $ImgSrcClearDot, " width=1 height=4></td>\n";
	print "<td valign=middle align=left>";
	print $FontFace, $FontSize, $ImgClear88;
	print "Retrieve messages posted by $sorg ";
	print "\n<select name=section>\n";
	print "<option value=\"ALL\"> All $SorGs\n";
	for ($i=1; $i <= $C_Sect_n; $i++) {
		print "<option value=$Class",":", $C_Sects{$i}{"num"};
		print "> ", $C_Sects{$i}{"name"}, "\n";
	}
	print "</select>\n";
	print $BtnFormSubmit, "&nbsp;&nbsp;";
	print "</td>\n";
	print "<td bgcolor=$FTheaderback width=1>";
	print "<img src=", $ImgSrcClearDot, " width=1 height=4></td>\n";
	print "<td colspan=2><img src=", $ImgSrcClearDot, " width=4 height=4>";
	print "</td></tr>\n";

	# Spacer
	print "<tr><td bgcolor=$FTheaderback width=1>";
	print "<img src=", $ImgSrcClearDot, " width=1 height=4></td>\n";
	print "<td><img src=", $ImgSrcClearDot, " width=4 height=4>";
	print "</td>\n";
	print "<td bgcolor=$FTheaderback width=1>";
	print "<img src=", $ImgSrcClearDot, " width=1 height=4></td>\n";
	print "<td colspan=2><img src=", $ImgSrcClearDot, " width=4 height=4>";
	print "</td></tr>\n";
	
	# Divider
	print "<tr><td bgcolor=$FTheaderback colspan=3 height=1>";
	print "<img src=", $ImgSrcClearDot, " width=20 height=1>";
	print "<td colspan=2 height=1>";
	print "<img src=", $ImgSrcClearDot, " width=2 height=1>";
	print "</td></tr>\n";

	print "</table>\n";
	print "</form>\n";
} else {

	# Print out frameset
	# print $CGIQuery->header(-expires=>'-1d');
	print $CGIQuery->header;
	print "<html><head><title>$Class Forum Batch Content Gathering</title>\n";
	&printJavascript;
	print "</head>\n";
	print "<frameset rows='200,*' border=2>\n";
	print "	<frame name=batchmenu src=$CGIEnvScript?fid=$Class&func=menu ";
	print "frameborder=1 marginheight=0 marginwidth=0>\n";
	print "	<frame name=batchget src=$CGIEnvScript?fid=$Class&func=nothing ";
	print "frameborder=1 marginheight=0 marginwidth=0>\n";
	print "</frameset>\n";
}

#
########

sub printthreadhead {
	local($title, $tid, $psub) = @_;

	# Print header bar
	print "<table cellpadding=0 cellspacing=0 border=0 width=100%>\n";
	print "<tr><td valign=middle bgcolor=$FCheaderback>";
	print "<img src=images/cleardot.gif width=5 height=12 align=middle>";
	print $FontFace, $FontSize2;
	print "<font color=$FCheadertext><b>";
		
	print "Messages in Thread: $title &nbsp;</b>(ThreadID = $tid, Topic = ";
	print &printPretty($psub);
	print ")";

	print "</font></td></tr>\n";
	print "</table>\n\n";
}

sub printbydate {

	$printed = 0;
	for ($m = 0; $m < @dbf; $m++) {
		$dbf = @dbf[$m];
		$id = @id[$m];
	
		# Read from message db
		$dbfile = $dbf;
			
		foreach (`$prtDB $dbfile -tbtree -a -q`) {
			($DB_Key2, $ImgIndents, $title, $User, $U_Perms, $posttime, $comment, $fullname, $U_Photo, $U_Email, $attachment) = split(/\t/, &UnEscape($_));
			chomp($attachment);
			
			$status = &dbErrorCheck($?, $DB_Key2);
			if ($status) {
				&showErrorBackHTML("$status<p>Unable to read from $dbfile.");
				exit();
			}
			
			$value2 = join("\t", $ImgIndents, $title, $User, $U_Perms, $posttime, $comment, $fullname, $U_Photo, $U_Email, $attachment);
		
			$MsgID = $DB_Key2;
			
			if ($allval{"$posttime"}{"key"} ne "") {
				$posttime++;
			}
			
			if ($csection ne "ALL") {
				&lookupUser($User);
			}
			
			if ($csection eq "ALL" || ($csection eq $U_C_Sect)) {
				push(@alldates, $posttime);
				$allval{"$posttime"}{"key"} = $DB_Key2;
				$allval{"$posttime"}{"value"} = $value2;
				$allval{"$posttime"}{"subject"} = @psub[$m];
			}
		}
	}
	
	@alldates = sort(@alldates);
	
	for ($m=0; $m < @alldates; $m++) {
		$id = $allval{"@alldates[$m]"}{"key"};
		$Subject = $allval{"@alldates[$m]"}{"subject"};
	
		($ImgIndents, $title, $User, $U_Perms, $posttime, $comment, $fullname, $U_Photo, $U_Email, $attachment, @junk) = split(/\t/, $allval{"@alldates[$m]"}{"value"});
		
		&procUserPhoto;
		
		$printed = 1;

		# Print header bar
		print "<table cellpadding=0 cellspacing=0 border=0 width=100%>\n";
		print "<tr><td valign=middle bgcolor=$FCheaderback>";
		print "<img src=images/cleardot.gif width=5 height=12 align=middle>";
		print $FontFace, $FontSize2;
		print "<font color=$FCheadertext><b>";
			
		print "Title = $title : Topic = ";
		print &printPretty($Subject);
		print " : Time = $posttime : MessageID = $id ";
		

		print "</b></font></td></tr>\n";
		print "</table>\n\n";
		
		$U_Photo = "<img src=" . $U_Photo . " border=0>";

		$posttime = &formatDate($posttime);
			
		# Format comment for nice outputting
		$comment =~ s/\r/<br>\r/g;
			
		# Make multiple spaces look like multiple spaces in html
		$comment =~ s/  /\&nbsp\;\&nbsp\;/g;

		@comment = split(/\n/, $comment);
				
		# Put in breaks where they belong for quoted text.
		for ($i=0; $i < @comment; $i++) {
			if (@comment[$i] =~ /^>+/) {
					
				# Replace > with &gt;
				$numbrack = length($&);
				for ($k=0; $k < $numbrack; $k++) {
					@comment[$i] =~ s/>/\&gt\;/;
				}
			} 
		}

		print "<a name=" . $MsgID . ">\n";

		# Print out the table with the post in it.
				
		print "<table border=0 width=100% cellpadding=0>\n";
		print "<tr><td rowspan=2 valign=top>";
		print $FontFace, $FontSize;
			
		# A table for putting a border around the photo
		print "<table cellpadding=0 cellspacing=0 border=0 width=20>\n";
		print "<tr>\n";
			
		if (&IS_FAC($U_Perms)) {
			$U_Photoborder = "<td valign=middle align=center bgcolor=$Ffacultyhilight height=25 width=20>";
		} else {
			$U_Photoborder = "<td valign=middle align=center bgcolor=$Fstudenthilight height=25 width=20>";
		}
			
		if ($U_Photo eq "") {
			if ($CGIEnvUser eq "Anonymous") {
				$U_Photo = $anonphoto;
			} else {
				$U_Photo = $guestphoto;
			} 
		}
			
		print "$U_Photoborder", "$U_Photo";
		print "</td></tr></table>";
		print "</td>\n";
			
		print "<td rowspan=2 valign=top>";
		for ($k=0; $k < $ImgIndents; $k++) {
			print $ImgIndent, $ImgIndent;
		}
			
		# This makes the new icon display properly
		print $ImgIndent;
		print "<img src=images/cleardot.gif width=9 height=9></td>";
				
		print "<td width=100\%";	
		print " background=$ImgSrcTableBg";

		print ">";
		print $FontFace, $FontSize2;
			
		print "<b>$title</b></font>";

		print $FontSize;
		if ($U_Email ne "") {
			$link = "http://" . $ENV{'SERVER_NAME'} . $C_rooturl . "/$DIR_CLASSFORUM/";
			$link .= "?fid=$Class%26tid=$Subject%26mid=$MsgID";
			print "<a href=\"mailto:$U_Email?tid=$title&body=$link\">";
		}
		print $ImgIndent;
		print "<i>$User</i>";
		if ($U_Email ne "") {
			print "</a>";
		}
			
		print $ImgIndent;

		print "<font color=$FCdate>";
			
		print "<i><b>$posttime</b></i> ";
				
		print "</td></tr>\n";

		print "<tr>";
			
		print "<td width=100\%";	
			
		$comment = join("", @comment);
		print ">", $FontFace, $FontSize, "\n", $comment, "</td></tr>\n";
		print "</table>\n\n";
	}
	
	if (! $printed) {
		print "No messages found in the selected range.";
	}
	
	print "</body></html>\n";
}
