// =================================================================
//
//  Copyright (C) 2003 Alex Vinokur
//
//  For conditions of distribution and use, see
//  copyright notice in common.h
//
// =================================================================


// #################################################################
//
//  SOFTWARE : C++ Stream-Compatible TCP/IP Sockets Demo Application
//  FILE     : partner.h
//
//  DESCRIPTION :
//         Partner related class definition
//
// #################################################################


//////////////////////////
#ifndef INCLUDED_PARTNER_H
#define INCLUDED_PARTNER_H
//////////////////////////

// =================
#include "packet2.h"
// =================


#define CLIENT_NAME	"client"
#define SERVER_NAME	"server"


#define END_OF_SESSION_ID	ULONG_MAX

// ---------------------------

// ---------------------------
// ----------------------------
class BasicPartner;


// ----------------------------
class BasicCallAction
{
  public :
    virtual bool call_send_templated_packet(
		BasicPartner* const	ptr_partner_io,
		const BasicDataType*&	ptr_packet_i
		) = 0;
    virtual bool call_recv_templated_packet(
		BasicPartner* const	ptr_partner_io,
		ulong			request_id_i,
		const string&		packet_typename_i, 
		size_t			packet_size_i,
		BasicDataType*&		ptr_recv_packet_o
		) = 0;

    BasicCallAction ();
    virtual ~BasicCallAction ();
};


// ----------------------------
template <typename T>
class TemplateCallAction : public BasicCallAction
{
  public :
    bool call_send_templated_packet(
		BasicPartner* const	ptr_partner_io,
		const BasicDataType*&	ptr_packet_i
		);
    bool call_recv_templated_packet (
		BasicPartner* const	ptr_partner_io,
		ulong			request_id_i,
		const string&		packet_typename_i, 
		size_t			packet_size_i,
		BasicDataType*&		ptr_recv_packet_o
		);
    TemplateCallAction ();
    ~TemplateCallAction ();
};



// ---------------------------
// ---------------------------
class BasicPartner
{
friend class ApplicationInit;
friend class ApplicationRun;

  private :
    static map<string, BasicCallAction*>	call_action_s;
    const map<string, BasicCallAction*>		call_action_;

  protected :
    const string	partner_name_;
    bool		pre_check_;
    const int		ip_port_no_;

    ulong		total_sent_packets_;
    ulong		total_recv_packets_;
    size_t		local_sent_packets_;
    size_t		local_recv_packets_;

    ulong		cur_request_id_;
    ulong		prev_request_id_;


    // ---------------------------------
    string		get_partner_name () const;
    virtual string	get_peer_name () const = 0;

    virtual string	get_outcoming_packet_desr () const = 0;
    virtual string	get_incoming_packet_desr () const = 0;

    virtual string	get_connection_ip_desr () const = 0;


    virtual void	set_local_sent_packets () = 0;
    virtual void	set_local_recv_packets () = 0;


    bool	check_ip_port_no () const;
    int		get_ip_port_no () const;

    void	set_request_id (ulong request_id_i);
    ulong	get_request_id () const;

    bool	is_end_of_session (ulong request_id_i) const;
    bool	is_end_of_session () const;


    // ---------
    virtual bool write_to_stream (const string& data_i, const string& msg_i = string()) = 0;

    template <typename T>
    bool write_via_broker_to_stream (const T& data_i, const string& msg_i = string());

    template <typename T>
    void send_templated_data (const vector<T>& send_data_i);

    bool send_relevant_packet (const BasicDataType*& packet_i);

    // ---------
    virtual void read_from_stream (string& data_o) = 0;

    template <typename T>
    bool read_via_broker_from_stream (T& data_o, const string& msg_i = string());

    template <typename T>
    void recv_templated_data (size_t data_size_i, vector<T>& recv_data_o);

    bool recv_packet_head (
			ulong&  request_id_o,
			string& packet_typename_o, 
			size_t& packet_size_o
			);

    bool recv_relevant_packet (BasicDataType*& ptr_recv_packet_o);

    virtual string get_peer_ip_address() const = 0;

    void show_outcoming_packet (const BasicDataType*& packet_i) const;
    void show_incoming_packet (const BasicDataType*& packet_i) const;


  public :
    // Constructor-1
    BasicPartner (const string& partner_name_i, int ip_port_no_i);

    // Destructor
    virtual ~BasicPartner ();

    template <typename T>
    void send_templated_packet (const PacketType<T>& send_packet_i);

    template <typename T>
    bool recv_templated_packet (
		vector<T>&	recv_data_o, 
		ulong		request_id_i,
		const string&	packet_typename_i, 
		size_t		packet_size_i
		);

    ulong	get_total_sent_packets () const;
    ulong	get_total_recv_packets () const;


};


//////
#endif
//////


