// =================================================================
//
//  Copyright (C) 2003 Alex Vinokur
//
//  For conditions of distribution and use, see
//  copyright notice in common.h
//
// =================================================================


// #################################################################
//
//  SOFTWARE : C++ Stream-Compatible TCP/IP Sockets Demo Application
//  FILE     : demoapp2.h
//
//  DESCRIPTION :
//         Demo2 application related class implementation
//	   (template methods)
//
// #################################################################


///////////////////////////
#ifndef INCLUDED_DEMOAPP2_H
#define INCLUDED_DEMOAPP2_H
///////////////////////////


// =================
#include "demoapp.h"
// =================


// ------------------------------------
// See also specialization in demoapp.cpp
template <typename T1, typename T2>
vector<T2> ApplicationRun::demo2_prepare_subreply (const vector<T1>&)
{
SET_TRACE;
  return vector<T2>();
}

// ------------------------------------
template <typename T>
vector<T> ApplicationRun::get_subreply_data (const vector<BasicDataType*>& replies_i) const
{
SET_TRACE;

vector<T> ret_vect;

  for (size_t i = 0; i < replies_i.size(); i++)
  {
    if (is_type<T> (replies_i[i]->get_typeid_data_type()))
    {
      PacketType<T>* ptr = dynamic_cast<PacketType<T>*> (replies_i[i]);
      assert (ptr != NULL);
      vector<T> vect (ptr->get_data_items());
      assert (ret_vect.empty());
      copy (vect.begin(), vect.end(), back_inserter(ret_vect));
    }
  }

  return ret_vect;

}

// ----------------------------
// ----------------------------
template <typename T>
CallPrepareReply<T>::CallPrepareReply()
			:
			BasicCallPrepareReply(),
			map_subreplies_ (map_subreplies_s)
{
  assert (!map_subreplies_.empty());
}

// ----------------------------
template <typename T>
CallPrepareReply<T>::~CallPrepareReply()
{
}


// ------------------------------
template <typename T>
vector<BasicDataType*> CallPrepareReply<T>::demo2_call_prepare_reply(
		ApplicationRun&	app_io,
		const BasicDataType*&	ptr_packet_i
		)
{
SET_TRACE;
vector<BasicDataType*> ret_vect;

const PacketType<T>* ptr_packet = dynamic_cast<const PacketType<T> * > (ptr_packet_i);
  assert (!(ptr_packet == NULL)); 

map<string, BasicCallPrepareSubReply*>::const_iterator citer;

  for (citer = map_subreplies_.begin(); citer != map_subreplies_.end(); citer++)
  {
    BasicDataType* ptr = citer->second->demo2_call_prepare_subreply(app_io, ptr_packet_i); 

    if (ptr != NULL)  
    {
      ret_vect.push_back (ptr);
      WARNING (ptr->is_packet_allowed_len());
    }

  }

  WARNING (ApplicationRun::Is_Reply_Allowed_Len (ret_vect));

  return ret_vect;
}


// ------------------------------
// ------------------------------
template <typename T1, typename T2>
CallPrepareSubReply<T1, T2>::CallPrepareSubReply()
			:
			BasicCallPrepareSubReply()
{
SET_CTOR_TRACE;
}


// ------------------------------
template <typename T1, typename T2>
CallPrepareSubReply<T1, T2>::~CallPrepareSubReply()
{
SET_DTOR_TRACE;
}


// ------------------------------
template <typename T1, typename T2>
BasicDataType* CallPrepareSubReply<T1, T2>::demo2_call_prepare_subreply(
		ApplicationRun&		app_io,
		const BasicDataType*&	ptr_packet_i
		)
{
SET_TRACE;
const PacketType<T1>* ptr_packet = dynamic_cast<const PacketType<T1> * > (ptr_packet_i);
  assert (!(ptr_packet == NULL)); 

vector<T2> reply_data_items ( 
	app_io.template demo2_prepare_subreply<T1, T2>(
			ptr_packet->get_data_items()
			)
      			);

BasicDataType* ret_packet = NULL;
  
  if (!reply_data_items.empty())
  {	
    ret_packet = new PacketType<T2> (reply_data_items, __FILE__, __LINE__);
    assert (ret_packet);

    WARNING (ret_packet->is_packet_allowed_len())
  }

  return ret_packet;
}

//////
#endif
//////
