// ==============================================================
//
//  Copyright (c) 2002-2003 by Alex Vinokur.
//
//  For conditions of distribution and use, see
//  copyright notice in version.h
//
// ==============================================================


// ##############################################################
//
//  SOFTWARE : C/C++ Program Perfometer
//  FILE     : adapt.h
//
//  DESCRIPTION :
//         Definition of performeter's user-related metrics classes
//
// ##############################################################


/////////////////
#ifndef _ADAPT_H
#define _ADAPT_H
/////////////////


// ==================
#include "pfmeter2.h"


#if (defined UNIX_ENV)
// -------------------
#include <unistd.h>
#include <utime.h>
#include <sys/resource.h>
// -------------------
#endif



// =================
// === clock
// =================
#define  TURN_ON_CLOCK_USER_TIME(t)         TURN_ON (clock_t, clock_t, RESOURCE_user_time_used, t) 
#define  TURN_ON_THE_CLOCK_USER_TIME(t, s)  TURN_ON_CLOCK_USER_TIME (string(t) + " (size = " + to_string(s) + ")") 
// Nothing


#if (defined UCLOCK_ENV)
// -------------------
// =================
// === uclock
// =================
#define  TURN_ON_UCLOCK_USER_TIME(t)        TURN_ON (uclock_t, uclock_t, RESOURCE_user_time_used, t) 
#define  TURN_ON_THE_UCLOCK_USER_TIME(t, s) TURN_ON_UCLOCK_USER_TIME (string(t) + " (size = " + to_string(s) + ")") 
// Nothing
// -------------------
#endif


#if (defined UNIX_ENV)
// -------------------
// =================
// === timeval, double 
// =================
#define  TURN_ON_RUSAGE_USER_TIME(x, t)        TURN_ON (timeval, x, RESOURCE_user_time_used, t) 
#define  TURN_ON_THE_RUSAGE_USER_TIME(x, t, s) TURN_ON_RUSAGE_USER_TIME (x, string(t) + " (size = " + to_string(s) + ")") 

bool	 operator==  (const timeval& inst1_i, const timeval& inst2_i);
bool	 operator<  (const timeval& inst1_i, const timeval& inst2_i);
bool	 operator<=  (const timeval& inst1_i, const timeval& inst2_i);
ostream& operator<< (ostream& o, const timeval& instance_i);
// -------------------
#endif



#if (defined UNIX_ENV)
// -------------------
#define  TURN_ON_DEFAULT_TIMER(t, s) TURN_ON_THE_RUSAGE_USER_TIME(ulonglong, t, s)
#else
#if (defined UCLOCK_ENV)
#define  TURN_ON_DEFAULT_TIMER(t, s) TURN_ON_THE_UCLOCK_USER_TIME(t, s)
#else
#define  TURN_ON_DEFAULT_TIMER(t, s) TURN_ON_THE_CLOCK_USER_TIME(t, s)
#endif // UCLOCK_ENV
// -------------------
#endif // UNIX_ENV



// =================
// === AAA, BBB 
// =================


// ###################################################
// ############## "State-Resource" Test Class ########
// ###################################################
class AAA
{
friend ostream& operator<< (ostream& o, const AAA& instance_i);
friend bool     operator< (const AAA& inst1_i, const AAA& inst2_i);
friend bool     operator== (const AAA& inst1_i, const AAA& inst2_i);
friend bool     operator<= (const AAA& inst1_i, const AAA& inst2_i);
friend AAA      operator- (const AAA& inst1_i, const AAA& inst2_i);

  private :
    int		a_value_;

  public :
    AAA ();
    ~AAA ();
    AAA (int a_value_i);

    int		get_a_value () const;
};

// =========================
ostream&	operator<< (ostream& o, const AAA& instance_i);
bool		operator< (const AAA& inst1_i, const AAA& inst2_i);
bool		operator== (const AAA& inst1_i, const AAA& inst2_i);
bool		operator<= (const AAA& inst1_i, const AAA& inst2_i);
AAA		operator- (const AAA& inst1_i, const AAA& inst2_i);


// ###################################################
// ############## "Cost-Resource" Test Class #########
// ###################################################
class BBB
{
friend ostream& operator<< (ostream& o, const BBB& instance_i);
friend bool     operator< (const BBB& inst1_i, const BBB& inst2_i);
friend bool     operator== (const BBB& inst1_i, const BBB& inst2_i);
friend bool     operator<= (const BBB& inst1_i, const BBB& inst2_i);
friend BBB      operator- (const BBB& inst1_i, const BBB& inst2_i);
friend BBB      operator/ (const BBB& inst1_i, unsigned int int_value_i);

  private :
    int		b_value_;

  public :
    BBB ();
    BBB (int b_value_i);
    ~BBB ();

    int		get_b_value () const;
    BBB&	operator+= (const BBB& inst_i);

};

// =========================
ostream&	operator<< (ostream& o, const BBB& instance_i);
bool		operator< (const BBB& inst1_i, const BBB& inst2_i);
bool		operator== (const BBB& inst1_i, const BBB& inst2_i);
bool		operator<= (const BBB& inst1_i, const BBB& inst2_i);
BBB		operator- (const BBB& inst1_i, const BBB& inst2_i);
BBB		operator/ (const BBB& inst1_i, unsigned int int_value_i);




///////////////////
#endif	// _ADAPT_H
///////////////////

