USE GsEventLogGathererDB
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[FK_AlertItem_AlertHdr]') and OBJECTPROPERTY(id, N'IsForeignKey') = 1)
ALTER TABLE [dbo].[AlertItem] DROP CONSTRAINT FK_AlertItem_AlertHdr
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[FK_AlertSchedule_AlertHdr]') and OBJECTPROPERTY(id, N'IsForeignKey') = 1)
ALTER TABLE [dbo].[AlertSchedule] DROP CONSTRAINT FK_AlertSchedule_AlertHdr
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[FK_AppUserRole_AppRole]') and OBJECTPROPERTY(id, N'IsForeignKey') = 1)
ALTER TABLE [dbo].[AppUserRole] DROP CONSTRAINT FK_AppUserRole_AppRole
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[FK_AppUserRole_AppUser]') and OBJECTPROPERTY(id, N'IsForeignKey') = 1)
ALTER TABLE [dbo].[AppUserRole] DROP CONSTRAINT FK_AppUserRole_AppUser
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[FK_SavedReport_AppUser]') and OBJECTPROPERTY(id, N'IsForeignKey') = 1)
ALTER TABLE [dbo].[SavedReportHdr] DROP CONSTRAINT FK_SavedReport_AppUser
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[FK_ELServerLogTypeID_ELServer]') and OBJECTPROPERTY(id, N'IsForeignKey') = 1)
ALTER TABLE [dbo].[ELServerLogType] DROP CONSTRAINT FK_ELServerLogTypeID_ELServer
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[FK_EventExclusion_ELServer]') and OBJECTPROPERTY(id, N'IsForeignKey') = 1)
ALTER TABLE [dbo].[EventExclusion] DROP CONSTRAINT FK_EventExclusion_ELServer
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[FK_LogEntry_ELSource]') and OBJECTPROPERTY(id, N'IsForeignKey') = 1)
ALTER TABLE [dbo].[LogEntry] DROP CONSTRAINT FK_LogEntry_ELSource
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[FK_LogEntry_ELUser]') and OBJECTPROPERTY(id, N'IsForeignKey') = 1)
ALTER TABLE [dbo].[LogEntry] DROP CONSTRAINT FK_LogEntry_ELUser
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[FK_LogEntry_EventCategory]') and OBJECTPROPERTY(id, N'IsForeignKey') = 1)
ALTER TABLE [dbo].[LogEntry] DROP CONSTRAINT FK_LogEntry_EventCategory
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[FK_EventExclusion_EventType]') and OBJECTPROPERTY(id, N'IsForeignKey') = 1)
ALTER TABLE [dbo].[EventExclusion] DROP CONSTRAINT FK_EventExclusion_EventType
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[FK_LogEntry_EventType]') and OBJECTPROPERTY(id, N'IsForeignKey') = 1)
ALTER TABLE [dbo].[LogEntry] DROP CONSTRAINT FK_LogEntry_EventType
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[FK_ELServerLogTypeID_LogType]') and OBJECTPROPERTY(id, N'IsForeignKey') = 1)
ALTER TABLE [dbo].[ELServerLogType] DROP CONSTRAINT FK_ELServerLogTypeID_LogType
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[FK_LogEntry_ELServerLogType]') and OBJECTPROPERTY(id, N'IsForeignKey') = 1)
ALTER TABLE [dbo].[LogEntry] DROP CONSTRAINT FK_LogEntry_ELServerLogType
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[FK_SavedReportItem_SavedReportHdr]') and OBJECTPROPERTY(id, N'IsForeignKey') = 1)
ALTER TABLE [dbo].[SavedReportItem] DROP CONSTRAINT FK_SavedReportItem_SavedReportHdr
GO

/****** Object:  Table [dbo].[LogEntry]    Script Date: 12/6/2002 8:00:57 AM ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[LogEntry]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[LogEntry]
GO

/****** Object:  Table [dbo].[SavedReportItem]    Script Date: 12/6/2002 8:00:57 AM ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[SavedReportItem]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[SavedReportItem]
GO

/****** Object:  Table [dbo].[AlertItem]    Script Date: 12/6/2002 8:00:57 AM ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[AlertItem]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[AlertItem]
GO

/****** Object:  Table [dbo].[AlertSchedule]    Script Date: 12/6/2002 8:00:57 AM ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[AlertSchedule]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[AlertSchedule]
GO

/****** Object:  Table [dbo].[AppUserRole]    Script Date: 12/6/2002 8:00:57 AM ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[AppUserRole]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[AppUserRole]
GO

/****** Object:  Table [dbo].[ELServerLogType]    Script Date: 12/6/2002 8:00:57 AM ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ELServerLogType]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[ELServerLogType]
GO

/****** Object:  Table [dbo].[EventExclusion]    Script Date: 12/6/2002 8:00:57 AM ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[EventExclusion]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[EventExclusion]
GO

/****** Object:  Table [dbo].[SavedReportHdr]    Script Date: 12/6/2002 8:00:57 AM ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[SavedReportHdr]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[SavedReportHdr]
GO

/****** Object:  Table [dbo].[AlertHdr]    Script Date: 12/6/2002 8:00:57 AM ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[AlertHdr]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[AlertHdr]
GO

/****** Object:  Table [dbo].[AlertInstance]    Script Date: 12/6/2002 8:00:57 AM ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[AlertInstance]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[AlertInstance]
GO

/****** Object:  Table [dbo].[AppRole]    Script Date: 12/6/2002 8:00:57 AM ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[AppRole]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[AppRole]
GO

/****** Object:  Table [dbo].[AppUser]    Script Date: 12/6/2002 8:00:57 AM ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[AppUser]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[AppUser]
GO

/****** Object:  Table [dbo].[ELAlertInstance]    Script Date: 12/6/2002 8:00:57 AM ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ELAlertInstance]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[ELAlertInstance]
GO

/****** Object:  Table [dbo].[ELServer]    Script Date: 12/6/2002 8:00:57 AM ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ELServer]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[ELServer]
GO

/****** Object:  Table [dbo].[ELSource]    Script Date: 12/6/2002 8:00:57 AM ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ELSource]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[ELSource]
GO

/****** Object:  Table [dbo].[ELUser]    Script Date: 12/6/2002 8:00:57 AM ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ELUser]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[ELUser]
GO

/****** Object:  Table [dbo].[EventCategory]    Script Date: 12/6/2002 8:00:57 AM ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[EventCategory]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[EventCategory]
GO

/****** Object:  Table [dbo].[EventType]    Script Date: 12/6/2002 8:00:57 AM ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[EventType]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[EventType]
GO

/****** Object:  Table [dbo].[LogType]    Script Date: 12/6/2002 8:00:57 AM ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[LogType]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[LogType]
GO

/****** Object:  Table [dbo].[VersionInfo]    Script Date: 12/6/2002 8:00:57 AM ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[VersionInfo]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[VersionInfo]
GO

/****** Object:  Default dbo.defActive    Script Date: 12/6/2002 8:00:57 AM ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[defActive]') and OBJECTPROPERTY(id, N'IsDefault') = 1)
drop default [dbo].[defActive]
GO

/****** Object:  Default dbo.defInactive    Script Date: 12/6/2002 8:00:57 AM ******/
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[defInactive]') and OBJECTPROPERTY(id, N'IsDefault') = 1)
drop default [dbo].[defInactive]
GO

/****** Object:  Default dbo.defInactive    Script Date: 12/6/2002 8:00:57 AM ******/
/****** Object:  Default dbo.defInactive    Script Date: 12/23/2001 1:40:41 PM ******/
/****** Object:  Default dbo.defInactive    Script Date: 12/9/2001 3:29:36 PM ******/
create default [defInactive] as 0

GO

/****** Object:  Default dbo.defActive    Script Date: 12/6/2002 8:00:57 AM ******/
/****** Object:  Default dbo.defActive    Script Date: 12/23/2001 1:40:41 PM ******/
/****** Object:  Default dbo.defActive    Script Date: 12/9/2001 3:29:36 PM ******/
create default [defActive] as 1

GO

/****** Object:  Table [dbo].[AlertHdr]    Script Date: 12/6/2002 8:00:57 AM ******/
CREATE TABLE [dbo].[AlertHdr] (
	[AlertHdrID] [int] IDENTITY (1, 1) NOT NULL ,
	[AppUserName] [varchar] (50) NOT NULL ,
	[AlertDesc] [varchar] (50) NOT NULL ,
	[AlertSql] [varchar] (7000) NULL ,
	[Status] [tinyint] NOT NULL 
) ON [PRIMARY]
GO

/****** Object:  Table [dbo].[AlertInstance]    Script Date: 12/6/2002 8:00:58 AM ******/
CREATE TABLE [dbo].[AlertInstance] (
	[AlertInstanceID] [int] IDENTITY (1, 1) NOT NULL ,
	[AlertHdrID] [int] NOT NULL ,
	[AlertRecipientID] [int] NOT NULL ,
	[EmailTo] [varchar] (100) NOT NULL ,
	[LEID] [int] NOT NULL ,
	[EmailBody] [varchar] (8000) NOT NULL ,
	[EmailSubject] [varchar] (255) NOT NULL 
) ON [PRIMARY]
GO

/****** Object:  Table [dbo].[AppRole]    Script Date: 12/6/2002 8:00:58 AM ******/
CREATE TABLE [dbo].[AppRole] (
	[AppRoleID] [int] NOT NULL ,
	[AppRoleName] [varchar] (50) NOT NULL ,
	[AppRoleDescription] [varchar] (255) NULL ,
	[Status] [tinyint] NOT NULL 
) ON [PRIMARY]
GO

/****** Object:  Table [dbo].[AppUser]    Script Date: 12/6/2002 8:00:58 AM ******/
CREATE TABLE [dbo].[AppUser] (
	[AppUserID] [int] IDENTITY (10000, 1) NOT NULL ,
	[AppUserName] [varchar] (50) NOT NULL ,
	[AppUserPassword] [varchar] (20) NOT NULL ,
	[AppUserFirstName] [varchar] (50) NOT NULL ,
	[AppUserLastName] [varchar] (50) NOT NULL ,
	[AppUserDescription] [varchar] (255) NULL ,
	[Status] [tinyint] NOT NULL 
) ON [PRIMARY]
GO

/****** Object:  Table [dbo].[ELAlertInstance]    Script Date: 12/6/2002 8:00:58 AM ******/
CREATE TABLE [dbo].[ELAlertInstance] (
	[ELAlertInstanceID] [int] NOT NULL ,
	[ELAlertMailTo] [varchar] (511) NULL ,
	[ELAlertMailCc] [varchar] (511) NULL ,
	[ELAlertSubject] [varchar] (255) NULL ,
	[ELAlertMessage] [varchar] (1024) NULL ,
	[ELAlertID] [int] NOT NULL ,
	[CreatedDate] [datetime] NOT NULL ,
	[ErrorCode] [varchar] (50) NULL ,
	[ErrorDesc] [varchar] (511) NULL 
) ON [PRIMARY]
GO

/****** Object:  Table [dbo].[ELServer]    Script Date: 12/6/2002 8:00:58 AM ******/
CREATE TABLE [dbo].[ELServer] (
	[ELServerID] [int] IDENTITY (10000, 1) NOT NULL ,
	[ELServerName] [varchar] (127) NOT NULL ,
	[ELServerDescription] [varchar] (511) NULL ,
	[Status] [tinyint] NOT NULL 
) ON [PRIMARY]
GO

/****** Object:  Table [dbo].[ELSource]    Script Date: 12/6/2002 8:00:58 AM ******/
CREATE TABLE [dbo].[ELSource] (
	[ELSourceID] [int] IDENTITY (1, 1) NOT NULL ,
	[ELSourceName] [varchar] (127) NOT NULL 
) ON [PRIMARY]
GO

/****** Object:  Table [dbo].[ELUser]    Script Date: 12/6/2002 8:00:58 AM ******/
CREATE TABLE [dbo].[ELUser] (
	[ELUserID] [int] IDENTITY (1, 1) NOT NULL ,
	[ELUserName] [varchar] (127) NOT NULL 
) ON [PRIMARY]
GO

/****** Object:  Table [dbo].[EventCategory]    Script Date: 12/6/2002 8:00:58 AM ******/
CREATE TABLE [dbo].[EventCategory] (
	[EventCategoryID] [int] NOT NULL ,
	[EventCategoryName] [varchar] (127) NOT NULL 
) ON [PRIMARY]
GO

/****** Object:  Table [dbo].[EventType]    Script Date: 12/6/2002 8:00:58 AM ******/
CREATE TABLE [dbo].[EventType] (
	[EventTypeID] [int] NOT NULL ,
	[EventTypeCode] [varchar] (50) NOT NULL ,
	[EventTypeName] [varchar] (50) NOT NULL ,
	[EventTypeDesc] [varchar] (511) NOT NULL 
) ON [PRIMARY]
GO

/****** Object:  Table [dbo].[LogType]    Script Date: 12/6/2002 8:00:58 AM ******/
CREATE TABLE [dbo].[LogType] (
	[LogTypeID] [int] IDENTITY (1, 1) NOT NULL ,
	[LogTypeName] [varchar] (127) NOT NULL 
) ON [PRIMARY]
GO

/****** Object:  Table [dbo].[VersionInfo]    Script Date: 12/6/2002 8:00:59 AM ******/
CREATE TABLE [dbo].[VersionInfo] (
	[VersionInfoDesc] [varchar] (255) NOT NULL 
) ON [PRIMARY]
GO

/****** Object:  Table [dbo].[AlertItem]    Script Date: 12/6/2002 8:00:59 AM ******/
CREATE TABLE [dbo].[AlertItem] (
	[AlertHdrID] [int] NOT NULL ,
	[AlertItemID] [int] NOT NULL ,
	[AlertItemMetaData] [varchar] (1023) NOT NULL 
) ON [PRIMARY]
GO

/****** Object:  Table [dbo].[AlertSchedule]    Script Date: 12/6/2002 8:00:59 AM ******/
CREATE TABLE [dbo].[AlertSchedule] (
	[AlertHdrID] [int] NOT NULL ,
	[AlertRecipientID] [int] NOT NULL ,
	[Email] [varchar] (100) NOT NULL ,
	[ScheduleDaysMeta] [int] NOT NULL ,
	[ScheduleDaysDisplay] [varchar] (50) NOT NULL ,
	[ScheduleStartTime] [smalldatetime] NULL ,
	[ScheduleStartTimeMinutes] [int] NULL ,
	[ScheduleEndTime] [smalldatetime] NULL ,
	[ScheduleEndTimeMinutes] [int] NULL ,
	[ScheduleTimeDisplay] [varchar] (50) NOT NULL 
) ON [PRIMARY]
GO

/****** Object:  Table [dbo].[AppUserRole]    Script Date: 12/6/2002 8:00:59 AM ******/
CREATE TABLE [dbo].[AppUserRole] (
	[AppUserRoleID] [int] IDENTITY (1, 1) NOT NULL ,
	[AppUserID] [int] NOT NULL ,
	[AppRoleID] [int] NOT NULL ,
	[Status] [tinyint] NOT NULL 
) ON [PRIMARY]
GO

/****** Object:  Table [dbo].[ELServerLogType]    Script Date: 12/6/2002 8:00:59 AM ******/
CREATE TABLE [dbo].[ELServerLogType] (
	[ELServerID] [int] NOT NULL ,
	[LogTypeID] [int] NOT NULL 
) ON [PRIMARY]
GO

/****** Object:  Table [dbo].[EventExclusion]    Script Date: 12/6/2002 8:00:59 AM ******/
CREATE TABLE [dbo].[EventExclusion] (
	[ELServerID] [int] NOT NULL ,
	[EventTypeID] [int] NOT NULL 
) ON [PRIMARY]
GO

/****** Object:  Table [dbo].[SavedReportHdr]    Script Date: 12/6/2002 8:00:59 AM ******/
CREATE TABLE [dbo].[SavedReportHdr] (
	[SavedReportHdrID] [int] IDENTITY (1, 1) NOT NULL ,
	[AppUserID] [int] NOT NULL ,
	[SavedReportDescription] [varchar] (255) NOT NULL 
) ON [PRIMARY]
GO

/****** Object:  Table [dbo].[LogEntry]    Script Date: 12/6/2002 8:00:59 AM ******/
CREATE TABLE [dbo].[LogEntry] (
	[LEID] [int] IDENTITY (1, 1) NOT NULL ,
	[ELServerID] [int] NOT NULL ,
	[LogTypeID] [int] NOT NULL ,
	[RecordNumber] [int] NOT NULL ,
	[TimeGenerated] [datetime] NOT NULL ,
	[TimeWritten] [datetime] NOT NULL ,
	[EventID] [int] NOT NULL ,
	[EventTypeID] [int] NOT NULL ,
	[EventCategoryID] [int] NOT NULL ,
	[ELUserID] [int] NOT NULL ,
	[ELSourceID] [int] NOT NULL ,
	[FullMessage] [varchar] (1024) NOT NULL ,
	[CreatedAt] [datetime] NOT NULL 
) ON [PRIMARY]
GO

/****** Object:  Table [dbo].[SavedReportItem]    Script Date: 12/6/2002 8:00:59 AM ******/
CREATE TABLE [dbo].[SavedReportItem] (
	[SavedReportHdrID] [int] NOT NULL ,
	[SavedReportItemID] [int] NOT NULL ,
	[SavedReportMetaData] [varchar] (1023) NOT NULL 
) ON [PRIMARY]
GO

ALTER TABLE [dbo].[AlertHdr] WITH NOCHECK ADD 
	CONSTRAINT [PK_AlertHdr] PRIMARY KEY  CLUSTERED 
	(
		[AlertHdrID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[AlertInstance] WITH NOCHECK ADD 
	CONSTRAINT [PK_AlertInstance] PRIMARY KEY  CLUSTERED 
	(
		[AlertInstanceID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[AppRole] WITH NOCHECK ADD 
	CONSTRAINT [PK_AppRole] PRIMARY KEY  CLUSTERED 
	(
		[AppRoleID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[AppUser] WITH NOCHECK ADD 
	CONSTRAINT [PK_AppUser] PRIMARY KEY  CLUSTERED 
	(
		[AppUserID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[ELAlertInstance] WITH NOCHECK ADD 
	CONSTRAINT [PK_ELAlertInstance] PRIMARY KEY  CLUSTERED 
	(
		[ELAlertInstanceID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[ELServer] WITH NOCHECK ADD 
	CONSTRAINT [PK_ELServer] PRIMARY KEY  CLUSTERED 
	(
		[ELServerID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[ELSource] WITH NOCHECK ADD 
	CONSTRAINT [PK_ELSource] PRIMARY KEY  CLUSTERED 
	(
		[ELSourceID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[ELUser] WITH NOCHECK ADD 
	CONSTRAINT [PK_ELUser] PRIMARY KEY  CLUSTERED 
	(
		[ELUserID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[EventCategory] WITH NOCHECK ADD 
	CONSTRAINT [PK_EventCategory] PRIMARY KEY  CLUSTERED 
	(
		[EventCategoryID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[EventType] WITH NOCHECK ADD 
	CONSTRAINT [PK_EventType] PRIMARY KEY  CLUSTERED 
	(
		[EventTypeID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[LogType] WITH NOCHECK ADD 
	CONSTRAINT [PK_LogType] PRIMARY KEY  CLUSTERED 
	(
		[LogTypeID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[VersionInfo] WITH NOCHECK ADD 
	CONSTRAINT [PK_VersionInfo] PRIMARY KEY  CLUSTERED 
	(
		[VersionInfoDesc]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[AlertItem] WITH NOCHECK ADD 
	CONSTRAINT [PK_AlertItem] PRIMARY KEY  CLUSTERED 
	(
		[AlertHdrID],
		[AlertItemID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[AlertSchedule] WITH NOCHECK ADD 
	CONSTRAINT [PK_AlertSchedule] PRIMARY KEY  CLUSTERED 
	(
		[AlertHdrID],
		[AlertRecipientID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[AppUserRole] WITH NOCHECK ADD 
	CONSTRAINT [PK_AppUserRole] PRIMARY KEY  CLUSTERED 
	(
		[AppUserRoleID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[ELServerLogType] WITH NOCHECK ADD 
	CONSTRAINT [PK_ELServerLogType] PRIMARY KEY  CLUSTERED 
	(
		[ELServerID],
		[LogTypeID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[EventExclusion] WITH NOCHECK ADD 
	CONSTRAINT [PK_EventExclusion] PRIMARY KEY  CLUSTERED 
	(
		[ELServerID],
		[EventTypeID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[SavedReportHdr] WITH NOCHECK ADD 
	CONSTRAINT [PK_SavedReport] PRIMARY KEY  CLUSTERED 
	(
		[SavedReportHdrID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[LogEntry] WITH NOCHECK ADD 
	CONSTRAINT [PK_LogEntry] PRIMARY KEY  CLUSTERED 
	(
		[LEID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[SavedReportItem] WITH NOCHECK ADD 
	CONSTRAINT [PK_SavedReportItem] PRIMARY KEY  CLUSTERED 
	(
		[SavedReportHdrID],
		[SavedReportItemID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[AppRole] WITH NOCHECK ADD 
	CONSTRAINT [IX_AppRoleName] UNIQUE  NONCLUSTERED 
	(
		[AppRoleName]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[AppUser] WITH NOCHECK ADD 
	CONSTRAINT [IX_AppUserName] UNIQUE  NONCLUSTERED 
	(
		[AppUserID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[ELServer] WITH NOCHECK ADD 
	CONSTRAINT [IX_ELServer] UNIQUE  NONCLUSTERED 
	(
		[ELServerName]
	)  ON [PRIMARY] 
GO

 CREATE  INDEX [IX_ELSource] ON [dbo].[ELSource]([ELSourceName]) ON [PRIMARY]
GO

 CREATE  INDEX [IX_ELUser] ON [dbo].[ELUser]([ELUserName]) ON [PRIMARY]
GO

 CREATE  INDEX [IX_EventCategory] ON [dbo].[EventCategory]([EventCategoryName]) ON [PRIMARY]
GO

 CREATE  INDEX [IX_EventType] ON [dbo].[EventType]([EventTypeName]) ON [PRIMARY]
GO

 CREATE  INDEX [IX_LogType] ON [dbo].[LogType]([LogTypeName]) ON [PRIMARY]
GO

ALTER TABLE [dbo].[AppUserRole] WITH NOCHECK ADD 
	CONSTRAINT [IX_AppUserRole] UNIQUE  NONCLUSTERED 
	(
		[AppUserID],
		[AppRoleID]
	)  ON [PRIMARY] 
GO

 CREATE  INDEX [IX_ELServerLogTypeIDELServerID] ON [dbo].[ELServerLogType]([ELServerID]) ON [PRIMARY]
GO

 CREATE  INDEX [IX_ELServerLogTypeIDLogTypeID] ON [dbo].[ELServerLogType]([LogTypeID]) ON [PRIMARY]
GO

 CREATE  INDEX [IX_SavedReportAppUserID] ON [dbo].[SavedReportHdr]([AppUserID]) ON [PRIMARY]
GO

ALTER TABLE [dbo].[LogEntry] WITH NOCHECK ADD 
	CONSTRAINT [DF_LogEntry_CreatedAt] DEFAULT (getdate()) FOR [CreatedAt]
GO

 CREATE  INDEX [IX_LogEntryTimeGenerated] ON [dbo].[LogEntry]([TimeGenerated]) ON [PRIMARY]
GO

 CREATE  INDEX [IX_LogEntryEventID] ON [dbo].[LogEntry]([EventID]) ON [PRIMARY]
GO

 CREATE  INDEX [IX_LogEntryEventTypeID] ON [dbo].[LogEntry]([EventTypeID]) ON [PRIMARY]
GO

 CREATE  INDEX [IX_LogEntryEventCategoryID] ON [dbo].[LogEntry]([EventCategoryID]) ON [PRIMARY]
GO

 CREATE  INDEX [IX_LogEntryELUserID] ON [dbo].[LogEntry]([ELUserID]) ON [PRIMARY]
GO

 CREATE  INDEX [IX_LogEntryELSourceID] ON [dbo].[LogEntry]([ELSourceID]) ON [PRIMARY]
GO

 CREATE  INDEX [IX_LogEntryELServerID] ON [dbo].[LogEntry]([LogTypeID]) ON [PRIMARY]
GO

 CREATE  INDEX [IX_LogEntryLogType] ON [dbo].[LogEntry]([LogTypeID]) ON [PRIMARY]
GO

 CREATE  INDEX [IX_LogEntry] ON [dbo].[LogEntry]([ELServerID], [LogTypeID]) ON [PRIMARY]
GO

setuser
GO

EXEC sp_bindefault N'[dbo].[defActive]', N'[AppRole].[Status]'
GO

setuser
GO

setuser
GO

EXEC sp_bindefault N'[dbo].[defActive]', N'[AppUser].[AppUserName]'
GO

EXEC sp_bindefault N'[dbo].[defActive]', N'[AppUser].[Status]'
GO

setuser
GO

setuser
GO

EXEC sp_bindefault N'[dbo].[defActive]', N'[ELServer].[Status]'
GO

setuser
GO

setuser
GO

EXEC sp_bindefault N'[dbo].[defActive]', N'[AppUserRole].[Status]'
GO

setuser
GO

ALTER TABLE [dbo].[AlertItem] ADD 
	CONSTRAINT [FK_AlertItem_AlertHdr] FOREIGN KEY 
	(
		[AlertHdrID]
	) REFERENCES [dbo].[AlertHdr] (
		[AlertHdrID]
	)
GO

ALTER TABLE [dbo].[AlertSchedule] ADD 
	CONSTRAINT [FK_AlertSchedule_AlertHdr] FOREIGN KEY 
	(
		[AlertHdrID]
	) REFERENCES [dbo].[AlertHdr] (
		[AlertHdrID]
	)
GO

ALTER TABLE [dbo].[AppUserRole] ADD 
	CONSTRAINT [FK_AppUserRole_AppRole] FOREIGN KEY 
	(
		[AppRoleID]
	) REFERENCES [dbo].[AppRole] (
		[AppRoleID]
	),
	CONSTRAINT [FK_AppUserRole_AppUser] FOREIGN KEY 
	(
		[AppUserID]
	) REFERENCES [dbo].[AppUser] (
		[AppUserID]
	)
GO

ALTER TABLE [dbo].[ELServerLogType] ADD 
	CONSTRAINT [FK_ELServerLogTypeID_ELServer] FOREIGN KEY 
	(
		[ELServerID]
	) REFERENCES [dbo].[ELServer] (
		[ELServerID]
	),
	CONSTRAINT [FK_ELServerLogTypeID_LogType] FOREIGN KEY 
	(
		[LogTypeID]
	) REFERENCES [dbo].[LogType] (
		[LogTypeID]
	)
GO

ALTER TABLE [dbo].[EventExclusion] ADD 
	CONSTRAINT [FK_EventExclusion_ELServer] FOREIGN KEY 
	(
		[ELServerID]
	) REFERENCES [dbo].[ELServer] (
		[ELServerID]
	),
	CONSTRAINT [FK_EventExclusion_EventType] FOREIGN KEY 
	(
		[EventTypeID]
	) REFERENCES [dbo].[EventType] (
		[EventTypeID]
	)
GO

ALTER TABLE [dbo].[SavedReportHdr] ADD 
	CONSTRAINT [FK_SavedReport_AppUser] FOREIGN KEY 
	(
		[AppUserID]
	) REFERENCES [dbo].[AppUser] (
		[AppUserID]
	)
GO

ALTER TABLE [dbo].[LogEntry] ADD 
	CONSTRAINT [FK_LogEntry_ELServerLogType] FOREIGN KEY 
	(
		[ELServerID],
		[LogTypeID]
	) REFERENCES [dbo].[ELServerLogType] (
		[ELServerID],
		[LogTypeID]
	),
	CONSTRAINT [FK_LogEntry_ELSource] FOREIGN KEY 
	(
		[ELSourceID]
	) REFERENCES [dbo].[ELSource] (
		[ELSourceID]
	),
	CONSTRAINT [FK_LogEntry_ELUser] FOREIGN KEY 
	(
		[ELUserID]
	) REFERENCES [dbo].[ELUser] (
		[ELUserID]
	),
	CONSTRAINT [FK_LogEntry_EventCategory] FOREIGN KEY 
	(
		[EventCategoryID]
	) REFERENCES [dbo].[EventCategory] (
		[EventCategoryID]
	),
	CONSTRAINT [FK_LogEntry_EventType] FOREIGN KEY 
	(
		[EventTypeID]
	) REFERENCES [dbo].[EventType] (
		[EventTypeID]
	)
GO

ALTER TABLE [dbo].[SavedReportItem] ADD 
	CONSTRAINT [FK_SavedReportItem_SavedReportHdr] FOREIGN KEY 
	(
		[SavedReportHdrID]
	) REFERENCES [dbo].[SavedReportHdr] (
		[SavedReportHdrID]
	)
GO

