@rem
@rem RatheDG Cachalot System 1.2.0. ERU native command-line client, running script.
@rem
@rem Note:
@rem    1) System parameters marked as (!) MUST be configured by deployer.
@rem       System will not work if these parameters are not defined properly.
@rem
@rem    2) System parameters marked as (S) are important for system security.
@rem       It is recommended to configure them after initial system installation
@rem       and configuration.
@rem

@echo off

rem
rem (!) %SERVER% is host where ERU server is running.
rem See 'address' parameter in erus.conf.
rem
set SERVER=MyERUServer

rem
rem %PORT% is port which ERU server is listening to.
rem See 'port' parameter in erus.conf.
rem
set PORT=9008

rem
rem (S) %PASSWORD% is password to authenticate in ERU server.
rem See 'password' parameter in erus.conf.
rem
set PASSWORD=MyERUPassword

rem
rem %TIMEOUT% is connection timeout.
rem
set TIMEOUT=1000

rem
rem %ATTEMPTS% is number of attempts to send an event.
rem
set ATTEMPTS=1


if not defined CACHALOT_HOME set CACHALOT_HOME=%~dp0..

set ERU=%CACHALOT_HOME%\system\client\eru_nclc.exe
if exist "%ERU%" goto ERU
    echo Can't find file: %ERU%.
    echo This is essential part of the system and is needed to run this program.
    goto :EOF
:ERU

rem
rem Run ERU client.
rem
"%ERU%" %SERVER% %PORT% %PASSWORD% %TIMEOUT% %ATTEMPTS% %*

echo Error code: %ERRORLEVEL%

