/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jlGui.tag;

import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.Info;
import com.jcraft.jorbis.JOrbisException;
import com.jcraft.jorbis.VorbisFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;
import javazoom.jlGui.tag.TagInfo;

public class OggVorbisInfo
implements TagInfo {
    private int serial = 0;
    private int channels = 0;
    private int version = 0;
    private int rate = 0;
    private int minbitrate = 0;
    private int maxbitrate = 0;
    private int averagebitrate = 0;
    private int nominalbitrate = 0;
    private long totalms = 0L;
    private String vendor = null;
    private String location = null;
    private long size = 0L;
    private int track = -1;
    private String year = null;
    private String genre = null;
    private String title = null;
    private String artist = null;
    private String album = null;
    private Vector comments = null;
    private byte[] header;
    private byte[] packet;
    private long[] crc_lookup = new long[256];

    public OggVorbisInfo(String string) throws IOException, JOrbisException {
        VorbisFile vorbisFile = null;
        File file = new File(string);
        this.size = file.length();
        this.location = string;
        FileInputStream fileInputStream = new FileInputStream(string);
        this.checkAudioFormat(fileInputStream);
        fileInputStream.close();
        vorbisFile = new VorbisFile(string);
        this.loadInfo(vorbisFile);
    }

    private void checkAudioFormat(InputStream inputStream) throws JOrbisException, IOException {
        int n = 0;
        while (n < 256) {
            this.crc_lookup[n] = this._ogg_crc_entry(n);
            ++n;
        }
        byte[] byArray = new byte[27];
        int n2 = inputStream.read(byArray);
        if (n2 < 27) {
            throw new JOrbisException("Not enough bytes in header");
        }
        if (!"OggS".equals(new String(byArray, 0, 4))) {
            throw new JOrbisException("Not a valid Ogg Vorbis file");
        }
        int n3 = this.touint(byArray[26]) + 27;
        byte[] byArray2 = new byte[this.touint(byArray[26])];
        this.header = new byte[n3];
        Arrays.fill(this.header, (byte)0);
        System.arraycopy(byArray, 0, this.header, 0, 27);
        System.arraycopy(byArray2, 0, this.header, 27, n3 - 27);
        if ((n2 += inputStream.read(byArray2)) < n3) {
            String string = "Error reading vorbis file: Not enough bytes for header + seg table";
            throw new JOrbisException(string);
        }
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.header[26]) {
            n4 += this.touint(this.header[27 + n5]);
            ++n5;
        }
        this.packet = new byte[n4];
        Arrays.fill(this.packet, (byte)0);
        if ((n2 += inputStream.read(this.packet)) < n3 + n4) {
            String string = "Error reading vorbis file: Not enough bytes for header + body";
            throw new JOrbisException(string);
        }
        byte[] byArray3 = new byte[4];
        System.arraycopy(this.header, 22, byArray3, 0, 4);
        Arrays.fill(this.header, 22, 26, (byte)0);
        byte[] byArray4 = this.checksum();
        if (!new String(byArray3).equals(new String(byArray4))) {
            // empty if block
        }
    }

    private long _ogg_crc_entry(long l) {
        long l2 = l << 24;
        int n = 0;
        while (n < 8) {
            l2 = (l2 & 0x80000000L) != 0L ? l2 << 1 ^ 0x4C11DB7L : (l2 <<= 1);
            ++n;
        }
        return l2 & 0xFFFFFFFFFFFFFFFFL;
    }

    private byte[] checksum() {
        int n;
        long l = 0L;
        int n2 = 0;
        while (n2 < this.header.length) {
            n = (int)(l >>> 24 & 0xFFL ^ (long)this.touint(this.header[n2]));
            l = l << 8 ^ this.crc_lookup[n];
            l &= 0xFFFFFFFFFFFFFFFFL;
            ++n2;
        }
        n = 0;
        while (n < this.packet.length) {
            int n3 = (int)(l >>> 24 & 0xFFL ^ (long)this.touint(this.packet[n]));
            l = l << 8 ^ this.crc_lookup[n3];
            l &= 0xFFFFFFFFFFFFFFFFL;
            ++n;
        }
        byte[] byArray = new byte[]{(byte)(l & 0xFFL), (byte)(l >>> 8 & 0xFFL), (byte)(l >>> 16 & 0xFFL), (byte)(l >>> 24 & 0xFFL)};
        return byArray;
    }

    private int touint(byte by) {
        return by & 0xFF;
    }

    private void loadInfo(VorbisFile vorbisFile) {
        int n = vorbisFile.streams();
        this.serial = vorbisFile.serialnumber(-1);
        this.averagebitrate = vorbisFile.bitrate(-1);
        this.totalms = Math.round(vorbisFile.time_total(-1));
        Comment[] commentArray = vorbisFile.getComment();
        Info[] infoArray = vorbisFile.getInfo();
        this.comments = new Vector();
        int n2 = 0;
        while (n2 < n) {
            Info info = infoArray[n2];
            Comment comment = commentArray[n2];
            this.channels = info.channels;
            this.rate = info.rate;
            this.version = info.version;
            String string = info.toString();
            StringTokenizer stringTokenizer = new StringTokenizer(string = string.substring(string.indexOf("bitrate:") + 8, string.length()), ",");
            if (stringTokenizer.hasMoreTokens()) {
                this.minbitrate = Integer.parseInt(stringTokenizer.nextToken());
            }
            if (stringTokenizer.hasMoreTokens()) {
                this.nominalbitrate = Integer.parseInt(stringTokenizer.nextToken());
            }
            if (stringTokenizer.hasMoreTokens()) {
                this.maxbitrate = Integer.parseInt(stringTokenizer.nextToken());
            }
            this.vendor = comment.getVendor();
            int n3 = 0;
            while (n3 < comment.comments) {
                String string2 = comment.getComment(n3);
                int n4 = string2.indexOf("=");
                if (n4 != -1) {
                    String string3 = string2.substring(0, n4).trim();
                    String string4 = string2.substring(n4 + 1, string2.length());
                    if (string3.equalsIgnoreCase("artist")) {
                        this.artist = string4;
                    } else if (string3.equalsIgnoreCase("album")) {
                        this.album = string4;
                    } else if (string3.equalsIgnoreCase("title")) {
                        this.title = string4;
                    } else if (string3.equalsIgnoreCase("year")) {
                        this.year = string4;
                    } else if (string3.equalsIgnoreCase("genre")) {
                        this.genre = string4;
                    } else if (string3.equalsIgnoreCase("track")) {
                        this.track = Integer.parseInt(string4);
                    } else {
                        this.comments.add(string2);
                    }
                } else {
                    this.comments.add(string2);
                }
                ++n3;
            }
            ++n2;
        }
    }

    public int getSerial() {
        return this.serial;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getVersion() {
        return this.version;
    }

    public int getMinBitrate() {
        return this.minbitrate;
    }

    public int getMaxBitrate() {
        return this.maxbitrate;
    }

    public int getAverageBitrate() {
        return this.averagebitrate;
    }

    public long getSize() {
        return this.size;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getLocation() {
        return this.location;
    }

    public int getSamplingRate() {
        return this.rate;
    }

    public int getBitRate() {
        return this.nominalbitrate;
    }

    public long getPlayTime() {
        return this.totalms;
    }

    public String getTitle() {
        return this.title;
    }

    public String getArtist() {
        return this.artist;
    }

    public String getAlbum() {
        return this.album;
    }

    public int getTrack() {
        return this.track;
    }

    public String getGenre() {
        return this.genre;
    }

    public Vector getComment() {
        return this.comments;
    }

    public String getYear() {
        return this.year;
    }
}

