// ==============================================================
//
//  Copyright (c) 2003 by Alex Vinokur.
//
//  For conditions of distribution and use, see
//  copyright notice in version.h
//
// ==============================================================


// ##############################################################
//
//  SOFTWARE : Turing Machine with faults, failures and recovery
//             C++ Simulator
//
//  FILE     : t-aux.cpp
//
//  DESCRIPTION :
//         Class TuringMachine : auxilary class and methods (Implementation)
//
// ##############################################################


// =================
#include "turing-s.h"
// =================



// =========
// =========
// =========
// Constructor-0
AuxTuringMachine::AuxTuringMachine () 
  :
  embedded_internal_synchronous_tape_alphabet_ (vector<symbol_mt> (NUMBER_OF_SYNCHRONOUS_TAPE_ALPHABET_SYMBOLS)),

  descr_of_tape_kinds_ (vector<string> (NUMBER_OF_TAPE_KINDS)),
  max_size_of_descr_of_tape_kinds_ (0),

  descr_of_program_state_top_kinds_ (vector<string> (NUMBER_OF_PROGRAM_STATE_TOP_KINDS)),
  max_size_of_descr_of_program_state_top_kinds_ (0),

  descr_of_user_defined_program_state_kinds_ (vector<string>(NUMBER_OF_USER_DEFINED_PROGRAM_STATE_KINDS)),
  max_size_of_descr_of_user_defined_program_state_kinds_ (0),
  descr_of_user_defined_program_states_ (vector<vector<string> >(NUMBER_OF_USER_DEFINED_PROGRAM_STATE_KINDS)),
  max_size_of_descr_of_user_defined_program_states_ (vector<size_t> (NUMBER_OF_USER_DEFINED_PROGRAM_STATE_KINDS)),

  descr_of_neutral_program_state_kinds_ (vector<string>(NUMBER_OF_NEUTRAL_PROGRAM_STATE_KINDS)),
  max_size_of_descr_of_neutral_program_state_kinds_ (0),
  descr_of_neutral_program_states_ (vector<vector<string> >(NUMBER_OF_NEUTRAL_PROGRAM_STATE_KINDS)),
  max_size_of_descr_of_neutral_program_states_ (vector<size_t> (NUMBER_OF_NEUTRAL_PROGRAM_STATE_KINDS)),

  descr_of_pre_initial_program_state_kinds_ (vector<string>(NUMBER_OF_PRE_INITIAL_PROGRAM_STATE_KINDS)),
  max_size_of_descr_of_pre_initial_program_state_kinds_ (0),
  descr_of_pre_initial_program_states_ (vector<vector<string> >(NUMBER_OF_PRE_INITIAL_PROGRAM_STATE_KINDS)),
  max_size_of_descr_of_pre_initial_program_states_ (vector<size_t> (NUMBER_OF_PRE_INITIAL_PROGRAM_STATE_KINDS)),

  descr_of_post_halting_program_state_kinds_ (vector<string>(NUMBER_OF_POST_HALTING_PROGRAM_STATE_KINDS)),
  max_size_of_descr_of_post_halting_program_state_kinds_ (0),
  descr_of_post_halting_program_states_ (vector<vector<string> >(NUMBER_OF_POST_HALTING_PROGRAM_STATE_KINDS)),
  max_size_of_descr_of_post_halting_program_states_ (vector<size_t> (NUMBER_OF_POST_HALTING_PROGRAM_STATE_KINDS)),

  descr_of_user_required_program_state_kinds_ (vector<string>(NUMBER_OF_USER_REQUIRED_PROGRAM_STATE_KINDS)),
  max_size_of_descr_of_user_required_program_state_kinds_ (0),
  descr_of_user_required_program_states_ (vector<vector<string> >(NUMBER_OF_USER_REQUIRED_PROGRAM_STATE_KINDS)),
  max_size_of_descr_of_user_required_program_states_ (vector<size_t> (NUMBER_OF_USER_REQUIRED_PROGRAM_STATE_KINDS)),

  descr_of_embedded_program_state_kinds_ (vector<string>(NUMBER_OF_EMBEDDED_PROGRAM_STATE_KINDS)),
  max_size_of_descr_of_embedded_program_state_kinds_ (0),
  descr_of_embedded_program_states_ (vector<vector<string> >(NUMBER_OF_EMBEDDED_PROGRAM_STATE_KINDS)),
  max_size_of_descr_of_embedded_program_states_ (vector<size_t> (NUMBER_OF_EMBEDDED_PROGRAM_STATE_KINDS)),

  max_size_of_descr_of_program_state_kinds_ (0)
{
  init();
}

// =========
// Destructor-0
AuxTuringMachine::~AuxTuringMachine ()
{
}
		   
// =========
void AuxTuringMachine::init ()
{

  init_daemon_states ();
  init_tester_states ();
  init_apparatus_states ();
  init_synchronous_tape_alphabet ();
  init_descr_of_tape_kinds ();
  init_descr_of_program_state_top_kinds ();
  init_descr_of_user_defined_program_state_kinds ();
  init_descr_of_user_defined_program_states ();
  init_descr_of_neutral_program_state_kinds ();
  init_descr_of_neutral_program_states ();
  init_descr_of_pre_initial_program_state_kinds ();
  init_descr_of_pre_initial_program_states ();
  init_descr_of_post_halting_program_state_kinds ();
  init_descr_of_post_halting_program_states ();
  init_descr_of_user_required_program_state_kinds ();
  init_descr_of_user_required_program_states ();
  init_descr_of_embedded_program_state_kinds ();
  init_descr_of_embedded_program_states ();

  // -----------------
  assert (max_size_of_descr_of_program_state_kinds_ == 0);
  max_size_of_descr_of_program_state_kinds_ = MAX_VALUE (max_size_of_descr_of_program_state_kinds_, max_size_of_descr_of_user_defined_program_state_kinds_);
  max_size_of_descr_of_program_state_kinds_ = MAX_VALUE (max_size_of_descr_of_program_state_kinds_, max_size_of_descr_of_neutral_program_state_kinds_);
  max_size_of_descr_of_program_state_kinds_ = MAX_VALUE (max_size_of_descr_of_program_state_kinds_, max_size_of_descr_of_pre_initial_program_state_kinds_);
  max_size_of_descr_of_program_state_kinds_ = MAX_VALUE (max_size_of_descr_of_program_state_kinds_, max_size_of_descr_of_post_halting_program_state_kinds_);
  max_size_of_descr_of_program_state_kinds_ = MAX_VALUE (max_size_of_descr_of_program_state_kinds_, max_size_of_descr_of_user_required_program_state_kinds_);
  max_size_of_descr_of_program_state_kinds_ = MAX_VALUE (max_size_of_descr_of_program_state_kinds_, max_size_of_descr_of_embedded_program_state_kinds_);

} // init

		 
		   
// =========
void AuxTuringMachine::init_daemon_states ()
{
  assert (daemon_passive_states_.empty());
  daemon_passive_states_.push_back (DAEMON_PASSIVE_STATE);

  assert (daemon_active_states_.empty());
  daemon_active_states_.push_back (DAEMON_ACTIVE_STATE);

  assert (daemon_aggressive_states_.empty());
  daemon_aggressive_states_.push_back (DAEMON_AGGRESSSIVE_STATE);

  // -----------------	  
  get_max_size_of_daemon_states();


} // init_daemon_states 


// =========
void AuxTuringMachine::init_tester_states ()
{
  assert (tester_tracking_states_.empty());
  tester_tracking_states_.push_back(TESTER_TRACKING_STATE);
 
  assert (tester_stabilizing_states_.empty());
  tester_stabilizing_states_.push_back(TESTER_STABILIZING_STATE);

  // -----------------	  
  get_max_size_of_tester_states();

} // init_tester_states 


// =========
void AuxTuringMachine::init_apparatus_states ()
{
  assert (apparatus_normal_states_.empty());
  apparatus_normal_states_.push_back(APPARATUS_NORMAL_STATE);

  assert (apparatus_emergency_states_.empty());
  apparatus_emergency_states_.push_back(APPARATUS_EMERGENCY_STATE);

  // -----------------	  
  get_max_size_of_apparatus_states();


} // init_apparatus_states 


// =========
void AuxTuringMachine::init_synchronous_tape_alphabet ()
{

  assert (embedded_blank_synchronous_tape_alphabet_.empty());
  assert (embedded_internal_synchronous_tape_alphabet_.size() == NUMBER_OF_SYNCHRONOUS_TAPE_ALPHABET_SYMBOLS);

  embedded_blank_synchronous_tape_alphabet_.push_back (symbol_mt (SYNCHRONOUS_TAPE_ALPHABET__EMPTY_SYMBOL));
  
  embedded_internal_synchronous_tape_alphabet_[SYNCHRONOUS_TAPE_ALPHABET__BOUNDARY_SYMBOL__INDEX] = symbol_mt (SYNCHRONOUS_TAPE_ALPHABET__BOUNDARY_SYMBOL);
  embedded_internal_synchronous_tape_alphabet_[SYNCHRONOUS_TAPE_ALPHABET__SIGN_SYMBOL__INDEX] = symbol_mt (SYNCHRONOUS_TAPE_ALPHABET__SIGN_SYMBOL);

  assert (string (SYNCHRONOUS_TAPE_ALPHABET__EMPTY_SYMBOL).size() == string (SYNCHRONOUS_TAPE_ALPHABET__BOUNDARY_SYMBOL).size());
  assert (string (SYNCHRONOUS_TAPE_ALPHABET__EMPTY_SYMBOL).size() == string (SYNCHRONOUS_TAPE_ALPHABET__SIGN_SYMBOL).size());

  for (size_t i = 0; i < embedded_blank_synchronous_tape_alphabet_.size(); i++)
  {
    for (size_t j = 0; j < embedded_internal_synchronous_tape_alphabet_.size(); j++)
    {
      assert (embedded_blank_synchronous_tape_alphabet_[i] != embedded_internal_synchronous_tape_alphabet_[j]);
    }
  }

  for (size_t i = 0; i < embedded_internal_synchronous_tape_alphabet_.size(); i++)
  {
    for (size_t j = 0; j < embedded_internal_synchronous_tape_alphabet_.size(); j++)
    {
      if (i == j) continue;
      assert (embedded_internal_synchronous_tape_alphabet_[i] != embedded_internal_synchronous_tape_alphabet_[j]);
    }
  }


}


// =========
size_t AuxTuringMachine::get_max_size_of_daemon_states()
{
size_t	ret_value = 0;

  ret_value = MAX_VALUE (ret_value, get_max_size (daemon_passive_states_));
  ret_value = MAX_VALUE (ret_value, get_max_size (daemon_active_states_));
  ret_value = MAX_VALUE (ret_value, get_max_size (daemon_aggressive_states_));

  assert (ret_value);
  return ret_value;

}

// =========
size_t AuxTuringMachine::get_max_size_of_tester_states()
{
size_t	ret_value = 0;

  ret_value = MAX_VALUE (ret_value, get_max_size (tester_tracking_states_));
  ret_value = MAX_VALUE (ret_value, get_max_size (tester_stabilizing_states_));

  assert (ret_value);
  return ret_value;

}


// =========
size_t AuxTuringMachine::get_max_size_of_apparatus_states()
{
size_t	ret_value = 0;

  ret_value = MAX_VALUE (ret_value, get_max_size (apparatus_normal_states_));
  ret_value = MAX_VALUE (ret_value, get_max_size (apparatus_emergency_states_));

  assert (ret_value);
  return ret_value;

}





// =========			 
void AuxTuringMachine::init_descr_of_embedded_program_states ()
{
  assert (descr_of_embedded_program_states_.size() == NUMBER_OF_EMBEDDED_PROGRAM_STATE_KINDS);
  assert (max_size_of_descr_of_embedded_program_states_.size() == NUMBER_OF_EMBEDDED_PROGRAM_STATE_KINDS);

  descr_of_embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__PRE_INITIAL_BACKUP].resize (NUMBER_OF_PRE_INITIAL_BACKUP_STATES);
  descr_of_embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__COMPUTATION_CONTROL].resize (NUMBER_OF_COMPUTATION_CONTROL_STATES);
  descr_of_embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__BACKUP].resize (NUMBER_OF_BACKUP_STATES);
  descr_of_embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__BACKUP_CONTROL].resize (NUMBER_OF_BACKUP_CONTROL_STATES);
  descr_of_embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__RECOVERY].resize (NUMBER_OF_RECOVERY_STATES);
  descr_of_embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__RECOVERY_CONTROL].resize (NUMBER_OF_RECOVERY_CONTROL_STATES);
  descr_of_embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__SUMMARY_CONTROL].resize (NUMBER_OF_SUMMARY_CONTROL_STATES);
  descr_of_embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__EMERGENCY].resize (NUMBER_OF_EMBEDDED_EMERGENCY_STATES);
  descr_of_embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__SHUTTING_DOWN].resize (NUMBER_OF_EMBEDDED_HALTING_STATES);

  assert (descr_of_embedded_program_states_.size() == max_size_of_descr_of_embedded_program_states_.size());

  // -----------------

  descr_of_embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__PRE_INITIAL_BACKUP] [PRE_INITIAL_BACKUP_STATE_K1] = "K1";
  descr_of_embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__PRE_INITIAL_BACKUP] [PRE_INITIAL_BACKUP_STATE_K2] = "K2";

  descr_of_embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__COMPUTATION_CONTROL] [COMPUTATION_CONTROL_STATE_R1] = "R1";
  descr_of_embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__COMPUTATION_CONTROL] [COMPUTATION_CONTROL_STATE_R2] = "R2";

  descr_of_embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__BACKUP] [BACKUP_STATE_S1] = "S1";
  descr_of_embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__BACKUP] [BACKUP_STATE_S2] = "S2";
  descr_of_embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__BACKUP] [BACKUP_STATE_S3] = "S3";
  descr_of_embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__BACKUP] [BACKUP_STATE_S4] = "S4";

  descr_of_embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__BACKUP_CONTROL] [BACKUP_CONTROL_STATE_T1] = "T1";
  descr_of_embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__BACKUP_CONTROL] [BACKUP_CONTROL_STATE_T2] = "T2";
  descr_of_embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__BACKUP_CONTROL] [BACKUP_CONTROL_STATE_T3] = "T3";
  descr_of_embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__BACKUP_CONTROL] [BACKUP_CONTROL_STATE_T4] = "T4";


  descr_of_embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__RECOVERY] [RECOVERY_STATE_V1] = "V1";
  descr_of_embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__RECOVERY] [RECOVERY_STATE_V2] = "V2";
  descr_of_embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__RECOVERY] [RECOVERY_STATE_V3] = "V3";
  descr_of_embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__RECOVERY] [RECOVERY_STATE_V4] = "V4";

  descr_of_embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__RECOVERY_CONTROL] [RECOVERY_CONTROL_STATE_W1] = "W1";
  descr_of_embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__RECOVERY_CONTROL] [RECOVERY_CONTROL_STATE_W2] = "W2";
  descr_of_embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__RECOVERY_CONTROL] [RECOVERY_CONTROL_STATE_W3] = "W3";
  descr_of_embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__RECOVERY_CONTROL] [RECOVERY_CONTROL_STATE_W4] = "W4";

  descr_of_embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__SUMMARY_CONTROL] [SUMMARY_CONTROL_STATE_U1] = "U1";
  descr_of_embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__SUMMARY_CONTROL] [SUMMARY_CONTROL_STATE_U2] = "U2";

  descr_of_embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__EMERGENCY] [EMBEDDED_EMERGENCY_STATE__BASIC_E1] = "E1";
  descr_of_embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__EMERGENCY] [EMBEDDED_EMERGENCY_STATE__COMPUTATION_CONTROL_E2] = "E2";
  descr_of_embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__EMERGENCY] [EMBEDDED_EMERGENCY_STATE__BACKUP_E3] = "E3";
  descr_of_embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__EMERGENCY] [EMBEDDED_EMERGENCY_STATE__BACKUP_CONTROL_E4] = "E4";
  descr_of_embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__EMERGENCY] [EMBEDDED_EMERGENCY_STATE__RECOVERY_E5] = "E5";
  descr_of_embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__EMERGENCY] [EMBEDDED_EMERGENCY_STATE__RECOVERY_CONTROL_E6] = "E6";
  descr_of_embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__EMERGENCY] [EMBEDDED_EMERGENCY_STATE__SUMMARY_CONTROL_E7] = "E7";

  descr_of_embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__SHUTTING_DOWN] [EMBEDDED_HALTING_STATE_N1] = "N1";


  // -----------------
const size_t the_size = descr_of_embedded_program_states_.size();
  assert (the_size > 0);

set<string>	tmp_set;
typedef set<string>::value_type value_type;
pair<set<string>::iterator, bool> couple;

  for (size_t i = 0; i < the_size; i++)
  {
    max_size_of_descr_of_embedded_program_states_ [i] = 0;
    for (size_t j = 0; j < descr_of_embedded_program_states_[i].size(); j++)
    {
      assert (!descr_of_embedded_program_states_[i][j].empty());

      assert (count (tmp_set.begin(), tmp_set.end(), descr_of_embedded_program_states_[i][j]) == 0);

      couple = tmp_set.insert (descr_of_embedded_program_states_[i][j]);
      assert (couple.second);

      max_size_of_descr_of_embedded_program_states_ [i] = MAX_VALUE(max_size_of_descr_of_embedded_program_states_ [i], descr_of_embedded_program_states_[i][j].size());
    }
  }  

} // init_descr_of_embedded_program_states


// =========			 
void AuxTuringMachine::init_descr_of_embedded_program_state_kinds ()
{
  assert (descr_of_embedded_program_state_kinds_.size() == NUMBER_OF_EMBEDDED_PROGRAM_STATE_KINDS);
  assert (max_size_of_descr_of_embedded_program_state_kinds_ == 0);


  descr_of_embedded_program_state_kinds_[EMBEDDED_PROGRAM_STATE_KIND__PRE_INITIAL_BACKUP] = "Pre-Initial Backup";
  descr_of_embedded_program_state_kinds_[EMBEDDED_PROGRAM_STATE_KIND__COMPUTATION_CONTROL] = "Computation-Control";
  descr_of_embedded_program_state_kinds_[EMBEDDED_PROGRAM_STATE_KIND__BACKUP] = "Backup";
  descr_of_embedded_program_state_kinds_[EMBEDDED_PROGRAM_STATE_KIND__BACKUP_CONTROL] = "Backup-Control";
  descr_of_embedded_program_state_kinds_[EMBEDDED_PROGRAM_STATE_KIND__RECOVERY] = "Recovery";
  descr_of_embedded_program_state_kinds_[EMBEDDED_PROGRAM_STATE_KIND__RECOVERY_CONTROL] = "Recovery-Control";
  descr_of_embedded_program_state_kinds_[EMBEDDED_PROGRAM_STATE_KIND__SUMMARY_CONTROL] = "Summary-Control";
  descr_of_embedded_program_state_kinds_[EMBEDDED_PROGRAM_STATE_KIND__EMERGENCY] = "Emergency";
  descr_of_embedded_program_state_kinds_[EMBEDDED_PROGRAM_STATE_KIND__SHUTTING_DOWN] = "Shutting-Down";

  assert (count (descr_of_embedded_program_state_kinds_.begin(), descr_of_embedded_program_state_kinds_.end(), string()) == 0);

vector<string>::iterator pos_iter;
  for (pos_iter = descr_of_embedded_program_state_kinds_.begin(); 
       pos_iter != descr_of_embedded_program_state_kinds_.end();
       pos_iter++)
  {
    assert (count (pos_iter, descr_of_embedded_program_state_kinds_.end(), *pos_iter) == 1);
    max_size_of_descr_of_embedded_program_state_kinds_ = MAX_VALUE (max_size_of_descr_of_embedded_program_state_kinds_, pos_iter->size());
  }
  
  assert (max_size_of_descr_of_embedded_program_state_kinds_ > 0);

} // init_descr_of_embedded_program_states


// =========			 
void AuxTuringMachine::init_descr_of_tape_kinds ()
{
  assert (descr_of_tape_kinds_.size() == NUMBER_OF_TAPE_KINDS);
  assert (max_size_of_descr_of_tape_kinds_ == 0);

  descr_of_tape_kinds_[MASTER_COMPUTATION_TAPE] = "Master Computation";
  descr_of_tape_kinds_[SYNCHRONOUS_COMPUTATION_TAPE] = "Synchronous Computation";
  descr_of_tape_kinds_[BACKUP_COMPUTATION_TAPE] = "Backup Computation";
  descr_of_tape_kinds_[SYNCHRONOUS_BACKUP_COMPUTATION_TAPE] = "Synchronous Backup Computation";
  descr_of_tape_kinds_[TESTER_TAPE] = "Tester";

  assert (count (descr_of_tape_kinds_.begin(), descr_of_tape_kinds_.end(), string()) == 0);

vector<string>::iterator pos_iter;
  for (pos_iter = descr_of_tape_kinds_.begin(); 
       pos_iter != descr_of_tape_kinds_.end();
       pos_iter++)
  {
    assert (count (pos_iter, descr_of_tape_kinds_.end(), *pos_iter) == 1);
    max_size_of_descr_of_tape_kinds_ = MAX_VALUE (max_size_of_descr_of_tape_kinds_, pos_iter->size());
  }
  
  assert (max_size_of_descr_of_tape_kinds_ > 0);

} // init_descr_of_tapes


// =========			 
void AuxTuringMachine::init_descr_of_program_state_top_kinds ()
{
  assert (descr_of_program_state_top_kinds_.size() == NUMBER_OF_PROGRAM_STATE_TOP_KINDS);
  assert (max_size_of_descr_of_program_state_top_kinds_ == 0);

  descr_of_program_state_top_kinds_[PROGRAM_STATE_TOP_KIND__USER_DEFINED] = "User-Defined";
  descr_of_program_state_top_kinds_[PROGRAM_STATE_TOP_KIND__NEUTRAL] = "Neutral";
  descr_of_program_state_top_kinds_[PROGRAM_STATE_TOP_KIND__PRE_INITIAL] = "PreInitial";
  descr_of_program_state_top_kinds_[PROGRAM_STATE_TOP_KIND__POST_HALTING] = "PostHalting";
  descr_of_program_state_top_kinds_[PROGRAM_STATE_TOP_KIND__USER_REQUIRED] = "User-Required";
  descr_of_program_state_top_kinds_[PROGRAM_STATE_TOP_KIND__EMBEDDED] = "Embedded";

  assert (count (descr_of_program_state_top_kinds_.begin(), descr_of_program_state_top_kinds_.end(), string()) == 0);

vector<string>::iterator pos_iter;
  for (pos_iter = descr_of_program_state_top_kinds_.begin(); 
       pos_iter != descr_of_program_state_top_kinds_.end();
       pos_iter++)
  {
    assert (count (pos_iter, descr_of_program_state_top_kinds_.end(), *pos_iter) == 1);
    max_size_of_descr_of_program_state_top_kinds_ = MAX_VALUE (max_size_of_descr_of_program_state_top_kinds_, pos_iter->size());
  }
  
  assert (max_size_of_descr_of_program_state_top_kinds_ > 0);

} // init_descr_of_program_state_tops



// =========			 
void AuxTuringMachine::init_descr_of_user_defined_program_state_kinds ()
{
  assert (descr_of_user_defined_program_state_kinds_.size() == NUMBER_OF_USER_DEFINED_PROGRAM_STATE_KINDS);
  assert (max_size_of_descr_of_user_defined_program_state_kinds_ == 0);

  descr_of_user_defined_program_state_kinds_[USER_DEFINED_PROGRAM_STATE_KIND__INITIAL] = "Initial";
  descr_of_user_defined_program_state_kinds_[USER_DEFINED_PROGRAM_STATE_KIND__INTERNAL] = "Internal";
  descr_of_user_defined_program_state_kinds_[USER_DEFINED_PROGRAM_STATE_KIND__HALTING] = "Halting";

  assert (count (descr_of_user_defined_program_state_kinds_.begin(), descr_of_user_defined_program_state_kinds_.end(), string()) == 0);

vector<string>::iterator pos_iter;
  for (pos_iter = descr_of_user_defined_program_state_kinds_.begin(); 
       pos_iter != descr_of_user_defined_program_state_kinds_.end();
       pos_iter++)
  {
    assert (count (pos_iter, descr_of_user_defined_program_state_kinds_.end(), *pos_iter) == 1);
    max_size_of_descr_of_user_defined_program_state_kinds_ = MAX_VALUE (max_size_of_descr_of_user_defined_program_state_kinds_, pos_iter->size());
  }
  
  assert (max_size_of_descr_of_user_defined_program_state_kinds_ > 0);

}


// =========			 
void AuxTuringMachine::init_descr_of_user_defined_program_states ()
{
  for (size_t i = 0; i < descr_of_user_defined_program_states_.size(); i++)
  {
    descr_of_user_defined_program_states_[i].push_back (
			"DUMMY-" + 
			to_string(i) + 
			"--" + 
			string (__FILE__) +
			"-Line#" +
			to_string (__LINE__)
			);  
  }


  // -----------------
const size_t the_size = descr_of_user_defined_program_states_.size();
  assert (the_size > 0);

set<string>	tmp_set;
typedef set<string>::value_type value_type;
pair<set<string>::iterator, bool> couple;

  for (size_t i = 0; i < the_size; i++)
  {
    max_size_of_descr_of_user_defined_program_states_ [i] = 0;
    for (size_t j = 0; j < descr_of_user_defined_program_states_[i].size(); j++)
    {
      assert (!descr_of_user_defined_program_states_[i][j].empty());

      assert (count (tmp_set.begin(), tmp_set.end(), descr_of_user_defined_program_states_[i][j]) == 0);

      couple = tmp_set.insert (descr_of_user_defined_program_states_[i][j]);
      assert (couple.second);

      max_size_of_descr_of_user_defined_program_states_ [i] = MAX_VALUE(max_size_of_descr_of_user_defined_program_states_ [i], descr_of_user_defined_program_states_[i][j].size());
    }
  }  

}


// =========			 
void AuxTuringMachine::init_descr_of_neutral_program_state_kinds ()
{
  assert (descr_of_neutral_program_state_kinds_.size() == NUMBER_OF_NEUTRAL_PROGRAM_STATE_KINDS);
  assert (max_size_of_descr_of_neutral_program_state_kinds_ == 0);

  descr_of_neutral_program_state_kinds_[NEUTRAL_PROGRAM_STATE_KIND__CUR_NEUTRAL] = "Neutral Current SubState";
  descr_of_neutral_program_state_kinds_[NEUTRAL_PROGRAM_STATE_KIND__NEXT_THE_SAME] = "The Same Next SubState";
  descr_of_neutral_program_state_kinds_[NEUTRAL_PROGRAM_STATE_KIND__NEXT_NOT_THE_SAME] = "Not The Same Next SubState";

  assert (count (descr_of_neutral_program_state_kinds_.begin(), descr_of_neutral_program_state_kinds_.end(), string()) == 0);

vector<string>::iterator pos_iter;
  for (pos_iter = descr_of_neutral_program_state_kinds_.begin(); 
       pos_iter != descr_of_neutral_program_state_kinds_.end();
       pos_iter++)
  {
    assert (count (pos_iter, descr_of_neutral_program_state_kinds_.end(), *pos_iter) == 1);
    max_size_of_descr_of_neutral_program_state_kinds_ = MAX_VALUE (max_size_of_descr_of_neutral_program_state_kinds_, pos_iter->size());
  }
  
  assert (max_size_of_descr_of_neutral_program_state_kinds_ > 0);

} // init_descr_of_neutral_program_states




// =========			 
void AuxTuringMachine::init_descr_of_pre_initial_program_state_kinds ()
{

  assert (descr_of_pre_initial_program_state_kinds_.size() == NUMBER_OF_PRE_INITIAL_PROGRAM_STATE_KINDS);
  assert (max_size_of_descr_of_pre_initial_program_state_kinds_ == 0);

  descr_of_pre_initial_program_state_kinds_[PRE_INITIAL_PROGRAM_STATE_KIND__INITIAL] = "Pre-Initial";

  assert (count (descr_of_pre_initial_program_state_kinds_.begin(), descr_of_pre_initial_program_state_kinds_.end(), string()) == 0);

vector<string>::iterator pos_iter;
  for (pos_iter = descr_of_pre_initial_program_state_kinds_.begin(); 
       pos_iter != descr_of_pre_initial_program_state_kinds_.end();
       pos_iter++)
  {
    assert (count (pos_iter, descr_of_pre_initial_program_state_kinds_.end(), *pos_iter) == 1);
    max_size_of_descr_of_pre_initial_program_state_kinds_ = MAX_VALUE (max_size_of_descr_of_pre_initial_program_state_kinds_, pos_iter->size());
  }
  
  assert (max_size_of_descr_of_pre_initial_program_state_kinds_ > 0);


} // init_descr_of_pre_initial_program_states



// =========			 
void AuxTuringMachine::init_descr_of_post_halting_program_state_kinds ()
{

  // ------------- PostHalting -----------
  assert (descr_of_post_halting_program_state_kinds_.size() == NUMBER_OF_POST_HALTING_PROGRAM_STATE_KINDS);
  assert (max_size_of_descr_of_post_halting_program_state_kinds_ == 0);

  descr_of_post_halting_program_state_kinds_[POST_HALTING_PROGRAM_STATE_KIND__HALTING] = "Post-Halting";

  assert (count (descr_of_post_halting_program_state_kinds_.begin(), descr_of_post_halting_program_state_kinds_.end(), string()) == 0);

vector<string>::iterator pos_iter;
  for (pos_iter = descr_of_post_halting_program_state_kinds_.begin(); 
       pos_iter != descr_of_post_halting_program_state_kinds_.end();
       pos_iter++)
  {
    assert (count (pos_iter, descr_of_post_halting_program_state_kinds_.end(), *pos_iter) == 1);
    max_size_of_descr_of_post_halting_program_state_kinds_ = MAX_VALUE (max_size_of_descr_of_post_halting_program_state_kinds_, pos_iter->size());
  }
  
  assert (max_size_of_descr_of_post_halting_program_state_kinds_ > 0);


} // init_descr_of_post_halting_program_states



// =========			 
void AuxTuringMachine::init_descr_of_user_required_program_state_kinds ()
{
  assert (descr_of_user_required_program_state_kinds_.size() == NUMBER_OF_USER_REQUIRED_PROGRAM_STATE_KINDS);
  assert (max_size_of_descr_of_user_required_program_state_kinds_ == 0);

  descr_of_user_required_program_state_kinds_[USER_REQUIRED_PROGRAM_STATE_KIND__CHECK_POINT] = "Check-Point";

  assert (count (descr_of_user_required_program_state_kinds_.begin(), descr_of_user_required_program_state_kinds_.end(), string()) == 0);

vector<string>::iterator pos_iter;
  for (pos_iter = descr_of_user_required_program_state_kinds_.begin(); 
       pos_iter != descr_of_user_required_program_state_kinds_.end();
       pos_iter++)
  {
    assert (count (pos_iter, descr_of_user_required_program_state_kinds_.end(), *pos_iter) == 1);
    max_size_of_descr_of_user_required_program_state_kinds_ = MAX_VALUE (max_size_of_descr_of_user_required_program_state_kinds_, pos_iter->size());
  }
  
  assert (max_size_of_descr_of_user_required_program_state_kinds_ > 0);

} // init_descr_of_user_required_program_states



// =========			 
void AuxTuringMachine::init_descr_of_neutral_program_states ()
{
  for (size_t i = 0; i < descr_of_neutral_program_states_.size(); i++)
  {
    descr_of_neutral_program_states_[i].push_back (
			"DUMMY-" + 
			to_string(i) + 
			"--" + 
			string (__FILE__) +
			"-Line#" +
			to_string (__LINE__)
			);  
  }


  // -----------------
const size_t the_size = descr_of_neutral_program_states_.size();
  assert (the_size > 0);

set<string>	tmp_set;
typedef set<string>::value_type value_type;
pair<set<string>::iterator, bool> couple;

  for (size_t i = 0; i < the_size; i++)
  {
    max_size_of_descr_of_neutral_program_states_ [i] = 0;
    for (size_t j = 0; j < descr_of_neutral_program_states_[i].size(); j++)
    {
      assert (!descr_of_neutral_program_states_[i][j].empty());

      assert (count (tmp_set.begin(), tmp_set.end(), descr_of_neutral_program_states_[i][j]) == 0);

      couple = tmp_set.insert (descr_of_neutral_program_states_[i][j]);
      assert (couple.second);

      max_size_of_descr_of_neutral_program_states_ [i] = MAX_VALUE(max_size_of_descr_of_neutral_program_states_ [i], descr_of_neutral_program_states_[i][j].size());
    }
  }  

}


// =========			 
void AuxTuringMachine::init_descr_of_pre_initial_program_states ()
{
  for (size_t i = 0; i < descr_of_pre_initial_program_states_.size(); i++)
  {
    descr_of_pre_initial_program_states_[i].push_back (
			"DUMMY1-" + 
			to_string(i) + 
			"--" + 
			string (__FILE__) +
			"-Line#" +
			to_string (__LINE__)
			);  
  }


  // -----------------
const size_t the_size = descr_of_pre_initial_program_states_.size();
  assert (the_size > 0);

set<string>	tmp_set;
typedef set<string>::value_type value_type;
pair<set<string>::iterator, bool> couple;

  for (size_t i = 0; i < the_size; i++)
  {
    max_size_of_descr_of_pre_initial_program_states_ [i] = 0;
    for (size_t j = 0; j < descr_of_pre_initial_program_states_[i].size(); j++)
    {
      assert (!descr_of_pre_initial_program_states_[i][j].empty());

      assert (count (tmp_set.begin(), tmp_set.end(), descr_of_pre_initial_program_states_[i][j]) == 0);

      couple = tmp_set.insert (descr_of_pre_initial_program_states_[i][j]);
      assert (couple.second);

      max_size_of_descr_of_pre_initial_program_states_ [i] = MAX_VALUE(max_size_of_descr_of_pre_initial_program_states_ [i], descr_of_pre_initial_program_states_[i][j].size());
    }
  }  

} // init_descr_of_pre_initial_program_states



// =========			 
void AuxTuringMachine::init_descr_of_post_halting_program_states ()
{
  for (size_t i = 0; i < descr_of_post_halting_program_states_.size(); i++)
  {
    descr_of_post_halting_program_states_[i].push_back (
			"DUMMY2-" + 
			to_string(i) + 
			"--" + 
			string (__FILE__) +
			"-Line#" +
			to_string (__LINE__)
			);  
  }


  // -----------------
const size_t the_size = descr_of_post_halting_program_states_.size();
  assert (the_size > 0);

set<string>	tmp_set;
typedef set<string>::value_type value_type;
pair<set<string>::iterator, bool> couple;

  for (size_t i = 0; i < the_size; i++)
  {
    max_size_of_descr_of_post_halting_program_states_ [i] = 0;
    for (size_t j = 0; j < descr_of_post_halting_program_states_[i].size(); j++)
    {
      assert (!descr_of_post_halting_program_states_[i][j].empty());

      assert (count (tmp_set.begin(), tmp_set.end(), descr_of_post_halting_program_states_[i][j]) == 0);

      couple = tmp_set.insert (descr_of_post_halting_program_states_[i][j]);
      assert (couple.second);

      max_size_of_descr_of_post_halting_program_states_ [i] = MAX_VALUE(max_size_of_descr_of_post_halting_program_states_ [i], descr_of_post_halting_program_states_[i][j].size());
    }
  }  

} // init_descr_of_post_halting_program_states



// =========			 
void AuxTuringMachine::init_descr_of_user_required_program_states ()
{
  for (size_t i = 0; i < descr_of_user_required_program_states_.size(); i++)
  {
    descr_of_user_required_program_states_[i].push_back (
			"DUMMY-" + 
			to_string(i) + 
			"--" + 
			string (__FILE__) +
			"-Line#" +
			to_string (__LINE__)
			);  
  }


  // -----------------
const size_t the_size = descr_of_user_required_program_states_.size();
  assert (the_size > 0);

set<string>	tmp_set;
typedef set<string>::value_type value_type;
pair<set<string>::iterator, bool> couple;

  for (size_t i = 0; i < the_size; i++)
  {
    max_size_of_descr_of_user_required_program_states_ [i] = 0;
    for (size_t j = 0; j < descr_of_user_required_program_states_[i].size(); j++)
    {
      assert (!descr_of_user_required_program_states_[i][j].empty());

      assert (count (tmp_set.begin(), tmp_set.end(), descr_of_user_required_program_states_[i][j]) == 0);

      couple = tmp_set.insert (descr_of_user_required_program_states_[i][j]);
      assert (couple.second);

      max_size_of_descr_of_user_required_program_states_ [i] = MAX_VALUE(max_size_of_descr_of_user_required_program_states_ [i], descr_of_user_required_program_states_[i][j].size());
    }
  }  

}


