// ==============================================================
//
//  Copyright (c) 1999-2002 by Alex Vinokur.  This work and all works
//  derived from it may be copied and modified without any
//  restrictions other than that a copy of this copyright notice
//  must be included in any copy of this work or any derived work.
//
// ==============================================================

///////////////////////////////////////

#ifndef democase_H
#define democase_H

///////////////////////////////////////

static char id_democase_H[] = "@(#)## n-ary Huffman Template Algorithm ## Author : Alex Vinokur ## "__FILE__;


// ##############################################################
// =================================
//  n-ary Huffman Template Algorithm
// ==================================
//
//  FILE : democase.h
//
//  AUTHOR : Alex Vinokur
//
//  DESCRIPTION :
//
//         Declaration of the following test cases :
//         ----------------------------------------------
//         Test#t1.   Creating Loaded 5-ary Huffman Tree
//                    from data vector
//                    with char-symbols and int-weights
//
//         Test#t2.   Creating Loaded 24-ary Huffman Tree
//                    from data vector
//                    with char-symbols and int-weights
//
//         Test#t3.   Creating Loaded Binary Huffman Tree
//                    from data vector
//                    with char-symbols and int-weights
//
//         Test#t4.   Creating Dried (Unload) Binary Huffman Tree
//                    from data vector
//                    with int-weights
//                    Note. This vector contains Fibonacci sequence.
//
//         Test#t5.   Creating Dried (Unload) Binary Huffman Tree
//                    from data file
//                    with int-weights
//
//         Test#t6.   Creating Loaded Binary Huffman Tree
//                    from data file
//                    with char-symbols and int-weights
//
//         Test#7.    Creating Loaded Binary Huffman Tree
//                    from data vector
//                    with string-symbols and float-weights
//
//         Test#t8.   Creating Loaded Binary Huffman Tree
//                    from data vector
//                    with AAA-symbols and BBB-weights
//
//
//         Test#mv1.  Encoding and Decoding vector-message
//                    using 5-ary Huffman Tree
//
//         Test#ms1.  Encoding and Decoding string-message
//                    using 5-ary Huffman Tree
//
//         Test#mv2.  Encoding and Decoding vector-message
//                    using Binary Huffman Tree
//
//         Test#ms2.  Encoding and Decoding string-message
//                    using Binary Huffman Tree
//
//         ----------------------------------------------
//
// ##############################################################


// ===========================
#include "methods.h"
#include "demotype.h"
// ===========================

#define	DEMO_CASE(x)	demo_case_##x (__FILE__, __LINE__, __PRETTY_FUNCTION__)

// ===========================
class ClassTest
{
  private :
    int inst_type_;


    vector<Cell<char, int> >		char_int_data_vector_;
    vector<Cell<string, float> >	string_float_data_vector_;
    vector<Cell<AAA, BBB> >		AAA_BBB_data_vector_;

    vector<int>				int_weights_vector_;

    string				char_int_data_file_name_;
    string				int_weights_file_name_;

    void init1_data_vectors ();
    void init1_weights_vectors ();

    void init2_data_vectors ();
    void init2_weights_vectors ();

    void set1_data_files_name ();
    void set2_data_files_name ();

    void set1_weights_files_name ();
    void set2_weights_files_name ();

    void show_char_int_data_vector () const;
    void show_string_float_data_vector () const;
    void show_AAA_BBB_data_vector () const;

    void show_int_weights_vector () const;


  public :
    ClassTest (int inst_type_i = 1);
    ~ClassTest ();
 
   void demo_case_t01 (const string& file_name_i, size_t line_no_i, const string& func_name_i) const;
   void demo_case_t02 (const string& file_name_i, size_t line_no_i, const string& func_name_i) const;
   void demo_case_t03 (const string& file_name_i, size_t line_no_i, const string& func_name_i) const;
   void demo_case_t04 (const string& file_name_i, size_t line_no_i, const string& func_name_i) const;
   void demo_case_t05 (const string& file_name_i, size_t line_no_i, const string& func_name_i) const;
   void demo_case_t06 (const string& file_name_i, size_t line_no_i, const string& func_name_i) const;
   void demo_case_t07 (const string& file_name_i, size_t line_no_i, const string& func_name_i) const;
   void demo_case_t08 (const string& file_name_i, size_t line_no_i, const string& func_name_i) const;

   void demo_case_m01 (const string& file_name_i, size_t line_no_i, const string& func_name_i) const;
   void demo_case_m02 (const string& file_name_i, size_t line_no_i, const string& func_name_i) const;

};


#endif	// democase_H

// #######################################################
// ################ END OF FILE ##########################
// #######################################################

