// #########################################################
// === File #10 of 15 : func.cpp ===========================
// ------------------- C++ code : BEGIN --------------------

// ==============================================================
//
//  Copyright (c) 1999 - 2002 by Alex Vinokur.  This work and all works
//  derived from it may be copied and modified without any
//  restrictions other than that a copy of this copyright notice
//  must be included in any copy of this work or any derived work.
//
// ==============================================================
// #########################################################
// ## mailto:alexvn@bigfoot.com, mailto:alexv@hitechclub.com
// ## http://up.to/alexv, http://go.to/alexv_math
// #########################################################
// ==============================================================


// ##############################################################
//
//  SOFTWARE : Vector and Matrix with arbitrary bounds
//  FILE     : func.cpp
//
//  DESCRIPTION :
//         Implementation of auxiliary (non-template) functions
//
//  -------	-----------
//  Created	Mar-15-1999
//  -------	-----------
//  Updated	Oct-30-2001    gcc-2.95.3,  Windows98
//  Updated	May-06-2002    gcc-3.0.4,   Windows2000
//  Updated	Dec-06-2002    gcc-3.2.0,   Windows2000
//
// ##############################################################


//=====================
#include "funcs.h"
//=====================


//=================================================
static const char*	STR_ACCOUNT_CNS = "ACCOUNT";
//=================================================

//######################################
//############# FUNCTIONS ##############
//######################################

//======================================
string	gstrAboutAccount (
		const string& theObjectType_i, 
		long countConstructors_i, 
		long countDestructors_i
		)
//======================================
{
string		ret_stringValue;
ostringstream       oss;

	oss << STR_ACCOUNT_CNS
		      << " -> ";

	//--------------------------------
	oss.width (20);
	oss.fill (' ');
	oss.setf (ios::left, ios::adjustfield);

	oss << theObjectType_i.c_str () 
		      << " : ";

	//--------------------------------
	oss.setf (ios::right, ios::adjustfield);

	//--------------------------------
	oss.setf (ios::showpos);
	oss.width (12);
	oss << countConstructors_i; 

	oss.unsetf (ios::showpos);
	oss.width (12);
	oss << (-countDestructors_i); 

	oss << " = "; 
	oss.width (10);
	oss << (countConstructors_i - countDestructors_i); 

	//--------------------------------
	oss << ends;
	ret_stringValue = oss.str(); 

	//--------------------------------
	return ret_stringValue;

} // string gstrAboutAccount () 


//################################################################
//#                          END OF FILE                         # 
//################################################################


// ------------------- C++ code : END ----------------------
// === File #10 of 15 : func.cpp ===========================
