/*
 * Decompiled with CFR 0.152.
 */
package vscript.GUI;

import java.awt.BorderLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import vscript.interpreter.EventTagManager;
import vscript.interpreter.TagInterpreter;
import vscript.message.Messagable;
import vscript.message.Message;
import vscript.parser.Parser;

public class VList
extends JPanel
implements Messagable,
ListSelectionListener,
MouseListener {
    private EventTagManager etm;
    private JList jlist = new JList();
    private JScrollPane jsp = new JScrollPane(this.jlist);
    private List listData = new LinkedList();

    public VList(List list, String string, String string2, String string3, String string4) {
        if (list != null) {
            this.listData.addAll(list);
            this.jlist.setListData(list.toArray());
        }
        TagInterpreter.processEnabled(this.jlist, string3);
        TagInterpreter.processBColor(this.jlist, string);
        TagInterpreter.processFColor(this.jlist, string2);
        TagInterpreter.processBorder(this.jsp, string4);
        TagInterpreter.processBColor(this.jsp.getVerticalScrollBar(), string);
        TagInterpreter.processBColor(this.jsp.getHorizontalScrollBar(), string);
        this.jlist.addListSelectionListener(this);
        this.setLayout(new BorderLayout());
        this.add(this.jsp);
        this.jlist.addMouseListener(this);
    }

    public void handleMessage(Message message) {
        TagInterpreter.handleMessageGUI(this, message);
        String string = message.getMessageString();
        if (string != null) {
            int n;
            String[] stringArray;
            if (string.equals("enable")) {
                this.jlist.setEnabled(true);
            } else if (string.equals("disable")) {
                this.jlist.setEnabled(false);
            } else if (string.equals("clear")) {
                this.listData.clear();
                this.jlist.setListData(this.listData.toArray());
            } else if (string.equals("add")) {
                String[] stringArray2 = message.getArguments();
                if (stringArray2.length > 0) {
                    int n2 = 0;
                    while (n2 < stringArray2.length) {
                        this.listData.addAll(Parser.getElements(stringArray2[n2], 44));
                        ++n2;
                    }
                    this.jlist.setListData(this.listData.toArray());
                }
            } else if (string.equals("select") && (stringArray = message.getArguments()).length > 0 && (n = Integer.valueOf(stringArray[0]).intValue()) < this.jlist.getModel().getSize()) {
                this.jlist.setSelectedIndex(n);
                this.jlist.ensureIndexIsVisible(n);
            }
        }
    }

    public void setEventTagManager(EventTagManager eventTagManager) {
        this.etm = eventTagManager;
    }

    public String getDataValue(String string) {
        String string2 = null;
        if (string != null) {
            int n = this.jlist.getSelectedIndex();
            if (string.equals("data")) {
                string2 = (String)this.jlist.getSelectedValue();
            } else if (string.equals("next")) {
                int n2 = this.jlist.getModel().getSize() - 1;
                if (n < n2) {
                    this.jlist.setSelectedIndex(n + 1);
                    string2 = (String)this.jlist.getSelectedValue();
                    this.jlist.ensureIndexIsVisible(n + 1);
                }
            } else if (string.equals("prev")) {
                if (n > -1) {
                    this.jlist.setSelectedIndex(n - 1);
                    string2 = (String)this.jlist.getSelectedValue();
                    this.jlist.ensureIndexIsVisible(n - 1);
                }
            } else if (string.equals("index")) {
                n = this.jlist.getSelectedIndex();
                string2 = String.valueOf(n);
            }
        }
        if (string2 == null) {
            return "null";
        }
        return string2;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this.etm.processEvent("select");
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.etm.processEvent("click");
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.etm.processEvent("mousein");
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.etm.processEvent("mouseout");
    }
}

