/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.validator;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.ValidatorResources;
import org.apache.commons.validator.ValidatorResourcesInitializer;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.PlugIn;
import org.apache.struts.config.ModuleConfig;

public class ValidatorPlugIn
implements PlugIn {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$struts$validator$ValidatorPlugIn == null ? (class$org$apache$struts$validator$ValidatorPlugIn = ValidatorPlugIn.class$("org.apache.struts.validator.ValidatorPlugIn")) : class$org$apache$struts$validator$ValidatorPlugIn));
    private ModuleConfig config = null;
    private ActionServlet servlet = null;
    private static final String RESOURCE_DELIM = ",";
    public static final String VALIDATOR_KEY = "org.apache.commons.validator.VALIDATOR_RESOURCES";
    protected ValidatorResources resources = null;
    private String pathnames = null;
    static /* synthetic */ Class class$org$apache$struts$validator$ValidatorPlugIn;

    public String getPathnames() {
        return this.pathnames;
    }

    public void setPathnames(String pathnames) {
        this.pathnames = pathnames;
    }

    public void init(ActionServlet servlet, ModuleConfig config) throws ServletException {
        this.config = config;
        this.servlet = servlet;
        try {
            this.initResources();
            servlet.getServletContext().setAttribute(VALIDATOR_KEY + config.getPrefix(), (Object)this.resources);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UnavailableException("Cannot load a validator resource from '" + this.pathnames + "'");
        }
    }

    public void destroy() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Destroying ValidatorPlugin");
        }
        this.servlet = null;
        this.config = null;
        this.destroyResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void initResources() throws IOException, ServletException {
        this.resources = new ValidatorResources();
        if (this.pathnames == null || this.pathnames.length() <= 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(this.pathnames, RESOURCE_DELIM);
        while (true) {
            InputStream input;
            if (!st.hasMoreTokens()) {
                this.resources.process();
                return;
            }
            String validatorRules = st.nextToken().trim();
            if (log.isInfoEnabled()) {
                log.info((Object)("Loading validation rules file from '" + validatorRules + "'"));
            }
            if ((input = this.servlet.getServletContext().getResourceAsStream(validatorRules)) != null) {
                Object var7_6;
                BufferedInputStream bis = new BufferedInputStream(input);
                try {
                    try {
                        ValidatorResourcesInitializer.initialize((ValidatorResources)this.resources, (InputStream)bis, (boolean)false);
                    }
                    catch (IOException e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                        var7_6 = null;
                        bis.close();
                        continue;
                    }
                    var7_6 = null;
                }
                catch (Throwable throwable) {
                    var7_6 = null;
                    bis.close();
                    throw throwable;
                }
                bis.close();
                continue;
            }
            log.error((Object)("Skipping validation rules file from '" + validatorRules + "'.  No stream could be opened."));
        }
    }

    protected void destroyResources() {
        this.resources = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

