/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.taglib.html;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.RequestUtils;

public class BaseTag
extends TagSupport {
    protected static MessageResources messages = MessageResources.getMessageResources("org.apache.struts.taglib.html.LocalStrings");
    protected String server = null;
    protected String target = null;

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public int doStartTag() throws JspException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        String serverName = this.server == null ? request.getServerName() : this.server;
        String baseTag = this.renderBaseElement(request.getScheme(), serverName, request.getServerPort(), request.getRequestURI());
        JspWriter out = this.pageContext.getOut();
        try {
            out.write(baseTag);
        }
        catch (IOException e) {
            this.pageContext.setAttribute("org.apache.struts.action.EXCEPTION", (Object)e, 2);
            throw new JspException(messages.getMessage("common.io", (Object)e.toString()));
        }
        return 1;
    }

    protected String renderBaseElement(String scheme, String serverName, int port, String uri) {
        StringBuffer tag = new StringBuffer("<base href=\"");
        tag.append(scheme);
        tag.append("://");
        tag.append(serverName);
        if (!("http".equals(scheme) && port == 80 || "https".equals(scheme) && port == 443)) {
            tag.append(":");
            tag.append(port);
        }
        tag.append(uri);
        tag.append("\"");
        if (this.target != null) {
            tag.append(" target=\"");
            tag.append(this.target);
            tag.append("\"");
        }
        if (RequestUtils.isXhtml(this.pageContext)) {
            tag.append(" />");
        } else {
            tag.append(">");
        }
        return tag.toString();
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }
}

