/*
 * Decompiled with CFR 0.152.
 */
package jChatBox.Service;

import jChatBox.Chat.ChatException;
import jChatBox.Chat.Chatroom;
import jChatBox.Chat.ChatroomManager;
import jChatBox.Chat.ChatroomUser;
import jChatBox.Chat.Msg;
import jChatBox.Service.Login;
import jChatBox.Service.UserProcessor;
import jChatBox.Util.Debug;
import jChatBox.Util.XMLConfig;
import jChatBox.Util.XMLPropertyResourceBundle;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class XMLConnector {
    private String _$5663 = "jChatBox.Service.UserLogin";
    private String _$5664 = "UTF-8";
    private String _$5665 = null;
    private String _$5666 = null;
    private String _$5667 = null;
    private String _$5668 = null;
    private UserProcessor _$5669 = null;
    private boolean _$5670 = false;

    public XMLConnector() {
        this.init();
    }

    public void init() {
        this._$5669 = new UserProcessor();
        this.trace(0, this.getClass().getName() + " Initialized");
    }

    public void setXMLEncoding(String string) {
        this._$5664 = string;
    }

    public void setLoginModule(String string) {
        this._$5663 = string;
    }

    public void setXSLGetManager(String string) {
        this._$5665 = string;
    }

    public void setXSLGetChat(String string) {
        this._$5666 = string;
    }

    public void setXSLError(String string) {
        this._$5668 = string;
    }

    public void setXSLGetChatroom(String string) {
        this._$5667 = string;
    }

    public void setDTDEnabled(boolean bl) {
        this._$5670 = bl;
    }

    public String execute(HttpServletRequest httpServletRequest, HttpSession httpSession) {
        try {
            String string = httpServletRequest.getParameter("todo");
            if (string != null && !string.equals("")) {
                if ((string = string.toUpperCase()).equals("MANAGER")) {
                    return this.xmlGetManager();
                }
                if (string.equals("CHATROOM")) {
                    String string2 = httpServletRequest.getParameter("id");
                    if (string2 != null && !string2.equals("")) {
                        int n = -1;
                        try {
                            n = Integer.parseInt(string2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            return this.xmlError(numberFormatException.getMessage(), 5);
                        }
                        return this.xmlGetChatroom(n);
                    }
                    return this.xmlError("id parameter missing", 5);
                }
                if (string.equals("LANGUAGES")) {
                    return this.xmlGetLanguages();
                }
                if (string.equals("RESOURCE")) {
                    String string3 = httpServletRequest.getParameter("language");
                    if (string3 != null && !string3.equals("")) {
                        return this.xmlGetResource(string3);
                    }
                    return this.xmlError("language parameter missing", 5);
                }
                if (string.equals("LOGIN")) {
                    Login login = this.getLoginInstance(this._$5663);
                    if (login != null) {
                        String string4 = login.doLogin(httpServletRequest, httpSession);
                        if (string4 != null) {
                            ChatroomUser chatroomUser = (ChatroomUser)httpSession.getValue(XMLConfig.USERSESSIONID);
                            String string5 = httpServletRequest.getParameter("newonly");
                            if (string5 != null && string5.equalsIgnoreCase("true")) {
                                return this.xmlGetChat(chatroomUser, httpSession);
                            }
                            return this.xmlGetChat(chatroomUser);
                        }
                        return this.xmlError(login.getSysMessage(), 1);
                    }
                    return this.xmlError(this._$5663 + " invalid or not found", 2);
                }
                if (string.equals("REFRESH") || string.equals("CHAT")) {
                    String string6 = this._$5669.execute(httpServletRequest, null, httpSession, null);
                    if (string6 == null) {
                        ChatroomUser chatroomUser = (ChatroomUser)httpSession.getValue(XMLConfig.USERSESSIONID);
                        String string7 = httpServletRequest.getParameter("newonly");
                        if (string7 != null && string7.equalsIgnoreCase("true")) {
                            return this.xmlGetChat(chatroomUser, httpSession);
                        }
                        return this.xmlGetChat(chatroomUser);
                    }
                    return this.xmlError(this._$5669.getSysMessage(httpSession), 3);
                }
                if (string.equals("LOGOUT") || string.equals("QUIT")) {
                    this._$5669.execute(httpServletRequest, null, httpSession, null);
                    return this.xmlGetManager();
                }
                return this.xmlError("Unknown action", 4);
            }
            return this.xmlError("todo parameter missing", 5);
        }
        catch (Exception exception) {
            return this.xmlError("Server Error", 0);
        }
    }

    private String _$5693(Document document) {
        OutputFormat outputFormat = new OutputFormat("XML", this._$5664, true);
        outputFormat.setStandalone(false);
        outputFormat.setPreserveSpace(true);
        outputFormat.setIndent(1);
        outputFormat.setIndenting(true);
        outputFormat.setLineWidth(0);
        outputFormat.setLineSeparator("\n");
        StringWriter stringWriter = new StringWriter();
        XMLSerializer xMLSerializer = new XMLSerializer((Writer)stringWriter, outputFormat);
        try {
            xMLSerializer.asDOMSerializer();
            xMLSerializer.serialize(document);
            stringWriter.close();
        }
        catch (IOException iOException) {
            this.trace(0, this.getClass().getName() + " " + iOException.getMessage());
        }
        return stringWriter.toString();
    }

    protected String xmlError(String string, int n) {
        DOMImplementationImpl dOMImplementationImpl = new DOMImplementationImpl();
        DocumentType documentType = dOMImplementationImpl.createDocumentType("ERROR", null, "error.dtd");
        DocumentImpl documentImpl = null;
        documentImpl = this._$5670 ? new DocumentImpl(documentType) : new DocumentImpl();
        Element element = documentImpl.createElement("ERROR");
        if (this._$5668 != null) {
            ProcessingInstruction processingInstruction = documentImpl.createProcessingInstruction("xml-stylesheet", "type=\"text/xsl\" href=\"" + this._$5668 + "\"");
            documentImpl.appendChild(processingInstruction);
        }
        element.setAttribute("CODE", "" + n);
        element.appendChild(documentImpl.createTextNode(string));
        documentImpl.appendChild(element);
        return this._$5693((Document)documentImpl);
    }

    protected String xmlGetManager() {
        Object object;
        DOMImplementationImpl dOMImplementationImpl = new DOMImplementationImpl();
        DocumentType documentType = dOMImplementationImpl.createDocumentType("MANAGER", null, "manager.dtd");
        DocumentImpl documentImpl = null;
        documentImpl = this._$5670 ? new DocumentImpl(documentType) : new DocumentImpl();
        Element element = documentImpl.createElement("MANAGER");
        if (this._$5665 != null) {
            object = documentImpl.createProcessingInstruction("xml-stylesheet", "type=\"text/xsl\" href=\"" + this._$5665 + "\"");
            documentImpl.appendChild((Node)object);
        }
        object = ChatroomManager.getInstance();
        Vector vector = ((ChatroomManager)object).getChatrooms();
        Chatroom chatroom = null;
        Element element2 = null;
        XMLPropertyResourceBundle xMLPropertyResourceBundle = null;
        int n = 0;
        while (n < vector.size()) {
            chatroom = (Chatroom)vector.elementAt(n);
            xMLPropertyResourceBundle = (XMLPropertyResourceBundle)XMLConfig.RESOURCES.get(chatroom.getParams().getLanguage());
            element2 = documentImpl.createElement("CHATROOM");
            element2.setAttribute("NAME", chatroom.getParams().getName());
            element2.setAttribute("ID", "" + chatroom.getParams().getID());
            element2.setAttribute("SUBJECT", chatroom.getParams().getSubject());
            element2.setAttribute("MAXUSERS", "" + chatroom.getParams().getMaxUsers());
            element2.setAttribute("TOTALUSERS", "" + chatroom.getTotalUsers());
            element2.setAttribute("LANGUAGE", "" + chatroom.getParams().getLanguage());
            element2.setAttribute("DATE", new SimpleDateFormat(xMLPropertyResourceBundle.getString("login.date.format")).format(chatroom.getDate()));
            element.appendChild(element2);
            ++n;
        }
        documentImpl.appendChild(element);
        return this._$5693((Document)documentImpl);
    }

    protected String xmlGetLanguages() throws ChatException {
        DOMImplementationImpl dOMImplementationImpl = new DOMImplementationImpl();
        DocumentType documentType = dOMImplementationImpl.createDocumentType("LANGUAGES", null, "languages.dtd");
        DocumentImpl documentImpl = null;
        documentImpl = this._$5670 ? new DocumentImpl(documentType) : new DocumentImpl();
        Element element = documentImpl.createElement("LANGUAGES");
        element.setAttribute("DEFAULT", "" + XMLConfig.DEFAULTLANGUAGE);
        Element element2 = null;
        Enumeration enumeration = XMLConfig.LANGUAGES.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            element2 = documentImpl.createElement("LANGUAGE");
            element2.setAttribute("NAME", string);
            element.appendChild(element2);
        }
        documentImpl.appendChild(element);
        return this._$5693((Document)documentImpl);
    }

    protected String xmlGetResource(String string) throws ChatException {
        XMLPropertyResourceBundle xMLPropertyResourceBundle = (XMLPropertyResourceBundle)XMLConfig.RESOURCES.get(string);
        DOMImplementationImpl dOMImplementationImpl = new DOMImplementationImpl();
        DocumentType documentType = dOMImplementationImpl.createDocumentType("RESOURCES", null, "resources.dtd");
        DocumentImpl documentImpl = null;
        documentImpl = this._$5670 ? new DocumentImpl(documentType) : new DocumentImpl();
        Element element = documentImpl.createElement("RESOURCES");
        Element element2 = null;
        Element element3 = null;
        Element element4 = null;
        Iterator iterator = xMLPropertyResourceBundle.getKeys();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = xMLPropertyResourceBundle.getString(string2);
            element2 = documentImpl.createElement("ELEMENT");
            element3 = documentImpl.createElement("NAME");
            element3.appendChild(documentImpl.createTextNode(string2));
            element4 = documentImpl.createElement("VALUE");
            element4.appendChild(documentImpl.createTextNode(string3));
            element2.appendChild(element3);
            element2.appendChild(element4);
            element.appendChild(element2);
        }
        documentImpl.appendChild(element);
        return this._$5693((Document)documentImpl);
    }

    protected String xmlGetChatroom(int n) throws ChatException {
        Object object;
        DOMImplementationImpl dOMImplementationImpl = new DOMImplementationImpl();
        DocumentType documentType = dOMImplementationImpl.createDocumentType("CHATROOM", null, "chatroom.dtd");
        DocumentImpl documentImpl = null;
        documentImpl = this._$5670 ? new DocumentImpl(documentType) : new DocumentImpl();
        Element element = documentImpl.createElement("CHATROOM");
        if (this._$5667 != null) {
            object = documentImpl.createProcessingInstruction("xml-stylesheet", "type=\"text/xsl\" href=\"" + this._$5667 + "\"");
            documentImpl.appendChild((Node)object);
        }
        object = ChatroomManager.getInstance();
        Chatroom chatroom = ((ChatroomManager)object).getChatroom(n);
        XMLPropertyResourceBundle xMLPropertyResourceBundle = (XMLPropertyResourceBundle)XMLConfig.RESOURCES.get(chatroom.getParams().getLanguage());
        Object var9_9 = null;
        element.setAttribute("NAME", chatroom.getParams().getName());
        element.setAttribute("ID", "" + chatroom.getParams().getID());
        element.setAttribute("SUBJECT", chatroom.getParams().getSubject());
        element.setAttribute("MAXUSERS", "" + chatroom.getParams().getMaxUsers());
        element.setAttribute("TOTALUSERS", "" + chatroom.getTotalUsers());
        element.setAttribute("LANGUAGE", "" + chatroom.getParams().getLanguage());
        element.setAttribute("DATE", new SimpleDateFormat(xMLPropertyResourceBundle.getString("board.date.format")).format(chatroom.getDate()));
        documentImpl.appendChild(element);
        return this._$5693((Document)documentImpl);
    }

    protected String xmlGetChat(ChatroomUser chatroomUser) throws ChatException {
        Node node;
        DOMImplementationImpl dOMImplementationImpl = new DOMImplementationImpl();
        DocumentType documentType = dOMImplementationImpl.createDocumentType("CHAT", null, "chat.dtd");
        DocumentImpl documentImpl = null;
        documentImpl = this._$5670 ? new DocumentImpl(documentType) : new DocumentImpl();
        if (this._$5666 != null) {
            node = documentImpl.createProcessingInstruction("xml-stylesheet", "type=\"text/xsl\" href=\"" + this._$5666 + "\"");
            documentImpl.appendChild(node);
        }
        node = documentImpl.createElement("CHAT");
        Element element = null;
        Element element2 = null;
        int n = chatroomUser.getParams().getChatroom();
        String string = chatroomUser.getName();
        ChatroomManager chatroomManager = ChatroomManager.getInstance();
        Chatroom chatroom = chatroomManager.getChatroom(n);
        XMLPropertyResourceBundle xMLPropertyResourceBundle = (XMLPropertyResourceBundle)XMLConfig.RESOURCES.get(chatroom.getParams().getLanguage());
        node.setAttribute("ID", "" + n);
        node.setAttribute("PRIVATEMSG", "" + chatroom.getParams().getPrivateStatus());
        node.setAttribute("REFRESH", "" + chatroomUser.getParams().getRefresh());
        Vector vector = chatroom.getChat(string);
        Msg msg = null;
        int n2 = vector.size() - chatroom.getParams().getHistory();
        if (n2 < 0) {
            n2 = 0;
        }
        int n3 = 0;
        element = documentImpl.createElement("MSGS");
        while (n2 < vector.size() && n3 < chatroom.getParams().getHistory()) {
            msg = (Msg)vector.elementAt(n2);
            element2 = documentImpl.createElement("MSG");
            element2.setAttribute("FROM", msg.getFrom());
            element2.setAttribute("TYPE", "" + msg.getType());
            element2.setAttribute("DATE", new SimpleDateFormat(xMLPropertyResourceBundle.getString("chatroom.date.format")).format(msg.getDate()));
            element2.appendChild(documentImpl.createTextNode(msg.getMsg()));
            element.appendChild(element2);
            ++n2;
            ++n3;
        }
        node.appendChild(element);
        Hashtable hashtable = chatroom.getUsers();
        ChatroomUser chatroomUser2 = null;
        Enumeration enumeration = hashtable.keys();
        String string2 = null;
        element = documentImpl.createElement("USERLIST");
        element.setAttribute("CURRENT", "" + chatroom.getTotalUsers());
        element.setAttribute("MAX", "" + chatroom.getParams().getMaxUsers());
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            chatroomUser2 = (ChatroomUser)hashtable.get(string2);
            element2 = documentImpl.createElement("USER");
            element2.setAttribute("NAME", chatroomUser2.getName());
            element.appendChild(element2);
        }
        node.appendChild(element);
        documentImpl.appendChild(node);
        return this._$5693((Document)documentImpl);
    }

    protected String xmlGetChat(ChatroomUser chatroomUser, HttpSession httpSession) throws ChatException {
        Node node;
        DOMImplementationImpl dOMImplementationImpl = new DOMImplementationImpl();
        DocumentType documentType = dOMImplementationImpl.createDocumentType("CHAT", null, "chat.dtd");
        DocumentImpl documentImpl = null;
        documentImpl = this._$5670 ? new DocumentImpl(documentType) : new DocumentImpl();
        if (this._$5666 != null) {
            node = documentImpl.createProcessingInstruction("xml-stylesheet", "type=\"text/xsl\" href=\"" + this._$5666 + "\"");
            documentImpl.appendChild(node);
        }
        node = documentImpl.createElement("CHAT");
        Element element = null;
        Element element2 = null;
        int n = chatroomUser.getParams().getChatroom();
        String string = chatroomUser.getName();
        ChatroomManager chatroomManager = ChatroomManager.getInstance();
        Chatroom chatroom = chatroomManager.getChatroom(n);
        XMLPropertyResourceBundle xMLPropertyResourceBundle = (XMLPropertyResourceBundle)XMLConfig.RESOURCES.get(chatroom.getParams().getLanguage());
        node.setAttribute("ID", "" + n);
        node.setAttribute("PRIVATEMSG", "" + chatroom.getParams().getPrivateStatus());
        node.setAttribute("REFRESH", "" + chatroomUser.getParams().getRefresh());
        Vector vector = chatroom.getChat(string);
        Msg msg = null;
        int n2 = vector.size() - chatroom.getParams().getHistory();
        Integer n3 = (Integer)httpSession.getValue("internallastindex");
        if (n3 != null && n3 > n2) {
            n2 = n3;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        int n4 = 0;
        element = documentImpl.createElement("MSGS");
        while (n2 < vector.size() && n4 < chatroom.getParams().getHistory()) {
            msg = (Msg)vector.elementAt(n2);
            element2 = documentImpl.createElement("MSG");
            element2.setAttribute("FROM", msg.getFrom());
            element2.setAttribute("TYPE", "" + msg.getType());
            element2.setAttribute("DATE", new SimpleDateFormat(xMLPropertyResourceBundle.getString("chatroom.date.format")).format(msg.getDate()));
            element2.appendChild(documentImpl.createTextNode(msg.getMsg()));
            element.appendChild(element2);
            ++n2;
            ++n4;
        }
        n3 = new Integer(n2--);
        httpSession.putValue("internallastindex", (Object)n3);
        node.appendChild(element);
        Hashtable hashtable = chatroom.getUsers();
        ChatroomUser chatroomUser2 = null;
        Enumeration enumeration = hashtable.keys();
        String string2 = null;
        element = documentImpl.createElement("USERLIST");
        element.setAttribute("CURRENT", "" + chatroom.getTotalUsers());
        element.setAttribute("MAX", "" + chatroom.getParams().getMaxUsers());
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            chatroomUser2 = (ChatroomUser)hashtable.get(string2);
            element2 = documentImpl.createElement("USER");
            element2.setAttribute("NAME", chatroomUser2.getName());
            element.appendChild(element2);
        }
        node.appendChild(element);
        documentImpl.appendChild(node);
        return this._$5693((Document)documentImpl);
    }

    protected Login getLoginInstance(String string) {
        Login login;
        block5: {
            login = null;
            boolean bl = false;
            try {
                Class<?> clazz;
                Class<?> clazz2 = clazz = Class.forName(string);
                while (clazz2 != null) {
                    if (clazz2.getName().equals("jChatBox.Service.Login")) {
                        bl = true;
                        break;
                    }
                    clazz2 = clazz2.getSuperclass();
                }
                if (!bl) {
                    this.trace(0, this.getClass().getName() + " Error : Login implementation not found in " + string + " hierarchy");
                    break block5;
                }
                Class[] classArray = new Class[]{};
                Constructor<?> constructor = clazz.getConstructor(classArray);
                login = (Login)constructor.newInstance(null);
                this.trace(0, "" + this.getClass().getName() + " " + string + " loaded");
            }
            catch (Exception exception) {
                this.trace(0, this.getClass().getName() + " Error : " + string + " : " + exception.getMessage());
            }
        }
        return login;
    }

    protected void trace(int n, String string) {
        Debug.log(n, this.getClass().getName(), string);
    }
}

