/*
 * Decompiled with CFR 0.152.
 */
package jChatBox.Chat.Transcript;

import jChatBox.Chat.ChatException;
import jChatBox.Chat.Chatroom;
import jChatBox.Chat.Msg;
import jChatBox.Chat.Transcript.Dump;
import jChatBox.Util.XMLConfig;
import jChatBox.Util.XMLPropertyResourceBundle;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

public class TextDump
extends Dump {
    public TextDump() {
        this._id = "text_dump";
        this._name = "TEXT";
        this._description = "Text file dump.";
    }

    public void init() {
    }

    public String process(Chatroom chatroom, String string) throws ChatException {
        if (chatroom != null && string != null) {
            XMLPropertyResourceBundle xMLPropertyResourceBundle = (XMLPropertyResourceBundle)XMLConfig.RESOURCES.get(chatroom.getParams().getLanguage());
            RandomAccessFile randomAccessFile = null;
            try {
                int n;
                randomAccessFile = new RandomAccessFile(XMLConfig.LOGFOLDER + XMLConfig.SEPARATOR + string, "rw");
                String string2 = "";
                Vector vector = chatroom.getChat();
                Msg msg = null;
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(xMLPropertyResourceBundle.getString("chatroom.date.format"));
                string2 = "TRANSCRIPT generated on : " + simpleDateFormat.format(new Date()) + "\n";
                randomAccessFile.writeBytes(string2);
                string2 = "CHATROOM : " + chatroom.getParams().getName() + "/" + chatroom.getParams().getSubject() + "/" + chatroom.getParams().getLanguage() + "/" + simpleDateFormat.format(chatroom.getDate()) + "\n";
                randomAccessFile.writeBytes(string2);
                String string3 = "MODERATORS : ";
                Vector vector2 = chatroom.getParams().getModerators();
                if (vector2 != null && vector2.size() > 0) {
                    n = 0;
                    while (n < vector2.size()) {
                        string3 = string3 + vector2.elementAt(n) + ",";
                        ++n;
                    }
                    string3 = string3.substring(0, string3.length() - 1);
                }
                randomAccessFile.writeBytes(string3 + "\n\n");
                n = 0;
                while (n < vector.size()) {
                    msg = (Msg)vector.elementAt(n);
                    string2 = simpleDateFormat.format(msg.getDate()) + " : " + msg.getFrom() + " TO " + msg.getTo() + " - " + msg.getMsg() + "\n";
                    randomAccessFile.writeBytes(string2);
                    ++n;
                }
            }
            catch (IOException iOException) {
                throw new ChatException(iOException.getMessage());
            }
            finally {
                try {
                    if (randomAccessFile != null) {
                        randomAccessFile.close();
                        this.trace(1, "Chatroom " + chatroom.getParams().getName() + " transcripted as " + string + "(TextDump)");
                    }
                }
                catch (IOException iOException) {
                    this.trace(1, "Cannot close transcript : " + iOException.getMessage());
                }
                return null;
            }
        }
        this.trace(1, "Cannot transcript : Chatroom or filename missing");
        throw new ChatException("Chatroom or filename missing");
    }
}

