/*
 * Decompiled with CFR 0.152.
 */
package jchatbox.client;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.List;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;
import jchatbox.client.LoginPanel;
import jchatbox.client.gui.jcbLabel;
import jchatbox.client.gui.jcbPanel;
import jchatbox.client.jcbApplet;
import jchatbox.client.local.ChatroomDesc;
import jchatbox.client.local.Communication;
import jchatbox.client.local.Msg;
import jchatbox.client.util.ChatException;
import jchatbox.client.util.Conf;
import jchatbox.client.util.Debug;
import jchatbox.client.util.RefreshThread;

public class ChatPanel
extends jcbPanel {
    jcbLabel label_message = new jcbLabel();
    jcbLabel label_name = new jcbLabel();
    TextField textfield_message = new TextField();
    Button button_send = new Button();
    TextArea textarea_chat = new TextArea(Conf.WELCOME1 + Conf.WELCOME2);
    List list_users = new List();
    Button button_refresh = new Button();
    Button button_logout = new Button();
    private String _$334 = "ALL";
    private Container _$335 = null;
    private ChatroomDesc _$336 = null;
    private int _$200 = -1;
    private boolean _$337 = true;
    private RefreshThread _$338 = null;
    private LoginPanel _$199 = null;

    public ChatPanel(Container container, ChatroomDesc chatroomDesc, LoginPanel loginPanel) {
        this._$199 = loginPanel;
        this._$336 = chatroomDesc;
        this._$335 = container;
        this._$200 = ((jcbApplet)container).getRefreshRate();
        if (this._$200 > 0) {
            this._$337 = false;
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.setLayout(null);
        this.setBackground(new Color(Integer.parseInt(Conf.CHATPANEL_COLOR, 16)));
        this.setImage(Conf.CHATPANEL_PICTURE);
        Font font = new Font(Conf.CHATPANEL_FONTNAME, Conf.CHATPANEL_FONTSTYLE, Conf.CHATPANEL_FONTSIZE);
        this.setFont(font);
        this.label_message.setForeground(new Color(Integer.parseInt(Conf.CHATPANEL_MESSAGE_LABEL_COLOR, 16)));
        this.label_message.setText(Conf.CHATPANEL_MESSAGE_LABEL);
        this.label_message.setBounds(new Rectangle(Conf.CHATPANEL_MESSAGE_LABEL_X, Conf.CHATPANEL_MESSAGE_LABEL_Y, Conf.CHATPANEL_MESSAGE_LABEL_W, Conf.CHATPANEL_MESSAGE_LABEL_H));
        this.label_name.setForeground(new Color(Integer.parseInt(Conf.CHATPANEL_NAME_LABEL_COLOR, 16)));
        this.label_name.setText(Conf.CHATPANEL_NAME_LABEL + this._$336.getName());
        this.label_name.setBounds(new Rectangle(Conf.CHATPANEL_NAME_LABEL_X, Conf.CHATPANEL_NAME_LABEL_Y, Conf.CHATPANEL_NAME_LABEL_W, Conf.CHATPANEL_NAME_LABEL_H));
        this.textfield_message.setBackground(new Color(Integer.parseInt(Conf.CHATPANEL_MESSAGE_TEXTFIELD_BGCOLOR, 16)));
        this.textfield_message.setForeground(new Color(Integer.parseInt(Conf.CHATPANEL_MESSAGE_TEXTFIELD_COLOR, 16)));
        this.textfield_message.setBounds(new Rectangle(Conf.CHATPANEL_MESSAGE_TEXTFIELD_X, Conf.CHATPANEL_MESSAGE_TEXTFIELD_Y, Conf.CHATPANEL_MESSAGE_TEXTFIELD_W, Conf.CHATPANEL_MESSAGE_TEXTFIELD_H));
        this.textfield_message.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                ChatPanel.this.textfield_message_keyPressed(keyEvent);
            }
        });
        this.textarea_chat.setEditable(false);
        this.textarea_chat.setBackground(new Color(Integer.parseInt(Conf.CHATPANEL_MESSAGES_TEXTAREA_BGCOLOR, 16)));
        this.textarea_chat.setForeground(new Color(Integer.parseInt(Conf.CHATPANEL_MESSAGES_TEXTAREA_COLOR, 16)));
        this.textarea_chat.setBounds(new Rectangle(Conf.CHATPANEL_MESSAGES_TEXTAREA_X, Conf.CHATPANEL_MESSAGES_TEXTAREA_Y, Conf.CHATPANEL_MESSAGES_TEXTAREA_W, Conf.CHATPANEL_MESSAGES_TEXTAREA_H));
        this.list_users.setBackground(new Color(Integer.parseInt(Conf.CHATPANEL_USERS_LIST_BGCOLOR, 16)));
        this.list_users.setForeground(new Color(Integer.parseInt(Conf.CHATPANEL_USERS_LIST_COLOR, 16)));
        this.list_users.setBounds(new Rectangle(Conf.CHATPANEL_USERS_LIST_X, Conf.CHATPANEL_USERS_LIST_Y, Conf.CHATPANEL_USERS_LIST_W, Conf.CHATPANEL_USERS_LIST_H));
        this.list_users.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ChatPanel.this.list_users_itemStateChanged(itemEvent);
            }
        });
        this.button_send.setBackground(new Color(Integer.parseInt(Conf.CHATPANEL_SEND_BUTTON_BGCOLOR, 16)));
        this.button_send.setForeground(new Color(Integer.parseInt(Conf.CHATPANEL_SEND_BUTTON_COLOR, 16)));
        this.button_send.setLabel(Conf.CHATPANEL_SEND_BUTTON_LABEL);
        this.button_send.setBounds(new Rectangle(Conf.CHATPANEL_SEND_BUTTON_X, Conf.CHATPANEL_SEND_BUTTON_Y, Conf.CHATPANEL_SEND_BUTTON_W, Conf.CHATPANEL_SEND_BUTTON_H));
        this.button_send.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChatPanel.this.button_send_actionPerformed(actionEvent);
            }
        });
        this.button_refresh.setBackground(new Color(Integer.parseInt(Conf.CHATPANEL_REFRESH_BUTTON_BGCOLOR, 16)));
        this.button_refresh.setForeground(new Color(Integer.parseInt(Conf.CHATPANEL_REFRESH_BUTTON_COLOR, 16)));
        this.button_refresh.setLabel(Conf.CHATPANEL_REFRESH_BUTTON_LABEL);
        this.button_refresh.setBounds(new Rectangle(Conf.CHATPANEL_REFRESH_BUTTON_X, Conf.CHATPANEL_REFRESH_BUTTON_Y, Conf.CHATPANEL_REFRESH_BUTTON_W, Conf.CHATPANEL_REFRESH_BUTTON_H));
        this.button_refresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChatPanel.this.button_refresh_actionPerformed(actionEvent);
            }
        });
        this.button_logout.setBackground(new Color(Integer.parseInt(Conf.CHATPANEL_LOGOUT_BUTTON_BGCOLOR, 16)));
        this.button_logout.setForeground(new Color(Integer.parseInt(Conf.CHATPANEL_LOGOUT_BUTTON_COLOR, 16)));
        this.button_logout.setLabel(Conf.CHATPANEL_LOGOUT_BUTTON_LABEL);
        this.button_logout.setBounds(new Rectangle(Conf.CHATPANEL_LOGOUT_BUTTON_X, Conf.CHATPANEL_LOGOUT_BUTTON_Y, Conf.CHATPANEL_LOGOUT_BUTTON_W, Conf.CHATPANEL_LOGOUT_BUTTON_H));
        this.button_logout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChatPanel.this.button_logout_actionPerformed(actionEvent);
            }
        });
        this.add((Component)this.textarea_chat, null);
        this.add((Component)this.list_users, null);
        this.add((Component)this.button_send, null);
        this.add((Component)this.button_refresh, null);
        this.add((Component)this.textfield_message, null);
        this.add((Component)this.label_message, null);
        this.add((Component)this.label_name, null);
        this.add((Component)this.button_logout, null);
    }

    void button_send_actionPerformed(ActionEvent actionEvent) {
        String string = this.textfield_message.getText();
        String string2 = "ALL";
        if (string != null && !string.equals("")) {
            this._$423(string, string2);
            this.textfield_message.setText("");
        }
    }

    void textfield_message_keyPressed(KeyEvent keyEvent) {
        String string;
        if (keyEvent.getKeyCode() == 10 && (string = this.textfield_message.getText()) != null && !string.equals("")) {
            this._$423(string, this._$334);
            this.textfield_message.setText("");
        }
    }

    private void _$423(String string, String string2) {
        Communication communication = Communication.getInstance(Conf.URL);
        try {
            this._$336 = communication.doChat(this._$336, string, string2);
            if (this._$337) {
                this._$200 = Integer.parseInt(this._$336.getRefresh());
            }
            this.updateUserList(this._$336.getUserList());
            this.updateMsgs(this._$336.getMsgs());
        }
        catch (ChatException chatException) {
            this._$338.disable();
            this._$226(1, this.getClass().getName(), "Send error : " + chatException.getMessage());
            this.textarea_chat.append("\n----- " + chatException.getMessage());
            this.textarea_chat.append("\n----- " + Conf.PLEASELOGOUT);
            this.textarea_chat.repaint();
        }
        catch (Exception exception) {
            this._$338.disable();
            this._$226(1, this.getClass().getName(), "Send error : " + exception.getMessage());
            this.textarea_chat.append("\n----- " + Conf.INVALIDRESPONSE);
            this.textarea_chat.append("\n----- " + Conf.PLEASELOGOUT);
            this.textarea_chat.repaint();
        }
    }

    void button_refresh_actionPerformed(ActionEvent actionEvent) {
        this.performRefresh();
    }

    public void performRefresh() {
        Communication communication = Communication.getInstance(Conf.URL);
        try {
            this._$336 = communication.doRefresh(this._$336);
            if (this._$337) {
                this._$200 = Integer.parseInt(this._$336.getRefresh());
            }
            this.updateUserList(this._$336.getUserList());
            this.updateMsgs(this._$336.getMsgs());
        }
        catch (ChatException chatException) {
            this._$338.disable();
            this._$226(1, this.getClass().getName(), "Refresh error : " + chatException.getMessage());
            this.textarea_chat.append("\n----- " + chatException.getMessage());
            this.textarea_chat.append("\n----- " + Conf.PLEASELOGOUT);
            this.textarea_chat.repaint();
        }
        catch (Exception exception) {
            this._$338.disable();
            this._$226(1, this.getClass().getName(), "Refresh error : " + exception.getMessage());
            this.textarea_chat.append("\n----- " + Conf.INVALIDRESPONSE);
            this.textarea_chat.append("\n----- " + Conf.PLEASELOGOUT);
            this.textarea_chat.repaint();
        }
    }

    void button_logout_actionPerformed(ActionEvent actionEvent) {
        this.performLogout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performLogout() {
        LoginPanel loginPanel = this._$199;
        Communication communication = Communication.getInstance(Conf.URL);
        try {
            this._$200 = -1;
            this._$338.disable();
            Vector vector = communication.doLogout();
            loginPanel.setRooms(vector);
            loginPanel.updateChatRooms();
        }
        catch (ChatException chatException) {
            this._$226(1, this.getClass().getName(), "Logout error : " + chatException.getMessage());
        }
        catch (Exception exception) {
            this._$226(1, this.getClass().getName(), "Logout error : " + exception.getMessage());
        }
        finally {
            this._$338.disable();
            communication.resetSession();
            this._$335.remove(this);
            this._$335.add(loginPanel);
            loginPanel.setSize(Conf.APPLET_WIDTH, Conf.APPLET_HEIGHT);
        }
    }

    void list_users_itemStateChanged(ItemEvent itemEvent) {
        String string = this.list_users.getSelectedItem();
        if (!(string == null || string.equals("") || string.equals(Conf.CHATPANEL_USERS_LIST_SEPARATOR) || string.equals(Conf.SEPARATOR2) || string.equals(Conf.RIGHT))) {
            if (string.equals(Conf.CHATPANEL_USERS_LIST_TITLE)) {
                this.textarea_chat.append(Conf.PREPRIVMSG + Conf.CHATPANEL_MESSAGES_TEXTAREA_ALL);
                this._$334 = "ALL";
            } else {
                this.textarea_chat.append(Conf.PREPRIVMSG + Conf.CHATPANEL_MESSAGES_TEXTAREA_PRIVATE + string);
                this._$334 = string;
            }
        }
    }

    public synchronized void updateUserList(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        this.list_users.removeAll();
        this.list_users.add(Conf.CHATPANEL_USERS_LIST_TITLE);
        this.list_users.add(Conf.CHATPANEL_USERS_LIST_SEPARATOR);
        int n = 0;
        while (n < vector.size()) {
            string = (String)vector.elementAt(n);
            this.list_users.add(string);
            ++n;
        }
        this.list_users.add(Conf.SEPARATOR2);
        this.list_users.add(Conf.RIGHT);
    }

    public synchronized void updateMsgs(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer();
        Msg msg = null;
        String string = null;
        int n = 0;
        while (n < vector.size()) {
            msg = (Msg)vector.elementAt(n);
            string = msg.getType() == 1 ? "*** " + msg.getMsg() + Conf.CHATPANEL_MESSAGES_TEXTAREA_JOIN : (msg.getType() == 2 ? "*** " + msg.getMsg() + Conf.CHATPANEL_MESSAGES_TEXTAREA_QUIT : (msg.getType() == 3 ? ">" + msg.getFrom() + "< " + msg.getMsg() : "<" + msg.getFrom() + "> " + msg.getMsg()));
            this.textarea_chat.append("\n" + string);
            ++n;
        }
    }

    public void setCurrentRoom(ChatroomDesc chatroomDesc) {
        this._$336 = chatroomDesc;
    }

    public int getRefreshRate() {
        return this._$200;
    }

    public void setRefreshRate(int n) {
        this._$200 = n;
    }

    public void activateRefresh(int n) {
        if (this._$200 > 0) {
            this._$338 = new RefreshThread(this);
            this._$338.start();
            this._$226(5, this.getClass().getName(), "Refresh activated");
        } else if (n > 0) {
            this._$200 = n;
            this._$338 = new RefreshThread(this);
            this._$338.start();
            this._$226(5, this.getClass().getName(), "Auto Refresh activated");
        } else {
            this._$226(5, this.getClass().getName(), "Refresh not activated");
        }
    }

    private void _$226(int n, String string, String string2) {
        Debug.log(n, string + ":" + string2);
    }
}

