import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import cc.gammasoft.date.*;
import javax.swing.event.*;
import java.util.*;
import java.sql.*;
import javax.swing.table.*;
public class TestDatePicker extends JPanel implements ChangeListener{
        TestDatePicker() {
                initTest();
                initSQLDatePanel();
                initSelectionTrackingPanel();
                initFormatPanel();
                initPropertiesPanel();
                initJTablePanel();
        }
        private void initJTablePanel() {
          DefaultTableModel model=new DefaultTableModel(new String[][] {{"JBuilder 4","1","$1499.99",null,null},
                                                                                                                                        {"Sybase 11","1","$2499.99",null,""},
                                                                                                                                        {"Gammasoft Date Combo","1","$99.99","2003-05-11",""},
                                                                                                                                        {"SUSE 7 Professional","1","$199.99","",""}},
                                                                                                        new String[] {"Product","Qty","Price($)","Ship Date","Exp. Date"});

          JTable tableProducts=new JTable(model);
      JScrollPane pane=new JScrollPane();
      DatePicker datePicker=new DatePicker();

      pane.getViewport().add(tableProducts, null);
      tableProducts.getColumnModel().getColumn(4).setCellRenderer(datePicker.getCellRenderer());
      tableProducts.getColumnModel().getColumn(3).setCellRenderer(datePicker.getCellRenderer());
      tableProducts.getColumnModel().getColumn(3).setCellEditor(datePicker.getCellEditor());
      tableProducts.getColumnModel().getColumn(4).setCellEditor(datePicker.getCellEditor());

           tabs.add(pane,"JTable");

        }
        private void initTest() {
                panelMain.setLayout(new BorderLayout());
                panelMain.add(tabs);
                JPanel panelPicker=new JPanel();
                panelPicker.setLayout(new GridBagLayout());
                GridBagConstraints g=new GridBagConstraints();
                g.gridx=0;
                g.gridy=0;
                g.weightx=1.0;
                panelPicker.add(datePicker,g);

                g=new GridBagConstraints();
                g.gridx=1;
                g.gridy=0;
                g.weightx=1.0;
                panelPicker.add(monthView,g);
                panelMain.add(panelPicker,BorderLayout.NORTH);


                setLayout(new BorderLayout());
                add(panelMain);

                datePicker.addChangeListener(this);

        }
        private void initSQLDatePanel() {

                /* set SQL Related components */
                JPanel panelSQL=new JPanel();
                JPanel panelSQLDateButtons=new JPanel();
                JButton setSQLDate=new JButton("Set SQL Date");
                JButton setTimeStamp=new JButton("Set TimeStamp");
                JButton getSQLDate=new JButton("Get SQL Date");
                JButton getTimeStamp=new JButton("Get TimeStamp");

                panelSQLDateButtons.setLayout(new GridLayout(0,1));
                panelSQLDateButtons.add(setSQLDate);
                panelSQLDateButtons.add(getSQLDate);
                panelSQLDateButtons.add(setTimeStamp);
                panelSQLDateButtons.add(getTimeStamp);

                panelSQL.setLayout(new BorderLayout());
                panelSQL.add(panelSQLDateButtons,BorderLayout.EAST);
                panelSQL.add(txtSQL,BorderLayout.NORTH);
                tabs.add(panelSQL,"SQL");

                setSQLDate.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent event) {
                                datePicker.getDateModel().setSQLDate(txtSQL.getText());
                        }
                });

                getSQLDate.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent event) {
                                txtSQL.setText((datePicker.getDateModel().getSQLDateValue()==null?"null":datePicker.getDateModel().getSQLDateValue()));
                        }
                });

                setTimeStamp.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent event) {
                                datePicker.getDateModel().setTimestamp(txtSQL.getText());
                        }
                });

                getTimeStamp.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent event) {
                                txtSQL.setText((datePicker.getDateModel().getTimestampValue()==null?"null":datePicker.getDateModel().getTimestampValue()));
                        }
                });

        }

        private void initSelectionTrackingPanel() {
                JPanel panelSelectionTracking=new JPanel();
                panelSelectionTracking.setLayout(new BorderLayout());

                JPanel panelSelections=new JPanel();
                panelSelections.add(chkEnableSelection);
                panelSelections.add(chkEnableReselection);
                panelSelectionTracking.add(panelSelections,BorderLayout.NORTH);

                JScrollPane scrollList=new JScrollPane();
                scrollList.getViewport().add(txtList);
                panelSelectionTracking.add(scrollList);

                tabs.add(panelSelectionTracking,"Selection Tracking");

                chkEnableSelection.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent event){
                                datePicker.getDateModel().enableSelectionTracking(chkEnableSelection.isSelected());
                                monthView.getDateModel().enableSelectionTracking(chkEnableSelection.isSelected());
                        }
                });

                chkEnableReselection.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent event){
                                datePicker.getDateModel().enableReselection(chkEnableReselection.isSelected());
                                monthView.getDateModel().enableReselection(chkEnableReselection.isSelected());
                        }
                });


        }

        private void initFormatPanel() {
                JPanel panelFormat=new JPanel();
                panelFormat.setLayout(new BorderLayout());

                final JTextField txtFormat=new JTextField(10);
                final JTextField txtLocale=new JTextField(10);
                txtFormat.setText("dd.MM.yyyy");
                txtLocale.setText("de");
                JButton buttonApply=new JButton("Apply");
                final JCheckBox chkLongMonthNames=new JCheckBox("Long Month Names");
                final JCheckBox chkLongWeekDayNames=new JCheckBox("Long Week Day Names");

                JPanel panelName=new JPanel();
                panelName.add(chkLongMonthNames);
                panelName.add(chkLongWeekDayNames);

                panelFormat.add(panelName,BorderLayout.NORTH);



                chkLongMonthNames.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent event){
                                datePicker.setMonthNames(datePicker.getDateFormat(),(chkLongMonthNames.isSelected()?MonthYearPanel.LONG_MONTH_NAME:MonthYearPanel.SHORT_MONTH_NAME));
                                monthView.setMonthNames(datePicker.getDateFormat(),(chkLongMonthNames.isSelected()?MonthYearPanel.LONG_MONTH_NAME:MonthYearPanel.SHORT_MONTH_NAME));
                        }
                });

                chkLongWeekDayNames.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent event){
                                datePicker.setWeekDayNames(datePicker.getDateFormat(),(chkLongWeekDayNames.isSelected()?WeekDayPanel.LONG_WEEKDAY_NAME:WeekDayPanel.SHORT_WEEKDAY_NAME));
                                monthView.setWeekDayNames(datePicker.getDateFormat(),(chkLongWeekDayNames.isSelected()?WeekDayPanel.LONG_WEEKDAY_NAME:WeekDayPanel.SHORT_WEEKDAY_NAME));

                        }
                });

                buttonApply.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent event){
                                datePicker.setDateFormat(new java.text.SimpleDateFormat(txtFormat.getText(),new java.util.Locale(txtLocale.getText())));
                                monthView.setDateFormat(new java.text.SimpleDateFormat(txtFormat.getText(),new java.util.Locale(txtLocale.getText())));

                        }
                });

                txtFormat.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent event){
                                datePicker.setDateFormat(new java.text.SimpleDateFormat(txtFormat.getText()));
                                monthView.setDateFormat(new java.text.SimpleDateFormat(txtFormat.getText()));

                        }
                });

                JPanel panelCenter=new JPanel();
                panelCenter.add(new JLabel("Format "));
                panelCenter.add(txtFormat);
                panelCenter.add(new JLabel("Locale "));
                panelCenter.add(txtLocale);
                panelCenter.add(buttonApply);

                panelFormat.add(panelCenter);

                tabs.add(panelFormat,"Format");

        }

        private void initPropertiesPanel() {
                JPanel panelProperties=new JPanel();
                final JComboBox comboColors=new JComboBox();
                final JComboBox comboBorders=new JComboBox();
                final JComboBox comboFonts=new JComboBox();

                JButton buttonSetbackground=new JButton("Set Background");
                JButton buttonSetForeground=new JButton("Set Foreground");
                JButton buttonSetFont=new JButton("Set Font");
                JButton buttonSetBorder=new JButton("Set Border");
                JButton buttonSetHighLightColor=new JButton("Set High Light Color");

                comboFonts.addItem(new PickerFonts("Arial",Font.PLAIN,13));
                comboFonts.addItem(new PickerFonts("Arial",Font.PLAIN,12));
                comboFonts.addItem(new PickerFonts("Arial",Font.PLAIN,11));
                comboFonts.addItem(new PickerFonts("Arial",Font.ITALIC,14));
                comboFonts.addItem(new PickerFonts("Dialog",Font.BOLD+Font.ITALIC,12));
                comboFonts.addItem(new PickerFonts("Arial",Font.PLAIN,22));
                comboFonts.addItem(new PickerFonts("Dialog",Font.ITALIC,14));
                comboFonts.addItem(new PickerFonts("Arial",Font.PLAIN,10));
                comboFonts.setRenderer(new ListCellRenderer() {
                        private JLabel label=new JLabel();
                        public Component getListCellRendererComponent(JList list,Object value,int index, boolean isSelected,boolean cellHasFocus) {
                           label.setText("");
                           if(value!=null) {
                                label.setText(value.toString());
                                label.setFont(((PickerFonts)value).getFont());
                           }
                           return label;
                        }
                });
                comboColors.addItem(new PickerColors("Black",Color.black));
                comboColors.addItem(new PickerColors("Red",Color.red));
                comboColors.addItem(new PickerColors("Blue",Color.blue));
                comboColors.addItem(new PickerColors("Green",Color.green));
                comboColors.addItem(new PickerColors("Yellow",Color.yellow));
                comboColors.addItem(new PickerColors("White",Color.white));
                comboColors.addItem(new PickerColors("Light Gray",Color.LIGHT_GRAY));

                comboColors.setRenderer(new ListCellRenderer() {
                        private JLabel label=new JLabel();
                        public Component getListCellRendererComponent(JList list,Object value,int index, boolean isSelected,boolean cellHasFocus) {
                           label.setText("");
                           if(value!=null) {
                                label.setText(value.toString());
                                label.setForeground(((PickerColors)value).getColor());
                           }
                           return label;

                        }
                });
                comboBorders.addItem(new PickerBorders("Line -Light Gray",new LineBorder(Color.lightGray,1)));
                comboBorders.addItem(new PickerBorders("Etched",new EtchedBorder()));
                comboBorders.addItem(new PickerBorders("SoftBevelBorder -LOWERED",new SoftBevelBorder(SoftBevelBorder.LOWERED)));
                comboBorders.addItem(new PickerBorders("SoftBevelBorder -RAISED",new SoftBevelBorder(SoftBevelBorder.RAISED)));
                comboBorders.addItem(new PickerBorders("Line -Blue",new LineBorder(Color.blue,2)));
                comboBorders.addItem(new PickerBorders("null",null));
                comboBorders.setRenderer(new ListCellRenderer() {
                        private JLabel label=new JLabel();
                        public Component getListCellRendererComponent(JList list,Object value,int index, boolean isSelected,boolean cellHasFocus) {
                           label.setText("");
                           if(value!=null) {
                                label.setText(value.toString());
                                label.setBorder(((PickerBorders)value).getBorder());
                           }
                           return label;

                        }
                });

                buttonSetbackground.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent event){
                                if(chkWeekDayLabels.isSelected()) {
                                        datePicker.getMonthView().getWeekDayPanel().setBackground(((PickerColors)comboColors.getSelectedItem()).getColor());
                                        monthView.getWeekDayPanel().setBackground(((PickerColors)comboColors.getSelectedItem()).getColor());
                                }
                                if(chkDateLabelsC.isSelected()) {
                                        datePicker.getMonthView().getDatePanel().setCurrentMonthBackground(((PickerColors)comboColors.getSelectedItem()).getColor());
                                        monthView.getDatePanel().setCurrentMonthBackground(((PickerColors)comboColors.getSelectedItem()).getColor());
                                }
                                if(chkDateLabelsP.isSelected()) {
                                        datePicker.getMonthView().getDatePanel().setPreviousNextMonthBackground(((PickerColors)comboColors.getSelectedItem()).getColor());
                                        monthView.getDatePanel().setPreviousNextMonthBackground(((PickerColors)comboColors.getSelectedItem()).getColor());
                                }
                                if(chkMonthEditor.isSelected()) {
                                        datePicker.getMonthView().getMonthYearPanel().getMonthSpinner().setBackground(((PickerColors)comboColors.getSelectedItem()).getColor());
                                        monthView.getMonthYearPanel().getMonthSpinner().setBackground(((PickerColors)comboColors.getSelectedItem()).getColor());
                                }
                                if(chkYearEditor.isSelected()) {
                                        datePicker.getMonthView().getMonthYearPanel().getYearSpinner().setBackground(((PickerColors)comboColors.getSelectedItem()).getColor());
                                        monthView.getMonthYearPanel().getYearSpinner().setBackground(((PickerColors)comboColors.getSelectedItem()).getColor());
                                }
                                if(chkToday.isSelected()) {
                                        datePicker.getMonthView().getStatusPanel().setBackground(((PickerColors)comboColors.getSelectedItem()).getColor());
                                        monthView.getStatusPanel().setBackground(((PickerColors)comboColors.getSelectedItem()).getColor());
                                }


                        }
                });

                buttonSetForeground.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent event){
                                if(chkWeekDayLabels.isSelected()) {
                                        datePicker.getMonthView().getWeekDayPanel().setForeground(((PickerColors)comboColors.getSelectedItem()).getColor());
                                        monthView.getWeekDayPanel().setForeground(((PickerColors)comboColors.getSelectedItem()).getColor());
                                }
                                if(chkDateLabelsC.isSelected()) {
                                        datePicker.getMonthView().getDatePanel().setCurrentMonthForeground(((PickerColors)comboColors.getSelectedItem()).getColor());
                                        monthView.getDatePanel().setCurrentMonthForeground(((PickerColors)comboColors.getSelectedItem()).getColor());
                                }
                                if(chkDateLabelsP.isSelected()) {
                                        datePicker.getMonthView().getDatePanel().setPreviousNextMonthForeground(((PickerColors)comboColors.getSelectedItem()).getColor());
                                        monthView.getDatePanel().setPreviousNextMonthForeground(((PickerColors)comboColors.getSelectedItem()).getColor());
                                }
                                if(chkMonthEditor.isSelected()) {
                                        datePicker.getMonthView().getMonthYearPanel().getMonthSpinner().setForeground(((PickerColors)comboColors.getSelectedItem()).getColor());
                                        monthView.getMonthYearPanel().getMonthSpinner().setForeground(((PickerColors)comboColors.getSelectedItem()).getColor());
                                }
                                if(chkYearEditor.isSelected()) {
                                        datePicker.getMonthView().getMonthYearPanel().getYearSpinner().setForeground(((PickerColors)comboColors.getSelectedItem()).getColor());
                                        monthView.getMonthYearPanel().getYearSpinner().setForeground(((PickerColors)comboColors.getSelectedItem()).getColor());
                                }
                                if(chkToday.isSelected()) {
                                        datePicker.getMonthView().getStatusPanel().setForeground(((PickerColors)comboColors.getSelectedItem()).getColor());
                                        monthView.getStatusPanel().setForeground(((PickerColors)comboColors.getSelectedItem()).getColor());
                                }

                        }
                });

                buttonSetBorder.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent event){
                                if(chkWeekDayLabels.isSelected()) {
                                        datePicker.getMonthView().getWeekDayPanel().setBorder(((PickerBorders)comboBorders.getSelectedItem()).getBorder());
                                        monthView.getWeekDayPanel().setBorder(((PickerBorders)comboBorders.getSelectedItem()).getBorder());
                                }
                                if(chkDateLabelsC.isSelected()) {
                                        datePicker.getMonthView().getDatePanel().setCurrentMonthBorder(((PickerBorders)comboBorders.getSelectedItem()).getBorder());
                                        monthView.getDatePanel().setCurrentMonthBorder(((PickerBorders)comboBorders.getSelectedItem()).getBorder());
                                }
                                if(chkDateLabelsP.isSelected()) {
                                        datePicker.getMonthView().getDatePanel().setPreviousNextMonthBorder(((PickerBorders)comboBorders.getSelectedItem()).getBorder());
                                        monthView.getDatePanel().setPreviousNextMonthBorder(((PickerBorders)comboBorders.getSelectedItem()).getBorder());
                                }
                                if(chkMonthEditor.isSelected()) {
                                        datePicker.getMonthView().getMonthYearPanel().getMonthSpinner().setBorder(((PickerBorders)comboBorders.getSelectedItem()).getBorder());
                                        monthView.getMonthYearPanel().getMonthSpinner().setBorder(((PickerBorders)comboBorders.getSelectedItem()).getBorder());
                                }
                                if(chkYearEditor.isSelected()) {
                                        datePicker.getMonthView().getMonthYearPanel().getYearSpinner().setBorder(((PickerBorders)comboBorders.getSelectedItem()).getBorder());
                                        monthView.getMonthYearPanel().getYearSpinner().setBorder(((PickerBorders)comboBorders.getSelectedItem()).getBorder());
                                }

                        }
                });

                buttonSetFont.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent event){
                                if(chkWeekDayLabels.isSelected()) {
                                        datePicker.getMonthView().getWeekDayPanel().setFont(((PickerFonts)comboFonts.getSelectedItem()).getFont());
                                        monthView.getWeekDayPanel().setFont(((PickerFonts)comboFonts.getSelectedItem()).getFont());
                                }
                                if(chkDateLabelsC.isSelected()) {
                                        datePicker.getMonthView().getDatePanel().setCurrentMonthFont(((PickerFonts)comboFonts.getSelectedItem()).getFont());
                                        monthView.getDatePanel().setCurrentMonthFont(((PickerFonts)comboFonts.getSelectedItem()).getFont());
                                }
                                if(chkDateLabelsP.isSelected()) {
                                        datePicker.getMonthView().getDatePanel().setPreviousNextMonthFont(((PickerFonts)comboFonts.getSelectedItem()).getFont());
                                        monthView.getDatePanel().setPreviousNextMonthFont(((PickerFonts)comboFonts.getSelectedItem()).getFont());
                                }
                                if(chkMonthEditor.isSelected()) {
                                        datePicker.getMonthView().getMonthYearPanel().getMonthEditor().setFont(((PickerFonts)comboFonts.getSelectedItem()).getFont());
                                        monthView.getMonthYearPanel().getMonthEditor().setFont(((PickerFonts)comboFonts.getSelectedItem()).getFont());
                                }
                                if(chkYearEditor.isSelected()) {
                                        datePicker.getMonthView().getMonthYearPanel().getYearEditor().setFont(((PickerFonts)comboFonts.getSelectedItem()).getFont());
                                        monthView.getMonthYearPanel().getYearEditor().setFont(((PickerFonts)comboFonts.getSelectedItem()).getFont());
                                }
                                if(chkToday.isSelected()) {
                                        datePicker.getMonthView().getStatusPanel().setFont(((PickerFonts)comboFonts.getSelectedItem()).getFont());
                                        monthView.getStatusPanel().setFont(((PickerFonts)comboFonts.getSelectedItem()).getFont());
                                }

                        }
                });

                buttonSetHighLightColor.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent event){
                                datePicker.getMonthView().getDatePanel().setHightLightColor(((PickerColors)comboColors.getSelectedItem()).getColor());
                                monthView.getDatePanel().setHightLightColor(((PickerColors)comboColors.getSelectedItem()).getColor());
                        }
                });


                chkHideToday.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent event){
                                datePicker.getMonthView().getStatusPanel().setVisible(chkHideToday.isSelected());
                                monthView.getStatusPanel().setVisible(chkHideToday.isSelected());
                        }
                });

                chkDateSelectionShape.setSelected(true);
                chkDateSelectionShape.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent event){
                                datePicker.getMonthView().getDatePanel().setDateSelectionShape((chkDateSelectionShape.isSelected()?DateLabel.OVAL:DateLabel.RECT));
                                monthView.getDatePanel().setDateSelectionShape((chkDateSelectionShape.isSelected()?DateLabel.OVAL:DateLabel.RECT));
                        }
                });

                JPanel panelNorth=new JPanel();
                panelNorth.setLayout(new GridLayout(0,2));
                panelNorth.add(chkWeekDayLabels);
                panelNorth.add(chkDateLabelsC);
                panelNorth.add(chkDateLabelsP);
                panelNorth.add(chkToday);
                panelNorth.add(chkYearEditor);
                panelNorth.add(chkMonthEditor);
                panelNorth.add(chkHideToday);
                panelNorth.add(chkDateSelectionShape);


                chkHideToday.setSelected(true);

                JPanel panelCenter=new JPanel();
                panelCenter.setLayout(new GridLayout(0,2));
                panelCenter.add(new JLabel("Color"));
                panelCenter.add(comboColors);
                panelCenter.add(new JLabel("Fonts"));
                panelCenter.add(comboFonts);
                panelCenter.add(new JLabel("Borders"));
                panelCenter.add(comboBorders);

                panelProperties.setLayout(new BorderLayout());
                panelProperties.add(panelNorth,BorderLayout.NORTH);
                JPanel panelButtons=new JPanel();
                panelButtons.setLayout(new GridLayout(0,1));
                panelButtons.add(buttonSetbackground);
                panelButtons.add(buttonSetForeground);
                panelButtons.add(buttonSetBorder);
                panelButtons.add(buttonSetFont);
                panelButtons.add(buttonSetHighLightColor);


                panelProperties.add(panelCenter);
                panelProperties.add(panelButtons,BorderLayout.EAST);

                JPanel panelSouth=new JPanel();
                panelSouth.setBorder(new TitledBorder("Popup Buttons"));


				DefaultPickerButton buttonDefault=new DefaultPickerButton();
				buttonDefault.addActionListener(new ActionListener() {
					public void actionPerformed(ActionEvent event){
						datePicker.setPopupButton(new DefaultPickerButton());
						TestDatePicker.this.revalidate();

					}
				});

				Button1 button1=new Button1();
				button1.addActionListener(new ActionListener() {
					public void actionPerformed(ActionEvent event){
						datePicker.setPopupButton(new Button1());
					}
				});


				Button2 button2=new Button2();
				button2.addActionListener(new ActionListener() {
					public void actionPerformed(ActionEvent event){
						datePicker.setPopupButton(new Button2());
					}
				});

                panelSouth.add(buttonDefault);
                panelSouth.add(button1);
                panelSouth.add(button2);
                panelProperties.add(panelSouth,BorderLayout.SOUTH);

                tabs.add(panelProperties,"Colors,Borders");
        }
        public void stateChanged(ChangeEvent e) {
                txtList.setText("");
                java.util.TreeSet set=datePicker.getDateModel().getSelectedValues();
                Iterator it=set.iterator();
                while(it.hasNext()) {
                        Calendar calendar=(Calendar)it.next();
                        txtList.append((new java.sql.Date(calendar.getTime().getTime()).toString())+"\n");
                }
        }

        public static void main(String args[]) {
                TestDatePicker test=new TestDatePicker();
                JFrame frame=new JFrame();
                frame.setTitle("DatePicker Demo");
                frame.addWindowListener(new WindowAdapter() {
                        public void windowClosing(WindowEvent event){
                                System.exit(0);
                        }
                });

                frame.getContentPane().add(test);
                frame.setSize(650,500);
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                Dimension windowSize = frame.getSize();
                frame.setLocation(screenSize.width/2 - (windowSize.width/2),screenSize.height/2 - (windowSize.height/2));
                frame.show();

        }

        DatePicker datePicker=new DatePicker(new java.text.SimpleDateFormat("MM/dd/yyyy hh:mm:ss"));
        MonthView monthView=new MonthView();
        JPanel panelMain=new JPanel();
        JTabbedPane tabs=new JTabbedPane();

        private JTextArea txtList=new JTextArea();
        private JTextField txtSQL=new JTextField();
        private	JCheckBox chkEnableSelection=new JCheckBox("Enable Selection Tracking");
        private	JCheckBox chkEnableReselection=new JCheckBox("Enable re-selection");

        private JCheckBox chkWeekDayLabels=new JCheckBox("Week Day Labels");
        private JCheckBox chkDateLabelsC=new JCheckBox("Date Labels (Current Month)");
        private JCheckBox chkDateLabelsP=new JCheckBox("Date Labels (Previous and Next Month)");
        private JCheckBox chkYearEditor=new JCheckBox("Year Spinner ");
        private JCheckBox chkMonthEditor=new JCheckBox("Month Spinner");
        private JCheckBox chkToday=new JCheckBox("Today Panel");
        private JCheckBox chkHideToday=new JCheckBox("Today Panel Visible");
        private JCheckBox chkDateSelectionShape=new JCheckBox("Oval highlight");



  private class Button1 extends PickerButton {
	  Button1() {
		  setText("V");
	  }
  }

  private class Button2 extends PickerButton {
	  Button2() {
		  setText("My Button");
	  }
	  public Dimension getPreferredSize() {
		  return new Dimension(100,30);
	  }

  }


  private class PickerFonts {
    String fontName;
    int fontType;
    int fontSize;
    PickerFonts(String fontName,int fontType,int fontSize) {
      this.fontName=fontName;
      this.fontType=fontType;
      this.fontSize=fontSize;
    }
    public Font getFont() {
      return new Font(fontName,fontType,fontSize);
    }
    public String toString() {
      return fontName+" "+fontSize;
    }
  }


  private class PickerColors {
    Color c;
    String name;
    PickerColors(String name,Color c) {
      this.name=name;
      this.c=c;
    }
    public String toString() {
      return name;
    }
    public Color getColor() {
      return c;
    }
  }

  private class PickerBorders {
    Border border;
    String name;
    PickerBorders(String name,Border border) {
      this.name=name;
      this.border=border;
    }
    public String toString() {
      return name;
    }
    public Border getBorder() {
      return border;
    }
  }

}

