/*
 * Decompiled with CFR 0.152.
 */
package cc.gammasoft.date;

import cc.gammasoft.date.DateModel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Calendar;
import javax.swing.JLabel;
import javax.swing.border.Border;

public class DateLabel
extends JLabel {
    private boolean mouseEntered = false;
    private boolean isCurrentMonthValue = true;
    private boolean isSelectedValue = false;
    private boolean isCurrentValue = false;
    private LabelMouseAdapter labelMouseAdapter = new LabelMouseAdapter();
    private boolean isToday;
    private Color currentMonthForeground = Color.BLACK;
    private Color currentMonthBackground = Color.WHITE;
    private Border currentMonthBorder;
    private Font currentMonthFont = new Font("Arial", 0, 11);
    private Color previousNextMonthForeground = Color.GRAY;
    private Color previousNextMonthBackground = Color.WHITE;
    private Border previousNextMonthBorder;
    private Font previousNextMonthFont = new Font("Arial", 2, 11);
    public static final int RECT = 0;
    public static final int OVAL = 1;
    private int selectionDrawType = 1;
    private Color highLightColor = Color.DARK_GRAY;
    public static final float ALPHA = 0.5f;
    private float alpha = 0.5f;
    private Composite c = AlphaComposite.getInstance(3, this.alpha);

    DateLabel() {
        this.initDayLabel();
    }

    public void setValue(Calendar labelValue) {
        if (labelValue == null) {
            throw new RuntimeException("Null Calendar");
        }
        this.isToday = DateModel.TODAY.get(1) == labelValue.get(1) && DateModel.TODAY.get(2) == labelValue.get(2) && DateModel.TODAY.get(5) == labelValue.get(5);
        this.setText(String.valueOf(labelValue.get(5)));
    }

    private void initDayLabel() {
        this.addMouseListener(this.labelMouseAdapter);
        this.setHorizontalAlignment(0);
        this.setOpaque(true);
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paintComponent(g);
        g2.setComposite(this.c);
        if (this.mouseEntered) {
            g2.setColor(this.highLightColor);
            if (this.selectionDrawType == 1) {
                g2.fillOval(2, 1, this.getWidth() - 6, this.getHeight() - 3);
            } else {
                g2.fillRect(1, 1, this.getWidth() - 1, this.getHeight() - 1);
            }
        }
        if (this.isToday) {
            g2.setColor(Color.RED);
            g2.drawOval(2, 1, this.getWidth() - 6, this.getHeight() - 3);
        }
        if (this.isSelectedValue) {
            g2.setColor(Color.RED);
            g2.drawLine(1, 1, this.getWidth() - 1, this.getHeight() - 1);
            g2.drawLine(1, this.getHeight() - 1, this.getWidth() - 1, 1);
        }
        if (this.isCurrentValue) {
            g2.setColor(this.highLightColor);
            if (this.selectionDrawType == 1) {
                g2.fillOval(2, 1, this.getWidth() - 6, this.getHeight() - 3);
            } else {
                g2.fillRect(1, 1, this.getWidth() - 1, this.getHeight() - 1);
            }
        }
        this.mouseEntered = false;
    }

    public void setCurrentMonthValue(boolean value) {
        this.isCurrentMonthValue = value;
        if (this.isCurrentMonthValue) {
            this.setForeground(this.currentMonthForeground);
            if (this.currentMonthBackground != null) {
                this.setBackground(this.currentMonthBackground);
            }
            if (this.currentMonthBorder != null) {
                this.setBorder(this.currentMonthBorder);
            }
            this.setFont(this.currentMonthFont);
        } else {
            this.setForeground(this.previousNextMonthForeground);
            if (this.previousNextMonthBackground != null) {
                this.setBackground(this.previousNextMonthBackground);
            }
            if (this.previousNextMonthBorder != null) {
                this.setBorder(this.previousNextMonthBorder);
            }
            this.setFont(this.previousNextMonthFont);
        }
    }

    public boolean isCurrentMonthValue() {
        return this.isCurrentMonthValue;
    }

    public void setSelectedValue(boolean value) {
        this.isSelectedValue = value;
    }

    public boolean isSelectedValue() {
        return this.isSelectedValue();
    }

    public boolean isCurrentValue() {
        return this.isCurrentValue;
    }

    public void setCurrentValue(boolean value) {
        this.isCurrentValue = value;
    }

    public void setCurrentMonthForeground(Color c) {
        this.currentMonthForeground = c;
    }

    public Color getCurrentMonthForeground() {
        return this.currentMonthForeground;
    }

    public void setCurrentMonthBackground(Color c) {
        this.currentMonthBackground = c;
    }

    public Color getCurrentMonthBackground() {
        return this.currentMonthBackground;
    }

    public void setCurrentMonthFont(Font f) {
        this.currentMonthFont = f;
    }

    public Font getCurrentMonthFont() {
        return this.currentMonthFont;
    }

    public void setCurrentMonthBorder(Border b) {
        this.currentMonthBorder = b;
    }

    public Border getCurrentMonthBorder() {
        return this.currentMonthBorder;
    }

    public void setPreviousNextMonthForeground(Color c) {
        this.previousNextMonthForeground = c;
    }

    public Color getPreviousNextMonthForeground() {
        return this.previousNextMonthForeground;
    }

    public void setPreviousNextMonthBackground(Color c) {
        this.previousNextMonthBackground = c;
    }

    public Color getPreviousNextMonthBackground() {
        return this.previousNextMonthBackground;
    }

    public void setPreviousNextMonthFont(Font f) {
        this.previousNextMonthFont = f;
    }

    public Font getPreviousNextMonthFont() {
        return this.previousNextMonthFont;
    }

    public void setPreviousNextMonthBorder(Border b) {
        this.previousNextMonthBorder = b;
    }

    public Border getPreviousNextMonthBorder() {
        return this.previousNextMonthBorder;
    }

    public void setDateSelectionShape(int type) {
        this.selectionDrawType = type;
    }

    public void setHightLightColor(Color color) {
        this.highLightColor = color;
    }

    private class LabelMouseAdapter
    extends MouseAdapter {
        private LabelMouseAdapter() {
        }

        public void mouseEntered(MouseEvent event) {
            DateLabel.this.mouseEntered = true;
            DateLabel.this.repaint();
        }

        public void mouseExited(MouseEvent event) {
            DateLabel.this.mouseEntered = false;
            DateLabel.this.repaint();
        }
    }
}

