/*
 * Decompiled with CFR 0.152.
 */
class Sticky {
    private int istickyhits;
    private long expireTime;
    private String address;
    private ServiceClass sc;

    public Sticky(ServiceClass serviceClass, String string, long l) {
        this.sc = serviceClass;
        this.address = string;
        this.expireTime = l;
        this.istickyhits = 1;
    }

    public Sticky(ServiceClass serviceClass, String string, int n) {
        this.sc = serviceClass;
        this.address = string;
        this.expireTime = System.currentTimeMillis() + (long)(n * 60000);
        this.istickyhits = 1;
    }

    public String getAddress() {
        return this.address;
    }

    public long getExpireTime() {
        return this.expireTime;
    }

    public ServiceClass getServiceClass() {
        return this.sc;
    }

    public boolean checkExpire() {
        long l = System.currentTimeMillis();
        return l > this.expireTime;
    }

    public void incStickyHits() {
        ++this.istickyhits;
    }

    public void expireSticky() {
        this.expireTime = System.currentTimeMillis();
    }

    public String toString() {
        long l = System.currentTimeMillis();
        return "Sticky: " + this.sc.getName() + " / " + this.address + " / Hits: " + this.istickyhits + " / TTL:" + (this.expireTime - l) / 1000L + "s";
    }
}

