<%
Dim strMessageText, textLength, textStart, textEnd

Sub displayAppointment(inMessage)

  On Error Resume Next

  writeTitle DATETEXT & "/" & TIMETEXT & COLONSPACETEXT
  rwbc FormatDateTime(inMessage.Fields("{0220060000000000C000000000000046}0x820D"), vbLongDate)
  rwbc FormatDateTime(inMessage.Fields("{0220060000000000C000000000000046}0x820D"), vbLongTime)
  writeTitle DURATIONTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields("{0220060000000000C000000000000046}0x8213")) & " " & MINTEXT
  writeTitle SUBJECTTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Subject)
  writeTitle LOCATIONTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields("{0220060000000000C000000000000046}0x8208"))
  writeTitle DETAILSTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Text)

End Sub

Sub displayContact(inMessage)

  On Error Resume Next

  writeTitle NAMETEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Subject)

  writeTitle TITLETEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields(&H3A17001F))

  writeTitle COMPANYTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields(&H3A16001F))

  writeTitle EMAILTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields("0x8084", "0420060000000000C000000000000046"))

  writeTitle BUSINESSPHONETEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields(&H3A08001F))

  writeTitle MOBILETEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields(&H3A1C001F))

  writeTitle BUSINESSADDRESSTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields("0x8045", "0420060000000000C000000000000046"))
  rwbc displayEncode(inMessage.Fields("0x8046", "0420060000000000C000000000000046"))
  rwbc displayEncode(inMessage.Fields("0x8047", "0420060000000000C000000000000046"))
  rwbc displayEncode(inMessage.Fields("0x8048", "0420060000000000C000000000000046"))
  rwbc displayEncode(inMessage.Fields("0x8049", "0420060000000000C000000000000046"))

End Sub

Sub displayMessage(inMessage)

  writeLinkWParams "MSRA.asp", ACTIONSTEXT, ""

  ' Are we in Sent Items?
  If checkTopFolder(inMessage.FolderID, 3) Then
    display = TO1TEXT & COLONSPACETEXT & getMessageRecipient(inMessage)
  Else
    display = FROMTEXT & COLONSPACETEXT & getMessageSender(inMessage)
  End If

  display = displayEncode(display)
  rwbc display

  display = SUBJECTTEXT & COLONSPACETEXT & inMessage.Subject
  display = displayEncode(display)
  rwbc display

  If inMessage.Importance = 2 Then rwbc IMPORTANCETEXT & COLONSPACETEXT & HIGHTEXT

  writeUnderline

  strMessageText = getMessageText(inMessage)
  textLength = Len(strMessageText) : textEnd = 0
  getTextStartAndEnd
  display = Mid(strMessageText, textStart, (textEnd - textStart) + 1)

  rwbc displayEncode(display)

  If textEnd < textLength Then
    pg = pg + 1
    writeLinkWParams "MSR.asp", NEXTTEXT, "PG"
  End If

End Sub

Sub displayNote(inMessage)

  writeTitle NOTETEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields(&H1000001F))

End Sub

Sub displayPost(inMessage)

  writeTitle FROMTEXT & COLONSPACETEXT
  display = getMessageSender(inMessage)
  rwbc displayEncode(display)

  writeTitle SUBJECTTEXT & COLONSPACETEXT
  display = inMessage.Subject
  rwbc displayEncode(display)

  writeUnderline

  strMessageText = getMessageText(inMessage)
  textLength = Len(strMessageText) : textEnd = 0
  getTextStartAndEnd
  display = Mid(strMessageText, textStart, (textEnd - textStart) + 1)

  rwbc displayEncode(display)

  If textEnd < textLength Then
    pg = pg + 1
    writeLinkWParams "PSR.asp", NEXTTEXT, "PG"
  End If

End Sub

Sub displayTask(inMessage)

  On Error Resume Next

  writeTitle SUBJECTTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Subject)

  writeTitle IMPORTANCETEXT & COLONSPACETEXT
  lImportance = inMessage.Fields(&H00170003)
  Select Case lImportance
    Case 0
      rwbc displayEncode(LOWTEXT)
    Case 1
      rwbc displayEncode(NORMALTEXT)
    Case 2
      rwbc displayEncode(HIGHTEXT)
  End Select

  writeTitle STATUSTEXT & COLONSPACETEXT
  lStatus = inMessage.Fields("0x8101", "0320060000000000C000000000000046")
  Select Case lStatus
    Case 0
      rwbc displayEncode(OPENTEXT)
    Case 1
      rwbc displayEncode(INPROGRESSTEXT)
    Case 2
      rwbc displayEncode(COMPLETEDTEXT)
    Case 3
      rwbc displayEncode(WAITINGONSOMEONEELSETEXT)
    Case 4
      rwbc displayEncode(DEFERREDTEXT)
  End Select

  writeTitle PERCENTCOMPLETETEXT & COLONSPACETEXT
  lPercentComplete = inMessage.Fields("0x8102", "0320060000000000C000000000000046")
  rwbc 100 * lPercentComplete & "%"

  writeTitle STARTDATETEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields("0x8104", "0320060000000000C000000000000046"))

  writeTitle DUEDATETEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields("0x8105", "0320060000000000C000000000000046"))

  writeTitle DETAILSTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Text)

End Sub

Sub getTextStartAndEnd

  For locN = 1 To pg
    textStart = textEnd + 1
    If textEnd + (MAXPAGESIZE - 1) < textLength Then
      textEnd = textStart + (MAXPAGESIZE - 1)
      locSpaceFound = False
      For locO = textEnd To (textStart + 1) Step - 1
        locChar = Mid(strMessageText, locO, 1)
        If (locChar = " ") Or (locChar = vbCrLf) Or (locChar = vbTab) Then
          locSpaceFound = True
          Exit For
        End If
      Next
      If locSpaceFound Then textEnd = locO
    Else
      textEnd = textLength
    End If
  Next

End Sub
%>
