VERSION 5.00
Begin VB.Form Form1 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "RFS Server Sample"
   ClientHeight    =   4500
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   6180
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4500
   ScaleWidth      =   6180
   StartUpPosition =   3  'Windows Default
   Begin VB.TextBox Text1 
      Height          =   285
      Left            =   4560
      TabIndex        =   12
      Text            =   "7007"
      Top             =   1320
      Width           =   855
   End
   Begin VB.TextBox ActiveConnections 
      Height          =   285
      Left            =   5400
      TabIndex        =   10
      Text            =   "0"
      Top             =   2160
      Width           =   615
   End
   Begin VB.CommandButton pbDummy 
      Caption         =   "Command3"
      Height          =   375
      Left            =   5160
      TabIndex        =   7
      Top             =   240
      Visible         =   0   'False
      Width           =   615
   End
   Begin VB.ListBox List3 
      Height          =   1815
      Left            =   120
      TabIndex        =   6
      Top             =   2520
      Width           =   5895
   End
   Begin VB.CommandButton Command2 
      Caption         =   "Stop Server"
      Height          =   375
      Left            =   1800
      TabIndex        =   5
      Top             =   1680
      Width           =   1335
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Start Server"
      Height          =   375
      Left            =   120
      TabIndex        =   4
      Top             =   1680
      Width           =   1575
   End
   Begin VB.Timer Timer1 
      Interval        =   1000
      Left            =   3720
      Top             =   0
   End
   Begin VB.ListBox List2 
      Height          =   1230
      Left            =   1800
      TabIndex        =   1
      Top             =   360
      Width           =   2055
   End
   Begin VB.ListBox List1 
      Height          =   1230
      Left            =   120
      TabIndex        =   0
      Top             =   360
      Width           =   1575
   End
   Begin VB.Label Label5 
      Caption         =   "Port:"
      Height          =   255
      Left            =   4080
      TabIndex        =   11
      Top             =   1320
      Width           =   375
   End
   Begin VB.Label Label4 
      Caption         =   "Active connections:"
      Height          =   255
      Left            =   3720
      TabIndex        =   9
      Top             =   2160
      Width           =   1575
   End
   Begin VB.Label Label1 
      Caption         =   "Server Activity"
      Height          =   255
      Left            =   120
      TabIndex        =   8
      Top             =   2160
      Width           =   1095
   End
   Begin VB.Label Label3 
      Caption         =   "Devices (rights)"
      Height          =   255
      Left            =   1800
      TabIndex        =   3
      Top             =   120
      Width           =   1335
   End
   Begin VB.Label Label2 
      Caption         =   "Users"
      Height          =   255
      Left            =   120
      TabIndex        =   2
      Top             =   120
      Width           =   1335
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Function CheckError(nCode As Integer) As Boolean
    Dim sError As String
    sError = Space(1024) 'allocate memory
    If nCode <> 0 Then
       Call RFS_GetErrorText(nCode, sError)
       Call MsgBox(ToString(sError))
       CheckError = False
    Else
       CheckError = True
    End If
End Function

Function LoadServerSecurity() As Boolean
  ' Load users, devices and users access rights
  Dim nRet As Integer
  If CheckError(RFS_UserAdd("adm", "adm")) And _
     CheckError(RFS_UserAdd("usr", "usr")) And _
     CheckError(RFS_DeviceAdd("CDRIVE", "C:")) And _
     CheckError(RFS_DeviceAdd("TEMP", "C:\Temp")) And _
     CheckError(RFS_SetUserDeviceRights("adm", "CDRIVE", "RWCLD")) And _
     CheckError(RFS_SetUserDeviceRights("adm", "TEMP", "RWL")) And _
     CheckError(RFS_SetUserDeviceRights("usr", "CDRIVE", "RL")) And _
     CheckError(RFS_SetUserDeviceRights("usr", "TEMP", "WL")) Then
     LoadServerSecurity = True
  Else
     LoadServerSecurity = False
  End If
End Function

Private Sub Form_Load()
  'assign our own window message procedure (WindowProc) for pbDummy button
  lpPrevWndProc = SetWindowLong(Form1.pbDummy.hwnd, GWL_WNDPROC, AddressOf WindowProc)
  ' Set 12-symbols registration code
  RFS_SetRegistrationCode ("A1B2C3D4E5F6")
  ' Dispaly server status
  Form1.Caption = "RFS - Not running"
  ' Load devices, users and users right
  Call LoadServerSecurity
  ' Dispaly users list
  Dim sUser As String
  sUser = String(1024, vbNullChar)
  If (RFS_EnumUsersFirst(sUser) = 0) Then
     Do
        List1.AddItem (ToString(sUser))
     Loop While RFS_EnumUsersNext(sUser) = 0
  End If
End Sub

Private Sub Command1_Click()
 ' StartServer
  If CheckError(RFS_StartServer(CInt(Text1), Form1.pbDummy.hwnd, WM_RFSEVENT)) Then
      
  End If
End Sub

Private Sub Command2_Click()
  ' StopServer
  If CheckError(RFS_StopServer()) Then
     
  End If
End Sub

Private Sub List1_Click()
   ' Dispaly devices and rights for selected user
   List2.Clear
   Dim sUser As String, sDevice  As String, sPath  As String, sRights As String
   sDevice = String(1024, vbNullChar)
   sPath = String(1024, vbNullChar)
   sRights = String(1024, vbNullChar)
   sUser = List1
   If (RFS_EnumDevicesFirst(sDevice, sPath) = 0) Then
      Do
        If (RFS_GetUserDeviceRights(sUser, sDevice, sRights) = 0) Then
            List2.AddItem (ToString(sDevice) + " (" + ToString(sRights) + ")")
        End If
        Loop While RFS_EnumDevicesNext(sDevice, sPath) = 0
      End If
End Sub

Private Sub Timer1_Timer()
  ' Check current server state
  If RFS_IsRunning() = 1 Then
      Form1.Caption = "RFS - Running"
      ActiveConnections = RFS_ActiveConnections()
  Else
      Form1.Caption = "RFS - Not running"
  End If
End Sub
