/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.validation;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarDescription;
import org.apache.xerces.xni.grammars.XMLGrammarPool;

public class XMLGrammarPoolImpl
implements XMLGrammarPool {
    protected Hashtable fGrammars = new Hashtable();
    protected Hashtable fGrammarsNS = new Hashtable();
    protected Grammar fNoNSGrammar = null;

    public Grammar[] retrieveInitialGrammarSet(String grammarType) {
        return null;
    }

    public void cacheGrammars(String grammarType, Grammar[] grammars) {
    }

    public Grammar retrieveGrammar(XMLGrammarDescription desc) {
        return null;
    }

    public void putGrammar(String rootElement, Grammar grammar) {
        this.fGrammars.put(rootElement, grammar);
    }

    public void putGrammarNS(String namespace, Grammar grammar) {
        if (namespace != null) {
            this.fGrammarsNS.put(namespace, grammar);
        } else {
            this.fNoNSGrammar = grammar;
        }
    }

    public Grammar getGrammar(String rootElement) {
        return (Grammar)this.fGrammars.get(rootElement);
    }

    public Grammar getGrammarNS(String namespace) {
        return namespace == null ? this.fNoNSGrammar : (Grammar)this.fGrammarsNS.get(namespace);
    }

    public Grammar removeGrammar(String rootElement) {
        if (this.fGrammars.contains(rootElement)) {
            return (Grammar)this.fGrammars.remove(rootElement);
        }
        return null;
    }

    public Grammar removeGrammarNS(String namespace) {
        if (namespace == null) {
            Grammar tempGrammar = this.fNoNSGrammar;
            this.fNoNSGrammar = null;
            return tempGrammar;
        }
        if (this.fGrammarsNS.contains(namespace)) {
            return (Grammar)this.fGrammarsNS.remove(namespace);
        }
        return null;
    }

    public boolean containsGrammar(String rootElement) {
        return this.fGrammars.containsKey(rootElement);
    }

    public boolean containsGrammarNS(String namespace) {
        return this.fGrammarsNS.containsKey(namespace);
    }

    public Grammar[] getGrammars() {
        int grammarSize = this.fGrammars.size();
        Grammar[] toReturn = new Grammar[grammarSize];
        int pos = 0;
        Enumeration grammars = this.fGrammars.elements();
        while (grammars.hasMoreElements()) {
            toReturn[pos++] = (Grammar)grammars.nextElement();
        }
        return toReturn;
    }

    public Grammar[] getGrammarsNS() {
        int grammarSize = this.fGrammarsNS.size() + (this.fNoNSGrammar == null ? 0 : 1);
        Grammar[] toReturn = new Grammar[grammarSize];
        int pos = 0;
        Enumeration grammarsNS = this.fGrammarsNS.elements();
        while (grammarsNS.hasMoreElements()) {
            toReturn[pos++] = (Grammar)grammarsNS.nextElement();
        }
        if (pos < grammarSize) {
            toReturn[pos++] = this.fNoNSGrammar;
        }
        return toReturn;
    }
}

