/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import java.math.BigDecimal;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.xs.TypeValidator;
import org.apache.xerces.impl.validation.ValidationContext;

public class DecimalDV
extends TypeValidator {
    public short getAllowedFacets() {
        return 4088;
    }

    public Object getActualValue(String content, ValidationContext context) throws InvalidDatatypeValueException {
        try {
            return new BigDecimal(DecimalDV.stripPlusIfPresent(content));
        }
        catch (Exception nfe) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{content, "decimal"});
        }
    }

    public boolean isEqual(Object value1, Object value2) {
        if (!(value1 instanceof BigDecimal) || !(value2 instanceof BigDecimal)) {
            return false;
        }
        return ((BigDecimal)value1).compareTo((BigDecimal)value2) == 0;
    }

    public int compare(Object value1, Object value2) {
        return ((BigDecimal)value1).compareTo((BigDecimal)value2);
    }

    public int getTotalDigits(Object value) {
        return ((BigDecimal)value).movePointRight(((BigDecimal)value).scale()).toString().length() - (((BigDecimal)value).signum() < 0 ? 1 : 0);
    }

    public int getFractionDigits(Object value) {
        return ((BigDecimal)value).scale();
    }

    private static String stripPlusIfPresent(String value) {
        String strippedPlus = value;
        if (value.length() >= 2 && value.charAt(0) == '+' && value.charAt(1) != '-') {
            strippedPlus = value.substring(1);
        }
        return strippedPlus;
    }
}

