/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.dtd;

import java.util.Hashtable;
import java.util.Locale;
import org.apache.xerces.impl.dv.dtd.AbstractDatatypeValidator;
import org.apache.xerces.impl.dv.dtd.DatatypeMessageProvider;
import org.apache.xerces.impl.dv.dtd.DatatypeValidator;
import org.apache.xerces.impl.dv.dtd.InvalidDatatypeFacetException;
import org.apache.xerces.impl.dv.dtd.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.dtd.StatefullDatatypeValidator;
import org.apache.xerces.util.XMLChar;

public class IDDatatypeValidator
extends AbstractDatatypeValidator
implements StatefullDatatypeValidator {
    private DatatypeValidator fBaseValidator;
    private Object fNullValue;
    private DatatypeMessageProvider fMessageProvider = new DatatypeMessageProvider();
    private Hashtable fTableOfId;
    private Locale fLocale;

    public IDDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public IDDatatypeValidator(DatatypeValidator base, Hashtable facets, boolean derivedByList) throws InvalidDatatypeFacetException {
    }

    public void validate(String content, Object state) throws InvalidDatatypeValueException {
        boolean status = XMLChar.isValidName(content);
        if (!status) {
            InvalidDatatypeValueException error = new InvalidDatatypeValueException(content);
            error.setKeyIntoReporter("IDInvalid");
            throw error;
        }
        if (!this.addId(content)) {
            InvalidDatatypeValueException error = new InvalidDatatypeValueException(content);
            error.setKeyIntoReporter("IDNotUnique");
            throw error;
        }
    }

    public void validate() throws InvalidDatatypeValueException {
    }

    public void initialize(Object tableOfIDs) {
        this.fTableOfId = (Hashtable)tableOfIDs;
    }

    public int compare(String content1, String content2) {
        return -1;
    }

    public Hashtable getFacets() {
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("clone() is not supported in " + this.getClass().getName());
    }

    public Object getInternalStateInformation() {
        return this.fTableOfId;
    }

    private void setBasetype(DatatypeValidator base) {
        this.fBaseValidator = base;
    }

    private boolean addId(String content) {
        if (this.fTableOfId.containsKey(content)) {
            return false;
        }
        if (this.fNullValue == null) {
            this.fNullValue = new Object();
        }
        try {
            this.fTableOfId.put(content, this.fNullValue);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    private String getErrorString(int major, int minor, Object[] args) {
        return this.fMessageProvider.formatMessage(this.fLocale, null, null);
    }
}

