/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv;

import java.util.Hashtable;
import org.apache.xerces.impl.dv.DVFactoryException;
import org.apache.xerces.impl.dv.XSListSimpleType;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.dv.XSUnionSimpleType;

public abstract class SchemaDVFactory {
    private static final String DEFAULT_FACTORY_CLASS = "org.apache.xerces.impl.dv.xs.SchemaDVFactoryImpl";
    private static String fFactoryClass = null;
    private static SchemaDVFactory fFactoryInstance = null;

    public static final void setFactoryClass(String factoryClass) throws DVFactoryException {
        if (fFactoryInstance != null) {
            throw new DVFactoryException("Cannot set the class name now. The class name '" + fFactoryClass + "' is already used.");
        }
        String string = DEFAULT_FACTORY_CLASS;
        synchronized (string) {
            if (fFactoryInstance != null) {
                throw new DVFactoryException("Cannot set the class name now. The class name '" + fFactoryClass + "' is already used.");
            }
            fFactoryClass = factoryClass;
        }
    }

    public static final SchemaDVFactory getInstance() throws DVFactoryException {
        if (fFactoryInstance != null) {
            return fFactoryInstance;
        }
        String string = DEFAULT_FACTORY_CLASS;
        synchronized (string) {
            if (fFactoryInstance != null) {
                SchemaDVFactory schemaDVFactory = fFactoryInstance;
                return schemaDVFactory;
            }
            try {
                if (fFactoryClass == null) {
                    fFactoryClass = DEFAULT_FACTORY_CLASS;
                }
                fFactoryInstance = (SchemaDVFactory)Class.forName(fFactoryClass).newInstance();
            }
            catch (ClassNotFoundException e1) {
                throw new DVFactoryException("Schema factory class " + fFactoryClass + " not found.");
            }
            catch (IllegalAccessException e2) {
                throw new DVFactoryException("Schema factory class " + fFactoryClass + " found but cannot be loaded.");
            }
            catch (InstantiationException e3) {
                throw new DVFactoryException("Schema factory class " + fFactoryClass + " loaded but cannot be instantiated (no empty public constructor?).");
            }
            catch (ClassCastException e4) {
                throw new DVFactoryException("Schema factory class " + fFactoryClass + " does not extend from SchemaDVFactory.");
            }
        }
        return fFactoryInstance;
    }

    protected SchemaDVFactory() {
    }

    public abstract XSSimpleType getBuiltInType(String var1);

    public abstract Hashtable getBuiltInTypes();

    public abstract XSSimpleType createTypeRestriction(String var1, String var2, short var3, XSSimpleType var4);

    public abstract XSListSimpleType createTypeList(String var1, String var2, short var3, XSSimpleType var4);

    public abstract XSUnionSimpleType createTypeUnion(String var1, String var2, short var3, XSSimpleType[] var4);
}

