/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.parsers;

import java.io.StringReader;
import org.apache.xerces.dom3.DOMErrorHandler;
import org.apache.xerces.dom3.ls.DOMBuilder;
import org.apache.xerces.dom3.ls.DOMBuilderFilter;
import org.apache.xerces.dom3.ls.DOMEntityResolver;
import org.apache.xerces.dom3.ls.DOMInputSource;
import org.apache.xerces.parsers.AbstractDOMParser;
import org.apache.xerces.parsers.DTDXSParserConfiguration;
import org.apache.xerces.util.DOMEntityResolverWrapper;
import org.apache.xerces.util.DOMErrorHandlerWrapper;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DOMBuilderImpl
extends AbstractDOMParser
implements DOMBuilder {
    protected static final String NAMESPACE_DECLARATIONS = "namespace-declarations";
    protected static final String VALIDATION = "validation";
    protected static final String EXTERNAL_PARAMETER_ENTITIES = "external-parameter-entities";
    protected static final String EXTERNAL_GENERAL_ENTITIES = "external-general-entities";
    protected static final String EXTERNAL_DTD_SUBSET = "external-dtd-subset";
    protected static final String VALIDATE_IF_SCHEMA = "validate-if-schema";
    protected static final String VALIDATE_AGAINST_DTD = "validate-against-dtd";
    protected static final String DATATYPE_NORMALIZATION = "datatype-normalization";
    protected static final String CREATE_ENTITY_REFERENCE_NODES = "create-entity-ref-nodes";
    protected static final String CREATE_ENTITY_NODES = "create-entity-nodes";
    protected static final String WHITESPACE_IN_ELEMENT_CONTENT = "whitespace-in-element-content";
    protected static final String COMMENTS = "comments";
    protected static final String CHARSET_OVERRIDES_XML_ENCODING = "charset-overrides-xml-encoding";
    protected static final String LOAD_AS_INFOSET = "load-as-infoset";
    protected static final String SUPPORTED_MEDIATYPES_ONLY = "supported-mediatypes-only";
    protected static final String VALIDATION_FEATURE = "http://xml.org/sax/features/validation";
    protected static final String EXTERNAL_PARAMETER_ENTITIES_FEATURE = "http://xml.org/sax/features/external-parameter-entities";
    protected static final String EXTERNAL_GENERAL_ENTITIES_FEATURE = "http://xml.org/sax/features/external-general-entities";
    protected static final String LOAD_EXTERNAL_DTD_FEATURE = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    protected static final String XMLSCHEMA = "http://apache.org/xml/features/validation/schema";
    protected static final String DYNAMIC_VALIDATION = "http://apache.org/xml/features/validation/dynamic";

    public DOMBuilderImpl() {
        this(new DTDXSParserConfiguration());
    }

    public DOMBuilderImpl(XMLParserConfiguration config) {
        super(config);
        String[] domRecognizedFeatures = new String[]{NAMESPACE_DECLARATIONS, VALIDATE_IF_SCHEMA, VALIDATE_AGAINST_DTD, DATATYPE_NORMALIZATION, CREATE_ENTITY_NODES, WHITESPACE_IN_ELEMENT_CONTENT, CHARSET_OVERRIDES_XML_ENCODING, LOAD_AS_INFOSET, SUPPORTED_MEDIATYPES_ONLY};
        this.fConfiguration.addRecognizedFeatures(domRecognizedFeatures);
        this.fConfiguration.setFeature(NAMESPACE_DECLARATIONS, true);
        this.fConfiguration.setFeature(VALIDATE_IF_SCHEMA, false);
        this.fConfiguration.setFeature(VALIDATE_AGAINST_DTD, false);
        this.fConfiguration.setFeature(CREATE_ENTITY_NODES, true);
        this.fConfiguration.setFeature(WHITESPACE_IN_ELEMENT_CONTENT, true);
        this.fConfiguration.setFeature(CHARSET_OVERRIDES_XML_ENCODING, true);
        this.fConfiguration.setFeature(LOAD_AS_INFOSET, false);
        this.fConfiguration.setFeature(SUPPORTED_MEDIATYPES_ONLY, false);
        this.fConfiguration.setFeature("http://apache.org/xml/features/validation/schema/normalized-value", false);
    }

    public DOMBuilderImpl(SymbolTable symbolTable) {
        this(new DTDXSParserConfiguration(symbolTable));
    }

    public DOMBuilderImpl(SymbolTable symbolTable, XMLGrammarPool grammarPool) {
        this(new DTDXSParserConfiguration(symbolTable, grammarPool));
    }

    public void reset() {
        super.reset();
    }

    public DOMEntityResolver getEntityResolver() {
        DOMEntityResolver domEntityResolver = null;
        try {
            DOMEntityResolver entityResolver = (DOMEntityResolver)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/entity-resolver");
            if (entityResolver != null && entityResolver instanceof DOMEntityResolverWrapper) {
                domEntityResolver = ((DOMEntityResolverWrapper)((Object)entityResolver)).getEntityResolver();
            }
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
        return domEntityResolver;
    }

    public void setEntityResolver(DOMEntityResolver entityResolver) {
        try {
            this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/entity-resolver", new DOMEntityResolverWrapper(entityResolver));
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
    }

    public DOMErrorHandler getErrorHandler() {
        DOMErrorHandler errorHandler = null;
        try {
            DOMErrorHandler domErrorHandler = (DOMErrorHandler)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/error-handler");
            if (domErrorHandler != null && domErrorHandler instanceof DOMErrorHandlerWrapper) {
                errorHandler = ((DOMErrorHandlerWrapper)domErrorHandler).getErrorHandler();
            }
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
        return errorHandler;
    }

    public void setErrorHandler(DOMErrorHandler errorHandler) {
        try {
            this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/error-handler", new DOMErrorHandlerWrapper(errorHandler));
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
    }

    public DOMBuilderFilter getFilter() {
        throw new DOMException(9, "Not supported");
    }

    public void setFilter(DOMBuilderFilter filter) {
        throw new DOMException(9, "Not supported");
    }

    public void setFeature(String name, boolean state) throws DOMException {
        block22: {
            try {
                if (this.canSetFeature(name, state)) {
                    if (name.equals(VALIDATION)) {
                        this.fConfiguration.setFeature(VALIDATION_FEATURE, state);
                    } else if (name.equals(VALIDATE_IF_SCHEMA)) {
                        this.fConfiguration.setFeature(DYNAMIC_VALIDATION, state);
                        this.fConfiguration.setFeature(XMLSCHEMA, state);
                    } else if (name.equals(WHITESPACE_IN_ELEMENT_CONTENT)) {
                        this.fConfiguration.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", state);
                    } else if (name.equals(DATATYPE_NORMALIZATION)) {
                        this.fConfiguration.setFeature("http://apache.org/xml/features/validation/schema/normalized-value", state);
                    } else if (name.equals(EXTERNAL_PARAMETER_ENTITIES)) {
                        this.fConfiguration.setFeature(EXTERNAL_PARAMETER_ENTITIES_FEATURE, state);
                    } else if (name.equals(EXTERNAL_GENERAL_ENTITIES)) {
                        this.fConfiguration.setFeature(EXTERNAL_GENERAL_ENTITIES_FEATURE, state);
                    } else if (name.equals(EXTERNAL_DTD_SUBSET)) {
                        this.fConfiguration.setFeature(LOAD_EXTERNAL_DTD_FEATURE, state);
                    } else if (name.equals(COMMENTS)) {
                        this.fConfiguration.setFeature("http://apache.org/xml/features/include-comments", state);
                    } else if (name.equals(CREATE_ENTITY_REFERENCE_NODES)) {
                        this.fConfiguration.setFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes", state);
                    } else {
                        this.fConfiguration.setFeature(name, state);
                    }
                    break block22;
                }
                throw new DOMException(9, "Feature \"" + name + "\" cannot be set to \"" + state + "\"");
            }
            catch (XMLConfigurationException e) {
                if (e.getType() == 0) {
                    throw new DOMException(8, "Feature \"" + name + "\" not recognized");
                }
                throw new DOMException(9, "Feature \"" + name + "\" not supported");
            }
        }
    }

    public boolean canSetFeature(String name, boolean state) {
        if (name.equals(NAMESPACE_DECLARATIONS) && !state) {
            return false;
        }
        if (name.equals(VALIDATE_AGAINST_DTD) && state) {
            return false;
        }
        if (name.equals(CREATE_ENTITY_NODES) && !state) {
            return false;
        }
        if (name.equals(LOAD_AS_INFOSET) && state) {
            return false;
        }
        return !name.equals(SUPPORTED_MEDIATYPES_ONLY) || !state;
    }

    public boolean getFeature(String name) throws DOMException {
        try {
            if (name.equals(VALIDATION)) {
                return this.fConfiguration.getFeature(VALIDATION_FEATURE);
            }
            if (name.equals(EXTERNAL_PARAMETER_ENTITIES)) {
                return this.fConfiguration.getFeature(EXTERNAL_PARAMETER_ENTITIES_FEATURE);
            }
            if (name.equals(EXTERNAL_GENERAL_ENTITIES)) {
                return this.fConfiguration.getFeature(EXTERNAL_GENERAL_ENTITIES_FEATURE);
            }
            if (name.equals(EXTERNAL_DTD_SUBSET)) {
                return this.fConfiguration.getFeature(LOAD_EXTERNAL_DTD_FEATURE);
            }
            if (name.equals(COMMENTS)) {
                return this.fConfiguration.getFeature("http://apache.org/xml/features/include-comments");
            }
            if (name.equals(CREATE_ENTITY_REFERENCE_NODES)) {
                return this.fConfiguration.getFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes");
            }
            if (name.equals(VALIDATE_IF_SCHEMA)) {
                return this.fConfiguration.getFeature(DYNAMIC_VALIDATION);
            }
            if (name.equals(WHITESPACE_IN_ELEMENT_CONTENT)) {
                return this.fConfiguration.getFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace");
            }
            if (name.equals(DATATYPE_NORMALIZATION)) {
                return this.fConfiguration.getFeature("http://apache.org/xml/features/validation/schema/normalized-value");
            }
            return this.fConfiguration.getFeature(name);
        }
        catch (XMLConfigurationException e) {
            if (e.getType() == 0) {
                throw new DOMException(8, "Feature \"" + name + "\" not recognized");
            }
            throw new DOMException(9, "Feature \"" + name + "\" not supported");
        }
    }

    public Document parseURI(String uri) throws Exception {
        XMLInputSource source = new XMLInputSource(null, uri, null);
        try {
            this.parse(source);
        }
        catch (XNIException e) {
            Exception ex = e.getException();
            throw ex;
        }
        return this.getDocument();
    }

    public Document parse(DOMInputSource is) throws Exception {
        try {
            XMLInputSource xmlInputSource = this.dom2xmlInputSource(is);
            this.parse(xmlInputSource);
        }
        catch (XNIException e) {
            Exception ex = e.getException();
            throw ex;
        }
        return this.getDocument();
    }

    public void parseWithContext(DOMInputSource is, Node cnode, short action) throws DOMException {
        throw new DOMException(9, "Not supported");
    }

    XMLInputSource dom2xmlInputSource(DOMInputSource is) {
        XMLInputSource xis = null;
        xis = is.getStringData() != null ? new XMLInputSource(is.getPublicId(), is.getSystemId(), is.getBaseURI(), new StringReader(is.getStringData()), "UTF-16") : (is.getCharacterStream() != null ? new XMLInputSource(is.getPublicId(), is.getSystemId(), is.getBaseURI(), is.getCharacterStream(), "UTF-16") : (is.getByteStream() != null ? new XMLInputSource(is.getPublicId(), is.getSystemId(), is.getBaseURI(), is.getByteStream(), is.getEncoding()) : new XMLInputSource(is.getPublicId(), is.getSystemId(), is.getBaseURI())));
        return xis;
    }
}

