; Program Name    : REAPER.ASM
; Author          : bill buckels
; Date            : July, 1993
; Purpose         : provide a 32K buffer in memory for printed output
;                   use interrupt 17h function FFh

; Uses            : intercept report output passthrough on the
;                   way to the printer and create a copy in memory
;                   which can later be saved to disk using SOWER.EXE

;                   return ax = numberofbytes in buffer
;                   return bx = offset of buffer
;                   return cx = segment of buffer
;                   return dx = numberofbytes in buffer

; calling sequence : call twice. the first call will contain
;                    exactly the same value in ax and dx.
;                    The second call will show ax and cx back to 0.
;                    See Sower.C for more details.

cr            equ  0dh               ;carriage return
lf            equ  0ah               ;line feed


CODE          SEGMENT PARA PUBLIC 'CODE'
              ASSUME CS:CODE
              ORG 100h

BEGIN:        jmp INITIALIZE         ;jump to initialization code


old_int_17h         label dword       ;old printer interrupt vector
old_printer_int     dw 2 dup (?)

bufoff              dw 0              ; segment of buffer
bufseg              dw 0              ; offset of buffer
bufctr              dw 0              ; buffer tail
buffer              db 32767 dup('A')

;-------------------------------------------------------
;Resident mainline and Front-end routine for the printer
;interrupt handler. Execution is vectored here
;when the printer is called
;-------------------------------------------------------

PRINTIT     PROC NEAR
              sti
              push ax          ;save registers
              push bx
              push cx
              push dx
              push si
              push di
              push ds
              push es

              cmp ah, 255          ; function 255 - reset buffer
              je CHANGE_ALL        ; and return address

              cmp ah, 0             ; function 0 - send byte to printer
              jne CHANGE_NOTHING    ; don't bother if not

              cmp bufctr,32767      ; don't bother if buffer is full
              jge CHANGE_NOTHING

              mov si,bufctr
              mov [buffer][si],al ; otherwise move a byte to buffer
              inc bufctr

CHANGE_NOTHING:
              pop es            ;restore the registers
              pop ds
              pop di
              pop si
              pop dx
              pop cx
              pop bx
              pop ax
              jmp old_int_17h   ;goto BIOS printer routine

CHANGE_ALL:
              mov cx,cs                ; cx = buffer seg
              mov bx,offset buffer     ; bx = buffer offset
              mov dx,bufctr            ; dx = byte count
              mov bufctr,0             ; reset the buffer head
              pop es                   ; restore the registers
              pop ds
              pop di
              pop si
              pop ax
              pop ax
              pop ax
              pop ax
              mov ax,dx
              iret
PRINTIT     ENDP


;------------------------------------------------------------
;         RESIDENT PORTION ENDS *** TRANSIENT PORTION STARTS
;------------------------------------------------------------

;------------------------------------------------------------
;initialization message - the requested time limit is inserted here
;------------------------------------------------------------
TITLE$  db 'ͻ',cr,lf
        db '  Reaper(C) by Bill Buckels 1993 ',cr,lf
        db '  Memory resident printed output ',cr,lf
        db '  interception and passthrough   ',cr,lf
        db '  Driver Module                  ',cr,lf
        db 'ͼ',cr,lf,'$'

SORRY$  db 7,'Error During Loading... Reaper is Already in Memory!',cr,lf,'$'

;------------------------------------------------------------
;LIST$ writes a string to stdout
;------------------------------------------------------------
LIST$ PROC NEAR
      push ax
      mov ah,9h ; call dos function 9H
      int 21h
      pop ax
      ret
LIST$ ENDP

;----------------------------------------------------------------
;INITIALIZE performs tasks to set the stage for the resident part
;of the program.
;-----------------------------------------------------------------
INITIALIZE    PROC NEAR

;let them know who we are

         lea dx, TITLE$
         call LIST$

;Check memory for ourselves already loaded
;and quit if we are

         mov ah,255
         int 17h
         cmp ax,dx
         jne FIRSTIME
         mov ah,255
         int 17h
         cmp ax,dx
         jne FIRSTIME
         cmp dx,0
         jne FIRSTIME
         lea dx, SORRY$
         call LIST$
         int 20h

FIRSTIME:

;Now save the printer vector and replace it
;with one pointing to the
;code that we will leave behind in memory.

              mov ah,35h                 ;get current interrupt 17H vector
              mov al,17h
              int 21h
              mov old_printer_int,bx       ;save vector offset
              mov old_printer_int[2],es    ;save vector segment

              mov ah,25h                   ;set new vector
              mov al,17h
              lea dx,PRINTIT               ;point it to new handler
              int 21h

;Exit thru INT 27h and reserve enough room
;the offset of TITLE$ is a marker to end of resident code

              mov dx,offset TITLE$          ;reserve space for code
              int 27h                       ;terminate-but-stay-resident
INITIALIZE    ENDP
;
CODE          ENDS
              END BEGIN
